% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfun_rpm_18_04_20.R
\name{predict.rpms}
\alias{predict.rpms}
\alias{predict}
\title{predict.rpms}
\usage{
\method{predict}{rpms}(object, newdata, ...)
}
\arguments{
\item{object}{Object inheriting from  \code{rpms}}

\item{newdata}{data frame with variables to use for predicting new values.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
vector of predicticed values for each row of newdata
}
\description{
Predicted values based on \code{rpms} object
}
\examples{
{

# get rpms model of mean Soc Security income for families headed by a 
# retired person by several factors
r1 <-rpms(SOCRRX~EDUCA+AGE+BLS_URBN+REGION, 
          data=CE[which(CE$INCNONWK==1),], clusters=~CID) 

r1

# first 10 predicted means
predict(r1, CE[10:20, ])

}

}
