% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subroutines.R
\name{ftemp_kphio}
\alias{ftemp_kphio}
\title{Calculates the temperature dependence of the quantum yield efficiency}
\usage{
ftemp_kphio(tc, c4 = FALSE)
}
\arguments{
\item{tc}{Temperature, relevant for photosynthesis (degrees Celsius)}

\item{c4}{Boolean specifying whether fitted temperature response for C4 plants
is used. Defaults to \code{FALSE} (C3 photoynthesis temperature resposne following
Bernacchi et al., 2003 is used).}
}
\value{
A numeric value for \eqn{\phi(T)}
}
\description{
Calculates the temperature dependence of the quantum yield efficiency
following the temperature dependence of the maximum quantum yield of photosystem II
in light-adapted tobacco leaves, determined by Bernacchi et al. (2003)
}
\details{
The temperature factor for C3 photosynthesis (argument \code{c4 = FALSE}) is calculated
based on Bernacchi et al. (2003) as
			\deqn{
				\phi(T) = 0.352 + 0.022 T - 0.00034 T^2
      }

The temperature factor for C4 (argument \code{c4 = TRUE}) photosynthesis is calculated based on
unpublished work as
			\deqn{
				\phi(T) = -0.008 + 0.00375 T - 0.58e-4 T^2
      }

The factor \eqn{\phi(T)} is to be multiplied with leaf absorptance and the fraction
of absorbed light that reaches photosystem II. In the P-model these additional factors
are lumped into a single apparent quantum yield efficiency parameter (argument \code{kphio}
to function \link{rpmodel}).
}
\examples{
## Relative change in the quantum yield efficiency
## between 5 and 25 degrees celsius (percent change):
print(paste((ftemp_kphio(25.0)/ftemp_kphio(5.0)-1)*100 ))

}
\references{
Bernacchi, C. J., Pimentel, C., and Long, S. P.:  In vivo temperature
				response func-tions  of  parameters required  to  model  RuBP-limited
				photosynthesis,  Plant  Cell Environ., 26, 1419–1430, 2003
}
