% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/msa.R
\name{base.freq.msa}
\alias{base.freq.msa}
\title{Get the frequencies of characters in an alignment}
\usage{
base.freq.msa(x, seq = NULL, ignore.missing = TRUE, ignore.gaps = TRUE)
}
\arguments{
\item{x}{An object of type \code{msa}}

\item{seq}{A vector of character strings identifying the sequence(s)
to get base frequencies for.  If \code{NULL}, use all sequences.}

\item{ignore.missing}{If TRUE, ignore missing data characters ("N" and "?").
Must be TRUE if seq is stored as a pointer.}

\item{ignore.gaps}{If TRUE, ignore gaps.  Must be TRUE if seq is stored
as a pointer.}
}
\value{
A data frame with one row for each unique state (usually
"A", "C", "G", "T", and possibly "N", "?", "-", counts for
each state, and overall frequency of each state.
}
\description{
Get the frequencies of characters in an alignment
}
\author{
Melissa J. Hubisz
}
\seealso{
\code{statfreq.msa}, which gets observed frequencies of states
in an alignment with respect to a substitution model, and works for
pointers.
}

