% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_time.R
\name{getPiecewiseSurvivalTime}
\alias{getPiecewiseSurvivalTime}
\title{Get Piecewise Survival Time}
\usage{
getPiecewiseSurvivalTime(
  piecewiseSurvivalTime = NA_real_,
  ...,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  hazardRatio = NA_real_,
  pi1 = NA_real_,
  pi2 = NA_real_,
  median1 = NA_real_,
  median2 = NA_real_,
  eventTime = 12L,
  kappa = 1,
  delayedResponseAllowed = FALSE
)
}
\arguments{
\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for the piecewise 
definition of the exponential survival time cumulative distribution function (see details).}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{lambda1}{The assumed hazard rate in the treatment group, there is no default.
\code{lambda1} can also be used to define piecewise exponentially distributed survival times (see details).}

\item{lambda2}{The assumed hazard rate in the reference group, there is no default.
\code{lambda2} can also be used to define piecewise exponentially distributed survival times (see details).}

\item{hazardRatio}{The vector of hazard ratios under consideration. 
If the event or hazard rates in both treatment groups are defined, the hazard ratio needs 
not to be specified as it is calculated, there is no default.}

\item{pi1}{A numeric value or vector that represents the assumed event rate in the treatment group, 
default is \code{seq(0.2, 0.5, 0.1)} (power calculations and simulations) or 
\code{seq(0.4, 0.6, 0.1)} (sample size calculations).}

\item{pi2}{A numeric value that represents the assumed event rate in the control group, default is \code{0.2}.}

\item{median1}{The assumed median survival time in the treatment group, there is no default.}

\item{median2}{The assumed median survival time in the reference group, there is no default.}

\item{eventTime}{The assumed time under which the event rates are calculated, default is \code{12}.}

\item{kappa}{A numeric value > 0. A \code{kappa != 1} will be used for the specification 
of the shape of the Weibull distribution. 
Default is \code{1}, i.e., the exponential survival distribution is used instead of the Weibull distribution.
Note that the Weibull distribution cannot be used for the piecewise definition of 
the survival time distribution, i.e., only \code{piecewiselambda} (as a single value) and \code{kappa} 
   can be specified.
This function is equivalent to \code{pweibull(t, shape = kappa, scale = 1 / lambda)} 
of the \code{stats} package, i.e., the scale parameter is \code{1 / 'hazard rate'}.\cr
For example, 
\code{getPiecewiseExponentialDistribution(time = 130, piecewiseLambda = 0.01, kappa = 4.2)} 
and \code{pweibull(q = 130, shape = 4.2, scale = 1 / 0.01)} provide the sample result.}

\item{delayedResponseAllowed}{If \code{TRUE}, delayed response is allowed;
otherwise it will be validated that the response is not delayed, default is \code{FALSE}.}
}
\value{
Returns a \code{\link{PiecewiseSurvivalTime}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
  \item \code{\link[=names.FieldSet]{names}} to obtain the field names,
  \item \code{\link[=print.FieldSet]{print}} to print the object,
  \item \code{\link[=summary.ParameterSet]{summary}} to display a summary of the object,
  \item \code{\link[=plot.ParameterSet]{plot}} to plot the object,
  \item \code{\link[=as.data.frame.ParameterSet]{as.data.frame}} to coerce the object to a \code{\link[base]{data.frame}},
  \item \code{\link[=as.matrix.FieldSet]{as.matrix}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns a \code{PiecewiseSurvivalTime} object that contains the all relevant parameters 
of an exponential survival time cumulative distribution function.
Use \code{\link[base]{names}} to obtain the field names.
}
\section{Piecewise survival time}{

The first element of the vector \code{piecewiseSurvivalTime} must be equal to \code{0}. 
\code{piecewiseSurvivalTime} can also be a list that combines the definition of the 
time intervals and hazard rates in the reference group. 
The definition of the survival time in the treatment group is obtained by the specification 
of the hazard ratio (see examples for details).
}

\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of 
the \code{rpact} specific implementation of the generic. 
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and 
to identify the object specific name of it, e.g., 
use \code{methods("plot")} to get all the methods for the \code{plot} generic. 
There you can find, e.g., \code{plot.AnalysisResults} and 
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
getPiecewiseSurvivalTime(lambda2 = 0.5, hazardRatio = 0.8)

getPiecewiseSurvivalTime(lambda2 = 0.5, lambda1 = 0.4)

getPiecewiseSurvivalTime(pi2 = 0.5, hazardRatio = 0.8)

getPiecewiseSurvivalTime(pi2 = 0.5, pi1 = 0.4)

getPiecewiseSurvivalTime(pi1 = 0.3)

getPiecewiseSurvivalTime(hazardRatio = c(0.6, 0.8), lambda2 = 0.4)

getPiecewiseSurvivalTime(piecewiseSurvivalTime = c(0, 6, 9), 
    lambda2 = c(0.025, 0.04, 0.015), hazardRatio = 0.8)

getPiecewiseSurvivalTime(piecewiseSurvivalTime = c(0, 6, 9), 
    lambda2 = c(0.025, 0.04, 0.015), 
    lambda1 = c(0.025, 0.04, 0.015) * 0.8)

pwst <- getPiecewiseSurvivalTime(list(
    "0 - <6"   = 0.025, 
    "6 - <9"   = 0.04, 
    "9 - <15"  = 0.015, 
    "15 - <21" = 0.01, 
    ">=21"     = 0.007), hazardRatio = 0.75)
pwst
\donttest{
# The object created by getPiecewiseSurvivalTime() can be used directly in 
# getSampleSizeSurvival():
getSampleSizeSurvival(piecewiseSurvivalTime = pwst)

# The object created by getPiecewiseSurvivalTime() can be used directly in 
# getPowerSurvival():
getPowerSurvival(piecewiseSurvivalTime = pwst, 
    maxNumberOfEvents = 40, maxNumberOfSubjects = 100)
}
 
}
