% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querybatch.R
\name{osv_querybatch}
\alias{osv_querybatch}
\alias{.osv_querybatch}
\alias{.osv_querybatch_cache}
\title{Query OSV API for vulnerabilities given a vector of packages}
\usage{
osv_querybatch(
  name = NULL,
  version = NULL,
  ecosystem = NULL,
  commit = NULL,
  purl = NULL,
  parse = TRUE,
  cache = TRUE,
  ...
)

.osv_querybatch(
  name = NULL,
  version = NULL,
  ecosystem = NULL,
  commit = NULL,
  purl = NULL,
  parse = TRUE,
  cache = TRUE,
  ...
)

.osv_querybatch_cache(
  name = NULL,
  version = NULL,
  ecosystem = NULL,
  commit = NULL,
  purl = NULL,
  parse = TRUE,
  cache = TRUE,
  ...
)
}
\arguments{
\item{name}{Name of package.}

\item{version}{Version of package.}

\item{ecosystem}{Ecosystem package lives within (must be set if using \code{name}).}

\item{commit}{Commit hash to query against (do not use when version set).}

\item{purl}{URL for package (do not use if name or ecosystem set).}

\item{parse}{Boolean value to set if the content field should be parsed from JSON list format.}

\item{cache}{Boolean value to determine if should use a cached version of the function and API results.}

\item{...}{Additional parameters passed to nested functions.}
}
\value{
An R6 object containing API query contents.
}
\description{
Using a vector of input information, query the OSV API for any associated
vulnerability ID.
}
\details{
The query is constructed from the provided set of vectors. Default
will be \code{NULL} and thereby empty/null in the JSON request. If some values in the vector
are missing, use \code{NA}. For many queries, the conversion to a formatted JSON
request can be parallelized via \{future\}.

The returned information are vulnerability IDs and modified fields only, as per API instruction.
}
\section{Functions}{
\itemize{
\item \code{.osv_querybatch()}: Internal function to run \code{osv_querybatch} without caching.

\item \code{.osv_querybatch_cache()}: Internal function to run a memoise and cached version of \code{osv_querybatch}.

}}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
osv_querybatch(c("commonmark", "dask"), ecosystem = c('CRAN', 'PyPI'))
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://ossf.github.io/osv-schema/#affectedpackage-field}{Ecosystem list}
}
