% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prov.R
\name{provFromHistory}
\alias{provFromHistory}
\title{Generate a provenance store from hashed output history}
\usage{
provFromHistory(outvar, outvarhash, outvarclass, invars, prevouts,
  prevouthashes, prevoutclasses, code)
}
\arguments{
\item{outvar}{character(1). A single output variable}

\item{outvarhash}{character(1). The hash of the value of
\code{outvar}.}

\item{outvarclass}{character(1). The (top level) class of the
output variable}

\item{invars}{A vector of input variables for \code{outvar}.}

\item{prevouts}{character. A vector of previous output variables}

\item{prevouthashes}{character. A vector of previous output hashes
corresponding to \code{prevouts}}

\item{prevoutclasses}{character. A vector of (top level) classes
corresponding to \code{prevouts}}

\item{code}{The code corresponding with the generation of
\code{outvar}}
}
\value{
A ProvStoreDF object
}
\description{
Generate provenance of a single variable from a
    history of hashed outputs.
}
