% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mrs_db_geo}
\alias{mrs_db_geo}
\title{Constellation generated from MRS file through a query and with geographic information}
\format{
A \code{star_database}.
}
\source{
\url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
}
\usage{
mrs_db_geo
}
\description{
The original dataset covers from 1962 to 2016. For each week, in 122 US cities,
from the original file, we have stored in the package a file with the same
format as the original file but that includes only 1\% of its data, selected at
random.
}
\details{
From these data the constellation in the vignette titled 'Obtaining and
transforming flat tables' has been generated. This variable contains the defined
constellation.
}
\examples{
# Defined by:

sq <- mrs_db |>
  star_query() |>
  select_dimension(name = "where",
                   attributes = "state") |>
  select_dimension(name = "when",
                   attributes = "year") |>
  select_fact(
    name = "mrs_age",
    measures = "all_deaths"
  )  |>
  select_fact(
    name = "mrs_cause",
    measures = "pneumonia_and_influenza_deaths"
  )

db <- mrs_db |>
  run_query(sq)

mrs_db_geo <- db |>
  define_geoattribute(
    dimension = "where",
    attribute = "state",
    from_layer = us_layer_state,
    by = "STUSPS"
  )

}
\seealso{
Other mrs example data: 
\code{\link{ft_age_rpd}},
\code{\link{ft_age}},
\code{\link{ft_cause_rpd}},
\code{\link{ft_num}},
\code{\link{ft}},
\code{\link{mrs_db}},
\code{\link{mrs_ft_new}},
\code{\link{mrs_ft}}
}
\concept{mrs example data}
\keyword{datasets}
