% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R, R/generic.R, R/star_database.R
\name{replace_attribute_values.flat_table}
\alias{replace_attribute_values.flat_table}
\alias{replace_attribute_values}
\alias{replace_attribute_values.star_database}
\title{Replace instance values}
\usage{
\method{replace_attribute_values}{flat_table}(db, name = NULL, attributes = NULL, old, new)

replace_attribute_values(db, name, attributes, old, new)

\method{replace_attribute_values}{star_database}(db, name, attributes = NULL, old, new)
}
\arguments{
\item{db}{A \code{flat_table} or \code{star_database} object.}

\item{name}{A string, dimension name.}

\item{attributes}{A vector of strings, attribute names.}

\item{old}{A vector of values.}

\item{new}{A vector of values.}
}
\value{
A \code{flat_table} or \code{star_database} object.
}
\description{
Given the values of a possible instance, for that combination, replace them
with the new data values.
}
\examples{

db <- star_database(mrs_cause_schema, ft_num) |>
  replace_attribute_values(name = "where",
    old = c('1', 'CT', 'Bridgeport'),
    new = c('1', 'CT', 'Hartford'))

db <- star_database(mrs_cause_schema, ft_num) |>
  replace_attribute_values(name = "where",
                           attributes = c('REGION', 'State'),
                           old = c('1', 'CT'),
                           new = c('2', 'CT'))

ft <- flat_table('iris', iris) |>
  replace_attribute_values(
    attributes = 'Species',
    old = c('setosa'),
    new = c('versicolor')
  )

}
\seealso{
\code{\link{star_database}}, \code{\link{flat_table}}

Other star database and flat table functions: 
\code{\link{get_attribute_names.flat_table}()},
\code{\link{get_measure_names.flat_table}()},
\code{\link{get_similar_attribute_values.flat_table}()},
\code{\link{get_similar_attribute_values_individually.flat_table}()},
\code{\link{get_unique_attribute_values.flat_table}()},
\code{\link{set_attribute_names.flat_table}()},
\code{\link{set_measure_names.flat_table}()},
\code{\link{snake_case.flat_table}()}
}
\concept{star database and flat table functions}
