% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh.R
\name{get_star_schema}
\alias{get_star_schema}
\alias{get_star_schema.star_database_update}
\title{Get star schema}
\usage{
get_star_schema(sdbu)

\method{get_star_schema}{star_database_update}(sdbu)
}
\arguments{
\item{sdbu}{A \code{star_database_update} object.}
}
\value{
A \code{star_schema} object.
}
\description{
From the planned update, it obtains the star schema used to define the data.
}
\examples{

f1 <- flat_table('ft_num', ft_cause_rpd) |>
  as_star_database(mrs_cause_schema_rpd)
f2 <- flat_table('ft_num2', ft_cause_rpd) |>
  update_according_to(f1)
st <- f2 |>
  get_star_schema()

}
\seealso{
Other star database refresh functions: 
\code{\link{get_existing_fact_instances}()},
\code{\link{get_lookup_tables}()},
\code{\link{get_new_dimension_instances}()},
\code{\link{get_star_database}()},
\code{\link{get_transformation_code}()},
\code{\link{get_transformation_file}()},
\code{\link{incremental_refresh}()},
\code{\link{update_according_to}()}
}
\concept{star database refresh functions}
