% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R, R/generic.R, R/star_database.R
\name{get_measure_names.flat_table}
\alias{get_measure_names.flat_table}
\alias{get_measure_names}
\alias{get_measure_names.star_database}
\title{Get the names of the measures}
\usage{
\method{get_measure_names}{flat_table}(db, name = NULL, ordered = FALSE, as_definition = FALSE)

get_measure_names(db, name, ordered, as_definition)

\method{get_measure_names}{star_database}(db, name = NULL, ordered = FALSE, as_definition = FALSE)
}
\arguments{
\item{db}{A \code{flat_table} or \code{star_database} object.}

\item{name}{A string, dimension name.}

\item{ordered}{A boolean, sort names alphabetically.}

\item{as_definition}{A boolean, get the names as a vector definition in R.}
}
\value{
A vector of strings or a string, measure names.
}
\description{
Obtain the names of the measures in a flat table or in a star database.
}
\examples{

names <- star_database(mrs_cause_schema, ft_num) |>
  get_measure_names()

names <- flat_table('iris', iris) |>
  get_measure_names()

}
\seealso{
\code{\link{star_database}}, \code{\link{flat_table}}

Other star database and flat table functions: 
\code{\link{get_attribute_names.flat_table}()},
\code{\link{get_similar_attribute_values.flat_table}()},
\code{\link{get_similar_attribute_values_individually.flat_table}()},
\code{\link{get_unique_attribute_values.flat_table}()},
\code{\link{replace_attribute_values.flat_table}()},
\code{\link{set_attribute_names.flat_table}()},
\code{\link{set_measure_names.flat_table}()},
\code{\link{snake_case.flat_table}()}
}
\concept{star database and flat table functions}
