% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethod_plotStoichiometry.r
\name{plotStoichiometry}
\alias{plotStoichiometry}
\title{Plot Qualitative Stoichiometry Matrix}
\arguments{
\item{box}{A vector of positive integers pointing to a spatial sub-unit of
the model.}

\item{time}{Time. The value is ignored in the case of autonomous models.}

\item{cex}{Character expansion factor.}

\item{colPositive}{Color for positive stoichiometric factors.}

\item{colNegative}{Color for negative stoichiometric factors.}

\item{colGrid}{Color of a grid (can be identical to background color).}
}
\description{
Visualizes the stoichiometry matrix using standard plot methods. The sign
of stoichiometric factors is displayed as upward and downward pointing
triangles, optionally colored.
}
\note{
The values of state variables and parameters must have been set using
  the \code{\link{setVars}} and \code{\link{setPars}} methods. If the
  stoichiometric factors are mathematical expressions involving
  function references, these functions must be defined in R (even if the
  numerical computations are based on generated Fortran code).
}
\examples{
data(vars, pars, funs, pros, stoi)
model <- rodeo$new(vars, pars, funs, pros, stoi, dim=c(1))
model$setVars(c(bac=0.1, sub=0.5))
model$setPars(c(mu=0.8, half=0.1, yield= 0.1, vol=1000, flow=50, sub_in=1))
monod <- function(c,h) {c/(c+h)}
model$plotStoichiometry(box=c(1))
}
\author{
\email{david.kneis@tu-dresden.de}
}
\seealso{
See other methods of the \code{\link{rodeo-class}} or
  \code{\link{stoichiometry}} for computing the stoichiometric factors only.
  Alternative options for displaying stoichiometry information are described
  in the package vignette.
}

