% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/classMethod_compile.r
\name{compile}
\alias{compile}
\title{Create Fortran Library}
\arguments{
\item{fileFuns}{Fortran source file defining a module 'functions' that
contains any user-defined functions referenced in process rates or
stoichiometric factors. If the Fortran code is split over several dependent
files, a vector of character strings can be supplied instead of a single
file name.}

\item{NLVL}{The desired number of spatial levels (boxes). Defaults to 1.}
}
\value{
A vector of character strings with named elements as follows:
\itemize{
  \item{\code{libFile}} File path of the generated library. Needs to be
    passed to, e.g., \code{\link[base]{dyn.load}}.
  \item{\code{libName}} The pure library name, which is the base name of
    \code{libFile} with the platform specific extension stripper. This name
    has to be supplied as the \code{dllname} argument of the solver methods
    in \code{\link[deSolve]{deSolve}} or \code{\link[rootSolve]{rootSolve}}.
  \item{\code{libFunc}} Name of the method contained in the built library
    which computes the derivatives. This name has to be supplied as the
    \code{func} argument of the solver methods
    in \code{\link[deSolve]{deSolve}} or \code{\link[rootSolve]{rootSolve}}.
}
}
\description{
Create a Fortran library for use with numerical methods from packages
\code{\link[deSolve]{deSolve}} or \code{\link[rootSolve]{rootSolve}}.
}
\examples{
data(exampleIdentifiers, exampleProcesses, exampleStoichiometry)
model= new("rodeo",
  vars=subset(exampleIdentifiers, type=="v"),
  pars=subset(exampleIdentifiers, type=="p"),
  funs=subset(exampleIdentifiers, type=="f"),
  pros=exampleProcesses, stoi=exampleStoichiometry
)
# This would trigger compilation assuming that 'functionsCode.f95' contains
# a Fortran implementation of all functions; see vignette for full example
\dontrun{
lib= model$compile(fileFun="functionsCode.f95")
}
}
\author{
\email{david.kneis@tu-dresden.de}
}
\seealso{
This method internally calls \code{\link{generate}} and the
  non-class method \code{\link{solverInterface}}.
}

