% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc_text_functions.R
\name{extract_roc_text}
\alias{extract_roc_text}
\title{Extract a section, parameter or set of dot-parameters from a function documentation}
\usage{
extract_roc_text(
  fun,
  type = c("general", "section", "param", "dot_params"),
  select = NULL,
  capitalize = NA
)
}
\arguments{
\item{fun}{Function or character (of length 1L) indicating function name.}

\item{type}{Type of extraction. Please choose one from the following table
according to the \code{@tag} you would otherwise use if you would like to inherit
the section, parameter or set of dot-parameters as a whole:\tabular{cc}{
   \code{@tag} you would use \tab \code{type} you should choose \cr
   \code{@inherit} \tab \code{"general"} \cr
   \code{@inheritSection} \tab \code{"section"} \cr
   \code{@inheritParams} \tab \code{"param"} \cr
   \code{@inheritDotParams} \tab \code{"dot_params"} \cr
}}

\item{select}{Selection of extraction based on \code{type}.
\describe{
\item{\code{type = "general"}}{Character (of length 1L) indicating the section to extract}
\item{\code{type = "section"}}{Character (of length 1L) indicating the section title to extract}
\item{\code{type = "param"}}{Character (of length 1L) indicating the name of parameter to extract}
\item{\code{type = "dot_params"}}{Character (of length 1L) or character vector to add or remove (with "-") parameters as \code{@inheritDotParams};
if character vector provided, the elements are concatenated with spaces just as \code{@inheritDotParams} syntax,
e.g. \code{"x y"} to inherit two parameters, \code{"-z"} to remove a parameter or \code{c("-x", "-y")} to remove two parameters}
}}

\item{capitalize}{Logical (of length 1L) indicating whether the first letter of the return should be capitalized.
Default to \code{capitalize = NA}, in which case the first letter of the return is left as is.}
}
\value{
Character (of length 1L) as a valid Rd character string to diffuse into \code{\link[roxygen2]{roxygen2}} comments.
}
\description{
\code{extract_roc_text} cites sections or parameters from a function documentation
in the syntax of \code{@inherit}, \code{@inheritSection}, \code{@inheritParams} or \code{@inheritDotParams} tag
from \code{\link[roxygen2]{roxygen2}} package. See details about how to use this function.
}
\details{
To diffuse the function output into \code{\link[roxygen2]{roxygen2}} comments,
one may write the function documentation with inline code like this:
\preformatted{
#' Diffusion of function documentation with inline code
#'
#' @return Same as \code{\link[stats]{lm}}:
#' `r extract_roc_text(stats::lm, type = "general", select = "return")`
my_fun <- function() {}
}

or with code block like this:
\preformatted{
#' Diffusion of function documentation with code block
#'
#' @param lm_arg Named list of
#' ```{r}
#' extract_roc_text(stats::lm,
#'                  type = "dot_params",
#'                  select = c("-formula", "-data"),
#'                  capitalize = FALSE)
#' ```
my_fun <- function(lm_arg) {}
}
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
\item{0.1.1 Xiurui Zhu - Change the default of \code{capitalize} from \code{TRUE} to \code{NA}.}
\item{0.1.1 Xiurui Zhu - Improve code security in evaluating the formal arguments of \code{fun}.}
}
}
\examples{
# Inherit a standard section, and leave the first letter as is
cat(
  extract_roc_text(stats::lm,
                   type = "general",
                   select = "description",
                   capitalize = NA)
)

# Inherit a self-defined section, and capitalize the first letter
cat(
  extract_roc_text(stats::lm,
                   type = "section",
                   select = "Using time series",
                   capitalize = TRUE)
)

# Inherit a parameter, and diffuse it into text
cat(
  paste0(
    "Here is the `formula` argument of `stats::lm`, defined as: ",
    extract_roc_text(stats::lm,
                     type = "param",
                     select = "formula",
                     capitalize = FALSE)
  )
)

# Inherit a set of dot params, and diffuse it into text
cat(
  paste0(
    "`lm_arg` is a named list of ",
    extract_roc_text(stats::lm,
                     type = "dot_params",
                     select = c("-formula", "-data"),
                     capitalize = FALSE)
  )
)
}
\author{
Xiurui Zhu
}
