% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{setupDriver}
\alias{setupDriver}
\title{Setup database driver and define connection parameters.}
\usage{
setupDriver(db, drv, ..., protect = c("password", "user"))
}
\arguments{
\item{db}{rocker object}

\item{drv}{Driver object from suitable package e.g. \code{\link[RPostgres:Postgres]{RPostgres::Postgres()}}, \code{\link[RMariaDB:MariaDBDriver-class]{RMariaDB::MariaDB()}} and \code{\link[RSQLite:SQLite]{RSQLite::SQLite()}}}

\item{...}{Suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}} e.g. host, port, dbname, user and password}

\item{protect}{Parameters to be hidden}
}
\value{
Invisible self
}
\description{
Setup database driver and define connection parameters.
}
\examples{
db <- rocker::newDB()
rocker::setupDriver(
  db,
  drv = RSQLite::SQLite(),
  dbname = ":memory:"
)
rocker::unloadDriver(db)
}
