% Generated by roxygen2 (4.0.1): do not edit by hand
\name{padW0}
\alias{padW0}
\title{Pad with 0's.}
\usage{
padW0(x)
}
\arguments{
\item{x}{a numeric  variable.}
}
\value{
A character string vector padded with 0's
}
\description{
Sometimes we receive this c(1, 22, 131) and we need character
variables of the same size, such as c("001", "022", "131").  This
happens if a user has mistakenly converted a zip code (US regional
identifier) like "00231" to a number. This function converts the
number back to a 0 padded string.
}
\details{
This works differently if the number provided is an integer, or a
character string.  Integers are left padded with the character
"0".  A character string will be left-padded with blanks.
}
\examples{
x <- c(1 , 11, 22, 121, 14141, 31)
(xpad <- padW0(x))
x <- rpois(7, lambda = 11)
(xpad <- padW0(x))
x <- c("Alabama", "Iowa", "Washington")
}
\author{
Paul Johnson <pauljohn@ku.edu>
}

