% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_graph_theme.R
\name{apply_graph_theme}
\alias{apply_graph_theme}
\title{Apply multiple DiagrammeR global graph attributes}
\usage{
apply_graph_theme(graph, ...)
}
\arguments{
\item{graph}{The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph to apply the attributes to.}

\item{...}{One or more character vectors of length three, where the first element is
the attribute, the second the value, and the third, the attribute type (\code{graph},
\code{node}, or \code{edge}).}
}
\value{
The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph.
}
\description{
Apply multiple DiagrammeR global graph attributes
}
\examples{
exampleSource <- '
---
codes:
  -
    id: parentCode
    label: Parent code
    children:
      -
        id: childCode1
      -
        id: childCode2
  -
    id: childCode3
    label: Child Code
    parentId: parentCode
    children: [grandChild1, grandChild2]
---
';
parsedSource <-
  parse_source(text=exampleSource);
miniGraph <-
  apply_graph_theme(data.tree::ToDiagrammeRGraph(parsedSource$deductiveCodeTrees),
                    c("color", "#0000AA", "node"),
                    c("shape", "triangle", "node"),
                    c("fontcolor", "#FF0000", "node"));
### This line should be run when executing this example as test, because
### rendering a DiagrammeR graph takes quite long
\dontrun{
DiagrammeR::render_graph(miniGraph);
}
}
