% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustHD-deprecated.R
\name{robustHD-deprecated}
\alias{robustHD-deprecated}
\alias{fortify.seqModel}
\alias{fortify.rlars}
\alias{fortify.sparseLTS}
\alias{diagnosticPlot.default}
\title{Deprecated functions in package \pkg{robustHD}}
\usage{
\method{fortify}{seqModel}(model, data, s = NA, covArgs = list(...), ...)

\method{fortify}{sparseLTS}(
  model,
  data,
  s = NA,
  fit = c("reweighted", "raw", "both"),
  covArgs = list(...),
  ...
)

\method{diagnosticPlot}{default}(
  object,
  which = c("all", "rqq", "rindex", "rfit", "rdiag"),
  ask = (which == "all"),
  facets = attr(object, "facets"),
  size = c(2, 4),
  id.n = NULL,
  ...
)
}
\arguments{
\item{model}{the model fit to be converted.}

\item{data}{currently ignored.}

\item{s}{for the \code{"seqModel"} method, an integer vector giving
the steps of the submodels to be converted (the default is to use the
optimal submodel).  For the \code{"sparseLTS"} method, an integer vector
giving the indices of the models to be converted (the default is to use the
optimal model for each of the requested fits).}

\item{covArgs}{a list of arguments to be passed to
\code{\link[robustbase]{covMcd}} for computing robust Mahalanobis distances.}

\item{\dots}{for the \code{fortify} methods, additional arguments to be
passed to \code{\link[robustbase]{covMcd}} can be specified directly instead
of via \code{covArgs}.  For the default method of \code{diagnosticPlot},
additional arguments to be passed down to \code{\link[ggplot2]{geom_point}}.}

\item{fit}{a character string specifying which fit to convert.  Possible
values are \code{"reweighted"} (the default) to convert the reweighted fit,
\code{"raw"} to convert the raw fit, or \code{"both"} to convert both fits.}

\item{object}{a data frame containing all necessary information for
plotting (as generated by the \code{fortify} methods).}

\item{which}{a character string indicating which plot to show.  Possible
values are \code{"all"} (the default) for all of the following, \code{"rqq"}
for a normal Q-Q plot of the standardized residuals, \code{"rindex"} for a
plot of the standardized residuals versus their index, \code{"rfit"} for a
plot of the standardized residuals versus the fitted values, or
\code{"rdiag"} for a regression diagnostic plot  (standardized residuals
versus robust Mahalanobis distances of the predictor variables).}

\item{ask}{a logical indicating whether the user should be asked before
each plot (see \code{\link[grDevices]{devAskNewPage}}). The default is to
ask if all plots are requested and not ask otherwise.}

\item{facets}{a faceting formula to override the default behavior.  If
supplied, \code{\link[ggplot2]{facet_wrap}} or
\code{\link[ggplot2]{facet_grid}} is called depending on whether the formula
is one-sided or two-sided.}

\item{size}{a numeric vector of length two giving the point and label size,
respectively.}

\item{id.n}{an integer giving the number of the most extreme observations
to be identified by a label.  The default is to use the number of identified
outliers, which can be different for the different plots.}
}
\value{
The \code{fortify} methods return data frame containing the columns
listed below, as well as additional information stored in the attributes
\code{"qqLine"} (intercepts and slopes of the respective reference lines
to be displayed in residual Q-Q plots), \code{"q"} (quantiles of the
Mahalanobis distribution used as cutoff points for detecting leverage
points), and \code{"facets"} (default faceting formula for the diagnostic
plots).
\describe{
  \item{\code{step}}{the steps (for the \code{"seqModel"} method) or indices
  (for the \code{"sparseLTS"} method) of the models (only returned if more
  than one model is requested).}
  \item{\code{fit}}{the model fits (only returned if both the reweighted
  and raw fit are requested in the \code{"sparseLTS"} method).}
  \item{\code{index}}{the indices of the observations.}
  \item{\code{fitted}}{the fitted values.}
  \item{\code{residual}}{the standardized residuals.}
  \item{\code{theoretical}}{the corresponding theoretical quantiles from the
  standard normal distribution.}
  \item{\code{qqd}}{the absolute distances from a reference line through the
  first and third sample and theoretical quartiles.}
  \item{\code{rd}}{the robust Mahalanobis distances computed via the MCD
  (see \code{\link[robustbase]{covMcd}}).}
  \item{\code{xyd}}{the pairwise maxima of the absolute values of the
  standardized residuals and the robust Mahalanobis distances, divided by
  the respective other outlier detection cutoff point.}
  \item{\code{weight}}{the weights indicating regression outliers.}
  \item{\code{leverage}}{logicals indicating leverage points (i.e., outliers
  in the predictor space).}
  \item{\code{classification}}{a factor with levels \code{"outlier"}
  (regression outliers) and \code{"good"} (data points following the model).}
}
}
\description{
These functions are provided for compatibility with older versions only, and
may be defunct as soon as the next release.
}
\details{
The \code{fortify} methods supplement the fitted values and residuals of a
sequence of regression models (such as robust least angle regression models
or sparse least trimmed squares regression models) with other useful
information for diagnostic plots.

The default method of \code{diagnosticPlot} creates the corresponding plot
from the data frame returned by \code{fortify}.
}
\author{
Andreas Alfons
}
\keyword{hplot}
\keyword{utilities}
