% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{nonparametric}
\alias{nonparametric}
\title{Create indices for nonparametric bootstrap}
\usage{
nonparametric(
  indices,
  R,
  size = length(indices),
  replacement = TRUE,
  seed = NULL
)
}
\arguments{
\item{indices}{A vector of indices (integer) from which to sample.}

\item{R}{An integer specifying the number of resamples.}

\item{size}{An integer specifying the size of the resample. Standard
bootstrap suggests to resample as many datapoints as in the original sample,
which is set as the default.}

\item{replacement}{A logical value whether to sample with (TRUE) or without
(FALSE) replacement. Standard bootstrap suggests to resample with
replacement, which is set as the default.}

\item{seed}{\code{NULL} if seed should not be set explicitly or an integer to
which the seed is set. Since this function is usually used inside other
functions, it might not be desirable to set a seed explicitly.}
}
\value{
\code{nonparametric} returns a list of length \code{R} containing
vectors with the resampled indices.
}
\description{
\code{nonparametric} is used for nonparametric resampling, for example
nonparametric case or error/residual resampling. The function takes a vector
of indices that correspond to the indices of observations that should be used
in the resampling procedure.
}
