% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occurrence.R
\name{occurrence}
\alias{occurrence}
\title{Find occurrences.}
\usage{
occurrence(scientificname = NULL, year = NULL, obisid = NULL, aphiaid = NULL,
  groupid = NULL, resourceid = NULL, nodeid = NULL, areaid = NULL, startdate = NULL,
  enddate = NULL, startdepth = NULL, enddepth = NULL, geometry = NULL, qc = NULL,
  fields = NULL, verbose = FALSE)
}
\arguments{
\item{scientificname}{character vector. The full scientific name, with authorship and
date information if known.}

\item{year}{integer vector. The year in which the Event occurred.}

\item{obisid}{integer vector. The OBIS identifier of the species.}

\item{aphiaid}{integer vector. The WoRMS identifier of the species.}

\item{groupid}{integer. The taxonomic group id. See also \code{\link{group}} for the
list of taxonomic groups.}

\item{resourceid}{integer vector. The dataset identifier. See also
\code{\link{dataset}} for querying the list of datasets.}

\item{nodeid}{integer vector. The OBIS node identifier. See also \code{\link{node}} for
the list of nodes.}

\item{areaid}{integer vector. The OBIS area identifier (country, marine world heritage
site, ABNJ, EBSA, ...). See also \code{\link{area}} for the list of areas.}

\item{startdate}{The earliest date on which the Event occurred.}

\item{enddate}{The latest date on which the Event occurred.}

\item{startdepth}{The minimum depth below the sea surface.}

\item{enddepth}{The maximum depth below the sea surface.}

\item{geometry}{A wkt geometry string.}

\item{qc}{A vector of quality control flags you want to filter on. List of
\link[=qc]{QC flags}.}

\item{fields}{A vector of field names you want to have returned in order, by default
all fields with values are returned.}

\item{verbose}{logical. Optional parameter to enable verbose logging (default =
\code{FALSE}).}
}
\value{
The occurrence records.
}
\description{
Find occurrences.
}
\examples{
records <- occurrence(scientificname = "Abra sibogai")
records <- occurrence(aphiaid = 141438, startdate = as.Date("2007-10-10"))
records <- occurrence(aphiaid = 141438, geometry = "POLYGON ((0 0, 0 45, 45 45, 45 0, 0 0))")
records <- occurrence(scientificname = "Abra sibogai", qc = c(1:6, 27))
records <- occurrence(scientificname = "Abra sibogai",
                      fields = c("species", "decimalLongitude", "decimalLatitude"))
}
\seealso{
\code{\link{leafletmap}} \code{\link{qcflags}} \code{\link{checklist}}
  \code{\link{dataset}} \code{\link{area}} \code{\link{node}} \code{\link{group}}
}
