% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intArray.R
\name{intArray}
\alias{intArray}
\title{Interaction array}
\usage{
intArray(x)
}
\arguments{
\item{x}{an object of class \dQuote{intTab}}
}
\value{
The interaction array
}
\description{
Estimates the interaction compositional table 
with normalization for further analysis according to Egozcue et al. (2015)
}
\details{
Estimates the interaction table using its ilr coordinates.
}
\examples{
data(precipitation) 
tab1prob <- prop.table(precipitation)
tab1 <- indTab(precipitation)
tabINT <- intTab(tab1prob, tab1)
intArray(tabINT)
}
\references{
Egozcue, J.J., Pawlowsky-Glahn, V., Templ, M., Hron, K. (2015)
Independence in contingency tables using simplicial geometry. 
\emph{Communications in Statistics - Theory and Methods}, 44 (18), 3978--3996.
}
\seealso{
\code{\link{intTab}}
}
\author{
Matthias Templ
}
