% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impRZilr.R
\name{impRZilr}
\alias{impRZilr}
\title{EM-based replacement of rounded zeros in compositional data}
\usage{
impRZilr(
  x,
  maxit = 10,
  eps = 0.1,
  method = "pls",
  dl = rep(0.05, ncol(x)),
  variation = FALSE,
  nComp = "boot",
  bruteforce = FALSE,
  noisemethod = "residuals",
  noise = FALSE,
  R = 10,
  correction = "normal",
  verbose = FALSE
)
}
\arguments{
\item{x}{data.frame or matrix}

\item{maxit}{maximum number of iterations}

\item{eps}{convergency criteria}

\item{method}{either \dQuote{lm}, \dQuote{MM} or \dQuote{pls}}

\item{dl}{Detection limit for each variable. zero for variables with
variables that have no detection limit problems.}

\item{variation}{matrix is used to first select number of parts}

\item{nComp}{if determined, it fixes the number of pls components. If
\dQuote{boot}, the number of pls components are estimated using a
bootstraped cross validation approach.}

\item{bruteforce}{sets imputed values above the detection limit to the
detection limit. Replacement above the detection limit only exceptionally
occur due to numerical instabilities. The default is FALSE!}

\item{noisemethod}{adding noise to imputed values. Experimental}

\item{noise}{TRUE to activate noise (experimental)}

\item{R}{number of bootstrap samples for the determination of pls
components. Only important for method \dQuote{pls}.}

\item{correction}{normal or density}

\item{verbose}{additional print output during calculations.}
}
\value{
\item{x }{imputed data} \item{criteria }{change between last and
second last iteration} \item{iter }{number of iterations} \item{maxit
}{maximum number of iterations} \item{wind}{index of zeros}
\item{nComp}{number of components for method pls} \item{method}{chosen
method}
}
\description{
Parametric replacement of rounded zeros for compositional data using
classical and robust methods based on ilr coordinates with a special
choice of balances.
}
\details{
Statistical analysis of compositional data including zeros runs into
problems, because log-ratios cannot be applied. Usually, rounded zeros are
considered as missing not at random missing values.

The algorithm iteratively imputes parts with rounded zeros whereas in each
step (1) compositional data are expressed in pivot coordinates (2) tobit regression is
applied (3) the rounded zeros are replaced by the expected values (4) the
corresponding inverse ilr mapping is applied. After all parts are
imputed, the algorithm starts again until the imputations do not change.
}
\examples{

data(arcticLake)
x <- arcticLake
## generate rounded zeros artificially:
#x[x[,1] < 5, 1] <- 0
x[x[,2] < 44, 2] <- 0
xia <- impRZilr(x, dl=c(5,44,0), eps=0.01, method="lm")
xia$x

}
\references{
Martin-Fernandez, J.A., Hron, K., Templ, M., Filzmoser, P., Palarea-Albaladejo, J. (2012)
Model-based replacement of rounded zeros in compositional data: Classical and robust approaches. 
\emph{Computational Statistics and Data Analysis}, 56 (9), 2688-2704.

Templ, M., Hron, K., Filzmoser, P., Gardlo, A. (2016) Imputation of rounded zeros
for high-dimensional compositional data. \emph{Chemometrics and Intelligent
Laboratory Systems}, 155, 183-190.
}
\seealso{
\code{\link{impRZalr}}
}
\author{
Matthias Templ and Peter Filzmoser
}
\keyword{manip}
\keyword{multivariate}
