% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{trondelagC}
\alias{trondelagC}
\title{regional geochemical survey of soil C in Norway}
\format{A data frame with 754 observations and 70 variables}
\usage{
data(trondelagC)
}
\description{
A regional-scale geochemical survey of C horizon samples in Nord-Trondelag, Central Norway
}
\details{
\itemize{
 \item{\code{X.S_ID }}{ID}
 \item{\code{X.Loc_ID }}{ID}
 \item{\code{longitude }}{longitude in WGS84}
 \item{\code{latitude }}{latitude in WGS84}
 \item{\code{E32wgs }}{UTM zone east}
 \item{\code{N32wgs }}{UTM zone north}
 \item{\code{X.Medium }}{}
 \item{\code{Ag }}{Concentration of silver (in mg/kg)}
 \item{\code{Al }}{Concentration of aluminum (in mg/kg)}
 \item{\code{As }}{Concentration of arsenic (in mg/kg)}
 \item{\code{Au }}{Concentration of gold (in mg/kg)}
 \item{\code{B }}{Concentration of boron (in mg/kg)}
 \item{\code{Ba }}{Concentration of barium (in mg/kg)}
 \item{\code{Be }}{Concentration of beryllium (in mg/kg)}
 \item{\code{Bi }}{Concentration of bismuth (in mg/kg)}
 \item{\code{Ca }}{Concentration of calzium (in mg/kg)}
 \item{\code{Cd }}{Concentration of cadmium (in mg/kg)}
 \item{\code{Ce }}{Concentration of cerium (in mg/kg)}
 \item{\code{Co }}{Concentration of cobalt (in mg/kg)}
 \item{\code{Cr }}{Concentration of chromium (in mg/kg)}
 \item{\code{Cs }}{Concentration of cesium (in mg/kg)}
 \item{\code{Cu }}{Concentration of copper (in mg/kg)}
 \item{\code{Fe }}{Concentration of iron (in mg/kg)}
 \item{\code{Ga }}{Concentration of gallium (in mg/kg)}
 \item{\code{Ge }}{Concentration of germanium (in mg/kg)}
 \item{\code{Hf }}{Concentration of hafnium (in mg/kg)}
 \item{\code{Hg }}{Concentration of mercury (in mg/kg)}
 \item{\code{In }}{Concentration of indium (in mg/kg)}
 \item{\code{K }}{Concentration of pottasium (in mg/kg)}
 \item{\code{La }}{Concentration of lanthanum (in mg/kg)}
 \item{\code{Li }}{Concentration of lithium (in mg/kg)}
 \item{\code{Mg }}{Concentration of magnesium (in mg/kg)}
 \item{\code{Mn }}{Concentration of manganese (in mg/kg)}
 \item{\code{Mo }}{Concentration of molybdenum (in mg/kg)}
 \item{\code{Na }}{Concentration of sodium (in mg/kg)}
 \item{\code{Nb }}{Concentration of niobium (in mg/kg)}
 \item{\code{Ni }}{Concentration of nickel (in mg/kg)}
 \item{\code{P }}{Concentration of phosphorus (in mg/kg)}
 \item{\code{Pb }}{Concentration of lead (in mg/kg)}
 \item{\code{Pb204 }}{Concentration of lead, 204 neutrons (in mg/kg)}
 \item{\code{Pb206 }}{Concentration of lead, 206 neutrons (in mg/kg)}
 \item{\code{Pb207 }}{Concentration of lead, 207 neutrons (in mg/kg)}
 \item{\code{Pb208 }}{Concentration of lead, 208 neutrons (in mg/kg)}
 \item{\code{X6_7Pb }}{Concentration of lead (in mg/kg)}
 \item{\code{X7_8Pb }}{Concentration of lead (in mg/kg)}
 \item{\code{X6_4Pb }}{Concentration of lead (in mg/kg)}
 \item{\code{X7_4Pb }}{Concentration of lead (in mg/kg)}
 \item{\code{X8_4Pb }}{Concentration of lead (in mg/kg)}
 \item{\code{Pd }}{Concentration of palladium (in mg/kg)}
 \item{\code{Pt }}{Concentration of platium (in mg/kg)}
 \item{\code{Rb }}{Concentration of rubidium (in mg/kg)}
 \item{\code{Re }}{Concentration of rhenium (in mg/kg)}
 \item{\code{S }}{Concentration of sulfur (in mg/kg)}
 \item{\code{Sb }}{Concentration of antimony (in mg/kg)}
 \item{\code{Sc }}{Concentration of scandium (in mg/kg)}
 \item{\code{Se }}{Concentration of selenium (in mg/kg)}
 \item{\code{Sn }}{Concentration of tin (in mg/kg)}
 \item{\code{Sr }}{Concentration of strontium (in mg/kg)}
 \item{\code{Ta }}{Concentration of tantalum (in mg/kg)}
 \item{\code{Te }}{Concentration of tellurium (in mg/kg)}
 \item{\code{Th }}{Concentration of thorium (in mg/kg)}
 \item{\code{Ti }}{Concentration of titanium (in mg/kg)}
 \item{\code{Tl }}{Concentration of thalium (in mg/kg)}
 \item{\code{U }}{Concentration of uranium (in mg/kg)}
 \item{\code{V }}{Concentration of vanadium (in mg/kg)}
 \item{\code{W }}{Concentration of tungsten (in mg/kg)}
 \item{\code{Y }}{Concentration of yttrium (in mg/kg)}
 \item{\code{Zn }}{Concentration of zinc (in mg/kg)}
 \item{\code{Zr }}{Concentration of zirconium (in mg/kg)}
}

The samples were analysed using aqua regia extraction. 
Sampling was based on a 6.6km grid, i.e. 1 sample site/36 km2.
}
\examples{

data(trondelagC)
str(trondelagC)
}
\references{
C.Reimann, J.Schilling, D.Roberts, K.Fabian. A regional-scale geochemical survey of soil C horizon samples in Nord-Trondelag, Central Norway. Geology and mineral potential, \emph{Applied Geochemistry} 61 (2015) 192-205.
}
\author{
NGU, \url{http://www.ngu.no}, transfered to R by Matthias Templ \email{matthias.templ@tuwien.ac.at}
}
\keyword{data}
