% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BandDepths.R
\name{MBD_relative}
\alias{MBD_relative}
\alias{MBD_relative.default}
\alias{MBD_relative.fData}
\title{Relative Modified Band Depth of functions in a univariate functional dataset}
\usage{
MBD_relative(Data_target, Data_reference)

\method{MBD_relative}{fData}(Data_target, Data_reference)

\method{MBD_relative}{default}(Data_target, Data_reference)
}
\arguments{
\item{Data_target}{is the univariate functional dataset, provided either as
an \code{fData} object or in matrix
form (N observations as rows and P measurements as columns), whose MBD
have to be computed with respect to the reference dataset.}

\item{Data_reference}{is the dataset, provided either as an \code{fData}
object or in matrix form (N observations
as rows and P measurements as columns), containing the reference
univariate functional data that must be used to compute the MBD of
elements in \code{Data_target}. If \code{Data_target} is \code{fData}, it
must be of class \code{fData}.}
}
\value{
The function returns a vector containing the MBD of elements in
\code{Data_target} with respect to elements in \code{Data_reference}.
}
\description{
This function computes Modified Band Depth (BD) of elements of a univariate
functional dataset with respect to another univariate functional dataset.
}
\details{
Given a univariate functional dataset of elements \eqn{X_1(t), X_2(t),
\ldots, X_N(t)}, and another univariate functional dataset of elements
\eqn{Y_1(t), Y_2(t) \ldots, Y_M(t)}, defined over the same compact interval
\eqn{I=[a,b]}, this function computes the MBD of
elements of the former with respect to elements of the latter, i.e.:

\deqn{ MBD( X_i( t ) ) = {M \choose 2 }^{-1} \sum_{1 \leq i_1 < i_2 \leq M}
\tilde{\lambda}\big( {t : \min( Y_{i_1}(t), Y_{i_2}(t) ) \leq X_i(t) \leq
\max( Y_{i_1}(t), Y_{i_2}(t) ) } \big),}

\eqn{\forall i = 1, \ldots, N}, where \eqn{\tilde{\lambda}(\cdot)} is the
normalised Lebesgue measure over \eqn{I=[a,b]}, that is
\eqn{\tilde{\lambda(A)} = \lambda( A ) / ( b - a )}.
}
\examples{
grid = seq( 0, 1, length.out = 1e2 )

Data_ref = matrix( c( 0  + sin( 2 * pi * grid ),
                      1  + sin( 2 * pi * grid ),
                      -1 + sin( 2 * pi * grid ) ),
                   nrow = 3, ncol = length( grid ), byrow = TRUE )

Data_test_1 = matrix( c( 0.6 + sin( 2 * pi * grid ) ),
                      nrow = 1, ncol = length( grid ), byrow = TRUE )

Data_test_2 = matrix( c( 0.6 + sin( 2 * pi * grid ) ),
                      nrow = length( grid ), ncol = 1, byrow = TRUE )

Data_test_3 = 0.6 + sin( 2 * pi * grid )

Data_test_4 = array( 0.6 + sin( 2 * pi * grid ), dim = length( grid ) )

Data_test_5 = array( 0.6 + sin( 2 * pi * grid ), dim = c( 1, length( grid ) ) )

Data_test_6 = array( 0.6 + sin( 2 * pi * grid ), dim = c( length( grid ), 1 ) )

Data_test_7 = matrix( c( 0.5  + sin( 2 * pi * grid ),
                         -0.5 + sin( 2 * pi * grid ),
                         1.1 + sin( 2 * pi * grid ) ),
                      nrow = 3, ncol = length( grid ), byrow = TRUE )

fD_ref = fData( grid, Data_ref )
fD_test_1 = fData( grid, Data_test_1 )
fD_test_2 = fData( grid, Data_test_2 )
fD_test_3 = fData( grid, Data_test_3 )
fD_test_4 = fData( grid, Data_test_4 )
fD_test_5 = fData( grid, Data_test_5 )
fD_test_6 = fData( grid, Data_test_6 )
fD_test_7 = fData( grid, Data_test_7 )

MBD_relative( fD_test_1, fD_ref )
MBD_relative( Data_test_1, Data_ref )

MBD_relative( fD_test_2, fD_ref )
MBD_relative( Data_test_2, Data_ref )

MBD_relative( fD_test_3, fD_ref )
MBD_relative( Data_test_3, Data_ref )

MBD_relative( fD_test_4, fD_ref )
MBD_relative( Data_test_4, Data_ref )

MBD_relative( fD_test_5, fD_ref )
MBD_relative( Data_test_5, Data_ref )

MBD_relative( fD_test_6, fD_ref )
MBD_relative( Data_test_6, Data_ref )

MBD_relative( fD_test_7, fD_ref )
MBD_relative( Data_test_7, Data_ref )
}
\seealso{
\code{\link{MBD}}, \code{\link{BD}}, \code{\link{BD_relative}},
\code{\link{fData}}
}

