% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gefs.R
\name{gefs}
\alias{gefs}
\alias{gefs_CONNECT}
\alias{gefs_GET}
\alias{gefs_latitudes}
\alias{gefs_longitudes}
\alias{gefs_variables}
\alias{gefs_dimensions}
\alias{gefs_dimension_values}
\title{Get GEFS ensemble forecast data for a specific lat/lon.}
\usage{
gefs(var, lat, lon, ...)

gefs_CONNECT(date = format(Sys.time(), "\%Y\%m\%d"),
  forecast_time = c("0000", "0600", "1200", "1800"))

gefs_GET(var, lat, lon, date = format(Sys.time(), "\%Y\%m\%d"),
  forecast_time = c("0000", "0600", "1200", "1800"), ens_idx = 1:21,
  time_idx = 1:65, dims = NULL, raw = FALSE, ...)

gefs_latitudes(con = NULL, ...)

gefs_longitudes(con = NULL, ...)

gefs_variables(con = NULL, ...)

gefs_dimensions(con = NULL, ...)

gefs_dimension_values(dim, con = NULL, ...)
}
\arguments{
\item{var}{the variable to get. Must be one of the variables listed in
\code{gefs_variables()}.}

\item{lat, lon}{the longitude. Will be converted to the nearest GEFS available
longitude. If lon is a list of vlaues, it must be a sequential list, and
data are returned for the number of longitudes in the list starting with
the maximum value and incrementing through the indexed values for the
length of the list.}

\item{...}{additional parameters passed to \code{ncvar_get}.}

\item{date}{A date/string formatted as YYYYMMDD.}

\item{forecast_time}{a string indicating which time of day UTC the forecast is from.
Options are "0000", "0600", "1200", "1800".}

\item{ens_idx}{sequential list of ensembles to fetch. Default is all 21. Note that the
ensembles are labelled 0-20, so ens_idx=1:3 will return ensembles 0, 1, and 2.}

\item{time_idx}{sequential list of time increments to return. List is the index
of times, which are in 6 hour increments. (e.g. c(1,2) fetches the 6 and 12 hour forecast.)}

\item{dims}{(not implemented) indices for additional dimensions to be included between
lat, lon, ens, and time.}

\item{raw}{logical to indicate whether to return raw data matrix or reshaped data frame.}

\item{con}{an ncdf4 connection.}

\item{dim}{(character) the dimension.}
}
\value{
a list containing metadata and accompanying data frame of forecast
  values. If lat/lon are not specified, the $data is an unprocessed matrix.
}
\description{
Fetches GEFS forecast data for every 6 hours out to 384 hours past selected date. GEFS
is an ensemble of 21 models that can be summarized to estimate likelihoods of forecasts.
}
\examples{
\dontrun{

#avialable latitudes and longitudes
gefs_latitudes()
gefs_longitudes()

#get a list of all gefs variables
gefs_variables()

#All GEFS dimensions
gefs_dimensions()

#values for a specific dimension
gefs_dimension_values("height_above_ground")

#example location.
lat <- 46.28125
lon <- -118.2188

#Get forecast for a certain variable.
forecast <- gefs("Total_precipitation_surface_6_Hour_Accumulation_ens",
  lat, lon)

#Fetch a different date (available up to 10 days prior to today)
forecast_yesterday_prec <- gefs(
   "Total_precipitation_surface_6_Hour_Accumulation_ens",
   lat, lon, date=format(as.Date(Sys.time()) - 1, "\%Y\%m\%d"))

#specific ensemble and times, for the 1800 forecast.
# here ensembles 1-3 (ensembles are numbered starting with 0)
# and time for 2 days from today at 1800
date <- format(as.Date(Sys.time()) - 1, "\%Y\%m\%d")
var <- "Temperature_height_above_ground_ens"
gefs(var, lat, lon, date = date, forecast_time = "1800", ens_idx=2:4,
  time_idx=1:8)

#One ensemble, all latitudes and longitudes (this is a big file) for the
# next 3 days.
# gefs(var, ens=1, time=1:12)
}

}
\references{
\itemize{
 \item Data description - \url{http://bit.ly/noaagefs}.
 \item Adapted from Python code written by Von P. Walden, Washington State University.
}
}
\author{
Nicholas Potter \email{potterzot@gmail.com}
}
