% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpc.R
\name{cpc_prcp}
\alias{cpc_prcp}
\title{Precipitation data from NOAA Climate Prediction Center (CPC)}
\usage{
cpc_prcp(date, us = FALSE, ...)
}
\arguments{
\item{date}{(date/character) date in YYYY-MM-DD format}

\item{us}{(logical) US data only? default: \code{FALSE}}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
a data.frame, with columns:
\itemize{
 \item lon - longitude (0 to 360)
 \item lat - latitude (-90 to 90)
 \item precip - precipitation (in mm)
}
}
\description{
Precipitation data from NOAA Climate Prediction Center (CPC)
}
\details{
Rainfall data for the world (1979-present, resolution 50 km), and
the US (1948-present, resolution 25 km).
}
\examples{
\dontrun{
cpc_prcp(date = "2017-01-15")
cpc_prcp(date = "2015-06-05")
cpc_prcp(date = "2017-01-15")

cpc_prcp(date = "2005-07-09")

cpc_prcp(date = "2005-07-09", us = TRUE)
cpc_prcp(date = "2009-08-03", us = TRUE)
}
}
\references{
\url{http://www.cpc.ncep.noaa.gov/}
ftp://ftp.cpc.ncep.noaa.gov/precip/CPC_UNI_PRCP
ftp://ftp.cpc.ncep.noaa.gov/precip/CPC_UNI_PRCP/GAUGE_CONUS/DOCU/PRCP_CU_GAUGE_V1.0CONUS_0.25deg.README
ftp://ftp.cpc.ncep.noaa.gov/precip/CPC_UNI_PRCP/GAUGE_GLB/DOCU/PRCP_CU_GAUGE_V1.0GLB_0.50deg_README.txt
https://www.esrl.noaa.gov/psd/data/gridded/data.unified.daily.conus.html
}
