% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.sensitivity_function.R
\name{run_sensitivity}
\alias{run_sensitivity}
\title{Perform sensitivity analysis for missing participant outcome data}
\usage{
run_sensitivity(
  full,
  assumption,
  mean_scenarios,
  var_misspar,
  n_chains,
  n_iter,
  n_burnin,
  n_thin
)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{assumption}{Character string indicating the structure of the
informative missingness parameter. Set \code{assumption} equal to one of
the following two: \code{"HIE-ARM"}, or \code{"IDE-ARM"} (see 'Details').
The default argument is \code{"IDE-ARM"}. The abbreviations \code{"IDE"},
and \code{"HIE"} stand for identical, and hierarchical, respectively.}

\item{mean_scenarios}{A vector with numeric values for the mean of the normal
distribution of the informative missingness parameter (see 'Details').
The vector should have a length equal to 5 or larger.
The missing-at-random (MAR) assumption should be the median of the vector,
so that the same number of informative scenarios appear before and after
the MAR. The default scenarios are c(-log(3), -log(2), log(0.9999), log(2),
log(3)) and c(-2, -1, 0, 1, 2) for binary and continuous outcome data,
respectively.}

\item{var_misspar}{A positive non-zero number for the variance of the normal
distribution of the informative missingness parameter. When the
\code{measure} (defined in \code{\link{run_model}}) is \code{"OR"},
\code{"MD"}, or \code{"SMD"} the default argument is 1. When the
\code{measure} is \code{"ROM"}, the default argument is 0.04.}

\item{n_chains}{Integer specifying the number of chains for the MCMC
sampling; an argument of the \code{\link[R2jags:jags]{jags}} function of
the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 2.}

\item{n_iter}{Integer specifying the number of Markov chains for the MCMC
sampling; an argument of the \code{\link[R2jags:jags]{jags}} function of
the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 10000.}

\item{n_burnin}{Integer specifying the number of iterations to discard at the
beginning of the MCMC sampling; an argument of the
\code{\link[R2jags:jags]{jags}} function of the R-package
\href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1000.}

\item{n_thin}{Integer specifying the thinning rate for the MCMC sampling; an
argument of the \code{\link[R2jags:jags]{jags}} function of the R-package
\href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1.}
}
\value{
A list of R2jags outputs on the summaries of the posterior
  distribution, and the Gelman-Rubin convergence diagnostic
  (Gelman et al., 1992) of the following monitored parameters for a
  random-effects pairwise meta-analysis:
  \item{EM}{The estimated summary effect measure (according to the
   argument \code{measure} defined in \code{\link{run_model}}).}
  \item{EM_LOR}{The estimated summary odd ratio in the logarithmic scale when
  \code{measure = "RR"} or \code{measure = "RD"}.}
  \item{tau}{The between-trial standard deviation. This element does
   not appear in the case of a fixed-effect pairwise meta-analysis.}

  In a random-effects network meta-analysis, \code{EM} refer to all possible
  pairwise comparisons of interventions in the network. Furthermore,
  \code{tau} is typically assumed to be common for all observed comparisons
  in the network.
}
\description{
Performs a sensitivity analysis by applying pairwise
  meta-analysis or network meta-analysis for a series of different scenarios
  about the informative missingness parameter.
}
\details{
The model runs in \code{JAGS} and the progress of the simulation
  appears on the R console. The number of times \code{run_sensitivity} is
  used appears on the R console as a text in red and it equals the
  \bold{number of scenarios} defined as \emph{the square of the length of the
  vector specified in \code{mean_scenarios}} (see 'Examples').
  The output of \code{run_sensitivity} is used as an S3 object by other
  functions of the package to be processed further and provide an
  end-user-ready output.

  In the case of pairwise meta-analysis, \code{EM} and \code{tau} are
  estimated as many times as the number of scenarios considered.
  In the case of network meta-analysis, each possible pairwise comparison is
  estimated as many times as the number of scenarios considered.

  The informative missingness parameter is assumed to differ only across the
  interventions of the dataset. Therefore, the user can specify the
  informative missingness parameter to be arm-specific \emph{and} identical
  (\code{assumption = "IDE-ARM"}), or arm-specific \emph{and}
  hierarchical (\code{assumption = "HIE-ARM"}) (Spineli et al., 2021).

  The length of the vector specified in argument \code{mean_scenarios} should
  be equal to or more than 5 (a positive odd integer) to allow for an
  adequate number of scenarios. It is important that the number
  corresponding to the MAR assumption is the middle of the numbers in the
  vector specified in argument \code{mean_scenarios}. The \bold{MAR
  assumption} constitutes the \bold{primary analysis}.
  Under the informative missingness difference of means parameter (relevant
  for the raw and standardised mean diffenre), the MAR assumption equals 0.
  Under the informative missingness odds ratio parameter (IMOR; relevant for
  the odds ratio) and the informative missingness ratio of means (IMRoM;
  relevant for the ratio of means) parameter, the MAR assumption equals 1;
  however, both parameters are analysed in the logarithmic scale. We advise
  using the value \code{0.999} rather than \code{1} in \code{mean_scenarios}
  for the IMOR and IMRoM parameters; otherwise, the execution of the function
  will be stopped and the error 'Invalid parent values' will be printed on
  the R console.

  Currently, there are no empirically-based prior distributions for the
  informative missingness parameters. The users may refer to Spineli (2019),
  Mavridis et al. (2015), Turner et al. (2015), and White et al. (2008) to
  determine \code{mean_scenarios} for an informative missingness mechanism
  and select a proper value for \code{var_misspar}.

  \code{run_sensitivity} inherits the arguments \code{data},
  \code{measure}, \code{model}, \code{heter_prior}, \code{D}, \code{indic},
  \code{base_risk}, and \code{ref} from \code{\link{run_model}}
  (now contained in the argument \code{full}). This prevents specifying a
  different Bayesian model from that considered in the primary analysis
  (via \code{\link{run_model}})--an exception in the \code{assumption}
  argument as it is restricted to only two character strings. Therefore, the
  user needs first to apply \code{\link{run_model}}, and then use
  \code{run_sensitivity} (see 'Examples').

  The \code{run_sensitivity} function also returns the arguments
  \code{measure}, \code{scenarios}, \code{D}, \code{heter}, \code{n_chains},
  \code{n_iter}, \code{n_burnin}, and \code{n_thin} as specified by the user
  to be inherited by other relevant functions of the package.

  \code{run_sensitivity} can be used only when missing participant
  outcome data have been extracted for at least one trial. Otherwise, the
  execution of the function will be stopped and an error message will be
  printed on the R console.
}
\examples{
data("pma.taylor2004")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_taylor.rds', package = 'rnmamod'))

\donttest{
# Perform the sensitivity analysis (default arguments)
# Note: Ideally, set 'n_iter' to 10000 and 'n_burnin' to 1000
run_sensitivity(full = res,
                assumption = "IDE-ARM",
                var_misspar = 1,
                n_chains = 3,
                n_iter = 1000,
                n_burnin = 100,
                n_thin = 5)
}

}
\references{
Gelman, A, Rubin, DB. Inference from iterative simulation using multiple
sequences. \emph{Stat Sci} 1992;\bold{7}(4):457--72.
doi: 10.1214/ss/1177011136

Mavridis D, White IR, Higgins JP, Cipriani A, Salanti G. Allowing for
uncertainty due to missing continuous outcome data in pairwise and network
meta-analysis. \emph{Stat Med} 2015;\bold{34}(5):721--41.
doi: 10.1002/sim.6365

Spineli LM, Kalyvas C, Papadimitropoulou K. Quantifying the robustness of
primary analysis results: A case study on missing outcome data in pairwise
and network meta-analysis.
\emph{Res Synth Methods} 2021;\bold{12}(4):475--90. doi: 10.1002/jrsm.1478

Spineli LM. An empirical comparison of Bayesian modelling strategies for
missing binary outcome data in network meta-analysis.
\emph{BMC Med Res Methodol} 2019;\bold{19}(1):86.
doi: 10.1186/s12874-019-0731-y

Turner NL, Dias S, Ades AE, Welton NJ. A Bayesian framework to account for
uncertainty due to missing binary outcome data in pairwise meta-analysis.
\emph{Stat Med} 2015;\bold{34}(12):2062--80. doi: 10.1002/sim.6475

White IR, Higgins JP, Wood AM. Allowing for uncertainty due to missing data
in meta-analysis--part 1: two-stage methods.
\emph{Stat Med} 2008;\bold{27}(5):711--27. doi: 10.1002/sim.3008
}
\seealso{
\code{\link[R2jags:jags]{jags}}, \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
