% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.missing.dataset_function.R
\name{heatmap_missing_dataset}
\alias{heatmap_missing_dataset}
\title{Heatmap of proportion of missing participants in the dataset}
\usage{
heatmap_missing_dataset(data, trial_names, drug_names)
}
\arguments{
\item{data}{A data-frame of a one-trial-per-row format containing arm-level
data of each trial. See 'Format' in \code{\link{run_model}}.}

\item{trial_names}{A vector of labels with the name of the trials in the
order they appear in the argument \code{data}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data}.}
}
\value{
A heatmap presenting the proportion of missing participants in each
  trial-arm of the dataset. The columns and the rows of the heatmap
  correspond to the interventions and trials, respectively.
  The 'five-and-twenty' rule of Sackett and colleagues (1997) is used to
  characterise the proportion of missing participants as being associated
  with low (up to 5\%), moderate (more than 5\% and up to 20\%), and high
  risk of bias (more than 20\%). Low, moderate, and high risk of bias due to
  missing participants are indicated using green, orange, and red colour,
  respectively. The function is also applicable for a pairwise meta-analysis.
  If missing participants have not been reported for a trial-arm, the
  corresponding cell is indicated in grey.
}
\description{
Illustrates the proportion of missing participants and the
  associated risk of bias in each arm of every trial in the dataset.
}
\details{
When the number of missing participants has not been extracted for
  any arm of the trials, the execution of the function will be stopped and
  an error message will be printed on the R console.

  When there are more than 80 trials, the value on the proportion of missing
  participants will not appear on the heatmap. This is because the number on
  the cells will not be distinguishable.
}
\examples{
data("nma.schwingshackl2014")

# Return the first six trials of the dataset
head(nma.schwingshackl2014)

# The names of the interventions in the order they appear in the dataset
interv_names <- c("aerobic", "resistance", "combined training")

# Create the heatmap
heatmap_missing_dataset(data = nma.schwingshackl2014,
                        trial_names = nma.schwingshackl2014$study,
                        drug_names = interv_names)

}
\references{
Sackett DL, Richardson WS, Rosenberg WM, Haynes RB. Evidence-based medicine:
how to practice and teach EBM. New York: Churchill Livingstone 1997.
ISBN: 0-443-05686-2.
}
\seealso{
\code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
