% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.missing.network_function.R
\name{heatmap_missing_network}
\alias{heatmap_missing_network}
\title{Heatmap of proportion of missing participant outcome data in the network}
\usage{
heatmap_missing_network(data, drug_names)
}
\arguments{
\item{data}{A data-frame of a one-trial-per-row format containing arm-level
data of each trial. See 'Format' in \code{\link[rnmamod]{run_model}}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data}. If the argument
\code{drug_names} is not defined, the order of the interventions as they
appear in \code{data} is used, instead.}
}
\value{
A heatmap of the proportion of MOD in each intervention and observed
  comparison in the network. Each cell annotates the median, minimum and
  maximum (the latter two in parenthesis) proportion of MOD across the
  corresponding trials.
  The proportion of MOD in each intervention and observed comparison are
  depicted in the main diagonal and lower off-diagonal with white and black
  colour, respectively, The pairwise comparisons are read from left to right.

  The 'five-and-twenty' rule of Sackett and colleagues (1997) is used to
  characterise the \bold{median} proportion of MOD as being associated with
  low (up to 5\%), moderate (more than 5\% and up to 20\%), and high risk of
  bias (more than 20\%). Low, moderate, and high risk of bias associated with
  MOD is indicated using green, orange, and red colour, respectively.

  The summary statistics (median, minimum and maximum) for each intervention
  (main diagonal; white font) result from calculating the proportion of
  missing participants in each arm of every trial and then summarising across
  the corresponding trial-arms. Similarly, the summary statistics for each
  observed comparison (lower off-diagonal; black font) result from
  calculating the proportion of total missing participants in each trial and
  then summarising across the corresponding trials.

  The \code{heatmap_missing_network} function is redundant for a pairwise
  meta-analysis.
}
\description{
Illustrates the distribution of missing participant outcome data
 (MOD) and the associated risk of bias for each intervention and observed
 comparison in the network.
}
\examples{
data("nma.stowe2011")

# Return the first six trials of the dataset
head(nma.stowe2011)

# The names of the interventions in the order they appear in the dataset
interv_names <- c("PBO+LD", "DA+LD", "COMTI+LD", "MAOBI+LD")

# Create the heatmap
heatmap_missing_network(data = nma.stowe2011,
                        drug_names = interv_names)

}
\references{
Sackett DL, Richardson WS, Rosenberg WM, Haynes RB. Evidence-based medicine:
how to practice and teach EBM. New York: Churchill Livingstone 1997.
ISBN: 0-443-05686-2.
}
\seealso{
\code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
