% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dateconverter.R
\name{dateconverter}
\alias{dateconverter}
\title{dateconverter}
\usage{
dateconverter(StartDate, EndDate, Transform)
}
\arguments{
\item{StartDate}{A valid as.Date object. This can be given as ymd("2000-01-01") or as.Date("2000-01-01")}

\item{EndDate}{A valid as.Date object. This can be given as ymd("2000-01-01") or as.Date("2000-01-01")}

\item{Transform}{This is the days that you want returned. Options include:
alldays: All calendar days between the start and end date
calendarEOM: Last calendar day of each month between the start and end date
weekdays: All weekdays between the start and end date (mon - fri)
weekdayEOW: All last weekdays between the start and end date
weekdayEOM: All last weekdays of the month between the start and end date
weekdayEOQ: All last weekdays of the quarter between the start and end date
weekdayEOY: All last weekdays of the year between the start and end date}
}
\value{
Path address just built.
}
\description{
dateconverter makes it easy to create a date vector in R. It offers a simple wrapper using xts functionality to create a vector of dates between a given Start and End date, and then correcting for the chosen frequency transformation.
}
\examples{
dateconverter(as.Date("2000-01-01"),
as.Date("2017-01-01"), "weekdays")
dateconverter(as.Date("2000-01-01"),
as.Date("2017-01-01"), "calendarEOM")
dateconverter(as.Date("2000-01-01"),
as.Date("2017-01-01"), "weekdayEOW")
dateconverter(as.Date("2000-01-01"),
as.Date("2017-01-01"), "weekdayEOM")
dateconverter(as.Date("2000-01-01"),
as.Date("2017-01-01"), "weekdayEOQ")
dateconverter(as.Date("2000-01-01"),
as.Date("2017-01-01"), "weekdayEOY")
dateconverter(as.Date("2000-01-01"),
as.Date("2017-01-01"), "alldays")
}
