% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mongo.index.TTLcreate}
\alias{mongo.index.TTLcreate}
\title{Add a time to live (TTL) index to a collection}
\usage{
mongo.index.TTLcreate(mongo, ns, key, expireAfterSeconds, index_name = NULL)
}
\arguments{
\item{mongo}{(\link{mongo}) A mongo connection object.}

\item{ns}{(string) The namespace of the collection to add a TTL index to.}

\item{key}{(\link{mongo.bson}) The desired field(s) to use as the basis for expiration time. The field should be of type 'Date'.

Alternately, \code{key} may be a list which will be converted to a
mongo.bson object by \code{\link{mongo.bson.from.list}()}.

Alternately, \code{key} may be a valid JSON character string which will be converted to a
mongo.bson object by \code{\link{mongo.bson.from.JSON}()}.}

\item{expireAfterSeconds}{(Numeric or Integer) The time in seconds after which records should be removed.}

\item{index_name}{(string) The name of the index to be created.}
}
\value{
NULL if the command failed.  \code{\link{mongo.get.err}()} may be
MONGO_COMMAND_FAILED.

(\link{mongo.bson}) The server's response if successful.
}
\description{
Add a time to live (TTL) index to a collection
}
\details{
See \url{http://docs.mongodb.org/manual/tutorial/expire-data}.
}
\examples{
mongo <- mongo.create()
if (mongo.is.connected(mongo)) {
 for (i in 1:10) mongo.insert(mongo, ns = 'test.testTTL', b = list(a = i,  last_updated = i))
 res_bson <- mongo.index.TTLcreate (mongo, ns = 'test.testTTL', key = list(last_updated = 1),
                                     expireAfterSeconds = 3600, index_name = 'last_updated_1')
 print(res_bson);
 mongo.drop(mongo, ns = 'test.testTTL')
}
mongo.destroy(mongo);
}
\seealso{
\code{\link{mongo.index.create}}
}

