% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mongo.cursor.to.list}
\alias{mongo.cursor.to.list}
\alias{mongo.cursor.to.rlist}
\title{Convert Mongo Cursor Object to List so that each element of resulting list represents document in source collection.}
\usage{
mongo.cursor.to.list(cursor, keep.ordering = TRUE)
}
\arguments{
\item{cursor}{(\link{mongo.cursor}) A mongo.cursor object returned from \code{\link{mongo.find}()}.}

\item{keep.ordering}{should the records be returned at the same order as fetched from cursor (if sorting was specified in query)?
For speed try to set this parameter to FALSE. This will prevent sorting after fetching from cursor.}
}
\value{
An R \link{list} object.
}
\description{
Converts a mongo cursor object to a list by interating over all cursor objects and combining them.
It doesn't make any data coercion!, just one-to-one mapping with documents in source collection.
}
\details{
Since rmongodb 1.8.0 function uses environments to avoid extra copying, so now it is much faster.
}
\examples{
mongo <- mongo.create()
if (mongo.is.connected(mongo)) {
    buf <- mongo.bson.buffer.create()
    mongo.bson.buffer.append(buf, "age", 22L)
    query <- mongo.bson.from.buffer(buf)

    # Find the first 100 records
    #    in collection people of database test where age == 22
    cursor <- mongo.find(mongo, "test.people", query, limit=100L)

    res <- mongo.cursor.to.list(cursor)

}
}
\seealso{
\code{\link{mongo.find}}
}

