/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j;

import com.chenlb.mmseg4j.CharNode;
import com.chenlb.mmseg4j.Chunk;
import com.chenlb.mmseg4j.Dictionary;
import com.chenlb.mmseg4j.Seg;
import com.chenlb.mmseg4j.Sentence;
import com.chenlb.mmseg4j.Word;
import com.chenlb.mmseg4j.rule.LargestAvgLenRule;
import com.chenlb.mmseg4j.rule.LargestSumDegreeFreedomRule;
import com.chenlb.mmseg4j.rule.MaxMatchRule;
import com.chenlb.mmseg4j.rule.Rule;
import com.chenlb.mmseg4j.rule.SmallestVarianceRule;
import java.util.ArrayList;
import java.util.List;

public class ComplexSeg
extends Seg {
    private MaxMatchRule mmr = new MaxMatchRule();
    private List<Rule> otherRules = new ArrayList<Rule>();
    private static boolean showChunk = false;

    public ComplexSeg(Dictionary dictionary) {
        super(dictionary);
        this.otherRules.add(new LargestAvgLenRule());
        this.otherRules.add(new SmallestVarianceRule());
        this.otherRules.add(new LargestSumDegreeFreedomRule());
    }

    public Chunk seg(Sentence sentence) {
        char[] cArray = sentence.getText();
        int[] nArray = new int[3];
        ArrayList[] arrayListArray = new ArrayList[2];
        for (int i = 0; i < 2; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        CharNode[] charNodeArray = new CharNode[3];
        int[] nArray2 = new int[3];
        this.mmr.reset();
        if (!sentence.isFinish()) {
            if (showChunk) {
                System.out.println();
            }
            int n = 0;
            nArray2[0] = sentence.getOffset();
            this.maxMatch(charNodeArray, 0, cArray, nArray2[0], arrayListArray, 0);
            for (int i = arrayListArray[0].size() - 1; i >= 0; --i) {
                nArray[0] = (Integer)arrayListArray[0].get(i);
                nArray2[1] = nArray2[0] + 1 + nArray[0];
                this.maxMatch(charNodeArray, 1, cArray, nArray2[1], arrayListArray, 1);
                for (int j = arrayListArray[1].size() - 1; j >= 0; --j) {
                    nArray[1] = (Integer)arrayListArray[1].get(j);
                    nArray2[2] = nArray2[1] + 1 + nArray[1];
                    nArray[2] = this.maxMatch(charNodeArray, 2, cArray, nArray2[2]);
                    int n2 = 0;
                    for (int k = 0; k < 3; ++k) {
                        n2 += nArray[k] + 1;
                    }
                    Chunk chunk = null;
                    if (n2 >= n) {
                        n = n2;
                        chunk = this.createChunk(sentence, cArray, nArray, nArray2, charNodeArray);
                        this.mmr.addChunk(chunk);
                    }
                    if (!showChunk) continue;
                    if (chunk == null) {
                        chunk = this.createChunk(sentence, cArray, nArray, nArray2, charNodeArray);
                        this.mmr.addChunk(chunk);
                    }
                    System.out.println(chunk);
                }
            }
            sentence.addOffset(n);
            List<Chunk> list = this.mmr.remainChunks();
            for (Rule rule : this.otherRules) {
                if (showChunk) {
                    System.out.println("-------filter before " + rule + "----------");
                    this.printChunk(list);
                }
                if (list.size() <= 1) break;
                rule.reset();
                rule.addChunks(list);
                list = rule.remainChunks();
            }
            if (showChunk) {
                System.out.println("-------remainChunks----------");
                this.printChunk(list);
            }
            if (list.size() > 0) {
                return list.get(0);
            }
        }
        return null;
    }

    private Chunk createChunk(Sentence sentence, char[] cArray, int[] nArray, int[] nArray2, CharNode[] charNodeArray) {
        Chunk chunk = new Chunk();
        for (int i = 0; i < 3; ++i) {
            CharNode charNode;
            if (nArray2[i] >= cArray.length) continue;
            chunk.words[i] = new Word(cArray, sentence.getStartOffset(), nArray2[i], nArray[i] + 1);
            if (nArray[i] != 0 || (charNode = charNodeArray[i]) == null) continue;
            chunk.words[i].setDegree(charNode.getFreq());
        }
        return chunk;
    }

    public static boolean isShowChunk() {
        return showChunk;
    }

    public static void setShowChunk(boolean bl) {
        showChunk = bl;
    }
}

