// Generated by rstantools.  Do not edit by hand.

/*
    rmdcev is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rmdcev is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rmdcev.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by %%NAME%% %%VERSION%%
#include <stan/model/model_header.hpp>
namespace model_mdcev_rp_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 224, column 1 to column 58)",
                                                      " (in 'string', line 225, column 1 to column 62)",
                                                      " (in 'string', line 226, column 1 to column 15)",
                                                      " (in 'string', line 227, column 3 to column 19)",
                                                      " (in 'string', line 228, column 1 to column 50)",
                                                      " (in 'string', line 229, column 3 to column 45)",
                                                      " (in 'string', line 230, column 1 to column 26)",
                                                      " (in 'string', line 233, column 1 to column 20)",
                                                      " (in 'string', line 234, column 3 to column 27)",
                                                      " (in 'string', line 236, column 8 to column 9)",
                                                      " (in 'string', line 236, column 11 to column 13)",
                                                      " (in 'string', line 236, column 1 to column 20)",
                                                      " (in 'string', line 237, column 8 to column 9)",
                                                      " (in 'string', line 237, column 11 to column 12)",
                                                      " (in 'string', line 237, column 1 to column 19)",
                                                      " (in 'string', line 238, column 10 to column 11)",
                                                      " (in 'string', line 238, column 3 to column 32)",
                                                      " (in 'string', line 239, column 10 to column 11)",
                                                      " (in 'string', line 239, column 13 to column 14)",
                                                      " (in 'string', line 239, column 3 to column 35)",
                                                      " (in 'string', line 240, column 10 to column 11)",
                                                      " (in 'string', line 240, column 13 to column 14)",
                                                      " (in 'string', line 240, column 3 to column 33)",
                                                      " (in 'string', line 241, column 3 to column 19)",
                                                      " (in 'string', line 245, column 4 to column 21)",
                                                      " (in 'string', line 243, column 4 to column 26)",
                                                      " (in 'string', line 242, column 3 to line 245, column 21)",
                                                      " (in 'string', line 246, column 18 to column 52)",
                                                      " (in 'string', line 246, column 1 to column 52)",
                                                      " (in 'string', line 251, column 2 to column 57)",
                                                      " (in 'string', line 250, column 22 to line 252, column 2)",
                                                      " (in 'string', line 250, column 8 to line 252, column 2)",
                                                      " (in 'string', line 249, column 2 to column 66)",
                                                      " (in 'string', line 248, column 15 to line 250, column 2)",
                                                      " (in 'string', line 248, column 1 to line 252, column 2)",
                                                      " (in 'string', line 262, column 2 to column 56)",
                                                      " (in 'string', line 263, column 2 to column 58)",
                                                      " (in 'string', line 261, column 51 to line 264, column 2)",
                                                      " (in 'string', line 261, column 8 to line 264, column 2)",
                                                      " (in 'string', line 254, column 2 to column 50)",
                                                      " (in 'string', line 260, column 3 to column 58)",
                                                      " (in 'string', line 259, column 7 to line 260, column 58)",
                                                      " (in 'string', line 258, column 5 to column 68)",
                                                      " (in 'string', line 257, column 7 to line 260, column 58)",
                                                      " (in 'string', line 256, column 5 to column 46)",
                                                      " (in 'string', line 255, column 2 to line 260, column 58)",
                                                      " (in 'string', line 253, column 44 to line 261, column 2)",
                                                      " (in 'string', line 253, column 1 to line 264, column 2)",
                                                      " (in 'string', line 271, column 2 to column 50)",
                                                      " (in 'string', line 269, column 3 to column 58)",
                                                      " (in 'string', line 268, column 7 to line 269, column 58)",
                                                      " (in 'string', line 267, column 3 to column 58)",
                                                      " (in 'string', line 266, column 2 to line 269, column 58)",
                                                      " (in 'string', line 265, column 44 to line 270, column 2)",
                                                      " (in 'string', line 265, column 1 to line 271, column 50)",
                                                      " (in 'string', line 282, column 3 to column 30)",
                                                      " (in 'string', line 281, column 7 to line 282, column 30)",
                                                      " (in 'string', line 280, column 4 to column 88)",
                                                      " (in 'string', line 279, column 3 to line 280, column 88)",
                                                      " (in 'string', line 278, column 2 to line 282, column 30)",
                                                      " (in 'string', line 277, column 26 to line 283, column 2)",
                                                      " (in 'string', line 277, column 8 to line 283, column 2)",
                                                      " (in 'string', line 273, column 2 to column 65)",
                                                      " (in 'string', line 276, column 4 to column 98)",
                                                      " (in 'string', line 275, column 3 to line 276, column 98)",
                                                      " (in 'string', line 274, column 2 to line 276, column 98)",
                                                      " (in 'string', line 272, column 19 to line 277, column 2)",
                                                      " (in 'string', line 272, column 1 to line 283, column 2)",
                                                      " (in 'string', line 289, column 9 to column 10)",
                                                      " (in 'string', line 289, column 12 to column 13)",
                                                      " (in 'string', line 289, column 2 to column 22)",
                                                      " (in 'string', line 294, column 4 to column 97)",
                                                      " (in 'string', line 293, column 3 to line 294, column 97)",
                                                      " (in 'string', line 292, column 7 to line 294, column 97)",
                                                      " (in 'string', line 291, column 3 to column 32)",
                                                      " (in 'string', line 290, column 2 to line 294, column 97)",
                                                      " (in 'string', line 295, column 2 to line 297, column 60)",
                                                      " (in 'string', line 288, column 27 to line 298, column 2)",
                                                      " (in 'string', line 288, column 8 to line 298, column 2)",
                                                      " (in 'string', line 285, column 2 to line 287, column 30)",
                                                      " (in 'string', line 284, column 19 to line 288, column 2)",
                                                      " (in 'string', line 284, column 1 to line 298, column 2)",
                                                      " (in 'string', line 235, column 3 to line 299, column 4)",
                                                      " (in 'string', line 313, column 3 to column 24)",
                                                      " (in 'string', line 314, column 3 to column 33)",
                                                      " (in 'string', line 316, column 11 to column 13)",
                                                      " (in 'string', line 316, column 15 to column 17)",
                                                      " (in 'string', line 316, column 4 to column 21)",
                                                      " (in 'string', line 322, column 3 to column 28)",
                                                      " (in 'string', line 321, column 23 to line 323, column 3)",
                                                      " (in 'string', line 321, column 9 to line 323, column 3)",
                                                      " (in 'string', line 318, column 10 to column 12)",
                                                      " (in 'string', line 318, column 14 to column 16)",
                                                      " (in 'string', line 318, column 3 to column 24)",
                                                      " (in 'string', line 319, column 3 to column 54)",
                                                      " (in 'string', line 320, column 3 to column 38)",
                                                      " (in 'string', line 317, column 16 to line 321, column 3)",
                                                      " (in 'string', line 317, column 2 to line 323, column 3)",
                                                      " (in 'string', line 315, column 1 to line 324, column 2)",
                                                      " (in 'string', line 326, column 2 to column 55)",
                                                      " (in 'string', line 325, column 14 to line 327, column 2)",
                                                      " (in 'string', line 325, column 1 to line 327, column 2)",
                                                      " (in 'string', line 303, column 3 to column 37)",
                                                      " (in 'string', line 304, column 1 to column 52)",
                                                      " (in 'string', line 305, column 1 to column 29)",
                                                      " (in 'string', line 306, column 1 to column 31)",
                                                      " (in 'string', line 307, column 1 to column 40)",
                                                      " (in 'string', line 308, column 1 to column 22)",
                                                      " (in 'string', line 310, column 2 to column 43)",
                                                      " (in 'string', line 127, column 0 to column 6)",
                                                      " (in 'string', line 128, column 0 to column 6)",
                                                      " (in 'string', line 129, column 0 to column 12)",
                                                      " (in 'string', line 130, column 0 to column 9)",
                                                      " (in 'string', line 131, column 0 to column 36)",
                                                      " (in 'string', line 132, column 8 to column 31)",
                                                      " (in 'string', line 132, column 34 to column 41)",
                                                      " (in 'string', line 132, column 0 to column 51)",
                                                      " (in 'string', line 133, column 8 to column 34)",
                                                      " (in 'string', line 133, column 37 to column 41)",
                                                      " (in 'string', line 133, column 0 to column 51)",
                                                      " (in 'string', line 134, column 7 to column 8)",
                                                      " (in 'string', line 134, column 10 to column 11)",
                                                      " (in 'string', line 134, column 0 to column 21)",
                                                      " (in 'string', line 135, column 7 to column 8)",
                                                      " (in 'string', line 135, column 10 to column 11)",
                                                      " (in 'string', line 135, column 0 to column 21)",
                                                      " (in 'string', line 136, column 7 to column 8)",
                                                      " (in 'string', line 136, column 0 to column 17)",
                                                      " (in 'string', line 137, column 0 to column 34)",
                                                      " (in 'string', line 138, column 0 to column 18)",
                                                      " (in 'string', line 139, column 0 to column 18)",
                                                      " (in 'string', line 140, column 0 to column 20)",
                                                      " (in 'string', line 141, column 0 to column 23)",
                                                      " (in 'string', line 142, column 0 to column 20)",
                                                      " (in 'string', line 143, column 0 to column 35)",
                                                      " (in 'string', line 144, column 0 to column 33)",
                                                      " (in 'string', line 145, column 0 to column 47)",
                                                      " (in 'string', line 146, column 0 to column 33)",
                                                      " (in 'string', line 147, column 0 to column 31)",
                                                      " (in 'string', line 148, column 7 to column 8)",
                                                      " (in 'string', line 148, column 0 to column 18)",
                                                      " (in 'string', line 149, column 2 to column 29)",
                                                      " (in 'string', line 150, column 11 to column 12)",
                                                      " (in 'string', line 150, column 2 to column 14)",
                                                      " (in 'string', line 151, column 22 to column 23)",
                                                      " (in 'string', line 151, column 2 to column 25)",
                                                      " (in 'string', line 152, column 12 to column 13)",
                                                      " (in 'string', line 152, column 2 to column 15)",
                                                      " (in 'string', line 153, column 10 to column 11)",
                                                      " (in 'string', line 153, column 2 to column 13)",
                                                      " (in 'string', line 154, column 2 to column 26)",
                                                      " (in 'string', line 155, column 2 to column 41)",
                                                      " (in 'string', line 156, column 2 to column 41)",
                                                      " (in 'string', line 159, column 1 to column 8)",
                                                      " (in 'string', line 160, column 1 to column 12)",
                                                      " (in 'string', line 161, column 1 to column 10)",
                                                      " (in 'string', line 162, column 1 to column 10)",
                                                      " (in 'string', line 165, column 0 to column 6)",
                                                      " (in 'string', line 166, column 0 to column 10)",
                                                      " (in 'string', line 167, column 0 to column 9)",
                                                      " (in 'string', line 168, column 0 to column 6)",
                                                      " (in 'string', line 169, column 7 to column 8)",
                                                      " (in 'string', line 169, column 0 to column 18)",
                                                      " (in 'string', line 170, column 7 to column 8)",
                                                      " (in 'string', line 170, column 10 to column 11)",
                                                      " (in 'string', line 170, column 0 to column 21)",
                                                      " (in 'string', line 171, column 7 to column 8)",
                                                      " (in 'string', line 171, column 0 to column 12)",
                                                      " (in 'string', line 172, column 7 to column 8)",
                                                      " (in 'string', line 172, column 0 to column 21)",
                                                      " (in 'string', line 175, column 1 to column 56)",
                                                      " (in 'string', line 177, column 2 to column 42)",
                                                      " (in 'string', line 176, column 14 to line 178, column 2)",
                                                      " (in 'string', line 176, column 1 to line 178, column 2)",
                                                      " (in 'string', line 179, column 3 to column 28)",
                                                      " (in 'string', line 174, column 13 to line 180, column 1)",
                                                      " (in 'string', line 174, column 0 to line 180, column 1)",
                                                      " (in 'string', line 182, column 0 to column 23)",
                                                      " (in 'string', line 188, column 2 to column 17)",
                                                      " (in 'string', line 187, column 25 to line 189, column 1)",
                                                      " (in 'string', line 187, column 7 to line 189, column 1)",
                                                      " (in 'string', line 186, column 2 to column 25)",
                                                      " (in 'string', line 185, column 18 to line 187, column 1)",
                                                      " (in 'string', line 185, column 0 to line 189, column 1)",
                                                      " (in 'string', line 198, column 1 to column 7)",
                                                      " (in 'string', line 199, column 2 to column 12)",
                                                      " (in 'string', line 197, column 26 to line 200, column 1)",
                                                      " (in 'string', line 197, column 7 to line 200, column 1)",
                                                      " (in 'string', line 195, column 2 to column 12)",
                                                      " (in 'string', line 196, column 2 to column 12)",
                                                      " (in 'string', line 194, column 26 to line 197, column 1)",
                                                      " (in 'string', line 194, column 7 to line 200, column 1)",
                                                      " (in 'string', line 192, column 2 to column 8)",
                                                      " (in 'string', line 193, column 2 to column 12)",
                                                      " (in 'string', line 191, column 55 to line 194, column 1)",
                                                      " (in 'string', line 191, column 0 to line 200, column 1)",
                                                      " (in 'string', line 203, column 2 to column 12)",
                                                      " (in 'string', line 202, column 38 to line 204, column 1)",
                                                      " (in 'string', line 202, column 0 to line 204, column 1)",
                                                      " (in 'string', line 209, column 1 to column 7)",
                                                      " (in 'string', line 208, column 5 to line 209, column 7)",
                                                      " (in 'string', line 207, column 1 to column 7)",
                                                      " (in 'string', line 206, column 0 to line 209, column 7)",
                                                      " (in 'string', line 212, column 1 to column 51)",
                                                      " (in 'string', line 213, column 1 to column 47)",
                                                      " (in 'string', line 214, column 1 to column 44)",
                                                      " (in 'string', line 215, column 1 to column 19)",
                                                      " (in 'string', line 216, column 1 to column 22)",
                                                      " (in 'string', line 217, column 1 to column 26)",
                                                      " (in 'string', line 211, column 1 to line 218, column 2)",
                                                      " (in 'string', line 224, column 18 to column 50)",
                                                      " (in 'string', line 225, column 26 to column 54)",
                                                      " (in 'string', line 226, column 8 to column 10)",
                                                      " (in 'string', line 227, column 10 to column 11)",
                                                      " (in 'string', line 227, column 13 to column 15)",
                                                      " (in 'string', line 228, column 22 to column 40)",
                                                      " (in 'string', line 229, column 32 to column 34)",
                                                      " (in 'string', line 230, column 17 to column 18)",
                                                      " (in 'string', line 233, column 8 to column 9)",
                                                      " (in 'string', line 234, column 19 to column 21)",
                                                      " (in 'string', line 313, column 10 to column 12)",
                                                      " (in 'string', line 313, column 14 to column 16)",
                                                      " (in 'string', line 7, column 8 to column 9)",
                                                      " (in 'string', line 7, column 11 to column 12)",
                                                      " (in 'string', line 7, column 1 to column 22)",
                                                      " (in 'string', line 14, column 3 to column 40)",
                                                      " (in 'string', line 13, column 6 to line 14, column 40)",
                                                      " (in 'string', line 12, column 3 to column 35)",
                                                      " (in 'string', line 11, column 6 to line 14, column 40)",
                                                      " (in 'string', line 10, column 3 to column 33)",
                                                      " (in 'string', line 9, column 1 to line 14, column 40)",
                                                      " (in 'string', line 16, column 0 to column 16)",
                                                      " (in 'string', line 5, column 55 to line 17, column 1)",
                                                      " (in 'string', line 21, column 8 to column 9)",
                                                      " (in 'string', line 21, column 11 to column 12)",
                                                      " (in 'string', line 21, column 1 to column 22)",
                                                      " (in 'string', line 28, column 3 to column 40)",
                                                      " (in 'string', line 27, column 6 to line 28, column 40)",
                                                      " (in 'string', line 26, column 3 to column 44)",
                                                      " (in 'string', line 25, column 6 to line 28, column 40)",
                                                      " (in 'string', line 24, column 3 to column 33)",
                                                      " (in 'string', line 23, column 1 to line 28, column 40)",
                                                      " (in 'string', line 30, column 0 to column 16)",
                                                      " (in 'string', line 19, column 61 to line 31, column 1)",
                                                      " (in 'string', line 35, column 8 to column 9)",
                                                      " (in 'string', line 35, column 1 to column 19)",
                                                      " (in 'string', line 40, column 3 to column 37)",
                                                      " (in 'string', line 38, column 3 to column 30)",
                                                      " (in 'string', line 37, column 1 to line 40, column 37)",
                                                      " (in 'string', line 42, column 0 to column 16)",
                                                      " (in 'string', line 33, column 54 to line 43, column 1)",
                                                      " (in 'string', line 50, column 8 to column 9)",
                                                      " (in 'string', line 50, column 1 to column 20)",
                                                      " (in 'string', line 51, column 8 to column 9)",
                                                      " (in 'string', line 51, column 1 to column 37)",
                                                      " (in 'string', line 52, column 8 to column 9)",
                                                      " (in 'string', line 52, column 11 to column 12)",
                                                      " (in 'string', line 52, column 1 to column 101)",
                                                      " (in 'string', line 53, column 8 to column 9)",
                                                      " (in 'string', line 53, column 1 to column 53)",
                                                      " (in 'string', line 54, column 8 to column 9)",
                                                      " (in 'string', line 54, column 11 to column 12)",
                                                      " (in 'string', line 54, column 1 to column 61)",
                                                      " (in 'string', line 55, column 8 to column 9)",
                                                      " (in 'string', line 55, column 1 to column 43)",
                                                      " (in 'string', line 57, column 1 to line 59, column 53)",
                                                      " (in 'string', line 62, column 9 to column 10)",
                                                      " (in 'string', line 62, column 12 to column 15)",
                                                      " (in 'string', line 62, column 2 to column 102)",
                                                      " (in 'string', line 63, column 9 to column 10)",
                                                      " (in 'string', line 63, column 2 to column 67)",
                                                      " (in 'string', line 66, column 3 to column 57)",
                                                      " (in 'string', line 65, column 2 to line 66, column 57)",
                                                      " (in 'string', line 68, column 2 to column 42)",
                                                      " (in 'string', line 61, column 21 to line 69, column 2)",
                                                      " (in 'string', line 61, column 1 to line 69, column 2)",
                                                      " (in 'string', line 71, column 0 to column 17)",
                                                      " (in 'string', line 48, column 51 to line 72, column 1)",
                                                      " (in 'string', line 77, column 2 to column 17)",
                                                      " (in 'string', line 78, column 9 to column 10)",
                                                      " (in 'string', line 78, column 12 to column 13)",
                                                      " (in 'string', line 78, column 2 to column 98)",
                                                      " (in 'string', line 79, column 2 to column 74)",
                                                      " (in 'string', line 80, column 2 to column 40)",
                                                      " (in 'string', line 82, column 0 to column 18)",
                                                      " (in 'string', line 75, column 40 to line 83, column 1)",
                                                      " (in 'string', line 89, column 11 to column 12)",
                                                      " (in 'string', line 89, column 4 to column 23)",
                                                      " (in 'string', line 90, column 11 to column 12)",
                                                      " (in 'string', line 90, column 4 to column 40)",
                                                      " (in 'string', line 91, column 11 to column 12)",
                                                      " (in 'string', line 91, column 14 to column 15)",
                                                      " (in 'string', line 91, column 4 to column 19)",
                                                      " (in 'string', line 92, column 11 to column 12)",
                                                      " (in 'string', line 92, column 14 to column 15)",
                                                      " (in 'string', line 92, column 4 to column 73)",
                                                      " (in 'string', line 93, column 11 to column 12)",
                                                      " (in 'string', line 93, column 4 to column 24)",
                                                      " (in 'string', line 102, column 2 to line 103, column 99)",
                                                      " (in 'string', line 101, column 42 to line 104, column 2)",
                                                      " (in 'string', line 101, column 8 to line 104, column 2)",
                                                      " (in 'string', line 97, column 9 to column 10)",
                                                      " (in 'string', line 97, column 2 to column 57)",
                                                      " (in 'string', line 98, column 9 to line 99, column 49)",
                                                      " (in 'string', line 96, column 16 to line 100, column 6)",
                                                      " (in 'string', line 96, column 3 to line 100, column 6)",
                                                      " (in 'string', line 95, column 35 to line 101, column 2)",
                                                      " (in 'string', line 95, column 1 to line 104, column 2)",
                                                      " (in 'string', line 106, column 3 to column 102)",
                                                      " (in 'string', line 109, column 3 to column 84)",
                                                      " (in 'string', line 113, column 10 to column 11)",
                                                      " (in 'string', line 113, column 3 to line 114, column 90)",
                                                      " (in 'string', line 116, column 4 to column 58)",
                                                      " (in 'string', line 115, column 6 to line 116, column 58)",
                                                      " (in 'string', line 118, column 10 to column 50)",
                                                      " (in 'string', line 112, column 20 to line 119, column 2)",
                                                      " (in 'string', line 112, column 1 to line 119, column 2)",
                                                      " (in 'string', line 121, column 0 to column 17)",
                                                      " (in 'string', line 87, column 85 to line 122, column 1)"};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
gamma_ll(const T0__& gamma_arg__, const int& I, const int& J,
         const int& Gamma, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& gamma = to_ref(gamma_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 223;
    validate_non_negative_index("gamma_j", "I", I);
    current_statement__ = 224;
    validate_non_negative_index("gamma_j", "J", J);
    Eigen::Matrix<local_scalar_t__, -1, -1> gamma_j;
    gamma_j = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
    stan::math::fill(gamma_j, DUMMY_VAR__);
    
    current_statement__ = 231;
    if (logical_eq(Gamma, 0)) {
      current_statement__ = 230;
      assign(gamma_j, nil_index_list(), rep_matrix(1, I, J),
        "assigning variable gamma_j");
    } else {
      current_statement__ = 229;
      if (logical_eq(Gamma, J)) {
        current_statement__ = 228;
        assign(gamma_j, nil_index_list(), rep_matrix(transpose(gamma), I),
          "assigning variable gamma_j");
      } else {
        current_statement__ = 227;
        if (logical_eq(Gamma, 1)) {
          current_statement__ = 226;
          assign(gamma_j, nil_index_list(), rep_matrix(gamma[(1 - 1)], I, J),
            "assigning variable gamma_j");
        } 
      }
    }
    current_statement__ = 232;
    return gamma_j;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct gamma_ll_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
operator()(const T0__& gamma, const int& I, const int& J, const int& Gamma,
           std::ostream* pstream__)  const 
{
return gamma_ll(gamma, I, J, Gamma, pstream__);
}
};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
alpha_j_ll(const T0__& alpha_arg__, const int& I, const int& J,
           const int& model_num, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& alpha = to_ref(alpha_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 234;
    validate_non_negative_index("alpha_j", "I", I);
    current_statement__ = 235;
    validate_non_negative_index("alpha_j", "J", J);
    Eigen::Matrix<local_scalar_t__, -1, -1> alpha_j;
    alpha_j = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
    stan::math::fill(alpha_j, DUMMY_VAR__);
    
    current_statement__ = 242;
    if ((primitive_value((primitive_value(logical_eq(model_num, 1)) ||
        primitive_value(logical_eq(model_num, 4)))) || primitive_value(
        logical_eq(model_num, 5)))) {
      current_statement__ = 241;
      assign(alpha_j, nil_index_list(), rep_matrix(0, I, J),
        "assigning variable alpha_j");
    } else {
      current_statement__ = 240;
      if (logical_eq(model_num, 2)) {
        current_statement__ = 239;
        assign(alpha_j, nil_index_list(),
          rep_matrix(
            transpose(
              rvalue(alpha,
                cons_list(index_min_max(2, (J + 1)), nil_index_list()),
                "alpha")), I), "assigning variable alpha_j");
      } else {
        current_statement__ = 238;
        if (logical_eq(model_num, 3)) {
          current_statement__ = 237;
          assign(alpha_j, nil_index_list(), rep_matrix(alpha[(1 - 1)], I, J),
            "assigning variable alpha_j");
        } 
      }
    }
    current_statement__ = 243;
    return alpha_j;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct alpha_j_ll_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
operator()(const T0__& alpha, const int& I, const int& J,
           const int& model_num, std::ostream* pstream__)  const 
{
return alpha_j_ll(alpha, I, J, model_num, pstream__);
}
};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
alpha_1_ll(const T0__& alpha_arg__, const int& I, const int& model_num,
           std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& alpha = to_ref(alpha_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 245;
    validate_non_negative_index("alpha_1", "I", I);
    Eigen::Matrix<local_scalar_t__, -1, 1> alpha_1;
    alpha_1 = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
    stan::math::fill(alpha_1, DUMMY_VAR__);
    
    current_statement__ = 249;
    if (logical_eq(model_num, 4)) {
      current_statement__ = 248;
      assign(alpha_1, nil_index_list(), rep_vector(0, I),
        "assigning variable alpha_1");
    } else {
      current_statement__ = 247;
      assign(alpha_1, nil_index_list(), rep_vector(alpha[(1 - 1)], I),
        "assigning variable alpha_1");
    }
    current_statement__ = 250;
    return alpha_1;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct alpha_1_ll_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
operator()(const T0__& alpha, const int& I, const int& model_num,
           std::ostream* pstream__)  const 
{
return alpha_1_ll(alpha, I, model_num, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T5__, typename T6__, typename T7__, typename T8__,
typename T9__, typename T10__, typename T13__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
stan::value_type_t<T6__>, stan::value_type_t<T7__>, stan::value_type_t<T8__>,
stan::value_type_t<T9__>, stan::promote_args_t<T10__,
stan::value_type_t<T13__>>>>, -1, 1>
mdcev_ll(const T0__& quant_j_arg__, const T1__& price_j_arg__,
         const T2__& log_num_arg__, const T3__& income_arg__,
         const T4__& M_arg__, const T5__& log_M_fact_arg__,
         const T6__& lpsi_arg__, const T7__& gamma_j_arg__,
         const T8__& alpha1_arg__, const T9__& alpha_j_arg__,
         const T10__& scale_full, const int& I, const int& J,
         const T13__& nonzero_arg__, const int& trunc_data,
         std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
          stan::value_type_t<T6__>,
          stan::value_type_t<T7__>,
          stan::value_type_t<T8__>,
          stan::value_type_t<T9__>, stan::promote_args_t<T10__,
          stan::value_type_t<T13__>>>>;
  const auto& quant_j = to_ref(quant_j_arg__);
  const auto& price_j = to_ref(price_j_arg__);
  const auto& log_num = to_ref(log_num_arg__);
  const auto& income = to_ref(income_arg__);
  const auto& M = to_ref(M_arg__);
  const auto& log_M_fact = to_ref(log_M_fact_arg__);
  const auto& lpsi = to_ref(lpsi_arg__);
  const auto& gamma_j = to_ref(gamma_j_arg__);
  const auto& alpha1 = to_ref(alpha1_arg__);
  const auto& alpha_j = to_ref(alpha_j_arg__);
  const auto& nonzero = to_ref(nonzero_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 252;
    validate_non_negative_index("log_like", "I", I);
    Eigen::Matrix<local_scalar_t__, -1, 1> log_like;
    log_like = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
    stan::math::fill(log_like, DUMMY_VAR__);
    
    current_statement__ = 254;
    validate_non_negative_index("ones_j", "J", J);
    Eigen::Matrix<local_scalar_t__, -1, 1> ones_j;
    ones_j = Eigen::Matrix<local_scalar_t__, -1, 1>(J);
    stan::math::fill(ones_j, DUMMY_VAR__);
    
    current_statement__ = 255;
    assign(ones_j, nil_index_list(), rep_vector(1, J),
      "assigning variable ones_j");
    current_statement__ = 256;
    validate_non_negative_index("v_j", "I", I);
    current_statement__ = 257;
    validate_non_negative_index("v_j", "J", J);
    Eigen::Matrix<local_scalar_t__, -1, -1> v_j;
    v_j = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
    stan::math::fill(v_j, DUMMY_VAR__);
    
    current_statement__ = 258;
    assign(v_j, nil_index_list(),
      divide(
        subtract(
          add(lpsi,
            elt_multiply(subtract(alpha_j, 1),
              stan::math::log(add(elt_divide(quant_j, gamma_j), 1)))),
          stan::math::log(price_j)), scale_full), "assigning variable v_j");
    current_statement__ = 259;
    validate_non_negative_index("v1", "I", I);
    Eigen::Matrix<local_scalar_t__, -1, 1> v1;
    v1 = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
    stan::math::fill(v1, DUMMY_VAR__);
    
    current_statement__ = 260;
    assign(v1, nil_index_list(),
      divide(elt_multiply(subtract(alpha1, 1), log_num), scale_full),
      "assigning variable v1");
    current_statement__ = 261;
    validate_non_negative_index("logf", "I", I);
    current_statement__ = 262;
    validate_non_negative_index("logf", "J", J);
    Eigen::Matrix<local_scalar_t__, -1, -1> logf;
    logf = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
    stan::math::fill(logf, DUMMY_VAR__);
    
    current_statement__ = 263;
    assign(logf, nil_index_list(),
      subtract(log1m(alpha_j), stan::math::log(add(quant_j, gamma_j))),
      "assigning variable logf");
    current_statement__ = 264;
    validate_non_negative_index("logf1", "I", I);
    Eigen::Matrix<local_scalar_t__, -1, 1> logf1;
    logf1 = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
    stan::math::fill(logf1, DUMMY_VAR__);
    
    current_statement__ = 265;
    assign(logf1, nil_index_list(), subtract(log1m(alpha1), log_num),
      "assigning variable logf1");
    current_statement__ = 266;
    assign(log_like, nil_index_list(),
      add(
        subtract(
          add(
            add(
              add(
                add(multiply(subtract(1, M), stan::math::log(scale_full)),
                  logf1), v1), rows_dot_product(nonzero, add(logf, v_j))),
            stan::math::log(
              add(inv(stan::math::exp(logf1)),
                rows_dot_product(nonzero,
                  elt_divide(price_j, stan::math::exp(logf)))))),
          elt_multiply(M,
            stan::math::log(
              add(stan::math::exp(v1),
                multiply(stan::math::exp(v_j), ones_j))))), log_M_fact),
      "assigning variable log_like");
    current_statement__ = 276;
    if (logical_eq(trunc_data, 1)) {
      current_statement__ = 267;
      validate_non_negative_index("v_1", "I", I);
      current_statement__ = 268;
      validate_non_negative_index("v_1", "J + 1", (J + 1));
      Eigen::Matrix<local_scalar_t__, -1, -1> v_1;
      v_1 = Eigen::Matrix<local_scalar_t__, -1, -1>(I, (J + 1));
      stan::math::fill(v_1, DUMMY_VAR__);
      
      current_statement__ = 269;
      assign(v_1, nil_index_list(),
        stan::math::exp(
          divide(
            append_col(
              elt_multiply(subtract(alpha1, 1), stan::math::log(income)),
              subtract(lpsi, stan::math::log(price_j))), scale_full)),
        "assigning variable v_1");
      current_statement__ = 270;
      validate_non_negative_index("like_trunc", "I", I);
      Eigen::Matrix<local_scalar_t__, -1, 1> like_trunc;
      like_trunc = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
      stan::math::fill(like_trunc, DUMMY_VAR__);
      
      current_statement__ = 271;
      assign(like_trunc, nil_index_list(),
        elt_divide(col(v_1, 1), multiply(v_1, rep_vector(1, (J + 1)))),
        "assigning variable like_trunc");
      current_statement__ = 273;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 272;
        assign(like_trunc, cons_list(index_uni(i), nil_index_list()),
          (logical_lt(like_trunc[(i - 1)], 1) ?
             stan::math::promote_scalar<local_scalar_t__>(like_trunc[
             (i - 1)]) : stan::math::promote_scalar<local_scalar_t__>(1)),
          "assigning variable like_trunc");}
      current_statement__ = 274;
      assign(log_like, nil_index_list(),
        subtract(stan::model::deep_copy(log_like), log1m(like_trunc)),
        "assigning variable log_like");
    } 
    current_statement__ = 277;
    return log_like;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct mdcev_ll_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T5__, typename T6__, typename T7__, typename T8__,
typename T9__, typename T10__, typename T13__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
stan::value_type_t<T6__>, stan::value_type_t<T7__>, stan::value_type_t<T8__>,
stan::value_type_t<T9__>, stan::promote_args_t<T10__,
stan::value_type_t<T13__>>>>, -1, 1>
operator()(const T0__& quant_j, const T1__& price_j, const T2__& log_num,
           const T3__& income, const T4__& M, const T5__& log_M_fact,
           const T6__& lpsi, const T7__& gamma_j, const T8__& alpha1,
           const T9__& alpha_j, const T10__& scale_full, const int& I,
           const int& J, const T13__& nonzero, const int& trunc_data,
           std::ostream* pstream__)  const 
{
return mdcev_ll(quant_j, price_j, log_num, income, M, log_M_fact, lpsi,
         gamma_j, alpha1, alpha_j, scale_full, I, J, nonzero, trunc_data,
         pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
stan::promote_args_t<stan::value_type_t<T0__>, T1__,
stan::value_type_t<T2__>,
stan::value_type_t<T3__>>
DeterminJacob(const T0__& phi_quant_term_arg__, const T1__& alpha,
              const T2__& price_j_num_arg__, const T3__& nonzero_arg__,
              const int& J, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T1__,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>>;
  const auto& phi_quant_term = to_ref(phi_quant_term_arg__);
  const auto& price_j_num = to_ref(price_j_num_arg__);
  const auto& nonzero = to_ref(nonzero_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ log_j_det;
    log_j_det = DUMMY_VAR__;
    
    current_statement__ = 280;
    validate_non_negative_index("jacobian", "J", J);
    current_statement__ = 281;
    validate_non_negative_index("jacobian", "J", J);
    Eigen::Matrix<local_scalar_t__, -1, -1> jacobian;
    jacobian = Eigen::Matrix<local_scalar_t__, -1, -1>(J, J);
    stan::math::fill(jacobian, DUMMY_VAR__);
    
    current_statement__ = 282;
    assign(jacobian, nil_index_list(),
      add_diag(rep_matrix(multiply((1 - alpha), price_j_num), J),
        inv(phi_quant_term)), "assigning variable jacobian");
    current_statement__ = 283;
    assign(jacobian, nil_index_list(),
      add_diag(diag_post_multiply(stan::model::deep_copy(jacobian), nonzero),
        subtract(1, nonzero)), "assigning variable jacobian");
    current_statement__ = 284;
    log_j_det = log_determinant(jacobian);
    current_statement__ = 285;
    return log_j_det;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct DeterminJacob_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__>
stan::promote_args_t<stan::value_type_t<T0__>, T1__,
stan::value_type_t<T2__>,
stan::value_type_t<T3__>>
operator()(const T0__& phi_quant_term, const T1__& alpha,
           const T2__& price_j_num, const T3__& nonzero, const int& J,
           std::ostream* pstream__)  const 
{
return DeterminJacob(phi_quant_term, alpha, price_j_num, nonzero, J,
         pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T5__, typename T6__, typename T7__, typename T8__,
typename T11__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
stan::value_type_t<T6__>, stan::value_type_t<T7__>, T8__,
stan::value_type_t<T11__>>>, -1, 1>
kt_ll(const T0__& quant_j_arg__, const T1__& price_j_arg__,
      const T2__& log_num_arg__, const T3__& income_arg__,
      const T4__& lpsi_arg__, const T5__& phi_ij_arg__,
      const T6__& gamma_arg__, const T7__& alpha_arg__,
      const T8__& scale_full, const int& I, const int& J,
      const T11__& nonzero_arg__, const int& trunc_data,
      const int& jacobian_analytical_grad, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
          stan::value_type_t<T6__>,
          stan::value_type_t<T7__>,
          T8__,
          stan::value_type_t<T11__>>>;
  const auto& quant_j = to_ref(quant_j_arg__);
  const auto& price_j = to_ref(price_j_arg__);
  const auto& log_num = to_ref(log_num_arg__);
  const auto& income = to_ref(income_arg__);
  const auto& lpsi = to_ref(lpsi_arg__);
  const auto& phi_ij = to_ref(phi_ij_arg__);
  const auto& gamma = to_ref(gamma_arg__);
  const auto& alpha = to_ref(alpha_arg__);
  const auto& nonzero = to_ref(nonzero_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 287;
    validate_non_negative_index("log_like", "I", I);
    Eigen::Matrix<local_scalar_t__, -1, 1> log_like;
    log_like = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
    stan::math::fill(log_like, DUMMY_VAR__);
    
    current_statement__ = 289;
    validate_non_negative_index("ones_j", "J", J);
    Eigen::Matrix<local_scalar_t__, -1, 1> ones_j;
    ones_j = Eigen::Matrix<local_scalar_t__, -1, 1>(J);
    stan::math::fill(ones_j, DUMMY_VAR__);
    
    current_statement__ = 290;
    assign(ones_j, nil_index_list(), rep_vector(1, J),
      "assigning variable ones_j");
    current_statement__ = 291;
    validate_non_negative_index("g", "I", I);
    current_statement__ = 292;
    validate_non_negative_index("g", "J", J);
    Eigen::Matrix<local_scalar_t__, -1, -1> g;
    g = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
    stan::math::fill(g, DUMMY_VAR__);
    
    current_statement__ = 294;
    validate_non_negative_index("phi_quant_term", "I", I);
    current_statement__ = 295;
    validate_non_negative_index("phi_quant_term", "J", J);
    Eigen::Matrix<local_scalar_t__, -1, -1> phi_quant_term;
    phi_quant_term = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
    stan::math::fill(phi_quant_term, DUMMY_VAR__);
    
    current_statement__ = 296;
    assign(phi_quant_term, nil_index_list(),
      elt_divide(add(elt_multiply(phi_ij, quant_j), gamma), phi_ij),
      "assigning variable phi_quant_term");
    current_statement__ = 297;
    validate_non_negative_index("log_j_det", "I", I);
    Eigen::Matrix<local_scalar_t__, -1, 1> log_j_det;
    log_j_det = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
    stan::math::fill(log_j_det, DUMMY_VAR__);
    
    current_statement__ = 308;
    if (logical_eq(jacobian_analytical_grad, 0)) {
      current_statement__ = 306;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 302;
        validate_non_negative_index("price_j_num", "J", J);
        Eigen::Matrix<local_scalar_t__, -1, 1> price_j_num;
        price_j_num = Eigen::Matrix<local_scalar_t__, -1, 1>(J);
        stan::math::fill(price_j_num, DUMMY_VAR__);
        
        current_statement__ = 303;
        assign(price_j_num, nil_index_list(),
          elt_divide(
            transpose(
              rvalue(price_j, cons_list(index_uni(i), nil_index_list()),
                "price_j")), stan::math::exp(log_num[(i - 1)])),
          "assigning variable price_j_num");
        current_statement__ = 304;
        assign(log_j_det, cons_list(index_uni(i), nil_index_list()),
          DeterminJacob(
            transpose(
              rvalue(phi_quant_term,
                cons_list(index_uni(i), nil_index_list()), "phi_quant_term")),
            alpha[(i - 1)], price_j_num,
            transpose(
              rvalue(nonzero, cons_list(index_uni(i), nil_index_list()),
                "nonzero")), J, pstream__), "assigning variable log_j_det");}
    } else {
      current_statement__ = 301;
      if (logical_eq(jacobian_analytical_grad, 1)) {
        current_statement__ = 299;
        assign(log_j_det, nil_index_list(),
          add(
            add(subtract(log1m(alpha), log_num),
              rows_dot_product(nonzero, stan::math::log(inv(phi_quant_term)))),
            stan::math::log(
              add(elt_divide(stan::math::exp(log_num), subtract(1, alpha)),
                rows_dot_product(nonzero,
                  elt_multiply(phi_quant_term, price_j))))),
          "assigning variable log_j_det");
      } 
    }
    current_statement__ = 309;
    assign(g, nil_index_list(),
      divide(
        subtract(
          add(minus(lpsi),
            stan::math::log(elt_multiply(phi_quant_term, price_j))),
          rep_matrix(elt_multiply(subtract(1, alpha), log_num), J)),
        scale_full), "assigning variable g");
    current_statement__ = 310;
    assign(log_like, nil_index_list(),
      add(log_j_det,
        multiply(
          add(
            elt_multiply(nonzero,
              subtract(minus(g), stan::math::log(scale_full))),
            minus(stan::math::exp(minus(g)))), ones_j)),
      "assigning variable log_like");
    current_statement__ = 317;
    if (logical_eq(trunc_data, 1)) {
      current_statement__ = 311;
      validate_non_negative_index("like_trunc", "I", I);
      Eigen::Matrix<local_scalar_t__, -1, 1> like_trunc;
      like_trunc = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
      stan::math::fill(like_trunc, DUMMY_VAR__);
      
      current_statement__ = 312;
      assign(like_trunc, nil_index_list(),
        stan::math::exp(
          multiply(
            minus(
              stan::math::exp(
                divide(
                  minus(
                    subtract(
                      add(
                        subtract(add(minus(lpsi), stan::math::log(price_j)),
                          stan::math::log(phi_ij)), stan::math::log(gamma)),
                      rep_matrix(
                        elt_multiply(subtract(1, alpha),
                          stan::math::log(income)), J))), scale_full))),
            ones_j)), "assigning variable like_trunc");
      current_statement__ = 314;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 313;
        assign(like_trunc, cons_list(index_uni(i), nil_index_list()),
          (logical_lt(like_trunc[(i - 1)], 1) ?
             stan::math::promote_scalar<local_scalar_t__>(like_trunc[
             (i - 1)]) : stan::math::promote_scalar<local_scalar_t__>(1)),
          "assigning variable like_trunc");}
      current_statement__ = 315;
      assign(log_like, nil_index_list(),
        subtract(stan::model::deep_copy(log_like), log1m(like_trunc)),
        "assigning variable log_like");
    } 
    current_statement__ = 318;
    return log_like;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct kt_ll_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T5__, typename T6__, typename T7__, typename T8__,
typename T11__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
stan::value_type_t<T6__>, stan::value_type_t<T7__>, T8__,
stan::value_type_t<T11__>>>, -1, 1>
operator()(const T0__& quant_j, const T1__& price_j, const T2__& log_num,
           const T3__& income, const T4__& lpsi, const T5__& phi_ij,
           const T6__& gamma, const T7__& alpha, const T8__& scale_full,
           const int& I, const int& J, const T11__& nonzero,
           const int& trunc_data, const int& jacobian_analytical_grad,
           std::ostream* pstream__)  const 
{
return kt_ll(quant_j, price_j, log_num, income, lpsi, phi_ij, gamma, alpha,
         scale_full, I, J, nonzero, trunc_data, jacobian_analytical_grad,
         pstream__);
}
};
#include <stan_meta_header.hpp>
class model_mdcev_rp final : public model_base_crtp<model_mdcev_rp> {
private:
  int I;
  int J;
  int NPsi_ij;
  int NPhi;
  int model_num;
  Eigen::Matrix<double, -1, -1> dat_psi;
  Eigen::Matrix<double, -1, -1> dat_phi;
  Eigen::Matrix<double, -1, -1> price_j;
  Eigen::Matrix<double, -1, -1> quant_j;
  Eigen::Matrix<double, -1, 1> income;
  int flat_priors;
  double prior_psi_sd;
  double prior_phi_sd;
  double prior_gamma_sd;
  double prior_alpha_shape;
  double prior_scale_sd;
  int fixed_scale1;
  int trunc_data;
  int jacobian_analytical_grad;
  int gamma_ascs;
  int psi_ascs;
  Eigen::Matrix<double, -1, 1> weights;
  int corr;
  std::vector<int> task;
  std::vector<int> task_individual;
  std::vector<int> start;
  std::vector<int> end;
  double lkj_shape;
  int gamma_nonrandom;
  int alpha_nonrandom;
  int RP;
  int RP_Phi;
  int RP_g;
  int RP_a;
  int A;
  int Gamma;
  int NPsi;
  int S;
  Eigen::Matrix<double, -1, 1> log_num;
  Eigen::Matrix<double, -1, -1> nonzero;
  Eigen::Matrix<double, -1, 1> M;
  Eigen::Matrix<double, -1, 1> log_M_fact;
  int gamma_1dim__;
  int alpha_1dim__;
  int L_Omega_1dim__;
  int L_Omega_2dim__;
 
public:
  ~model_mdcev_rp() { }
  
  inline std::string model_name() const final { return "model_mdcev_rp"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = %%NAME%%3 %%VERSION%%", "stancflags = "};
  }
  
  
  model_mdcev_rp(stan::io::var_context& context__,
                 unsigned int random_seed__ = 0,
                 std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_mdcev_rp_namespace::model_mdcev_rp";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 110;
      context__.validate_dims("data initialization","I","int",
          context__.to_vec());
      I = std::numeric_limits<int>::min();
      
      current_statement__ = 110;
      I = context__.vals_i("I")[(1 - 1)];
      current_statement__ = 111;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 111;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 112;
      context__.validate_dims("data initialization","NPsi_ij","int",
          context__.to_vec());
      NPsi_ij = std::numeric_limits<int>::min();
      
      current_statement__ = 112;
      NPsi_ij = context__.vals_i("NPsi_ij")[(1 - 1)];
      current_statement__ = 113;
      context__.validate_dims("data initialization","NPhi","int",
          context__.to_vec());
      NPhi = std::numeric_limits<int>::min();
      
      current_statement__ = 113;
      NPhi = context__.vals_i("NPhi")[(1 - 1)];
      current_statement__ = 114;
      context__.validate_dims("data initialization","model_num","int",
          context__.to_vec());
      model_num = std::numeric_limits<int>::min();
      
      current_statement__ = 114;
      model_num = context__.vals_i("model_num")[(1 - 1)];
      current_statement__ = 114;
      current_statement__ = 114;
      check_greater_or_equal(function__, "model_num", model_num, 1);
      current_statement__ = 114;
      current_statement__ = 114;
      check_less_or_equal(function__, "model_num", model_num, 5);
      current_statement__ = 115;
      validate_non_negative_index("dat_psi", "(NPsi_ij > 0 ? I * J : 0)",
                                  (logical_gt(NPsi_ij, 0) ? (I * J) : 0));
      current_statement__ = 116;
      validate_non_negative_index("dat_psi", "NPsi_ij", NPsi_ij);
      current_statement__ = 117;
      context__.validate_dims("data initialization","dat_psi","double",
          context__.to_vec((logical_gt(NPsi_ij, 0) ? (I * J) : 0), NPsi_ij));
      dat_psi = Eigen::Matrix<double, -1, -1>((logical_gt(NPsi_ij, 0) ?
                                                 (I * J) : 0), NPsi_ij);
      stan::math::fill(dat_psi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> dat_psi_flat__;
        current_statement__ = 117;
        assign(dat_psi_flat__, nil_index_list(), context__.vals_r("dat_psi"),
          "assigning variable dat_psi_flat__");
        current_statement__ = 117;
        pos__ = 1;
        current_statement__ = 117;
        for (int sym1__ = 1; sym1__ <= NPsi_ij; ++sym1__) {
          current_statement__ = 117;
          for (int sym2__ = 1;
               sym2__ <= (logical_gt(NPsi_ij, 0) ? (I * J) : 0); ++sym2__) {
            current_statement__ = 117;
            assign(dat_psi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              dat_psi_flat__[(pos__ - 1)], "assigning variable dat_psi");
            current_statement__ = 117;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 118;
      validate_non_negative_index("dat_phi", "(model_num == 5 ? I * J : 0)",
                                  (logical_eq(model_num, 5) ? (I * J) : 0));
      current_statement__ = 119;
      validate_non_negative_index("dat_phi", "NPhi", NPhi);
      current_statement__ = 120;
      context__.validate_dims("data initialization","dat_phi","double",
          context__.to_vec((logical_eq(model_num, 5) ? (I * J) : 0), NPhi));
      dat_phi = Eigen::Matrix<double, -1, -1>((logical_eq(model_num, 5) ?
                                                 (I * J) : 0), NPhi);
      stan::math::fill(dat_phi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> dat_phi_flat__;
        current_statement__ = 120;
        assign(dat_phi_flat__, nil_index_list(), context__.vals_r("dat_phi"),
          "assigning variable dat_phi_flat__");
        current_statement__ = 120;
        pos__ = 1;
        current_statement__ = 120;
        for (int sym1__ = 1; sym1__ <= NPhi; ++sym1__) {
          current_statement__ = 120;
          for (int sym2__ = 1;
               sym2__ <= (logical_eq(model_num, 5) ? (I * J) : 0); ++sym2__) {
            current_statement__ = 120;
            assign(dat_phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              dat_phi_flat__[(pos__ - 1)], "assigning variable dat_phi");
            current_statement__ = 120;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 121;
      validate_non_negative_index("price_j", "I", I);
      current_statement__ = 122;
      validate_non_negative_index("price_j", "J", J);
      current_statement__ = 123;
      context__.validate_dims("data initialization","price_j","double",
          context__.to_vec(I, J));
      price_j = Eigen::Matrix<double, -1, -1>(I, J);
      stan::math::fill(price_j, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> price_j_flat__;
        current_statement__ = 123;
        assign(price_j_flat__, nil_index_list(), context__.vals_r("price_j"),
          "assigning variable price_j_flat__");
        current_statement__ = 123;
        pos__ = 1;
        current_statement__ = 123;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 123;
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            current_statement__ = 123;
            assign(price_j,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              price_j_flat__[(pos__ - 1)], "assigning variable price_j");
            current_statement__ = 123;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 124;
      validate_non_negative_index("quant_j", "I", I);
      current_statement__ = 125;
      validate_non_negative_index("quant_j", "J", J);
      current_statement__ = 126;
      context__.validate_dims("data initialization","quant_j","double",
          context__.to_vec(I, J));
      quant_j = Eigen::Matrix<double, -1, -1>(I, J);
      stan::math::fill(quant_j, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> quant_j_flat__;
        current_statement__ = 126;
        assign(quant_j_flat__, nil_index_list(), context__.vals_r("quant_j"),
          "assigning variable quant_j_flat__");
        current_statement__ = 126;
        pos__ = 1;
        current_statement__ = 126;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 126;
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            current_statement__ = 126;
            assign(quant_j,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              quant_j_flat__[(pos__ - 1)], "assigning variable quant_j");
            current_statement__ = 126;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 127;
      validate_non_negative_index("income", "I", I);
      current_statement__ = 128;
      context__.validate_dims("data initialization","income","double",
          context__.to_vec(I));
      income = Eigen::Matrix<double, -1, 1>(I);
      stan::math::fill(income, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> income_flat__;
        current_statement__ = 128;
        assign(income_flat__, nil_index_list(), context__.vals_r("income"),
          "assigning variable income_flat__");
        current_statement__ = 128;
        pos__ = 1;
        current_statement__ = 128;
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          current_statement__ = 128;
          assign(income, cons_list(index_uni(sym1__), nil_index_list()),
            income_flat__[(pos__ - 1)], "assigning variable income");
          current_statement__ = 128;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 129;
      context__.validate_dims("data initialization","flat_priors","int",
          context__.to_vec());
      flat_priors = std::numeric_limits<int>::min();
      
      current_statement__ = 129;
      flat_priors = context__.vals_i("flat_priors")[(1 - 1)];
      current_statement__ = 129;
      current_statement__ = 129;
      check_greater_or_equal(function__, "flat_priors", flat_priors, 0);
      current_statement__ = 129;
      current_statement__ = 129;
      check_less_or_equal(function__, "flat_priors", flat_priors, 1);
      current_statement__ = 130;
      context__.validate_dims("data initialization","prior_psi_sd","double",
          context__.to_vec());
      prior_psi_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 130;
      prior_psi_sd = context__.vals_r("prior_psi_sd")[(1 - 1)];
      current_statement__ = 131;
      context__.validate_dims("data initialization","prior_phi_sd","double",
          context__.to_vec());
      prior_phi_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 131;
      prior_phi_sd = context__.vals_r("prior_phi_sd")[(1 - 1)];
      current_statement__ = 132;
      context__.validate_dims("data initialization","prior_gamma_sd",
          "double",context__.to_vec());
      prior_gamma_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 132;
      prior_gamma_sd = context__.vals_r("prior_gamma_sd")[(1 - 1)];
      current_statement__ = 133;
      context__.validate_dims("data initialization","prior_alpha_shape",
          "double",context__.to_vec());
      prior_alpha_shape = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 133;
      prior_alpha_shape = context__.vals_r("prior_alpha_shape")[(1 - 1)];
      current_statement__ = 134;
      context__.validate_dims("data initialization","prior_scale_sd",
          "double",context__.to_vec());
      prior_scale_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 134;
      prior_scale_sd = context__.vals_r("prior_scale_sd")[(1 - 1)];
      current_statement__ = 135;
      context__.validate_dims("data initialization","fixed_scale1","int",
          context__.to_vec());
      fixed_scale1 = std::numeric_limits<int>::min();
      
      current_statement__ = 135;
      fixed_scale1 = context__.vals_i("fixed_scale1")[(1 - 1)];
      current_statement__ = 135;
      current_statement__ = 135;
      check_greater_or_equal(function__, "fixed_scale1", fixed_scale1, 0);
      current_statement__ = 135;
      current_statement__ = 135;
      check_less_or_equal(function__, "fixed_scale1", fixed_scale1, 1);
      current_statement__ = 136;
      context__.validate_dims("data initialization","trunc_data","int",
          context__.to_vec());
      trunc_data = std::numeric_limits<int>::min();
      
      current_statement__ = 136;
      trunc_data = context__.vals_i("trunc_data")[(1 - 1)];
      current_statement__ = 136;
      current_statement__ = 136;
      check_greater_or_equal(function__, "trunc_data", trunc_data, 0);
      current_statement__ = 136;
      current_statement__ = 136;
      check_less_or_equal(function__, "trunc_data", trunc_data, 1);
      current_statement__ = 137;
      context__.validate_dims("data initialization",
          "jacobian_analytical_grad","int",context__.to_vec());
      jacobian_analytical_grad = std::numeric_limits<int>::min();
      
      current_statement__ = 137;
      jacobian_analytical_grad = context__.vals_i("jacobian_analytical_grad")[
          (1 - 1)];
      current_statement__ = 137;
      current_statement__ = 137;
      check_greater_or_equal(function__, "jacobian_analytical_grad",
                             jacobian_analytical_grad, 0);
      current_statement__ = 137;
      current_statement__ = 137;
      check_less_or_equal(function__, "jacobian_analytical_grad",
                          jacobian_analytical_grad, 1);
      current_statement__ = 138;
      context__.validate_dims("data initialization","gamma_ascs","int",
          context__.to_vec());
      gamma_ascs = std::numeric_limits<int>::min();
      
      current_statement__ = 138;
      gamma_ascs = context__.vals_i("gamma_ascs")[(1 - 1)];
      current_statement__ = 138;
      current_statement__ = 138;
      check_greater_or_equal(function__, "gamma_ascs", gamma_ascs, 0);
      current_statement__ = 138;
      current_statement__ = 138;
      check_less_or_equal(function__, "gamma_ascs", gamma_ascs, 1);
      current_statement__ = 139;
      context__.validate_dims("data initialization","psi_ascs","int",
          context__.to_vec());
      psi_ascs = std::numeric_limits<int>::min();
      
      current_statement__ = 139;
      psi_ascs = context__.vals_i("psi_ascs")[(1 - 1)];
      current_statement__ = 139;
      current_statement__ = 139;
      check_greater_or_equal(function__, "psi_ascs", psi_ascs, 0);
      current_statement__ = 139;
      current_statement__ = 139;
      check_less_or_equal(function__, "psi_ascs", psi_ascs, 1);
      current_statement__ = 140;
      validate_non_negative_index("weights", "I", I);
      current_statement__ = 141;
      context__.validate_dims("data initialization","weights","double",
          context__.to_vec(I));
      weights = Eigen::Matrix<double, -1, 1>(I);
      stan::math::fill(weights, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> weights_flat__;
        current_statement__ = 141;
        assign(weights_flat__, nil_index_list(), context__.vals_r("weights"),
          "assigning variable weights_flat__");
        current_statement__ = 141;
        pos__ = 1;
        current_statement__ = 141;
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          current_statement__ = 141;
          assign(weights, cons_list(index_uni(sym1__), nil_index_list()),
            weights_flat__[(pos__ - 1)], "assigning variable weights");
          current_statement__ = 141;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 142;
      context__.validate_dims("data initialization","corr","int",
          context__.to_vec());
      corr = std::numeric_limits<int>::min();
      
      current_statement__ = 142;
      corr = context__.vals_i("corr")[(1 - 1)];
      current_statement__ = 142;
      current_statement__ = 142;
      check_greater_or_equal(function__, "corr", corr, 0);
      current_statement__ = 142;
      current_statement__ = 142;
      check_less_or_equal(function__, "corr", corr, 1);
      current_statement__ = 143;
      validate_non_negative_index("task", "I", I);
      current_statement__ = 144;
      context__.validate_dims("data initialization","task","int",
          context__.to_vec(I));
      task = std::vector<int>(I, std::numeric_limits<int>::min());
      
      current_statement__ = 144;
      assign(task, nil_index_list(), context__.vals_i("task"),
        "assigning variable task");
      current_statement__ = 145;
      validate_non_negative_index("task_individual", "I", I);
      current_statement__ = 146;
      context__.validate_dims("data initialization","task_individual","int",
          context__.to_vec(I));
      task_individual = std::vector<int>(I, std::numeric_limits<int>::min());
      
      current_statement__ = 146;
      assign(task_individual, nil_index_list(),
        context__.vals_i("task_individual"),
        "assigning variable task_individual");
      current_statement__ = 147;
      validate_non_negative_index("start", "I", I);
      current_statement__ = 148;
      context__.validate_dims("data initialization","start","int",
          context__.to_vec(I));
      start = std::vector<int>(I, std::numeric_limits<int>::min());
      
      current_statement__ = 148;
      assign(start, nil_index_list(), context__.vals_i("start"),
        "assigning variable start");
      current_statement__ = 149;
      validate_non_negative_index("end", "I", I);
      current_statement__ = 150;
      context__.validate_dims("data initialization","end","int",
          context__.to_vec(I));
      end = std::vector<int>(I, std::numeric_limits<int>::min());
      
      current_statement__ = 150;
      assign(end, nil_index_list(), context__.vals_i("end"),
        "assigning variable end");
      current_statement__ = 151;
      context__.validate_dims("data initialization","lkj_shape","double",
          context__.to_vec());
      lkj_shape = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 151;
      lkj_shape = context__.vals_r("lkj_shape")[(1 - 1)];
      current_statement__ = 151;
      current_statement__ = 151;
      check_greater_or_equal(function__, "lkj_shape", lkj_shape, 1);
      current_statement__ = 152;
      context__.validate_dims("data initialization","gamma_nonrandom","int",
          context__.to_vec());
      gamma_nonrandom = std::numeric_limits<int>::min();
      
      current_statement__ = 152;
      gamma_nonrandom = context__.vals_i("gamma_nonrandom")[(1 - 1)];
      current_statement__ = 152;
      current_statement__ = 152;
      check_greater_or_equal(function__, "gamma_nonrandom", gamma_nonrandom,
                             0);
      current_statement__ = 152;
      current_statement__ = 152;
      check_less_or_equal(function__, "gamma_nonrandom", gamma_nonrandom, 1);
      current_statement__ = 153;
      context__.validate_dims("data initialization","alpha_nonrandom","int",
          context__.to_vec());
      alpha_nonrandom = std::numeric_limits<int>::min();
      
      current_statement__ = 153;
      alpha_nonrandom = context__.vals_i("alpha_nonrandom")[(1 - 1)];
      current_statement__ = 153;
      current_statement__ = 153;
      check_greater_or_equal(function__, "alpha_nonrandom", alpha_nonrandom,
                             0);
      current_statement__ = 153;
      current_statement__ = 153;
      check_less_or_equal(function__, "alpha_nonrandom", alpha_nonrandom, 1);
      current_statement__ = 154;
      RP = std::numeric_limits<int>::min();
      
      current_statement__ = 155;
      RP_Phi = std::numeric_limits<int>::min();
      
      current_statement__ = 156;
      RP_g = std::numeric_limits<int>::min();
      
      current_statement__ = 157;
      RP_a = std::numeric_limits<int>::min();
      
      current_statement__ = 158;
      A = std::numeric_limits<int>::min();
      
      current_statement__ = 159;
      Gamma = std::numeric_limits<int>::min();
      
      current_statement__ = 160;
      NPsi = std::numeric_limits<int>::min();
      
      current_statement__ = 161;
      S = std::numeric_limits<int>::min();
      
      current_statement__ = 162;
      validate_non_negative_index("log_num", "I", I);
      current_statement__ = 163;
      log_num = Eigen::Matrix<double, -1, 1>(I);
      stan::math::fill(log_num, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 164;
      validate_non_negative_index("nonzero", "I", I);
      current_statement__ = 165;
      validate_non_negative_index("nonzero", "J", J);
      current_statement__ = 166;
      nonzero = Eigen::Matrix<double, -1, -1>(I, J);
      stan::math::fill(nonzero, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 167;
      validate_non_negative_index("M", "I", I);
      current_statement__ = 168;
      M = Eigen::Matrix<double, -1, 1>(I);
      stan::math::fill(M, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 169;
      validate_non_negative_index("log_M_fact", "I", I);
      current_statement__ = 170;
      log_M_fact = Eigen::Matrix<double, -1, 1>(I);
      stan::math::fill(log_M_fact, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 177;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 171;
        assign(log_num, cons_list(index_uni(i), nil_index_list()),
          stan::math::log(
            (income[(i - 1)] -
              multiply(
                rvalue(price_j, cons_list(index_uni(i), nil_index_list()),
                  "price_j"),
                transpose(
                  rvalue(quant_j, cons_list(index_uni(i), nil_index_list()),
                    "quant_j"))))), "assigning variable log_num");
        current_statement__ = 174;
        for (int j = 1; j <= J; ++j) {
          current_statement__ = 172;
          assign(nonzero,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            (
               logical_gt(
                 rvalue(quant_j,
                   cons_list(index_uni(i),
                     cons_list(index_uni(j), nil_index_list())), "quant_j"),
                 0) ? 1 : 0), "assigning variable nonzero");}
        current_statement__ = 175;
        assign(M, cons_list(index_uni(i), nil_index_list()),
          (sum(
             rvalue(nonzero, cons_list(index_uni(i), nil_index_list()),
               "nonzero")) + 1), "assigning variable M");}
      current_statement__ = 178;
      assign(log_M_fact, nil_index_list(), stan::math::lgamma(M),
        "assigning variable log_M_fact");
      current_statement__ = 184;
      if (logical_eq(psi_ascs, 1)) {
        current_statement__ = 182;
        NPsi = ((J - 1) + NPsi_ij);
      } else {
        current_statement__ = 181;
        if (logical_eq(psi_ascs, 0)) {
          current_statement__ = 179;
          NPsi = NPsi_ij;
        } 
      }
      current_statement__ = 196;
      if ((primitive_value((primitive_value(logical_eq(model_num, 1)) ||
          primitive_value(logical_eq(model_num, 3)))) || primitive_value(
          logical_eq(model_num, 5)))) {
        current_statement__ = 193;
        A = 1;
        current_statement__ = 194;
        Gamma = J;
      } else {
        current_statement__ = 192;
        if (logical_eq(model_num, 2)) {
          current_statement__ = 189;
          A = (J + 1);
          current_statement__ = 190;
          Gamma = 0;
        } else {
          current_statement__ = 188;
          if (logical_eq(model_num, 4)) {
            current_statement__ = 185;
            A = 0;
            current_statement__ = 186;
            Gamma = J;
          } 
        }
      }
      current_statement__ = 199;
      if ((primitive_value(logical_neq(model_num, 2)) && primitive_value(
          logical_eq(gamma_ascs, 0)))) {
        current_statement__ = 197;
        Gamma = 1;
      } 
      current_statement__ = 203;
      if (logical_eq(fixed_scale1, 0)) {
        current_statement__ = 202;
        S = 1;
      } else {
        current_statement__ = 201;
        if (logical_eq(fixed_scale1, 1)) {
          current_statement__ = 200;
          S = 0;
        } 
      }
      {
        int n_gamma_rp;
        n_gamma_rp = std::numeric_limits<int>::min();
        
        current_statement__ = 204;
        n_gamma_rp = (logical_eq(gamma_nonrandom, 0) ? Gamma : 0);
        int n_alpha_rp;
        n_alpha_rp = std::numeric_limits<int>::min();
        
        current_statement__ = 205;
        n_alpha_rp = (logical_eq(alpha_nonrandom, 0) ? A : 0);
        current_statement__ = 206;
        RP = (((NPsi + NPhi) + n_gamma_rp) + n_alpha_rp);
        current_statement__ = 207;
        RP_Phi = (NPsi + 1);
        current_statement__ = 208;
        RP_g = (RP_Phi + NPhi);
        current_statement__ = 209;
        RP_a = (RP_g + n_gamma_rp);
      }
      current_statement__ = 211;
      gamma_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 211;
      gamma_1dim__ = (logical_eq(gamma_nonrandom, 1) ? Gamma : 0);
      current_statement__ = 211;
      validate_non_negative_index("gamma",
                                  "gamma_nonrandom == 1 ? Gamma : 0",
                                  gamma_1dim__);
      current_statement__ = 212;
      alpha_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 212;
      alpha_1dim__ = (logical_eq(alpha_nonrandom, 1) ? A : 0);
      current_statement__ = 212;
      validate_non_negative_index("alpha", "alpha_nonrandom == 1 ? A : 0",
                                  alpha_1dim__);
      current_statement__ = 213;
      validate_non_negative_index("mu", "RP", RP);
      current_statement__ = 214;
      validate_non_negative_index("z", "I", I);
      current_statement__ = 215;
      validate_non_negative_index("z", "RP", RP);
      current_statement__ = 216;
      L_Omega_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 216;
      L_Omega_1dim__ = (logical_eq(corr, 1) ? RP : 0);
      current_statement__ = 216;
      validate_non_negative_index("L_Omega", "corr == 1 ? RP : 0",
                                  L_Omega_1dim__);
      current_statement__ = 216;
      L_Omega_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 216;
      L_Omega_2dim__ = (logical_eq(corr, 1) ? RP : 0);
      current_statement__ = 216;
      validate_non_negative_index("L_Omega", "corr == 1 ? RP : 0",
                                  L_Omega_2dim__);
      current_statement__ = 217;
      validate_non_negative_index("tau_unif", "RP", RP);
      current_statement__ = 218;
      validate_non_negative_index("scale", "S", S);
      current_statement__ = 219;
      validate_non_negative_index("log_like", "I", I);
      current_statement__ = 220;
      validate_non_negative_index("tau", "RP", RP);
      current_statement__ = 221;
      validate_non_negative_index("Sigma", "RP", RP);
      current_statement__ = 222;
      validate_non_negative_index("Sigma", "RP", RP);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += gamma_1dim__;
      num_params_r__ += alpha_1dim__;
      num_params_r__ += RP;
      num_params_r__ += I * RP;
      num_params_r__ += ((L_Omega_1dim__ * (L_Omega_1dim__ - 1)) / 2);
      num_params_r__ += RP;
      num_params_r__ += S;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_mdcev_rp_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> gamma;
      gamma = Eigen::Matrix<local_scalar_t__, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, DUMMY_VAR__);
      
      current_statement__ = 1;
      gamma = in__.vector(gamma_1dim__);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gamma[(sym1__ - 1)], 0, lp__),
            "assigning variable gamma");
        } else {
          current_statement__ = 1;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gamma[(sym1__ - 1)], 0),
            "assigning variable gamma");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> alpha;
      alpha = Eigen::Matrix<local_scalar_t__, -1, 1>(alpha_1dim__);
      stan::math::fill(alpha, DUMMY_VAR__);
      
      current_statement__ = 2;
      alpha = in__.vector(alpha_1dim__);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(alpha[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable alpha");
        } else {
          current_statement__ = 2;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(alpha[(sym1__ - 1)], 0, 1),
            "assigning variable alpha");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> mu;
      mu = Eigen::Matrix<local_scalar_t__, -1, 1>(RP);
      stan::math::fill(mu, DUMMY_VAR__);
      
      current_statement__ = 3;
      mu = in__.vector(RP);
      Eigen::Matrix<local_scalar_t__, -1, -1> z;
      z = Eigen::Matrix<local_scalar_t__, -1, -1>(I, RP);
      stan::math::fill(z, DUMMY_VAR__);
      
      current_statement__ = 4;
      z = in__.matrix(I, RP);
      Eigen::Matrix<local_scalar_t__, -1, -1> L_Omega;
      L_Omega = Eigen::Matrix<local_scalar_t__, -1, -1>(L_Omega_1dim__, L_Omega_2dim__);
      stan::math::fill(L_Omega, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> L_Omega_in__;
      L_Omega_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((L_Omega_1dim__
                                                               *
                                                               (L_Omega_1dim__
                                                                 - 1)) / 2));
      stan::math::fill(L_Omega_in__, DUMMY_VAR__);
      
      current_statement__ = 5;
      L_Omega_in__ = in__.vector(
                       ((L_Omega_1dim__ * (L_Omega_1dim__ - 1)) / 2));
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        assign(L_Omega, nil_index_list(),
          stan::math::cholesky_corr_constrain(L_Omega_in__, L_Omega_1dim__,
            lp__), "assigning variable L_Omega");
      } else {
        current_statement__ = 5;
        assign(L_Omega, nil_index_list(),
          stan::math::cholesky_corr_constrain(L_Omega_in__, L_Omega_1dim__),
          "assigning variable L_Omega");
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> tau_unif;
      tau_unif = Eigen::Matrix<local_scalar_t__, -1, 1>(RP);
      stan::math::fill(tau_unif, DUMMY_VAR__);
      
      current_statement__ = 6;
      tau_unif = in__.vector(RP);
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        current_statement__ = 6;
        if (jacobian__) {
          current_statement__ = 6;
          assign(tau_unif, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(tau_unif[(sym1__ - 1)], 0,
              (stan::math::pi() / 2), lp__), "assigning variable tau_unif");
        } else {
          current_statement__ = 6;
          assign(tau_unif, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(tau_unif[(sym1__ - 1)], 0,
              (stan::math::pi() / 2)), "assigning variable tau_unif");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> scale;
      scale = Eigen::Matrix<local_scalar_t__, -1, 1>(S);
      stan::math::fill(scale, DUMMY_VAR__);
      
      current_statement__ = 7;
      scale = in__.vector(S);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        current_statement__ = 7;
        if (jacobian__) {
          current_statement__ = 7;
          assign(scale, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(scale[(sym1__ - 1)], 0, lp__),
            "assigning variable scale");
        } else {
          current_statement__ = 7;
          assign(scale, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(scale[(sym1__ - 1)], 0),
            "assigning variable scale");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> log_like;
      log_like = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
      stan::math::fill(log_like, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> tau;
      tau = Eigen::Matrix<local_scalar_t__, -1, 1>(RP);
      stan::math::fill(tau, DUMMY_VAR__);
      
      {
        current_statement__ = 10;
        validate_non_negative_index("beta", "I", I);
        current_statement__ = 11;
        validate_non_negative_index("beta", "RP", RP);
        Eigen::Matrix<local_scalar_t__, -1, -1> beta;
        beta = Eigen::Matrix<local_scalar_t__, -1, -1>(I, RP);
        stan::math::fill(beta, DUMMY_VAR__);
        
        current_statement__ = 13;
        validate_non_negative_index("lpsi", "I", I);
        current_statement__ = 14;
        validate_non_negative_index("lpsi", "J", J);
        Eigen::Matrix<local_scalar_t__, -1, -1> lpsi;
        lpsi = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
        stan::math::fill(lpsi, DUMMY_VAR__);
        
        current_statement__ = 16;
        validate_non_negative_index("alpha_individual_1", "I", I);
        Eigen::Matrix<local_scalar_t__, -1, 1> alpha_individual_1;
        alpha_individual_1 = Eigen::Matrix<local_scalar_t__, -1, 1>(I);
        stan::math::fill(alpha_individual_1, DUMMY_VAR__);
        
        current_statement__ = 18;
        validate_non_negative_index("alpha_individual_j", "I", I);
        current_statement__ = 19;
        validate_non_negative_index("alpha_individual_j", "J", J);
        Eigen::Matrix<local_scalar_t__, -1, -1> alpha_individual_j;
        alpha_individual_j = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
        stan::math::fill(alpha_individual_j, DUMMY_VAR__);
        
        current_statement__ = 21;
        validate_non_negative_index("gamma_individual", "I", I);
        current_statement__ = 22;
        validate_non_negative_index("gamma_individual", "J", J);
        Eigen::Matrix<local_scalar_t__, -1, -1> gamma_individual;
        gamma_individual = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
        stan::math::fill(gamma_individual, DUMMY_VAR__);
        
        local_scalar_t__ scale_full;
        scale_full = DUMMY_VAR__;
        
        current_statement__ = 27;
        if (logical_eq(fixed_scale1, 0)) {
          current_statement__ = 26;
          scale_full = scale[(1 - 1)];
        } else {
          current_statement__ = 25;
          scale_full = 1.0;
        }
        current_statement__ = 29;
        for (int rp = 1; rp <= RP; ++rp) {
          current_statement__ = 28;
          assign(tau, cons_list(index_uni(rp), nil_index_list()),
            (2.5 * stan::math::tan(tau_unif[(rp - 1)])),
            "assigning variable tau");}
        current_statement__ = 35;
        if (logical_eq(corr, 1)) {
          current_statement__ = 33;
          assign(beta, nil_index_list(),
            add(rep_matrix(transpose(mu), I),
              multiply(z, diag_pre_multiply(tau, L_Omega))),
            "assigning variable beta");
        } else {
          current_statement__ = 32;
          if (logical_eq(corr, 0)) {
            current_statement__ = 30;
            assign(beta, nil_index_list(),
              add(rep_matrix(transpose(mu), I), diag_post_multiply(z, tau)),
              "assigning variable beta");
          } 
        }
        current_statement__ = 48;
        if ((primitive_value(logical_eq(alpha_nonrandom, 0)) &&
            primitive_value(logical_neq(model_num, 4)))) {
          current_statement__ = 40;
          assign(alpha_individual_1, nil_index_list(),
            inv_logit(col(beta, RP_a)),
            "assigning variable alpha_individual_1");
          current_statement__ = 46;
          if (logical_eq(model_num, 1)) {
            current_statement__ = 45;
            assign(alpha_individual_j, nil_index_list(), rep_matrix(0, I, J),
              "assigning variable alpha_individual_j");
          } else {
            current_statement__ = 44;
            if (logical_eq(model_num, 2)) {
              current_statement__ = 43;
              assign(alpha_individual_j, nil_index_list(),
                inv_logit(block(beta, 1, (RP_a + 1), I, J)),
                "assigning variable alpha_individual_j");
            } else {
              current_statement__ = 42;
              if (logical_eq(model_num, 3)) {
                current_statement__ = 41;
                assign(alpha_individual_j, nil_index_list(),
                  rep_matrix(alpha_individual_1, J),
                  "assigning variable alpha_individual_j");
              } 
            }
          }
        } else {
          current_statement__ = 39;
          if ((primitive_value(logical_eq(alpha_nonrandom, 1)) ||
              primitive_value(logical_eq(model_num, 4)))) {
            current_statement__ = 36;
            assign(alpha_individual_1, nil_index_list(),
              alpha_1_ll(alpha, I, model_num, pstream__),
              "assigning variable alpha_individual_1");
            current_statement__ = 37;
            assign(alpha_individual_j, nil_index_list(),
              alpha_j_ll(alpha, I, J, model_num, pstream__),
              "assigning variable alpha_individual_j");
          } 
        }
        current_statement__ = 55;
        if ((primitive_value(logical_eq(gamma_nonrandom, 0)) &&
            primitive_value(logical_neq(model_num, 2)))) {
          current_statement__ = 53;
          if (logical_eq(gamma_ascs, 1)) {
            current_statement__ = 52;
            assign(gamma_individual, nil_index_list(),
              stan::math::exp(block(beta, 1, RP_g, I, Gamma)),
              "assigning variable gamma_individual");
          } else {
            current_statement__ = 51;
            if (logical_eq(gamma_ascs, 0)) {
              current_statement__ = 50;
              assign(gamma_individual, nil_index_list(),
                rep_matrix(stan::math::exp(col(beta, RP_g)), J),
                "assigning variable gamma_individual");
            } 
          }
        } else {
          current_statement__ = 49;
          assign(gamma_individual, nil_index_list(),
            gamma_ll(gamma, I, J, Gamma, pstream__),
            "assigning variable gamma_individual");
        }
        current_statement__ = 68;
        if (logical_eq(psi_ascs, 1)) {
          current_statement__ = 63;
          assign(lpsi, nil_index_list(),
            append_col(rep_vector(0, I), block(beta, 1, 1, I, (J - 1))),
            "assigning variable lpsi");
          current_statement__ = 66;
          if (logical_gt(NPsi_ij, 0)) {
            current_statement__ = 65;
            for (int i = 1; i <= I; ++i) {
              current_statement__ = 64;
              assign(lpsi, cons_list(index_uni(i), nil_index_list()),
                add(
                  stan::model::deep_copy(
                    rvalue(lpsi, cons_list(index_uni(i), nil_index_list()),
                      "lpsi")),
                  multiply(
                    sub_row(beta, task_individual[(i - 1)], J, NPsi_ij),
                    transpose(
                      rvalue(dat_psi,
                        cons_list(
                          index_min_max(start[(i - 1)], end[(i - 1)]),
                          nil_index_list()), "dat_psi")))),
                "assigning variable lpsi");}
          } 
        } else {
          current_statement__ = 62;
          if (logical_eq(psi_ascs, 0)) {
            current_statement__ = 60;
            if (logical_gt(NPsi_ij, 0)) {
              current_statement__ = 59;
              for (int i = 1; i <= I; ++i) {
                current_statement__ = 58;
                assign(lpsi, cons_list(index_uni(i), nil_index_list()),
                  multiply(
                    sub_row(beta, task_individual[(i - 1)], 1, NPsi_ij),
                    transpose(
                      rvalue(dat_psi,
                        cons_list(
                          index_min_max(start[(i - 1)], end[(i - 1)]),
                          nil_index_list()), "dat_psi"))),
                  "assigning variable lpsi");}
            } else {
              current_statement__ = 57;
              if (logical_eq(NPsi_ij, 0)) {
                current_statement__ = 56;
                assign(lpsi, nil_index_list(), rep_matrix(0, I, J),
                  "assigning variable lpsi");
              } 
            }
          } 
        }
        current_statement__ = 82;
        if (logical_lt(model_num, 5)) {
          current_statement__ = 80;
          assign(log_like, nil_index_list(),
            mdcev_ll(quant_j, price_j, log_num, income, M, log_M_fact, lpsi,
              gamma_individual, alpha_individual_1, alpha_individual_j,
              scale_full, I, J, nonzero, trunc_data, pstream__),
            "assigning variable log_like");
        } else {
          current_statement__ = 79;
          if (logical_eq(model_num, 5)) {
            current_statement__ = 69;
            validate_non_negative_index("phi_ij", "I", I);
            current_statement__ = 70;
            validate_non_negative_index("phi_ij", "J", J);
            Eigen::Matrix<local_scalar_t__, -1, -1> phi_ij;
            phi_ij = Eigen::Matrix<local_scalar_t__, -1, -1>(I, J);
            stan::math::fill(phi_ij, DUMMY_VAR__);
            
            current_statement__ = 76;
            if (logical_eq(NPhi, 0)) {
              current_statement__ = 75;
              assign(phi_ij, nil_index_list(), rep_matrix(1, I, J),
                "assigning variable phi_ij");
            } else {
              current_statement__ = 74;
              if (logical_gt(NPhi, 0)) {
                current_statement__ = 73;
                for (int i = 1; i <= I; ++i) {
                  current_statement__ = 72;
                  assign(phi_ij, cons_list(index_uni(i), nil_index_list()),
                    stan::math::exp(
                      multiply(
                        sub_row(beta, task_individual[(i - 1)], RP_Phi, NPhi),
                        transpose(
                          rvalue(dat_phi,
                            cons_list(
                              index_min_max(start[(i - 1)], end[(i - 1)]),
                              nil_index_list()), "dat_phi")))),
                    "assigning variable phi_ij");}
              } 
            }
            current_statement__ = 77;
            assign(log_like, nil_index_list(),
              kt_ll(quant_j, price_j, log_num, income, lpsi, phi_ij,
                gamma_individual, alpha_individual_1, scale_full, I, J,
                nonzero, trunc_data, jacobian_analytical_grad, pstream__),
              "assigning variable log_like");
          } 
        }
      }
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_greater_or_equal(function__, "tau[sym1__]", tau[(sym1__ - 1)],
                               0);}
      {
        current_statement__ = 103;
        lp_accum__.add(normal_lpdf<propto__>(gamma, 1, prior_gamma_sd));
        current_statement__ = 104;
        lp_accum__.add(
          beta_lpdf<propto__>(alpha, prior_alpha_shape, prior_alpha_shape));
        current_statement__ = 105;
        lp_accum__.add(std_normal_lpdf<propto__>(to_vector(z)));
        current_statement__ = 106;
        lp_accum__.add(normal_lpdf<propto__>(to_vector(mu), 0, 10));
        current_statement__ = 107;
        lp_accum__.add(lkj_corr_cholesky_lpdf<propto__>(L_Omega, lkj_shape));
        current_statement__ = 108;
        lp_accum__.add(normal_lpdf<propto__>(scale, 0, 1));
        current_statement__ = 109;
        lp_accum__.add(dot_product(log_like, weights));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_mdcev_rp_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> gamma;
      gamma = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      gamma = in__.vector(gamma_1dim__);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(gamma[(sym1__ - 1)], 0),
          "assigning variable gamma");}
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(alpha_1dim__);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      alpha = in__.vector(alpha_1dim__);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(alpha[(sym1__ - 1)], 0, 1),
          "assigning variable alpha");}
      Eigen::Matrix<double, -1, 1> mu;
      mu = Eigen::Matrix<double, -1, 1>(RP);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      mu = in__.vector(RP);
      Eigen::Matrix<double, -1, -1> z;
      z = Eigen::Matrix<double, -1, -1>(I, RP);
      stan::math::fill(z, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      z = in__.matrix(I, RP);
      Eigen::Matrix<double, -1, -1> L_Omega;
      L_Omega = Eigen::Matrix<double, -1, -1>(L_Omega_1dim__, L_Omega_2dim__);
      stan::math::fill(L_Omega, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> L_Omega_in__;
      L_Omega_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((L_Omega_1dim__
                                                               *
                                                               (L_Omega_1dim__
                                                                 - 1)) / 2));
      stan::math::fill(L_Omega_in__, DUMMY_VAR__);
      
      current_statement__ = 5;
      L_Omega_in__ = in__.vector(
                       ((L_Omega_1dim__ * (L_Omega_1dim__ - 1)) / 2));
      current_statement__ = 5;
      assign(L_Omega, nil_index_list(),
        stan::math::cholesky_corr_constrain(L_Omega_in__, L_Omega_1dim__),
        "assigning variable L_Omega");
      Eigen::Matrix<double, -1, 1> tau_unif;
      tau_unif = Eigen::Matrix<double, -1, 1>(RP);
      stan::math::fill(tau_unif, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      tau_unif = in__.vector(RP);
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        current_statement__ = 6;
        assign(tau_unif, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(tau_unif[(sym1__ - 1)], 0,
            (stan::math::pi() / 2)), "assigning variable tau_unif");}
      Eigen::Matrix<double, -1, 1> scale;
      scale = Eigen::Matrix<double, -1, 1>(S);
      stan::math::fill(scale, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      scale = in__.vector(S);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        current_statement__ = 7;
        assign(scale, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(scale[(sym1__ - 1)], 0),
          "assigning variable scale");}
      Eigen::Matrix<double, -1, 1> log_like;
      log_like = Eigen::Matrix<double, -1, 1>(I);
      stan::math::fill(log_like, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> tau;
      tau = Eigen::Matrix<double, -1, 1>(RP);
      stan::math::fill(tau, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
          vars__.emplace_back(
            rvalue(z,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "z"));}}
      for (int sym1__ = 1; sym1__ <= L_Omega_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= L_Omega_1dim__; ++sym2__) {
          vars__.emplace_back(
            rvalue(L_Omega,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "L_Omega"));
        }}
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        vars__.emplace_back(tau_unif[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        vars__.emplace_back(scale[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      {
        current_statement__ = 10;
        validate_non_negative_index("beta", "I", I);
        current_statement__ = 11;
        validate_non_negative_index("beta", "RP", RP);
        Eigen::Matrix<double, -1, -1> beta;
        beta = Eigen::Matrix<double, -1, -1>(I, RP);
        stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 13;
        validate_non_negative_index("lpsi", "I", I);
        current_statement__ = 14;
        validate_non_negative_index("lpsi", "J", J);
        Eigen::Matrix<double, -1, -1> lpsi;
        lpsi = Eigen::Matrix<double, -1, -1>(I, J);
        stan::math::fill(lpsi, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 16;
        validate_non_negative_index("alpha_individual_1", "I", I);
        Eigen::Matrix<double, -1, 1> alpha_individual_1;
        alpha_individual_1 = Eigen::Matrix<double, -1, 1>(I);
        stan::math::fill(alpha_individual_1, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 18;
        validate_non_negative_index("alpha_individual_j", "I", I);
        current_statement__ = 19;
        validate_non_negative_index("alpha_individual_j", "J", J);
        Eigen::Matrix<double, -1, -1> alpha_individual_j;
        alpha_individual_j = Eigen::Matrix<double, -1, -1>(I, J);
        stan::math::fill(alpha_individual_j, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 21;
        validate_non_negative_index("gamma_individual", "I", I);
        current_statement__ = 22;
        validate_non_negative_index("gamma_individual", "J", J);
        Eigen::Matrix<double, -1, -1> gamma_individual;
        gamma_individual = Eigen::Matrix<double, -1, -1>(I, J);
        stan::math::fill(gamma_individual, std::numeric_limits<double>::quiet_NaN());
        
        double scale_full;
        scale_full = std::numeric_limits<double>::quiet_NaN();
        
        current_statement__ = 27;
        if (logical_eq(fixed_scale1, 0)) {
          current_statement__ = 26;
          scale_full = scale[(1 - 1)];
        } else {
          current_statement__ = 25;
          scale_full = 1.0;
        }
        current_statement__ = 29;
        for (int rp = 1; rp <= RP; ++rp) {
          current_statement__ = 28;
          assign(tau, cons_list(index_uni(rp), nil_index_list()),
            (2.5 * stan::math::tan(tau_unif[(rp - 1)])),
            "assigning variable tau");}
        current_statement__ = 35;
        if (logical_eq(corr, 1)) {
          current_statement__ = 33;
          assign(beta, nil_index_list(),
            add(rep_matrix(transpose(mu), I),
              multiply(z, diag_pre_multiply(tau, L_Omega))),
            "assigning variable beta");
        } else {
          current_statement__ = 32;
          if (logical_eq(corr, 0)) {
            current_statement__ = 30;
            assign(beta, nil_index_list(),
              add(rep_matrix(transpose(mu), I), diag_post_multiply(z, tau)),
              "assigning variable beta");
          } 
        }
        current_statement__ = 48;
        if ((primitive_value(logical_eq(alpha_nonrandom, 0)) &&
            primitive_value(logical_neq(model_num, 4)))) {
          current_statement__ = 40;
          assign(alpha_individual_1, nil_index_list(),
            inv_logit(col(beta, RP_a)),
            "assigning variable alpha_individual_1");
          current_statement__ = 46;
          if (logical_eq(model_num, 1)) {
            current_statement__ = 45;
            assign(alpha_individual_j, nil_index_list(), rep_matrix(0, I, J),
              "assigning variable alpha_individual_j");
          } else {
            current_statement__ = 44;
            if (logical_eq(model_num, 2)) {
              current_statement__ = 43;
              assign(alpha_individual_j, nil_index_list(),
                inv_logit(block(beta, 1, (RP_a + 1), I, J)),
                "assigning variable alpha_individual_j");
            } else {
              current_statement__ = 42;
              if (logical_eq(model_num, 3)) {
                current_statement__ = 41;
                assign(alpha_individual_j, nil_index_list(),
                  rep_matrix(alpha_individual_1, J),
                  "assigning variable alpha_individual_j");
              } 
            }
          }
        } else {
          current_statement__ = 39;
          if ((primitive_value(logical_eq(alpha_nonrandom, 1)) ||
              primitive_value(logical_eq(model_num, 4)))) {
            current_statement__ = 36;
            assign(alpha_individual_1, nil_index_list(),
              alpha_1_ll(alpha, I, model_num, pstream__),
              "assigning variable alpha_individual_1");
            current_statement__ = 37;
            assign(alpha_individual_j, nil_index_list(),
              alpha_j_ll(alpha, I, J, model_num, pstream__),
              "assigning variable alpha_individual_j");
          } 
        }
        current_statement__ = 55;
        if ((primitive_value(logical_eq(gamma_nonrandom, 0)) &&
            primitive_value(logical_neq(model_num, 2)))) {
          current_statement__ = 53;
          if (logical_eq(gamma_ascs, 1)) {
            current_statement__ = 52;
            assign(gamma_individual, nil_index_list(),
              stan::math::exp(block(beta, 1, RP_g, I, Gamma)),
              "assigning variable gamma_individual");
          } else {
            current_statement__ = 51;
            if (logical_eq(gamma_ascs, 0)) {
              current_statement__ = 50;
              assign(gamma_individual, nil_index_list(),
                rep_matrix(stan::math::exp(col(beta, RP_g)), J),
                "assigning variable gamma_individual");
            } 
          }
        } else {
          current_statement__ = 49;
          assign(gamma_individual, nil_index_list(),
            gamma_ll(gamma, I, J, Gamma, pstream__),
            "assigning variable gamma_individual");
        }
        current_statement__ = 68;
        if (logical_eq(psi_ascs, 1)) {
          current_statement__ = 63;
          assign(lpsi, nil_index_list(),
            append_col(rep_vector(0, I), block(beta, 1, 1, I, (J - 1))),
            "assigning variable lpsi");
          current_statement__ = 66;
          if (logical_gt(NPsi_ij, 0)) {
            current_statement__ = 65;
            for (int i = 1; i <= I; ++i) {
              current_statement__ = 64;
              assign(lpsi, cons_list(index_uni(i), nil_index_list()),
                add(
                  stan::model::deep_copy(
                    rvalue(lpsi, cons_list(index_uni(i), nil_index_list()),
                      "lpsi")),
                  multiply(
                    sub_row(beta, task_individual[(i - 1)], J, NPsi_ij),
                    transpose(
                      rvalue(dat_psi,
                        cons_list(
                          index_min_max(start[(i - 1)], end[(i - 1)]),
                          nil_index_list()), "dat_psi")))),
                "assigning variable lpsi");}
          } 
        } else {
          current_statement__ = 62;
          if (logical_eq(psi_ascs, 0)) {
            current_statement__ = 60;
            if (logical_gt(NPsi_ij, 0)) {
              current_statement__ = 59;
              for (int i = 1; i <= I; ++i) {
                current_statement__ = 58;
                assign(lpsi, cons_list(index_uni(i), nil_index_list()),
                  multiply(
                    sub_row(beta, task_individual[(i - 1)], 1, NPsi_ij),
                    transpose(
                      rvalue(dat_psi,
                        cons_list(
                          index_min_max(start[(i - 1)], end[(i - 1)]),
                          nil_index_list()), "dat_psi"))),
                  "assigning variable lpsi");}
            } else {
              current_statement__ = 57;
              if (logical_eq(NPsi_ij, 0)) {
                current_statement__ = 56;
                assign(lpsi, nil_index_list(), rep_matrix(0, I, J),
                  "assigning variable lpsi");
              } 
            }
          } 
        }
        current_statement__ = 82;
        if (logical_lt(model_num, 5)) {
          current_statement__ = 80;
          assign(log_like, nil_index_list(),
            mdcev_ll(quant_j, price_j, log_num, income, M, log_M_fact, lpsi,
              gamma_individual, alpha_individual_1, alpha_individual_j,
              scale_full, I, J, nonzero, trunc_data, pstream__),
            "assigning variable log_like");
        } else {
          current_statement__ = 79;
          if (logical_eq(model_num, 5)) {
            current_statement__ = 69;
            validate_non_negative_index("phi_ij", "I", I);
            current_statement__ = 70;
            validate_non_negative_index("phi_ij", "J", J);
            Eigen::Matrix<double, -1, -1> phi_ij;
            phi_ij = Eigen::Matrix<double, -1, -1>(I, J);
            stan::math::fill(phi_ij, std::numeric_limits<double>::quiet_NaN());
            
            current_statement__ = 76;
            if (logical_eq(NPhi, 0)) {
              current_statement__ = 75;
              assign(phi_ij, nil_index_list(), rep_matrix(1, I, J),
                "assigning variable phi_ij");
            } else {
              current_statement__ = 74;
              if (logical_gt(NPhi, 0)) {
                current_statement__ = 73;
                for (int i = 1; i <= I; ++i) {
                  current_statement__ = 72;
                  assign(phi_ij, cons_list(index_uni(i), nil_index_list()),
                    stan::math::exp(
                      multiply(
                        sub_row(beta, task_individual[(i - 1)], RP_Phi, NPhi),
                        transpose(
                          rvalue(dat_phi,
                            cons_list(
                              index_min_max(start[(i - 1)], end[(i - 1)]),
                              nil_index_list()), "dat_phi")))),
                    "assigning variable phi_ij");}
              } 
            }
            current_statement__ = 77;
            assign(log_like, nil_index_list(),
              kt_ll(quant_j, price_j, log_num, income, lpsi, phi_ij,
                gamma_individual, alpha_individual_1, scale_full, I, J,
                nonzero, trunc_data, jacobian_analytical_grad, pstream__),
              "assigning variable log_like");
          } 
        }
      }
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_greater_or_equal(function__, "tau[sym1__]", tau[(sym1__ - 1)],
                               0);}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          vars__.emplace_back(log_like[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
          vars__.emplace_back(tau[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, -1> Sigma;
      Sigma = Eigen::Matrix<double, -1, -1>(RP, RP);
      stan::math::fill(Sigma, std::numeric_limits<double>::quiet_NaN());
      
      double sum_log_lik;
      sum_log_lik = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 85;
      sum_log_lik = 0;
      {
        current_statement__ = 86;
        validate_non_negative_index("L", "RP", RP);
        current_statement__ = 87;
        validate_non_negative_index("L", "RP", RP);
        Eigen::Matrix<double, -1, -1> L;
        L = Eigen::Matrix<double, -1, -1>(RP, RP);
        stan::math::fill(L, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 98;
        if (logical_eq(corr, 1)) {
          current_statement__ = 92;
          validate_non_negative_index("Omega", "RP", RP);
          current_statement__ = 93;
          validate_non_negative_index("Omega", "RP", RP);
          Eigen::Matrix<double, -1, -1> Omega;
          Omega = Eigen::Matrix<double, -1, -1>(RP, RP);
          stan::math::fill(Omega, std::numeric_limits<double>::quiet_NaN());
          
          current_statement__ = 95;
          assign(Omega, nil_index_list(),
            multiply_lower_tri_self_transpose(L_Omega),
            "assigning variable Omega");
          current_statement__ = 96;
          assign(Sigma, nil_index_list(), quad_form_diag(Omega, tau),
            "assigning variable Sigma");
        } else {
          current_statement__ = 91;
          if (logical_eq(corr, 0)) {
            current_statement__ = 89;
            assign(Sigma, nil_index_list(), diag_matrix(tau),
              "assigning variable Sigma");
          } 
        }
      }
      current_statement__ = 102;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 100;
        sum_log_lik = (sum_log_lik + (log_like[(i - 1)] * weights[(i - 1)]));
      }
      current_statement__ = 85;
      current_statement__ = 85;
      check_less_or_equal(function__, "sum_log_lik", sum_log_lik, 0);
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= RP; ++sym2__) {
          vars__.emplace_back(
            rvalue(Sigma,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "Sigma"));}}
      vars__.emplace_back(sum_log_lik);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> gamma;
      gamma = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_flat__;
        current_statement__ = 1;
        assign(gamma_flat__, nil_index_list(), context__.vals_r("gamma"),
          "assigning variable gamma_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
          current_statement__ = 1;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            gamma_flat__[(pos__ - 1)], "assigning variable gamma");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> gamma_free__;
      gamma_free__ = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(gamma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(gamma[(sym1__ - 1)], 0),
          "assigning variable gamma_free__");}
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(alpha_1dim__);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 2;
        assign(alpha_flat__, nil_index_list(), context__.vals_r("alpha"),
          "assigning variable alpha_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
          current_statement__ = 2;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            alpha_flat__[(pos__ - 1)], "assigning variable alpha");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> alpha_free__;
      alpha_free__ = Eigen::Matrix<double, -1, 1>(alpha_1dim__);
      stan::math::fill(alpha_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(alpha_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(alpha[(sym1__ - 1)], 0, 1),
          "assigning variable alpha_free__");}
      Eigen::Matrix<double, -1, 1> mu;
      mu = Eigen::Matrix<double, -1, 1>(RP);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 3;
        assign(mu_flat__, nil_index_list(), context__.vals_r("mu"),
          "assigning variable mu_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
          current_statement__ = 3;
          assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
            mu_flat__[(pos__ - 1)], "assigning variable mu");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, -1> z;
      z = Eigen::Matrix<double, -1, -1>(I, RP);
      stan::math::fill(z, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> z_flat__;
        current_statement__ = 4;
        assign(z_flat__, nil_index_list(), context__.vals_r("z"),
          "assigning variable z_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
          current_statement__ = 4;
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            current_statement__ = 4;
            assign(z,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              z_flat__[(pos__ - 1)], "assigning variable z");
            current_statement__ = 4;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> L_Omega;
      L_Omega = Eigen::Matrix<double, -1, -1>(L_Omega_1dim__, L_Omega_2dim__);
      stan::math::fill(L_Omega, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> L_Omega_flat__;
        current_statement__ = 5;
        assign(L_Omega_flat__, nil_index_list(), context__.vals_r("L_Omega"),
          "assigning variable L_Omega_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= L_Omega_2dim__; ++sym1__) {
          current_statement__ = 5;
          for (int sym2__ = 1; sym2__ <= L_Omega_1dim__; ++sym2__) {
            current_statement__ = 5;
            assign(L_Omega,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              L_Omega_flat__[(pos__ - 1)], "assigning variable L_Omega");
            current_statement__ = 5;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> L_Omega_free__;
      L_Omega_free__ = Eigen::Matrix<double, -1, 1>(((L_Omega_1dim__ *
                                                       (L_Omega_1dim__ - 1))
                                                      / 2));
      stan::math::fill(L_Omega_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      assign(L_Omega_free__, nil_index_list(),
        stan::math::cholesky_corr_free(L_Omega),
        "assigning variable L_Omega_free__");
      Eigen::Matrix<double, -1, 1> tau_unif;
      tau_unif = Eigen::Matrix<double, -1, 1>(RP);
      stan::math::fill(tau_unif, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> tau_unif_flat__;
        current_statement__ = 6;
        assign(tau_unif_flat__, nil_index_list(),
          context__.vals_r("tau_unif"), "assigning variable tau_unif_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
          current_statement__ = 6;
          assign(tau_unif, cons_list(index_uni(sym1__), nil_index_list()),
            tau_unif_flat__[(pos__ - 1)], "assigning variable tau_unif");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> tau_unif_free__;
      tau_unif_free__ = Eigen::Matrix<double, -1, 1>(RP);
      stan::math::fill(tau_unif_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        current_statement__ = 6;
        assign(tau_unif_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(tau_unif[(sym1__ - 1)], 0,
            (stan::math::pi() / 2)), "assigning variable tau_unif_free__");}
      Eigen::Matrix<double, -1, 1> scale;
      scale = Eigen::Matrix<double, -1, 1>(S);
      stan::math::fill(scale, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> scale_flat__;
        current_statement__ = 7;
        assign(scale_flat__, nil_index_list(), context__.vals_r("scale"),
          "assigning variable scale_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
          current_statement__ = 7;
          assign(scale, cons_list(index_uni(sym1__), nil_index_list()),
            scale_flat__[(pos__ - 1)], "assigning variable scale");
          current_statement__ = 7;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> scale_free__;
      scale_free__ = Eigen::Matrix<double, -1, 1>(S);
      stan::math::fill(scale_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        current_statement__ = 7;
        assign(scale_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(scale[(sym1__ - 1)], 0),
          "assigning variable scale_free__");}
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        vars__.emplace_back(alpha_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
          vars__.emplace_back(
            rvalue(z,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "z"));}}
      for (int sym1__ = 1;
           sym1__ <= ((L_Omega_1dim__ * (L_Omega_1dim__ - 1)) / 2); ++sym1__) {
        vars__.emplace_back(L_Omega_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        vars__.emplace_back(tau_unif_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        vars__.emplace_back(scale_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("gamma");
    names__.emplace_back("alpha");
    names__.emplace_back("mu");
    names__.emplace_back("z");
    names__.emplace_back("L_Omega");
    names__.emplace_back("tau_unif");
    names__.emplace_back("scale");
    names__.emplace_back("log_like");
    names__.emplace_back("tau");
    names__.emplace_back("Sigma");
    names__.emplace_back("sum_log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gamma_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(alpha_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(RP)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(I),
                                             static_cast<size_t>(RP)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(L_Omega_1dim__)
                                             ,
                                             static_cast<size_t>(L_Omega_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(RP)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(S)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(I)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(RP)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(RP),
                                             static_cast<size_t>(RP)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "z" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= L_Omega_2dim__; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= L_Omega_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "L_Omega" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_unif" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "scale" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_like" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= RP; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Sigma" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      param_names__.emplace_back(std::string() + "sum_log_lik");
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "z" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1;
         sym1__ <= ((L_Omega_1dim__ * (L_Omega_1dim__ - 1)) / 2); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "L_Omega" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_unif" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "scale" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_like" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= RP; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= RP; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Sigma" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      param_names__.emplace_back(std::string() + "sum_log_lik");
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" << gamma_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << alpha_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << RP << "},\"block\":\"parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"matrix\",\"rows\":" << I << ",\"cols\":" << RP << "},\"block\":\"parameters\"},{\"name\":\"L_Omega\",\"type\":{\"name\":\"matrix\",\"rows\":" << L_Omega_1dim__ << ",\"cols\":" << L_Omega_2dim__ << "},\"block\":\"parameters\"},{\"name\":\"tau_unif\",\"type\":{\"name\":\"vector\",\"length\":" << RP << "},\"block\":\"parameters\"},{\"name\":\"scale\",\"type\":{\"name\":\"vector\",\"length\":" << S << "},\"block\":\"parameters\"},{\"name\":\"log_like\",\"type\":{\"name\":\"vector\",\"length\":" << I << "},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"vector\",\"length\":" << RP << "},\"block\":\"transformed_parameters\"},{\"name\":\"Sigma\",\"type\":{\"name\":\"matrix\",\"rows\":" << RP << ",\"cols\":" << RP << "},\"block\":\"generated_quantities\"},{\"name\":\"sum_log_lik\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" << gamma_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << alpha_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << RP << "},\"block\":\"parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"matrix\",\"rows\":" << I << ",\"cols\":" << RP << "},\"block\":\"parameters\"},{\"name\":\"L_Omega\",\"type\":{\"name\":\"vector\",\"length\":" << ((L_Omega_1dim__ * (L_Omega_1dim__ - 1)) / 2) << "},\"block\":\"parameters\"},{\"name\":\"tau_unif\",\"type\":{\"name\":\"vector\",\"length\":" << RP << "},\"block\":\"parameters\"},{\"name\":\"scale\",\"type\":{\"name\":\"vector\",\"length\":" << S << "},\"block\":\"parameters\"},{\"name\":\"log_like\",\"type\":{\"name\":\"vector\",\"length\":" << I << "},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"vector\",\"length\":" << RP << "},\"block\":\"transformed_parameters\"},{\"name\":\"Sigma\",\"type\":{\"name\":\"matrix\",\"rows\":" << RP << ",\"cols\":" << RP << "},\"block\":\"generated_quantities\"},{\"name\":\"sum_log_lik\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_mdcev_rp_namespace::model_mdcev_rp;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_mdcev_rp_namespace::profiles__;
}
#endif
#endif
