// Generated by rstantools.  Do not edit by hand.

/*
    rmdcev is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rmdcev is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rmdcev.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_mdcev_rp_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_mdcev_rp");
    reader.add_event(2, 2, "include", "/common/mdcev_ll.stan");
    reader.add_event(2, 0, "start", "/common/mdcev_ll.stan");
    reader.add_event(121, 119, "end", "/common/mdcev_ll.stan");
    reader.add_event(121, 3, "restart", "model_mdcev_rp");
    reader.add_event(125, 7, "include", "/common/mdcev_data.stan");
    reader.add_event(125, 0, "start", "/common/mdcev_data.stan");
    reader.add_event(148, 23, "end", "/common/mdcev_data.stan");
    reader.add_event(148, 8, "restart", "model_mdcev_rp");
    reader.add_event(165, 25, "include", "/common/mdcev_tdata.stan");
    reader.add_event(165, 0, "start", "/common/mdcev_tdata.stan");
    reader.add_event(205, 40, "end", "/common/mdcev_tdata.stan");
    reader.add_event(205, 26, "restart", "model_mdcev_rp");
    reader.add_event(335, 154, "end", "model_mdcev_rp");
    return reader;
}
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
gamma_ll(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& gamma,
             const int& I,
             const int& J,
             const int& Gamma, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 6;
        validate_non_negative_index("gamma_j", "I", I);
        validate_non_negative_index("gamma_j", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> gamma_j(I, J);
        stan::math::initialize(gamma_j, DUMMY_VAR__);
        stan::math::fill(gamma_j, DUMMY_VAR__);
        current_statement_begin__ = 8;
        if (as_bool(logical_eq(Gamma, 0))) {
            current_statement_begin__ = 9;
            stan::math::assign(gamma_j, rep_matrix(1, I, J));
        } else if (as_bool(logical_eq(Gamma, J))) {
            current_statement_begin__ = 11;
            stan::math::assign(gamma_j, rep_matrix(transpose(gamma), I));
        } else if (as_bool(logical_eq(Gamma, 1))) {
            current_statement_begin__ = 13;
            stan::math::assign(gamma_j, rep_matrix(get_base1(gamma, 1, "gamma", 1), I, J));
        }
        current_statement_begin__ = 15;
        return stan::math::promote_scalar<fun_return_scalar_t__>(gamma_j);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct gamma_ll_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& gamma,
             const int& I,
             const int& J,
             const int& Gamma, std::ostream* pstream__) const {
        return gamma_ll(gamma, I, J, Gamma, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
alpha_j_ll(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& alpha,
               const int& I,
               const int& J,
               const int& model_num, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 20;
        validate_non_negative_index("alpha_j", "I", I);
        validate_non_negative_index("alpha_j", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> alpha_j(I, J);
        stan::math::initialize(alpha_j, DUMMY_VAR__);
        stan::math::fill(alpha_j, DUMMY_VAR__);
        current_statement_begin__ = 22;
        if (as_bool((primitive_value((primitive_value(logical_eq(model_num, 1)) || primitive_value(logical_eq(model_num, 4)))) || primitive_value(logical_eq(model_num, 5))))) {
            current_statement_begin__ = 23;
            stan::math::assign(alpha_j, rep_matrix(0, I, J));
        } else if (as_bool(logical_eq(model_num, 2))) {
            current_statement_begin__ = 25;
            stan::math::assign(alpha_j, rep_matrix(transpose(stan::model::rvalue(alpha, stan::model::cons_list(stan::model::index_min_max(2, (J + 1)), stan::model::nil_index_list()), "alpha")), I));
        } else if (as_bool(logical_eq(model_num, 3))) {
            current_statement_begin__ = 27;
            stan::math::assign(alpha_j, rep_matrix(get_base1(alpha, 1, "alpha", 1), I, J));
        }
        current_statement_begin__ = 29;
        return stan::math::promote_scalar<fun_return_scalar_t__>(alpha_j);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct alpha_j_ll_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& alpha,
               const int& I,
               const int& J,
               const int& model_num, std::ostream* pstream__) const {
        return alpha_j_ll(alpha, I, J, model_num, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
alpha_1_ll(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& alpha,
               const int& I,
               const int& model_num, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 34;
        validate_non_negative_index("alpha_1", "I", I);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha_1(I);
        stan::math::initialize(alpha_1, DUMMY_VAR__);
        stan::math::fill(alpha_1, DUMMY_VAR__);
        current_statement_begin__ = 36;
        if (as_bool(logical_eq(model_num, 4))) {
            current_statement_begin__ = 37;
            stan::math::assign(alpha_1, rep_vector(0, I));
        } else {
            current_statement_begin__ = 39;
            stan::math::assign(alpha_1, rep_vector(get_base1(alpha, 1, "alpha", 1), I));
        }
        current_statement_begin__ = 41;
        return stan::math::promote_scalar<fun_return_scalar_t__>(alpha_1);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct alpha_1_ll_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& alpha,
               const int& I,
               const int& model_num, std::ostream* pstream__) const {
        return alpha_1_ll(alpha, I, model_num, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T13__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T9__, T10__, T13__>::type>::type>::type, Eigen::Dynamic, 1>
mdcev_ll(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& quant_j,
             const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& price_j,
             const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& log_num,
             const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& income,
             const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& M,
             const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& log_M_fact,
             const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& lpsi,
             const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& gamma_j,
             const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& alpha1,
             const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& alpha_j,
             const T10__& scale_full,
             const int& I,
             const int& J,
             const Eigen::Matrix<T13__, Eigen::Dynamic, Eigen::Dynamic>& nonzero,
             const int& trunc_data, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T9__, T10__, T13__>::type>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 49;
        validate_non_negative_index("log_like", "I", I);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_like(I);
        stan::math::initialize(log_like, DUMMY_VAR__);
        stan::math::fill(log_like, DUMMY_VAR__);
        current_statement_begin__ = 50;
        validate_non_negative_index("ones_j", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ones_j(J);
        stan::math::initialize(ones_j, DUMMY_VAR__);
        stan::math::fill(ones_j, DUMMY_VAR__);
        stan::math::assign(ones_j,rep_vector(1, J));
        current_statement_begin__ = 51;
        validate_non_negative_index("v_j", "I", I);
        validate_non_negative_index("v_j", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> v_j(I, J);
        stan::math::initialize(v_j, DUMMY_VAR__);
        stan::math::fill(v_j, DUMMY_VAR__);
        stan::math::assign(v_j,divide(subtract(add(lpsi, elt_multiply(subtract(alpha_j, 1), stan::math::log(add(elt_divide(quant_j, gamma_j), 1)))), stan::math::log(price_j)), scale_full));
        current_statement_begin__ = 52;
        validate_non_negative_index("v1", "I", I);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v1(I);
        stan::math::initialize(v1, DUMMY_VAR__);
        stan::math::fill(v1, DUMMY_VAR__);
        stan::math::assign(v1,divide(elt_multiply(subtract(alpha1, 1), log_num), scale_full));
        current_statement_begin__ = 53;
        validate_non_negative_index("logf", "I", I);
        validate_non_negative_index("logf", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> logf(I, J);
        stan::math::initialize(logf, DUMMY_VAR__);
        stan::math::fill(logf, DUMMY_VAR__);
        stan::math::assign(logf,subtract(log1m(alpha_j), stan::math::log(add(quant_j, gamma_j))));
        current_statement_begin__ = 54;
        validate_non_negative_index("logf1", "I", I);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> logf1(I);
        stan::math::initialize(logf1, DUMMY_VAR__);
        stan::math::fill(logf1, DUMMY_VAR__);
        stan::math::assign(logf1,subtract(log1m(alpha1), log_num));
        current_statement_begin__ = 56;
        stan::math::assign(log_like, add(subtract(add(add(add(add(multiply(subtract(1, M), stan::math::log(scale_full)), logf1), v1), rows_dot_product(nonzero, add(logf, v_j))), stan::math::log(add(inv(stan::math::exp(logf1)), rows_dot_product(nonzero, elt_divide(price_j, stan::math::exp(logf)))))), elt_multiply(M, stan::math::log(add(stan::math::exp(v1), multiply(stan::math::exp(v_j), ones_j))))), log_M_fact));
        current_statement_begin__ = 60;
        if (as_bool(logical_eq(trunc_data, 1))) {
            {
            current_statement_begin__ = 61;
            validate_non_negative_index("v_1", "I", I);
            validate_non_negative_index("v_1", "(J + 1)", (J + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> v_1(I, (J + 1));
            stan::math::initialize(v_1, DUMMY_VAR__);
            stan::math::fill(v_1, DUMMY_VAR__);
            stan::math::assign(v_1,stan::math::exp(divide(append_col(elt_multiply(subtract(alpha1, 1), stan::math::log(income)), subtract(lpsi, stan::math::log(price_j))), scale_full)));
            current_statement_begin__ = 62;
            validate_non_negative_index("like_trunc", "I", I);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> like_trunc(I);
            stan::math::initialize(like_trunc, DUMMY_VAR__);
            stan::math::fill(like_trunc, DUMMY_VAR__);
            stan::math::assign(like_trunc,elt_divide(col(v_1, 1), multiply(v_1, rep_vector(1, (J + 1)))));
            current_statement_begin__ = 64;
            for (int i = 1; i <= I; ++i) {
                current_statement_begin__ = 65;
                stan::model::assign(like_trunc, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (logical_lt(get_base1(like_trunc, i, "like_trunc", 1), 1) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(like_trunc, i, "like_trunc", 1)) : stan::math::promote_scalar<local_scalar_t__>(1) ), 
                            "assigning variable like_trunc");
            }
            current_statement_begin__ = 67;
            stan::math::assign(log_like, subtract(log_like, log1m(like_trunc)));
            }
        }
        current_statement_begin__ = 70;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_like);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct mdcev_ll_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T13__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T9__, T10__, T13__>::type>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& quant_j,
             const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& price_j,
             const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& log_num,
             const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& income,
             const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& M,
             const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& log_M_fact,
             const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& lpsi,
             const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& gamma_j,
             const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& alpha1,
             const Eigen::Matrix<T9__, Eigen::Dynamic, Eigen::Dynamic>& alpha_j,
             const T10__& scale_full,
             const int& I,
             const int& J,
             const Eigen::Matrix<T13__, Eigen::Dynamic, Eigen::Dynamic>& nonzero,
             const int& trunc_data, std::ostream* pstream__) const {
        return mdcev_ll(quant_j, price_j, log_num, income, M, log_M_fact, lpsi, gamma_j, alpha1, alpha_j, scale_full, I, J, nonzero, trunc_data, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
DeterminJacob(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi_quant_term,
                  const T1__& alpha,
                  const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& price_j_num,
                  const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& nonzero,
                  const int& J, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 76;
        local_scalar_t__ log_j_det(DUMMY_VAR__);
        (void) log_j_det;  // dummy to suppress unused var warning
        stan::math::initialize(log_j_det, DUMMY_VAR__);
        stan::math::fill(log_j_det, DUMMY_VAR__);
        current_statement_begin__ = 77;
        validate_non_negative_index("jacobian", "J", J);
        validate_non_negative_index("jacobian", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> jacobian(J, J);
        stan::math::initialize(jacobian, DUMMY_VAR__);
        stan::math::fill(jacobian, DUMMY_VAR__);
        stan::math::assign(jacobian,add_diag(rep_matrix(multiply((1 - alpha), price_j_num), J), inv(phi_quant_term)));
        current_statement_begin__ = 78;
        stan::math::assign(jacobian, add_diag(diag_post_multiply(jacobian, nonzero), subtract(1, nonzero)));
        current_statement_begin__ = 79;
        stan::math::assign(log_j_det, log_determinant(jacobian));
        current_statement_begin__ = 81;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_j_det);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct DeterminJacob_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi_quant_term,
                  const T1__& alpha,
                  const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& price_j_num,
                  const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& nonzero,
                  const int& J, std::ostream* pstream__) const {
        return DeterminJacob(phi_quant_term, alpha, price_j_num, nonzero, J, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__, typename T11__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T11__>::type>::type>::type, Eigen::Dynamic, 1>
kt_ll(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& quant_j,
          const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& price_j,
          const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& log_num,
          const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& income,
          const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& lpsi,
          const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& phi_ij,
          const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& gamma,
          const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& alpha,
          const T8__& scale_full,
          const int& I,
          const int& J,
          const Eigen::Matrix<T11__, Eigen::Dynamic, Eigen::Dynamic>& nonzero,
          const int& trunc_data,
          const int& jacobian_analytical_grad, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T11__>::type>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 88;
        validate_non_negative_index("log_like", "I", I);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_like(I);
        stan::math::initialize(log_like, DUMMY_VAR__);
        stan::math::fill(log_like, DUMMY_VAR__);
        current_statement_begin__ = 89;
        validate_non_negative_index("ones_j", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ones_j(J);
        stan::math::initialize(ones_j, DUMMY_VAR__);
        stan::math::fill(ones_j, DUMMY_VAR__);
        stan::math::assign(ones_j,rep_vector(1, J));
        current_statement_begin__ = 90;
        validate_non_negative_index("g", "I", I);
        validate_non_negative_index("g", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> g(I, J);
        stan::math::initialize(g, DUMMY_VAR__);
        stan::math::fill(g, DUMMY_VAR__);
        current_statement_begin__ = 91;
        validate_non_negative_index("phi_quant_term", "I", I);
        validate_non_negative_index("phi_quant_term", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> phi_quant_term(I, J);
        stan::math::initialize(phi_quant_term, DUMMY_VAR__);
        stan::math::fill(phi_quant_term, DUMMY_VAR__);
        stan::math::assign(phi_quant_term,elt_divide(add(elt_multiply(phi_ij, quant_j), gamma), phi_ij));
        current_statement_begin__ = 92;
        validate_non_negative_index("log_j_det", "I", I);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_j_det(I);
        stan::math::initialize(log_j_det, DUMMY_VAR__);
        stan::math::fill(log_j_det, DUMMY_VAR__);
        current_statement_begin__ = 94;
        if (as_bool(logical_eq(jacobian_analytical_grad, 0))) {
            current_statement_begin__ = 95;
            for (int i = 1; i <= I; ++i) {
                {
                current_statement_begin__ = 96;
                validate_non_negative_index("price_j_num", "J", J);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> price_j_num(J);
                stan::math::initialize(price_j_num, DUMMY_VAR__);
                stan::math::fill(price_j_num, DUMMY_VAR__);
                stan::math::assign(price_j_num,elt_divide(transpose(get_base1(price_j, i, "price_j", 1)), stan::math::exp(get_base1(log_num, i, "log_num", 1))));
                current_statement_begin__ = 97;
                stan::model::assign(log_j_det, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            DeterminJacob(transpose(get_base1(phi_quant_term, i, "phi_quant_term", 1)), get_base1(alpha, i, "alpha", 1), price_j_num, transpose(get_base1(nonzero, i, "nonzero", 1)), J, pstream__), 
                            "assigning variable log_j_det");
                }
            }
        } else if (as_bool(logical_eq(jacobian_analytical_grad, 1))) {
            current_statement_begin__ = 101;
            stan::math::assign(log_j_det, add(add(subtract(log1m(alpha), log_num), rows_dot_product(nonzero, stan::math::log(inv(phi_quant_term)))), stan::math::log(add(elt_divide(stan::math::exp(log_num), subtract(1, alpha)), rows_dot_product(nonzero, elt_multiply(phi_quant_term, price_j))))));
        }
        current_statement_begin__ = 105;
        stan::math::assign(g, divide(subtract(add(minus(lpsi), stan::math::log(elt_multiply(phi_quant_term, price_j))), rep_matrix(elt_multiply(subtract(1, alpha), log_num), J)), scale_full));
        current_statement_begin__ = 108;
        stan::math::assign(log_like, add(log_j_det, multiply(add(elt_multiply(nonzero, subtract(minus(g), stan::math::log(scale_full))), minus(stan::math::exp(minus(g)))), ones_j)));
        current_statement_begin__ = 111;
        if (as_bool(logical_eq(trunc_data, 1))) {
            {
            current_statement_begin__ = 112;
            validate_non_negative_index("like_trunc", "I", I);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> like_trunc(I);
            stan::math::initialize(like_trunc, DUMMY_VAR__);
            stan::math::fill(like_trunc, DUMMY_VAR__);
            stan::math::assign(like_trunc,stan::math::exp(multiply(minus(stan::math::exp(divide(minus(subtract(add(subtract(add(minus(lpsi), stan::math::log(price_j)), stan::math::log(phi_ij)), stan::math::log(gamma)), rep_matrix(elt_multiply(subtract(1, alpha), stan::math::log(income)), J))), scale_full))), ones_j)));
            current_statement_begin__ = 114;
            for (int i = 1; i <= I; ++i) {
                current_statement_begin__ = 115;
                stan::model::assign(like_trunc, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (logical_lt(get_base1(like_trunc, i, "like_trunc", 1), 1) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(like_trunc, i, "like_trunc", 1)) : stan::math::promote_scalar<local_scalar_t__>(1) ), 
                            "assigning variable like_trunc");
            }
            current_statement_begin__ = 117;
            stan::math::assign(log_like, subtract(log_like, log1m(like_trunc)));
            }
        }
        current_statement_begin__ = 120;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_like);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct kt_ll_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__, typename T11__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T11__>::type>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& quant_j,
          const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& price_j,
          const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& log_num,
          const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& income,
          const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& lpsi,
          const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& phi_ij,
          const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& gamma,
          const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& alpha,
          const T8__& scale_full,
          const int& I,
          const int& J,
          const Eigen::Matrix<T11__, Eigen::Dynamic, Eigen::Dynamic>& nonzero,
          const int& trunc_data,
          const int& jacobian_analytical_grad, std::ostream* pstream__) const {
        return kt_ll(quant_j, price_j, log_num, income, lpsi, phi_ij, gamma, alpha, scale_full, I, J, nonzero, trunc_data, jacobian_analytical_grad, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_mdcev_rp
  : public stan::model::model_base_crtp<model_mdcev_rp> {
private:
        int I;
        int J;
        int NPsi_ij;
        int NPhi;
        int model_num;
        matrix_d dat_psi;
        matrix_d dat_phi;
        matrix_d price_j;
        matrix_d quant_j;
        vector_d income;
        int flat_priors;
        double prior_psi_sd;
        double prior_phi_sd;
        double prior_gamma_sd;
        double prior_alpha_shape;
        double prior_scale_sd;
        int fixed_scale1;
        int trunc_data;
        int jacobian_analytical_grad;
        int gamma_ascs;
        int psi_ascs;
        vector_d weights;
        int corr;
        std::vector<int> task;
        std::vector<int> task_individual;
        std::vector<int> start;
        std::vector<int> end;
        double lkj_shape;
        int gamma_nonrandom;
        int alpha_nonrandom;
        int RP;
        int RP_Phi;
        int RP_g;
        int RP_a;
        int A;
        int Gamma;
        int NPsi;
        vector_d log_num;
        matrix_d nonzero;
        vector_d M;
        vector_d log_M_fact;
public:
    model_mdcev_rp(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_mdcev_rp(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_mdcev_rp_namespace::model_mdcev_rp";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 127;
            context__.validate_dims("data initialization", "I", "int", context__.to_vec());
            I = int(0);
            vals_i__ = context__.vals_i("I");
            pos__ = 0;
            I = vals_i__[pos__++];
            current_statement_begin__ = 128;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 129;
            context__.validate_dims("data initialization", "NPsi_ij", "int", context__.to_vec());
            NPsi_ij = int(0);
            vals_i__ = context__.vals_i("NPsi_ij");
            pos__ = 0;
            NPsi_ij = vals_i__[pos__++];
            current_statement_begin__ = 130;
            context__.validate_dims("data initialization", "NPhi", "int", context__.to_vec());
            NPhi = int(0);
            vals_i__ = context__.vals_i("NPhi");
            pos__ = 0;
            NPhi = vals_i__[pos__++];
            current_statement_begin__ = 131;
            context__.validate_dims("data initialization", "model_num", "int", context__.to_vec());
            model_num = int(0);
            vals_i__ = context__.vals_i("model_num");
            pos__ = 0;
            model_num = vals_i__[pos__++];
            check_greater_or_equal(function__, "model_num", model_num, 1);
            check_less_or_equal(function__, "model_num", model_num, 5);
            current_statement_begin__ = 132;
            validate_non_negative_index("dat_psi", "(logical_gt(NPsi_ij, 0) ? (I * J) : 0 )", (logical_gt(NPsi_ij, 0) ? (I * J) : 0 ));
            validate_non_negative_index("dat_psi", "NPsi_ij", NPsi_ij);
            context__.validate_dims("data initialization", "dat_psi", "matrix_d", context__.to_vec((logical_gt(NPsi_ij, 0) ? (I * J) : 0 ),NPsi_ij));
            dat_psi = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_gt(NPsi_ij, 0) ? (I * J) : 0 ), NPsi_ij);
            vals_r__ = context__.vals_r("dat_psi");
            pos__ = 0;
            size_t dat_psi_j_2_max__ = NPsi_ij;
            size_t dat_psi_j_1_max__ = (logical_gt(NPsi_ij, 0) ? (I * J) : 0 );
            for (size_t j_2__ = 0; j_2__ < dat_psi_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < dat_psi_j_1_max__; ++j_1__) {
                    dat_psi(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 133;
            validate_non_negative_index("dat_phi", "(logical_eq(model_num, 5) ? (I * J) : 0 )", (logical_eq(model_num, 5) ? (I * J) : 0 ));
            validate_non_negative_index("dat_phi", "NPhi", NPhi);
            context__.validate_dims("data initialization", "dat_phi", "matrix_d", context__.to_vec((logical_eq(model_num, 5) ? (I * J) : 0 ),NPhi));
            dat_phi = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(model_num, 5) ? (I * J) : 0 ), NPhi);
            vals_r__ = context__.vals_r("dat_phi");
            pos__ = 0;
            size_t dat_phi_j_2_max__ = NPhi;
            size_t dat_phi_j_1_max__ = (logical_eq(model_num, 5) ? (I * J) : 0 );
            for (size_t j_2__ = 0; j_2__ < dat_phi_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < dat_phi_j_1_max__; ++j_1__) {
                    dat_phi(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 134;
            validate_non_negative_index("price_j", "I", I);
            validate_non_negative_index("price_j", "J", J);
            context__.validate_dims("data initialization", "price_j", "matrix_d", context__.to_vec(I,J));
            price_j = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(I, J);
            vals_r__ = context__.vals_r("price_j");
            pos__ = 0;
            size_t price_j_j_2_max__ = J;
            size_t price_j_j_1_max__ = I;
            for (size_t j_2__ = 0; j_2__ < price_j_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < price_j_j_1_max__; ++j_1__) {
                    price_j(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 135;
            validate_non_negative_index("quant_j", "I", I);
            validate_non_negative_index("quant_j", "J", J);
            context__.validate_dims("data initialization", "quant_j", "matrix_d", context__.to_vec(I,J));
            quant_j = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(I, J);
            vals_r__ = context__.vals_r("quant_j");
            pos__ = 0;
            size_t quant_j_j_2_max__ = J;
            size_t quant_j_j_1_max__ = I;
            for (size_t j_2__ = 0; j_2__ < quant_j_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < quant_j_j_1_max__; ++j_1__) {
                    quant_j(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 136;
            validate_non_negative_index("income", "I", I);
            context__.validate_dims("data initialization", "income", "vector_d", context__.to_vec(I));
            income = Eigen::Matrix<double, Eigen::Dynamic, 1>(I);
            vals_r__ = context__.vals_r("income");
            pos__ = 0;
            size_t income_j_1_max__ = I;
            for (size_t j_1__ = 0; j_1__ < income_j_1_max__; ++j_1__) {
                income(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 137;
            context__.validate_dims("data initialization", "flat_priors", "int", context__.to_vec());
            flat_priors = int(0);
            vals_i__ = context__.vals_i("flat_priors");
            pos__ = 0;
            flat_priors = vals_i__[pos__++];
            check_greater_or_equal(function__, "flat_priors", flat_priors, 0);
            check_less_or_equal(function__, "flat_priors", flat_priors, 1);
            current_statement_begin__ = 138;
            context__.validate_dims("data initialization", "prior_psi_sd", "double", context__.to_vec());
            prior_psi_sd = double(0);
            vals_r__ = context__.vals_r("prior_psi_sd");
            pos__ = 0;
            prior_psi_sd = vals_r__[pos__++];
            current_statement_begin__ = 139;
            context__.validate_dims("data initialization", "prior_phi_sd", "double", context__.to_vec());
            prior_phi_sd = double(0);
            vals_r__ = context__.vals_r("prior_phi_sd");
            pos__ = 0;
            prior_phi_sd = vals_r__[pos__++];
            current_statement_begin__ = 140;
            context__.validate_dims("data initialization", "prior_gamma_sd", "double", context__.to_vec());
            prior_gamma_sd = double(0);
            vals_r__ = context__.vals_r("prior_gamma_sd");
            pos__ = 0;
            prior_gamma_sd = vals_r__[pos__++];
            current_statement_begin__ = 141;
            context__.validate_dims("data initialization", "prior_alpha_shape", "double", context__.to_vec());
            prior_alpha_shape = double(0);
            vals_r__ = context__.vals_r("prior_alpha_shape");
            pos__ = 0;
            prior_alpha_shape = vals_r__[pos__++];
            current_statement_begin__ = 142;
            context__.validate_dims("data initialization", "prior_scale_sd", "double", context__.to_vec());
            prior_scale_sd = double(0);
            vals_r__ = context__.vals_r("prior_scale_sd");
            pos__ = 0;
            prior_scale_sd = vals_r__[pos__++];
            current_statement_begin__ = 143;
            context__.validate_dims("data initialization", "fixed_scale1", "int", context__.to_vec());
            fixed_scale1 = int(0);
            vals_i__ = context__.vals_i("fixed_scale1");
            pos__ = 0;
            fixed_scale1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "fixed_scale1", fixed_scale1, 0);
            check_less_or_equal(function__, "fixed_scale1", fixed_scale1, 1);
            current_statement_begin__ = 144;
            context__.validate_dims("data initialization", "trunc_data", "int", context__.to_vec());
            trunc_data = int(0);
            vals_i__ = context__.vals_i("trunc_data");
            pos__ = 0;
            trunc_data = vals_i__[pos__++];
            check_greater_or_equal(function__, "trunc_data", trunc_data, 0);
            check_less_or_equal(function__, "trunc_data", trunc_data, 1);
            current_statement_begin__ = 145;
            context__.validate_dims("data initialization", "jacobian_analytical_grad", "int", context__.to_vec());
            jacobian_analytical_grad = int(0);
            vals_i__ = context__.vals_i("jacobian_analytical_grad");
            pos__ = 0;
            jacobian_analytical_grad = vals_i__[pos__++];
            check_greater_or_equal(function__, "jacobian_analytical_grad", jacobian_analytical_grad, 0);
            check_less_or_equal(function__, "jacobian_analytical_grad", jacobian_analytical_grad, 1);
            current_statement_begin__ = 146;
            context__.validate_dims("data initialization", "gamma_ascs", "int", context__.to_vec());
            gamma_ascs = int(0);
            vals_i__ = context__.vals_i("gamma_ascs");
            pos__ = 0;
            gamma_ascs = vals_i__[pos__++];
            check_greater_or_equal(function__, "gamma_ascs", gamma_ascs, 0);
            check_less_or_equal(function__, "gamma_ascs", gamma_ascs, 1);
            current_statement_begin__ = 147;
            context__.validate_dims("data initialization", "psi_ascs", "int", context__.to_vec());
            psi_ascs = int(0);
            vals_i__ = context__.vals_i("psi_ascs");
            pos__ = 0;
            psi_ascs = vals_i__[pos__++];
            check_greater_or_equal(function__, "psi_ascs", psi_ascs, 0);
            check_less_or_equal(function__, "psi_ascs", psi_ascs, 1);
            current_statement_begin__ = 148;
            validate_non_negative_index("weights", "I", I);
            context__.validate_dims("data initialization", "weights", "vector_d", context__.to_vec(I));
            weights = Eigen::Matrix<double, Eigen::Dynamic, 1>(I);
            vals_r__ = context__.vals_r("weights");
            pos__ = 0;
            size_t weights_j_1_max__ = I;
            for (size_t j_1__ = 0; j_1__ < weights_j_1_max__; ++j_1__) {
                weights(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 149;
            context__.validate_dims("data initialization", "corr", "int", context__.to_vec());
            corr = int(0);
            vals_i__ = context__.vals_i("corr");
            pos__ = 0;
            corr = vals_i__[pos__++];
            check_greater_or_equal(function__, "corr", corr, 0);
            check_less_or_equal(function__, "corr", corr, 1);
            current_statement_begin__ = 150;
            validate_non_negative_index("task", "I", I);
            context__.validate_dims("data initialization", "task", "int", context__.to_vec(I));
            task = std::vector<int>(I, int(0));
            vals_i__ = context__.vals_i("task");
            pos__ = 0;
            size_t task_k_0_max__ = I;
            for (size_t k_0__ = 0; k_0__ < task_k_0_max__; ++k_0__) {
                task[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 151;
            validate_non_negative_index("task_individual", "I", I);
            context__.validate_dims("data initialization", "task_individual", "int", context__.to_vec(I));
            task_individual = std::vector<int>(I, int(0));
            vals_i__ = context__.vals_i("task_individual");
            pos__ = 0;
            size_t task_individual_k_0_max__ = I;
            for (size_t k_0__ = 0; k_0__ < task_individual_k_0_max__; ++k_0__) {
                task_individual[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 152;
            validate_non_negative_index("start", "I", I);
            context__.validate_dims("data initialization", "start", "int", context__.to_vec(I));
            start = std::vector<int>(I, int(0));
            vals_i__ = context__.vals_i("start");
            pos__ = 0;
            size_t start_k_0_max__ = I;
            for (size_t k_0__ = 0; k_0__ < start_k_0_max__; ++k_0__) {
                start[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 153;
            validate_non_negative_index("end", "I", I);
            context__.validate_dims("data initialization", "end", "int", context__.to_vec(I));
            end = std::vector<int>(I, int(0));
            vals_i__ = context__.vals_i("end");
            pos__ = 0;
            size_t end_k_0_max__ = I;
            for (size_t k_0__ = 0; k_0__ < end_k_0_max__; ++k_0__) {
                end[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 154;
            context__.validate_dims("data initialization", "lkj_shape", "double", context__.to_vec());
            lkj_shape = double(0);
            vals_r__ = context__.vals_r("lkj_shape");
            pos__ = 0;
            lkj_shape = vals_r__[pos__++];
            check_greater_or_equal(function__, "lkj_shape", lkj_shape, 1);
            current_statement_begin__ = 156;
            context__.validate_dims("data initialization", "gamma_nonrandom", "int", context__.to_vec());
            gamma_nonrandom = int(0);
            vals_i__ = context__.vals_i("gamma_nonrandom");
            pos__ = 0;
            gamma_nonrandom = vals_i__[pos__++];
            check_greater_or_equal(function__, "gamma_nonrandom", gamma_nonrandom, 0);
            check_less_or_equal(function__, "gamma_nonrandom", gamma_nonrandom, 1);
            current_statement_begin__ = 157;
            context__.validate_dims("data initialization", "alpha_nonrandom", "int", context__.to_vec());
            alpha_nonrandom = int(0);
            vals_i__ = context__.vals_i("alpha_nonrandom");
            pos__ = 0;
            alpha_nonrandom = vals_i__[pos__++];
            check_greater_or_equal(function__, "alpha_nonrandom", alpha_nonrandom, 0);
            check_less_or_equal(function__, "alpha_nonrandom", alpha_nonrandom, 1);
            // initialize transformed data variables
            current_statement_begin__ = 161;
            RP = int(0);
            stan::math::fill(RP, std::numeric_limits<int>::min());
            current_statement_begin__ = 162;
            RP_Phi = int(0);
            stan::math::fill(RP_Phi, std::numeric_limits<int>::min());
            current_statement_begin__ = 163;
            RP_g = int(0);
            stan::math::fill(RP_g, std::numeric_limits<int>::min());
            current_statement_begin__ = 164;
            RP_a = int(0);
            stan::math::fill(RP_a, std::numeric_limits<int>::min());
            current_statement_begin__ = 167;
            A = int(0);
            stan::math::fill(A, std::numeric_limits<int>::min());
            current_statement_begin__ = 168;
            Gamma = int(0);
            stan::math::fill(Gamma, std::numeric_limits<int>::min());
            current_statement_begin__ = 169;
            NPsi = int(0);
            stan::math::fill(NPsi, std::numeric_limits<int>::min());
            current_statement_begin__ = 170;
            validate_non_negative_index("log_num", "I", I);
            log_num = Eigen::Matrix<double, Eigen::Dynamic, 1>(I);
            stan::math::fill(log_num, DUMMY_VAR__);
            current_statement_begin__ = 171;
            validate_non_negative_index("nonzero", "I", I);
            validate_non_negative_index("nonzero", "J", J);
            nonzero = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(I, J);
            stan::math::fill(nonzero, DUMMY_VAR__);
            current_statement_begin__ = 172;
            validate_non_negative_index("M", "I", I);
            M = Eigen::Matrix<double, Eigen::Dynamic, 1>(I);
            stan::math::fill(M, DUMMY_VAR__);
            current_statement_begin__ = 173;
            validate_non_negative_index("log_M_fact", "I", I);
            log_M_fact = Eigen::Matrix<double, Eigen::Dynamic, 1>(I);
            stan::math::fill(log_M_fact, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 175;
            for (int i = 1; i <= I; ++i) {
                current_statement_begin__ = 176;
                stan::model::assign(log_num, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::log((get_base1(income, i, "income", 1) - multiply(get_base1(price_j, i, "price_j", 1), transpose(get_base1(quant_j, i, "quant_j", 1))))), 
                            "assigning variable log_num");
                current_statement_begin__ = 177;
                for (int j = 1; j <= J; ++j) {
                    current_statement_begin__ = 178;
                    stan::model::assign(nonzero, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                (logical_gt(get_base1(quant_j, i, j, "quant_j", 1), 0) ? 1 : 0 ), 
                                "assigning variable nonzero");
                }
                current_statement_begin__ = 180;
                stan::model::assign(M, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (sum(get_base1(nonzero, i, "nonzero", 1)) + 1), 
                            "assigning variable M");
            }
            current_statement_begin__ = 183;
            stan::math::assign(log_M_fact, stan::math::lgamma(M));
            current_statement_begin__ = 186;
            if (as_bool(logical_eq(psi_ascs, 1))) {
                current_statement_begin__ = 187;
                stan::math::assign(NPsi, ((J - 1) + NPsi_ij));
            } else if (as_bool(logical_eq(psi_ascs, 0))) {
                current_statement_begin__ = 189;
                stan::math::assign(NPsi, NPsi_ij);
            }
            current_statement_begin__ = 192;
            if (as_bool((primitive_value((primitive_value(logical_eq(model_num, 1)) || primitive_value(logical_eq(model_num, 3)))) || primitive_value(logical_eq(model_num, 5))))) {
                current_statement_begin__ = 193;
                stan::math::assign(A, 1);
                current_statement_begin__ = 194;
                stan::math::assign(Gamma, J);
            } else if (as_bool(logical_eq(model_num, 2))) {
                current_statement_begin__ = 196;
                stan::math::assign(A, (J + 1));
                current_statement_begin__ = 197;
                stan::math::assign(Gamma, 0);
            } else if (as_bool(logical_eq(model_num, 4))) {
                current_statement_begin__ = 199;
                stan::math::assign(A, 0);
                current_statement_begin__ = 200;
                stan::math::assign(Gamma, J);
            }
            current_statement_begin__ = 203;
            if (as_bool((primitive_value(logical_neq(model_num, 2)) && primitive_value(logical_eq(gamma_ascs, 0))))) {
                current_statement_begin__ = 204;
                stan::math::assign(Gamma, 1);
            }
            {
            current_statement_begin__ = 207;
            int n_gamma_rp(0);
            (void) n_gamma_rp;  // dummy to suppress unused var warning
            stan::math::fill(n_gamma_rp, std::numeric_limits<int>::min());
            stan::math::assign(n_gamma_rp,(logical_eq(gamma_nonrandom, 0) ? Gamma : 0 ));
            current_statement_begin__ = 208;
            int n_alpha_rp(0);
            (void) n_alpha_rp;  // dummy to suppress unused var warning
            stan::math::fill(n_alpha_rp, std::numeric_limits<int>::min());
            stan::math::assign(n_alpha_rp,(logical_eq(alpha_nonrandom, 0) ? A : 0 ));
            current_statement_begin__ = 209;
            stan::math::assign(RP, (((NPsi + NPhi) + n_gamma_rp) + n_alpha_rp));
            current_statement_begin__ = 210;
            stan::math::assign(RP_Phi, (NPsi + 1));
            current_statement_begin__ = 211;
            stan::math::assign(RP_g, (RP_Phi + NPhi));
            current_statement_begin__ = 212;
            stan::math::assign(RP_a, (RP_g + n_gamma_rp));
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 220;
            validate_non_negative_index("gamma", "(logical_eq(gamma_nonrandom, 1) ? Gamma : 0 )", (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 ));
            num_params_r__ += (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 );
            current_statement_begin__ = 221;
            validate_non_negative_index("alpha", "(logical_eq(alpha_nonrandom, 1) ? A : 0 )", (logical_eq(alpha_nonrandom, 1) ? A : 0 ));
            num_params_r__ += (logical_eq(alpha_nonrandom, 1) ? A : 0 );
            current_statement_begin__ = 222;
            validate_non_negative_index("mu", "RP", RP);
            num_params_r__ += RP;
            current_statement_begin__ = 223;
            validate_non_negative_index("z", "I", I);
            validate_non_negative_index("z", "RP", RP);
            num_params_r__ += (I * RP);
            current_statement_begin__ = 224;
            validate_non_negative_index("L_Omega", "(logical_eq(corr, 1) ? RP : 0 )", (logical_eq(corr, 1) ? RP : 0 ));
            validate_non_negative_index("L_Omega", "(logical_eq(corr, 1) ? RP : 0 )", (logical_eq(corr, 1) ? RP : 0 ));
            num_params_r__ += (((logical_eq(corr, 1) ? RP : 0 ) * ((logical_eq(corr, 1) ? RP : 0 ) - 1)) / 2);
            current_statement_begin__ = 225;
            validate_non_negative_index("tau_unif", "RP", RP);
            num_params_r__ += RP;
            current_statement_begin__ = 226;
            validate_non_negative_index("scale", "(logical_eq(fixed_scale1, 0) ? 1 : 0 )", (logical_eq(fixed_scale1, 0) ? 1 : 0 ));
            num_params_r__ += (logical_eq(fixed_scale1, 0) ? 1 : 0 );
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_mdcev_rp() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 220;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "(logical_eq(gamma_nonrandom, 1) ? Gamma : 0 )", (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 ));
        context__.validate_dims("parameter initialization", "gamma", "vector_d", context__.to_vec((logical_eq(gamma_nonrandom, 1) ? Gamma : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma((logical_eq(gamma_nonrandom, 1) ? Gamma : 0 ));
        size_t gamma_j_1_max__ = (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 221;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "(logical_eq(alpha_nonrandom, 1) ? A : 0 )", (logical_eq(alpha_nonrandom, 1) ? A : 0 ));
        context__.validate_dims("parameter initialization", "alpha", "vector_d", context__.to_vec((logical_eq(alpha_nonrandom, 1) ? A : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha((logical_eq(alpha_nonrandom, 1) ? A : 0 ));
        size_t alpha_j_1_max__ = (logical_eq(alpha_nonrandom, 1) ? A : 0 );
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            alpha(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 222;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "RP", RP);
        context__.validate_dims("parameter initialization", "mu", "vector_d", context__.to_vec(RP));
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu(RP);
        size_t mu_j_1_max__ = RP;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            mu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(mu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 223;
        if (!(context__.contains_r("z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z");
        pos__ = 0U;
        validate_non_negative_index("z", "I", I);
        validate_non_negative_index("z", "RP", RP);
        context__.validate_dims("parameter initialization", "z", "matrix_d", context__.to_vec(I,RP));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> z(I, RP);
        size_t z_j_2_max__ = RP;
        size_t z_j_1_max__ = I;
        for (size_t j_2__ = 0; j_2__ < z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
                z(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 224;
        if (!(context__.contains_r("L_Omega")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable L_Omega missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("L_Omega");
        pos__ = 0U;
        validate_non_negative_index("L_Omega", "(logical_eq(corr, 1) ? RP : 0 )", (logical_eq(corr, 1) ? RP : 0 ));
        validate_non_negative_index("L_Omega", "(logical_eq(corr, 1) ? RP : 0 )", (logical_eq(corr, 1) ? RP : 0 ));
        context__.validate_dims("parameter initialization", "L_Omega", "matrix_d", context__.to_vec((logical_eq(corr, 1) ? RP : 0 ),(logical_eq(corr, 1) ? RP : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> L_Omega((logical_eq(corr, 1) ? RP : 0 ), (logical_eq(corr, 1) ? RP : 0 ));
        size_t L_Omega_j_2_max__ = (logical_eq(corr, 1) ? RP : 0 );
        size_t L_Omega_j_1_max__ = (logical_eq(corr, 1) ? RP : 0 );
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                L_Omega(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cholesky_factor_corr_unconstrain(L_Omega);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable L_Omega: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 225;
        if (!(context__.contains_r("tau_unif")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau_unif missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau_unif");
        pos__ = 0U;
        validate_non_negative_index("tau_unif", "RP", RP);
        context__.validate_dims("parameter initialization", "tau_unif", "vector_d", context__.to_vec(RP));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau_unif(RP);
        size_t tau_unif_j_1_max__ = RP;
        for (size_t j_1__ = 0; j_1__ < tau_unif_j_1_max__; ++j_1__) {
            tau_unif(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, (stan::math::pi() / 2), tau_unif);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau_unif: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 226;
        if (!(context__.contains_r("scale")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable scale missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("scale");
        pos__ = 0U;
        validate_non_negative_index("scale", "(logical_eq(fixed_scale1, 0) ? 1 : 0 )", (logical_eq(fixed_scale1, 0) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "scale", "vector_d", context__.to_vec((logical_eq(fixed_scale1, 0) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> scale((logical_eq(fixed_scale1, 0) ? 1 : 0 ));
        size_t scale_j_1_max__ = (logical_eq(fixed_scale1, 0) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < scale_j_1_max__; ++j_1__) {
            scale(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, scale);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable scale: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 220;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.vector_lb_constrain(0, (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 ), lp__);
            else
                gamma = in__.vector_lb_constrain(0, (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 ));
            current_statement_begin__ = 221;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.vector_lub_constrain(0, 1, (logical_eq(alpha_nonrandom, 1) ? A : 0 ), lp__);
            else
                alpha = in__.vector_lub_constrain(0, 1, (logical_eq(alpha_nonrandom, 1) ? A : 0 ));
            current_statement_begin__ = 222;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.vector_constrain(RP, lp__);
            else
                mu = in__.vector_constrain(RP);
            current_statement_begin__ = 223;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> z;
            (void) z;  // dummy to suppress unused var warning
            if (jacobian__)
                z = in__.matrix_constrain(I, RP, lp__);
            else
                z = in__.matrix_constrain(I, RP);
            current_statement_begin__ = 224;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> L_Omega;
            (void) L_Omega;  // dummy to suppress unused var warning
            if (jacobian__)
                L_Omega = in__.cholesky_factor_corr_constrain((logical_eq(corr, 1) ? RP : 0 ), lp__);
            else
                L_Omega = in__.cholesky_factor_corr_constrain((logical_eq(corr, 1) ? RP : 0 ));
            current_statement_begin__ = 225;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau_unif;
            (void) tau_unif;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_unif = in__.vector_lub_constrain(0, (stan::math::pi() / 2), RP, lp__);
            else
                tau_unif = in__.vector_lub_constrain(0, (stan::math::pi() / 2), RP);
            current_statement_begin__ = 226;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scale;
            (void) scale;  // dummy to suppress unused var warning
            if (jacobian__)
                scale = in__.vector_lb_constrain(0, (logical_eq(fixed_scale1, 0) ? 1 : 0 ), lp__);
            else
                scale = in__.vector_lb_constrain(0, (logical_eq(fixed_scale1, 0) ? 1 : 0 ));
            // transformed parameters
            current_statement_begin__ = 230;
            validate_non_negative_index("log_like", "I", I);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_like(I);
            stan::math::initialize(log_like, DUMMY_VAR__);
            stan::math::fill(log_like, DUMMY_VAR__);
            current_statement_begin__ = 231;
            validate_non_negative_index("tau", "RP", RP);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau(RP);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            // transformed parameters block statements
            {
            current_statement_begin__ = 234;
            validate_non_negative_index("beta", "I", I);
            validate_non_negative_index("beta", "RP", RP);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta(I, RP);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 235;
            validate_non_negative_index("lpsi", "I", I);
            validate_non_negative_index("lpsi", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> lpsi(I, J);
            stan::math::initialize(lpsi, DUMMY_VAR__);
            stan::math::fill(lpsi, DUMMY_VAR__);
            current_statement_begin__ = 236;
            validate_non_negative_index("alpha_individual_1", "I", I);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha_individual_1(I);
            stan::math::initialize(alpha_individual_1, DUMMY_VAR__);
            stan::math::fill(alpha_individual_1, DUMMY_VAR__);
            current_statement_begin__ = 237;
            validate_non_negative_index("alpha_individual_j", "I", I);
            validate_non_negative_index("alpha_individual_j", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> alpha_individual_j(I, J);
            stan::math::initialize(alpha_individual_j, DUMMY_VAR__);
            stan::math::fill(alpha_individual_j, DUMMY_VAR__);
            current_statement_begin__ = 238;
            validate_non_negative_index("gamma_individual", "I", I);
            validate_non_negative_index("gamma_individual", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> gamma_individual(I, J);
            stan::math::initialize(gamma_individual, DUMMY_VAR__);
            stan::math::fill(gamma_individual, DUMMY_VAR__);
            current_statement_begin__ = 239;
            local_scalar_t__ scale_full(DUMMY_VAR__);
            (void) scale_full;  // dummy to suppress unused var warning
            stan::math::initialize(scale_full, DUMMY_VAR__);
            stan::math::fill(scale_full, DUMMY_VAR__);
            stan::math::assign(scale_full,(logical_eq(fixed_scale1, 0) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(scale, 1, "scale", 1)) : stan::math::promote_scalar<local_scalar_t__>(1.0) ));
            current_statement_begin__ = 241;
            for (int rp = 1; rp <= RP; ++rp) {
                current_statement_begin__ = 241;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(rp), stan::model::nil_index_list()), 
                            (2.5 * stan::math::tan(get_base1(tau_unif, rp, "tau_unif", 1))), 
                            "assigning variable tau");
            }
            current_statement_begin__ = 244;
            if (as_bool(logical_eq(corr, 1))) {
                current_statement_begin__ = 245;
                stan::math::assign(beta, add(rep_matrix(transpose(mu), I), multiply(z, diag_pre_multiply(tau, L_Omega))));
            } else if (as_bool(logical_eq(corr, 0))) {
                current_statement_begin__ = 247;
                stan::math::assign(beta, add(rep_matrix(transpose(mu), I), diag_post_multiply(z, tau)));
            }
            current_statement_begin__ = 250;
            if (as_bool((primitive_value(logical_eq(alpha_nonrandom, 0)) && primitive_value(logical_neq(model_num, 4))))) {
                current_statement_begin__ = 251;
                stan::math::assign(alpha_individual_1, inv_logit(col(beta, RP_a)));
                current_statement_begin__ = 252;
                if (as_bool(logical_eq(model_num, 1))) {
                    current_statement_begin__ = 253;
                    stan::math::assign(alpha_individual_j, rep_matrix(0, I, J));
                } else if (as_bool(logical_eq(model_num, 2))) {
                    current_statement_begin__ = 255;
                    stan::math::assign(alpha_individual_j, inv_logit(block(beta, 1, (RP_a + 1), I, J)));
                } else if (as_bool(logical_eq(model_num, 3))) {
                    current_statement_begin__ = 257;
                    stan::math::assign(alpha_individual_j, rep_matrix(alpha_individual_1, J));
                }
            } else if (as_bool((primitive_value(logical_eq(alpha_nonrandom, 1)) || primitive_value(logical_eq(model_num, 4))))) {
                current_statement_begin__ = 259;
                stan::math::assign(alpha_individual_1, alpha_1_ll(alpha, I, model_num, pstream__));
                current_statement_begin__ = 260;
                stan::math::assign(alpha_individual_j, alpha_j_ll(alpha, I, J, model_num, pstream__));
            }
            current_statement_begin__ = 263;
            if (as_bool((primitive_value(logical_eq(gamma_nonrandom, 0)) && primitive_value(logical_neq(model_num, 2))))) {
                current_statement_begin__ = 264;
                if (as_bool(logical_eq(gamma_ascs, 1))) {
                    current_statement_begin__ = 265;
                    stan::math::assign(gamma_individual, stan::math::exp(block(beta, 1, RP_g, I, Gamma)));
                } else if (as_bool(logical_eq(gamma_ascs, 0))) {
                    current_statement_begin__ = 267;
                    stan::math::assign(gamma_individual, rep_matrix(stan::math::exp(col(beta, RP_g)), J));
                }
            } else {
                current_statement_begin__ = 269;
                stan::math::assign(gamma_individual, gamma_ll(gamma, I, J, Gamma, pstream__));
            }
            current_statement_begin__ = 271;
            if (as_bool(logical_eq(psi_ascs, 1))) {
                current_statement_begin__ = 272;
                stan::math::assign(lpsi, append_col(rep_vector(0, I), block(beta, 1, 1, I, (J - 1))));
                current_statement_begin__ = 273;
                if (as_bool(logical_gt(NPsi_ij, 0))) {
                    current_statement_begin__ = 274;
                    for (int i = 1; i <= I; ++i) {
                        current_statement_begin__ = 275;
                        stan::model::assign(lpsi, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    add(get_base1(lpsi, i, "lpsi", 1), multiply(sub_row(beta, get_base1(task_individual, i, "task_individual", 1), J, NPsi_ij), transpose(stan::model::rvalue(dat_psi, stan::model::cons_list(stan::model::index_min_max(get_base1(start, i, "start", 1), get_base1(end, i, "end", 1)), stan::model::nil_index_list()), "dat_psi")))), 
                                    "assigning variable lpsi");
                    }
                }
            } else if (as_bool(logical_eq(psi_ascs, 0))) {
                current_statement_begin__ = 277;
                if (as_bool(logical_gt(NPsi_ij, 0))) {
                    current_statement_begin__ = 278;
                    for (int i = 1; i <= I; ++i) {
                        current_statement_begin__ = 279;
                        stan::model::assign(lpsi, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    multiply(sub_row(beta, get_base1(task_individual, i, "task_individual", 1), 1, NPsi_ij), transpose(stan::model::rvalue(dat_psi, stan::model::cons_list(stan::model::index_min_max(get_base1(start, i, "start", 1), get_base1(end, i, "end", 1)), stan::model::nil_index_list()), "dat_psi"))), 
                                    "assigning variable lpsi");
                    }
                } else if (as_bool(logical_eq(NPsi_ij, 0))) {
                    current_statement_begin__ = 281;
                    stan::math::assign(lpsi, rep_matrix(0, I, J));
                }
            }
            current_statement_begin__ = 284;
            if (as_bool(logical_lt(model_num, 5))) {
                current_statement_begin__ = 285;
                stan::math::assign(log_like, mdcev_ll(quant_j, price_j, log_num, income, M, log_M_fact, lpsi, gamma_individual, alpha_individual_1, alpha_individual_j, scale_full, I, J, nonzero, trunc_data, pstream__));
            } else if (as_bool(logical_eq(model_num, 5))) {
                {
                current_statement_begin__ = 289;
                validate_non_negative_index("phi_ij", "I", I);
                validate_non_negative_index("phi_ij", "J", J);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> phi_ij(I, J);
                stan::math::initialize(phi_ij, DUMMY_VAR__);
                stan::math::fill(phi_ij, DUMMY_VAR__);
                current_statement_begin__ = 290;
                if (as_bool(logical_eq(NPhi, 0))) {
                    current_statement_begin__ = 291;
                    stan::math::assign(phi_ij, rep_matrix(1, I, J));
                } else if (as_bool(logical_gt(NPhi, 0))) {
                    current_statement_begin__ = 293;
                    for (int i = 1; i <= I; ++i) {
                        current_statement_begin__ = 294;
                        stan::model::assign(phi_ij, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    stan::math::exp(multiply(sub_row(beta, get_base1(task_individual, i, "task_individual", 1), RP_Phi, NPhi), transpose(stan::model::rvalue(dat_phi, stan::model::cons_list(stan::model::index_min_max(get_base1(start, i, "start", 1), get_base1(end, i, "end", 1)), stan::model::nil_index_list()), "dat_phi")))), 
                                    "assigning variable phi_ij");
                    }
                }
                current_statement_begin__ = 296;
                stan::math::assign(log_like, kt_ll(quant_j, price_j, log_num, income, lpsi, phi_ij, gamma_individual, alpha_individual_1, scale_full, I, J, nonzero, trunc_data, jacobian_analytical_grad, pstream__));
                }
            }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 230;
            size_t log_like_j_1_max__ = I;
            for (size_t j_1__ = 0; j_1__ < log_like_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(log_like(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: log_like" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable log_like: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 231;
            size_t tau_j_1_max__ = RP;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tau(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tau: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "tau", tau, 0);
            // model body
            current_statement_begin__ = 305;
            lp_accum__.add(normal_log<propto__>(gamma, 1, prior_gamma_sd));
            current_statement_begin__ = 306;
            lp_accum__.add(beta_log<propto__>(alpha, prior_alpha_shape, prior_alpha_shape));
            current_statement_begin__ = 307;
            lp_accum__.add(std_normal_log<propto__>(to_vector(z)));
            current_statement_begin__ = 308;
            lp_accum__.add(normal_log<propto__>(to_vector(mu), 0, 10));
            current_statement_begin__ = 309;
            lp_accum__.add(lkj_corr_cholesky_log<propto__>(L_Omega, lkj_shape));
            current_statement_begin__ = 310;
            lp_accum__.add(normal_log<propto__>(scale, 0, 1));
            current_statement_begin__ = 312;
            lp_accum__.add(dot_product(log_like, weights));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("gamma");
        names__.push_back("alpha");
        names__.push_back("mu");
        names__.push_back("z");
        names__.push_back("L_Omega");
        names__.push_back("tau_unif");
        names__.push_back("scale");
        names__.push_back("log_like");
        names__.push_back("tau");
        names__.push_back("Sigma");
        names__.push_back("sum_log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((logical_eq(gamma_nonrandom, 1) ? Gamma : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(alpha_nonrandom, 1) ? A : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(RP);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(I);
        dims__.push_back(RP);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(corr, 1) ? RP : 0 ));
        dims__.push_back((logical_eq(corr, 1) ? RP : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(RP);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(fixed_scale1, 0) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(I);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(RP);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(RP);
        dims__.push_back(RP);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_mdcev_rp_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma = in__.vector_lb_constrain(0, (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 ));
        size_t gamma_j_1_max__ = (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            vars__.push_back(gamma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha = in__.vector_lub_constrain(0, 1, (logical_eq(alpha_nonrandom, 1) ? A : 0 ));
        size_t alpha_j_1_max__ = (logical_eq(alpha_nonrandom, 1) ? A : 0 );
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            vars__.push_back(alpha(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu = in__.vector_constrain(RP);
        size_t mu_j_1_max__ = RP;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            vars__.push_back(mu(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> z = in__.matrix_constrain(I, RP);
        size_t z_j_2_max__ = RP;
        size_t z_j_1_max__ = I;
        for (size_t j_2__ = 0; j_2__ < z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
                vars__.push_back(z(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> L_Omega = in__.cholesky_factor_corr_constrain((logical_eq(corr, 1) ? RP : 0 ));
        size_t L_Omega_j_2_max__ = (logical_eq(corr, 1) ? RP : 0 );
        size_t L_Omega_j_1_max__ = (logical_eq(corr, 1) ? RP : 0 );
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                vars__.push_back(L_Omega(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau_unif = in__.vector_lub_constrain(0, (stan::math::pi() / 2), RP);
        size_t tau_unif_j_1_max__ = RP;
        for (size_t j_1__ = 0; j_1__ < tau_unif_j_1_max__; ++j_1__) {
            vars__.push_back(tau_unif(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> scale = in__.vector_lb_constrain(0, (logical_eq(fixed_scale1, 0) ? 1 : 0 ));
        size_t scale_j_1_max__ = (logical_eq(fixed_scale1, 0) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < scale_j_1_max__; ++j_1__) {
            vars__.push_back(scale(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 230;
            validate_non_negative_index("log_like", "I", I);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_like(I);
            stan::math::initialize(log_like, DUMMY_VAR__);
            stan::math::fill(log_like, DUMMY_VAR__);
            current_statement_begin__ = 231;
            validate_non_negative_index("tau", "RP", RP);
            Eigen::Matrix<double, Eigen::Dynamic, 1> tau(RP);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            // do transformed parameters statements
            {
            current_statement_begin__ = 234;
            validate_non_negative_index("beta", "I", I);
            validate_non_negative_index("beta", "RP", RP);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta(I, RP);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 235;
            validate_non_negative_index("lpsi", "I", I);
            validate_non_negative_index("lpsi", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> lpsi(I, J);
            stan::math::initialize(lpsi, DUMMY_VAR__);
            stan::math::fill(lpsi, DUMMY_VAR__);
            current_statement_begin__ = 236;
            validate_non_negative_index("alpha_individual_1", "I", I);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha_individual_1(I);
            stan::math::initialize(alpha_individual_1, DUMMY_VAR__);
            stan::math::fill(alpha_individual_1, DUMMY_VAR__);
            current_statement_begin__ = 237;
            validate_non_negative_index("alpha_individual_j", "I", I);
            validate_non_negative_index("alpha_individual_j", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> alpha_individual_j(I, J);
            stan::math::initialize(alpha_individual_j, DUMMY_VAR__);
            stan::math::fill(alpha_individual_j, DUMMY_VAR__);
            current_statement_begin__ = 238;
            validate_non_negative_index("gamma_individual", "I", I);
            validate_non_negative_index("gamma_individual", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> gamma_individual(I, J);
            stan::math::initialize(gamma_individual, DUMMY_VAR__);
            stan::math::fill(gamma_individual, DUMMY_VAR__);
            current_statement_begin__ = 239;
            local_scalar_t__ scale_full(DUMMY_VAR__);
            (void) scale_full;  // dummy to suppress unused var warning
            stan::math::initialize(scale_full, DUMMY_VAR__);
            stan::math::fill(scale_full, DUMMY_VAR__);
            stan::math::assign(scale_full,(logical_eq(fixed_scale1, 0) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(scale, 1, "scale", 1)) : stan::math::promote_scalar<local_scalar_t__>(1.0) ));
            current_statement_begin__ = 241;
            for (int rp = 1; rp <= RP; ++rp) {
                current_statement_begin__ = 241;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(rp), stan::model::nil_index_list()), 
                            (2.5 * stan::math::tan(get_base1(tau_unif, rp, "tau_unif", 1))), 
                            "assigning variable tau");
            }
            current_statement_begin__ = 244;
            if (as_bool(logical_eq(corr, 1))) {
                current_statement_begin__ = 245;
                stan::math::assign(beta, add(rep_matrix(transpose(mu), I), multiply(z, diag_pre_multiply(tau, L_Omega))));
            } else if (as_bool(logical_eq(corr, 0))) {
                current_statement_begin__ = 247;
                stan::math::assign(beta, add(rep_matrix(transpose(mu), I), diag_post_multiply(z, tau)));
            }
            current_statement_begin__ = 250;
            if (as_bool((primitive_value(logical_eq(alpha_nonrandom, 0)) && primitive_value(logical_neq(model_num, 4))))) {
                current_statement_begin__ = 251;
                stan::math::assign(alpha_individual_1, inv_logit(col(beta, RP_a)));
                current_statement_begin__ = 252;
                if (as_bool(logical_eq(model_num, 1))) {
                    current_statement_begin__ = 253;
                    stan::math::assign(alpha_individual_j, rep_matrix(0, I, J));
                } else if (as_bool(logical_eq(model_num, 2))) {
                    current_statement_begin__ = 255;
                    stan::math::assign(alpha_individual_j, inv_logit(block(beta, 1, (RP_a + 1), I, J)));
                } else if (as_bool(logical_eq(model_num, 3))) {
                    current_statement_begin__ = 257;
                    stan::math::assign(alpha_individual_j, rep_matrix(alpha_individual_1, J));
                }
            } else if (as_bool((primitive_value(logical_eq(alpha_nonrandom, 1)) || primitive_value(logical_eq(model_num, 4))))) {
                current_statement_begin__ = 259;
                stan::math::assign(alpha_individual_1, alpha_1_ll(alpha, I, model_num, pstream__));
                current_statement_begin__ = 260;
                stan::math::assign(alpha_individual_j, alpha_j_ll(alpha, I, J, model_num, pstream__));
            }
            current_statement_begin__ = 263;
            if (as_bool((primitive_value(logical_eq(gamma_nonrandom, 0)) && primitive_value(logical_neq(model_num, 2))))) {
                current_statement_begin__ = 264;
                if (as_bool(logical_eq(gamma_ascs, 1))) {
                    current_statement_begin__ = 265;
                    stan::math::assign(gamma_individual, stan::math::exp(block(beta, 1, RP_g, I, Gamma)));
                } else if (as_bool(logical_eq(gamma_ascs, 0))) {
                    current_statement_begin__ = 267;
                    stan::math::assign(gamma_individual, rep_matrix(stan::math::exp(col(beta, RP_g)), J));
                }
            } else {
                current_statement_begin__ = 269;
                stan::math::assign(gamma_individual, gamma_ll(gamma, I, J, Gamma, pstream__));
            }
            current_statement_begin__ = 271;
            if (as_bool(logical_eq(psi_ascs, 1))) {
                current_statement_begin__ = 272;
                stan::math::assign(lpsi, append_col(rep_vector(0, I), block(beta, 1, 1, I, (J - 1))));
                current_statement_begin__ = 273;
                if (as_bool(logical_gt(NPsi_ij, 0))) {
                    current_statement_begin__ = 274;
                    for (int i = 1; i <= I; ++i) {
                        current_statement_begin__ = 275;
                        stan::model::assign(lpsi, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    add(get_base1(lpsi, i, "lpsi", 1), multiply(sub_row(beta, get_base1(task_individual, i, "task_individual", 1), J, NPsi_ij), transpose(stan::model::rvalue(dat_psi, stan::model::cons_list(stan::model::index_min_max(get_base1(start, i, "start", 1), get_base1(end, i, "end", 1)), stan::model::nil_index_list()), "dat_psi")))), 
                                    "assigning variable lpsi");
                    }
                }
            } else if (as_bool(logical_eq(psi_ascs, 0))) {
                current_statement_begin__ = 277;
                if (as_bool(logical_gt(NPsi_ij, 0))) {
                    current_statement_begin__ = 278;
                    for (int i = 1; i <= I; ++i) {
                        current_statement_begin__ = 279;
                        stan::model::assign(lpsi, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    multiply(sub_row(beta, get_base1(task_individual, i, "task_individual", 1), 1, NPsi_ij), transpose(stan::model::rvalue(dat_psi, stan::model::cons_list(stan::model::index_min_max(get_base1(start, i, "start", 1), get_base1(end, i, "end", 1)), stan::model::nil_index_list()), "dat_psi"))), 
                                    "assigning variable lpsi");
                    }
                } else if (as_bool(logical_eq(NPsi_ij, 0))) {
                    current_statement_begin__ = 281;
                    stan::math::assign(lpsi, rep_matrix(0, I, J));
                }
            }
            current_statement_begin__ = 284;
            if (as_bool(logical_lt(model_num, 5))) {
                current_statement_begin__ = 285;
                stan::math::assign(log_like, mdcev_ll(quant_j, price_j, log_num, income, M, log_M_fact, lpsi, gamma_individual, alpha_individual_1, alpha_individual_j, scale_full, I, J, nonzero, trunc_data, pstream__));
            } else if (as_bool(logical_eq(model_num, 5))) {
                {
                current_statement_begin__ = 289;
                validate_non_negative_index("phi_ij", "I", I);
                validate_non_negative_index("phi_ij", "J", J);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> phi_ij(I, J);
                stan::math::initialize(phi_ij, DUMMY_VAR__);
                stan::math::fill(phi_ij, DUMMY_VAR__);
                current_statement_begin__ = 290;
                if (as_bool(logical_eq(NPhi, 0))) {
                    current_statement_begin__ = 291;
                    stan::math::assign(phi_ij, rep_matrix(1, I, J));
                } else if (as_bool(logical_gt(NPhi, 0))) {
                    current_statement_begin__ = 293;
                    for (int i = 1; i <= I; ++i) {
                        current_statement_begin__ = 294;
                        stan::model::assign(phi_ij, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    stan::math::exp(multiply(sub_row(beta, get_base1(task_individual, i, "task_individual", 1), RP_Phi, NPhi), transpose(stan::model::rvalue(dat_phi, stan::model::cons_list(stan::model::index_min_max(get_base1(start, i, "start", 1), get_base1(end, i, "end", 1)), stan::model::nil_index_list()), "dat_phi")))), 
                                    "assigning variable phi_ij");
                    }
                }
                current_statement_begin__ = 296;
                stan::math::assign(log_like, kt_ll(quant_j, price_j, log_num, income, lpsi, phi_ij, gamma_individual, alpha_individual_1, scale_full, I, J, nonzero, trunc_data, jacobian_analytical_grad, pstream__));
                }
            }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 231;
            check_greater_or_equal(function__, "tau", tau, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t log_like_j_1_max__ = I;
                for (size_t j_1__ = 0; j_1__ < log_like_j_1_max__; ++j_1__) {
                    vars__.push_back(log_like(j_1__));
                }
                size_t tau_j_1_max__ = RP;
                for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                    vars__.push_back(tau(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 316;
            validate_non_negative_index("Sigma", "RP", RP);
            validate_non_negative_index("Sigma", "RP", RP);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Sigma(RP, RP);
            stan::math::initialize(Sigma, DUMMY_VAR__);
            stan::math::fill(Sigma, DUMMY_VAR__);
            current_statement_begin__ = 317;
            double sum_log_lik;
            (void) sum_log_lik;  // dummy to suppress unused var warning
            stan::math::initialize(sum_log_lik, DUMMY_VAR__);
            stan::math::fill(sum_log_lik, DUMMY_VAR__);
            stan::math::assign(sum_log_lik,0);
            // generated quantities statements
            {
            current_statement_begin__ = 320;
            validate_non_negative_index("L", "RP", RP);
            validate_non_negative_index("L", "RP", RP);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> L(RP, RP);
            stan::math::initialize(L, DUMMY_VAR__);
            stan::math::fill(L, DUMMY_VAR__);
            current_statement_begin__ = 321;
            if (as_bool(logical_eq(corr, 1))) {
                {
                current_statement_begin__ = 322;
                validate_non_negative_index("Omega", "RP", RP);
                validate_non_negative_index("Omega", "RP", RP);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Omega(RP, RP);
                stan::math::initialize(Omega, DUMMY_VAR__);
                stan::math::fill(Omega, DUMMY_VAR__);
                current_statement_begin__ = 323;
                stan::math::assign(Omega, multiply_lower_tri_self_transpose(L_Omega));
                current_statement_begin__ = 324;
                stan::math::assign(Sigma, quad_form_diag(Omega, tau));
                }
            } else if (as_bool(logical_eq(corr, 0))) {
                current_statement_begin__ = 326;
                stan::math::assign(Sigma, diag_matrix(tau));
            }
            }
            current_statement_begin__ = 330;
            for (int i = 1; i <= I; ++i) {
                current_statement_begin__ = 331;
                stan::math::assign(sum_log_lik, (sum_log_lik + (get_base1(log_like, i, "log_like", 1) * get_base1(weights, i, "weights", 1))));
            }
            // validate, write generated quantities
            current_statement_begin__ = 316;
            size_t Sigma_j_2_max__ = RP;
            size_t Sigma_j_1_max__ = RP;
            for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                    vars__.push_back(Sigma(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 317;
            check_less_or_equal(function__, "sum_log_lik", sum_log_lik, 0);
            vars__.push_back(sum_log_lik);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_mdcev_rp";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t gamma_j_1_max__ = (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_j_1_max__ = (logical_eq(alpha_nonrandom, 1) ? A : 0 );
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_j_1_max__ = RP;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_j_2_max__ = RP;
        size_t z_j_1_max__ = I;
        for (size_t j_2__ = 0; j_2__ < z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t L_Omega_j_2_max__ = (logical_eq(corr, 1) ? RP : 0 );
        size_t L_Omega_j_1_max__ = (logical_eq(corr, 1) ? RP : 0 );
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_Omega" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t tau_unif_j_1_max__ = RP;
        for (size_t j_1__ = 0; j_1__ < tau_unif_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_unif" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t scale_j_1_max__ = (logical_eq(fixed_scale1, 0) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < scale_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "scale" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t log_like_j_1_max__ = I;
            for (size_t j_1__ = 0; j_1__ < log_like_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_like" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = RP;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t Sigma_j_2_max__ = RP;
        size_t Sigma_j_1_max__ = RP;
        for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sum_log_lik";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t gamma_j_1_max__ = (logical_eq(gamma_nonrandom, 1) ? Gamma : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_j_1_max__ = (logical_eq(alpha_nonrandom, 1) ? A : 0 );
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_j_1_max__ = RP;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_j_2_max__ = RP;
        size_t z_j_1_max__ = I;
        for (size_t j_2__ = 0; j_2__ < z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t L_Omega_j_1_max__ = (((logical_eq(corr, 1) ? RP : 0 ) * ((logical_eq(corr, 1) ? RP : 0 ) - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "L_Omega" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_unif_j_1_max__ = RP;
        for (size_t j_1__ = 0; j_1__ < tau_unif_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_unif" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t scale_j_1_max__ = (logical_eq(fixed_scale1, 0) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < scale_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "scale" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t log_like_j_1_max__ = I;
            for (size_t j_1__ = 0; j_1__ < log_like_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_like" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = RP;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t Sigma_j_2_max__ = RP;
        size_t Sigma_j_1_max__ = RP;
        for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sum_log_lik";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_mdcev_rp_namespace::model_mdcev_rp stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
