/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import java.util.Map;
import jdistlib.Beta;
import jdistlib.Binomial;
import jdistlib.Cauchy;
import jdistlib.ChiSquare;
import jdistlib.DebugFun;
import jdistlib.Exponential;
import jdistlib.F;
import jdistlib.Gamma;
import jdistlib.Geometric;
import jdistlib.HyperGeometric;
import jdistlib.LogNormal;
import jdistlib.Logistic;
import jdistlib.NegBinomial;
import jdistlib.NonCentralBeta;
import jdistlib.NonCentralChiSquare;
import jdistlib.NonCentralF;
import jdistlib.NonCentralT;
import jdistlib.Normal;
import jdistlib.Poisson;
import jdistlib.SignRank;
import jdistlib.T;
import jdistlib.Uniform;
import jdistlib.Weibull;
import jdistlib.Wilcoxon;
import jdistlib.disttest.DistributionTest;
import jdistlib.disttest.NormalityTest;
import jdistlib.disttest.TestKind;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.math.VectorMath;
import jdistlib.rng.MersenneTwister;
import jdistlib.rng.RandomEngine;
import jdistlib.util.Utilities;
import org.junit.Test;

public class TestDPQR {
    static RandomEngine random = new MersenneTwister(123L);
    static final double defaultNumericalError = 1.4210854715202004E-14;

    public static final void setRandomEngine(RandomEngine rng) {
        random = rng;
    }

    public static final boolean dkwtest(GenericDistribution d) {
        return TestDPQR.dkwtest(d, 10000, 0.001);
    }

    public static final boolean dkwtest(GenericDistribution d, int n, double p0) {
        double qdkwbound;
        d.setRandomEngine(random);
        double[] x = d.random(n);
        Map<String, Integer> tbl_x = VectorMath.table(VectorMath.vsignif(x, 12));
        double[] xi = VectorMath.as_numeric(tbl_x.keySet());
        Utilities.sort(xi);
        double[] f = d.cumulative(xi);
        double[] tx = new double[xi.length];
        int i = 0;
        while (i < xi.length) {
            tx[i] = tbl_x.get(String.valueOf(xi[i])).intValue();
            ++i;
        }
        double[] fhat = VectorMath.vdiv(VectorMath.cumsum(tx), n);
        double s = VectorMath.max(VectorMath.vabs(VectorMath.vmin(fhat, f)));
        return s < (qdkwbound = Math.sqrt(Math.log(p0 / 2.0) / (double)(-2 * n)));
    }

    @Test
    public static final boolean test_binom() {
        System.out.println("##__ 1. Binomial __");
        int n0 = 50;
        int n1 = 16;
        int n2 = 22;
        int n3 = 8;
        boolean success = true;
        int i = 0;
        while (i < n1) {
            int n = (int)Binomial.random(2 * n0, 0.4, random);
            System.out.print("n=" + n + ": ");
            int j = 0;
            while (j < n2) {
                double p = j == 0 ? 0.0 : (j == 1 ? 1.0 : Beta.random(2.0, 4.0, random));
                System.out.print(".");
                int j2 = 0;
                while (j2 < n3) {
                    double f_eq;
                    int k = (int)Binomial.random(n, random.nextDouble(), random);
                    double prev_dbinom = 0.0;
                    int l = 0;
                    while (l <= k) {
                        double dbinom;
                        double pbinom = Binomial.cumulative(l, n, p, true, false);
                        prev_dbinom = dbinom = prev_dbinom + Binomial.density(l, n, p, false);
                        if (!DebugFun.isEqual(pbinom, dbinom)) {
                            System.err.println(String.format("Error: pbinom = %g, cumsum(dbinom) = %g", pbinom, dbinom));
                            success = false;
                        }
                        ++l;
                    }
                    double d = f_eq = k == n || p == 0.0 ? 1.0 : F.cumulative(((double)k + 1.0) / (double)(n - k) * (1.0 - p) / p, 2 * (n - k), 2 * (k + 1), true, false);
                    if (!DebugFun.isEqual(f_eq, prev_dbinom)) {
                        System.err.println(String.format("Error: pf = %g, sum(dbinom) = %g", f_eq, prev_dbinom));
                        success = false;
                    }
                    ++j2;
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
        return success;
    }

    @Test
    public static final boolean test_geom() {
        System.out.println("##__ 2. Geometric __");
        boolean success = true;
        int n = 15;
        double from = 1.0E-10;
        double to = 1.0;
        int i = 0;
        while (i < n) {
            double pr = from + (to - from) * (double)i / ((double)n - 1.0);
            double q = 1.0 - pr;
            double prev_dg = 0.0;
            boolean success1 = true;
            boolean success2 = true;
            int j = 0;
            while (j <= 10) {
                double pgeom;
                double direct;
                double dg = Geometric.density(j, pr, false);
                if (!DebugFun.isEqual(dg, direct = pr * Math.pow(q, j))) {
                    System.err.println(String.format("Error: dgeom = %g, direct = %g", dg, direct));
                    success1 = false;
                    success = false;
                }
                if (!DebugFun.isEqual(dg += prev_dg, pgeom = Geometric.cumulative(j, pr, true, false))) {
                    System.err.println(String.format("Error: cumsum(dgeom) = %g, pgeom = %g", dg, pgeom));
                    success2 = false;
                    success = false;
                }
                prev_dg = dg;
                ++j;
            }
            DebugFun.printBool(success1);
            DebugFun.printBool(success2);
            ++i;
        }
        return success;
    }

    @Test
    public static final boolean test_hyper() {
        System.out.println("##__ 3. Hypergeometric __");
        boolean success = true;
        int m = 10;
        int n = 7;
        int k = 2;
        while (k <= m) {
            double prev_dhyper = 0.0;
            boolean cur_success = true;
            int j = 0;
            while (j <= k + 1) {
                double dhyper;
                double phyper = HyperGeometric.cumulative(j, m, n, k, true, false);
                prev_dhyper = dhyper = prev_dhyper + HyperGeometric.density(j, m, n, k, false);
                if (!DebugFun.isEqual(phyper, dhyper)) {
                    System.err.println(String.format("Error: phyper = %g, cumsum(dhyper) = %g", phyper, dhyper));
                    cur_success = false;
                    success = false;
                }
                ++j;
            }
            DebugFun.printBool(cur_success);
            ++k;
        }
        return success;
    }

    @Test
    public static final boolean test_negbin() {
        boolean b;
        System.out.println("##__ 4. Negative Binomial __");
        boolean success = true;
        int i = 8;
        while (i <= 20) {
            double size = (double)i / 10.0;
            double prev_dnbinom = 0.0;
            boolean cur_success = true;
            int j = 0;
            while (j <= 7) {
                double dnbinom = prev_dnbinom + NegBinomial.density(j, size, 0.5, false);
                double pnbinom = NegBinomial.cumulative(j, size, 0.5, true, false);
                prev_dnbinom = dnbinom;
                if (!DebugFun.isEqual(dnbinom, pnbinom)) {
                    System.err.println(String.format("Error: cumsum(dnbinom) = %g, pnbinom = %g", dnbinom, dnbinom));
                    cur_success = false;
                    success = false;
                }
                ++j;
            }
            DebugFun.printBool(cur_success);
            ++i;
        }
        System.out.println();
        boolean bl = b = !DebugFun.isEqual(NegBinomial.cumulative(1.0, 0.9, 0.5, true, false), 0.777035760338812) || !DebugFun.isEqual(NegBinomial.cumulative(3.0, 0.9, 0.5, true, false), 0.946945347071519);
        if (b) {
            success = false;
        }
        DebugFun.printBool(!b);
        return success;
    }

    @Test
    public static final boolean test_poisson() {
        double dpois;
        System.out.println("##__ 5. Poisson __");
        boolean success = true;
        boolean cur_success = true;
        int i = 0;
        while (i <= 5) {
            dpois = Poisson.density(i, 0.0, false);
            if (!DebugFun.isEqual(dpois, i == 0 ? 1 : 0)) {
                System.err.println(String.format("Error: dpois = %g", dpois));
                cur_success = false;
                success = false;
            }
            ++i;
        }
        DebugFun.printBool(cur_success);
        cur_success = true;
        i = 0;
        while (i <= 5) {
            dpois = Poisson.density(i, 0.0, true);
            if (!DebugFun.isEqual(dpois, i == 0 ? 0.0 : Double.NEGATIVE_INFINITY)) {
                System.err.println(String.format("Error: log(dpois) = %g", dpois));
                cur_success = false;
                success = false;
            }
            ++i;
        }
        DebugFun.printBool(cur_success);
        int n1 = 20;
        int n2 = 16;
        int i2 = 0;
        while (i2 < n1) {
            double lambda = Exponential.random(1.0, random);
            int j = 0;
            while (j < n2) {
                int k = (int)Poisson.random(lambda, random);
                double prev_dpois = 0.0;
                cur_success = true;
                int j2 = 0;
                while (j2 <= k) {
                    double ppois;
                    double dpois2;
                    double comp_pchisq = 1.0 - ChiSquare.cumulative(2.0 * lambda, 2 * j2 + 2, true, false);
                    prev_dpois = dpois2 = prev_dpois + Poisson.density(j2, lambda, false);
                    if (!DebugFun.isEqual(comp_pchisq, dpois2)) {
                        System.err.println(String.format("Error: comp. pchisq = %g, dpois = %g", comp_pchisq, dpois2));
                        cur_success = false;
                        success = false;
                    }
                    if (!DebugFun.isEqual(ppois = Poisson.cumulative(j2, lambda, true, false), dpois2)) {
                        System.err.println(String.format("Error: ppois = %g, dpois = %g", ppois, dpois2));
                        cur_success = false;
                        success = false;
                    }
                    if (!DebugFun.isEqual(ppois = Poisson.cumulative(j2, lambda, false, false), 1.0 - dpois2)) {
                        System.err.println(String.format("Error: upper ppois = %g, dpois = %g", ppois, dpois2));
                        cur_success = false;
                        success = false;
                    }
                    ++j2;
                }
                ++j;
            }
            ++i2;
        }
        return success;
    }

    @Test
    public static final boolean test_signrank() {
        System.out.println("##__ 6. SignRank __");
        boolean success = true;
        int i = 0;
        while (i < 32) {
            int n = (int)Poisson.random(8.0, random);
            SignRank d = new SignRank(n);
            double prev_dsignrank = 0.0;
            int x = -1;
            while (x <= n + 4) {
                double dsignrank;
                double psignrank = d.cumulative(x, true, false);
                prev_dsignrank = dsignrank = prev_dsignrank + d.density(x, false);
                if (!DebugFun.isEqual(psignrank, dsignrank)) {
                    System.err.println(String.format("Error: psignrank = %g, dsignrank = %g", psignrank, dsignrank));
                    success = false;
                }
                ++x;
            }
            ++i;
        }
        return success;
    }

    @Test
    public static final boolean test_wilcox() {
        System.out.println("##__ 7. Wilcoxon (symmetry & cumulative) __");
        boolean success = true;
        boolean is_sym = true;
        int i = 0;
        while (i < 5) {
            int n = (int)Poisson.random(6.0, random);
            int j = 0;
            while (j < 15) {
                int m = (int)Poisson.random(8.0, random);
                Wilcoxon d = new Wilcoxon(n, m);
                Wilcoxon d_sym = new Wilcoxon(m, n);
                int limit = n * m + 1;
                double cum_dwilcox = 0.0;
                int x = -1;
                while (x <= limit) {
                    double pwilcox = d.cumulative(x, true, false);
                    double dwilcox = d.density(x, false);
                    double dwilcox_sym = d_sym.density(x, false);
                    if (!DebugFun.isEqual(pwilcox, cum_dwilcox += dwilcox)) {
                        System.err.println(String.format("Error: pwilcox = %g, dwilcox = %g", pwilcox, cum_dwilcox));
                        success = false;
                    }
                    is_sym &= DebugFun.isEqual(dwilcox, dwilcox_sym);
                    ++x;
                }
                ++j;
            }
            ++i;
        }
        DebugFun.printBool(is_sym);
        return success;
    }

    @Test
    public static final boolean test_gamma() {
        System.out.println("##__ Gamma Density (incl. central chi^2) __");
        boolean success = true;
        int i = 0;
        while (i < 100) {
            double x = MathFunctions.round(Gamma.random(2.0, 1.0, random), 2);
            int j = 0;
            while (j < 30) {
                double sh = MathFunctions.round(LogNormal.random(0.0, 1.0, random), 2);
                double Ga = MathFunctions.gammafn(sh);
                int k = 0;
                while (k < 30) {
                    double d3;
                    double d2;
                    double sig = MathFunctions.round(LogNormal.random(0.0, 1.0, random), 2);
                    double d1 = Gamma.density(x, sh, sig, false);
                    if (!DebugFun.isEqual(d1, d2 = Gamma.density(x / sig, sh, 1.0, false) / sig)) {
                        System.err.println(String.format("Error: scaled dgamma = %g, manually scaled dgamma = %g", d1, d2));
                        System.err.println(String.format("x = %g, sh = %g, sig = %g, Ga(sh) = %g", x, sh, sig, Ga));
                        success = false;
                    }
                    if (!VectorMath.isEqual(d1, d3 = 1.0 / (Ga * Math.pow(sig, sh)) * Math.pow(x, sh - 1.0) * Math.exp(-x / sig), 2.842170943040401E-14)) {
                        System.err.println(String.format("Error: scaled dgamma = %3.18g, manually comp dgamma = %3.18g", d1, d3));
                        System.err.println(String.format("x = %g, sh = %g, sig = %g, Ga(sh) = %3.30g", x, sh, sig, Ga));
                        success = false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double Inf = Double.POSITIVE_INFINITY;
        double xMax = Double.MAX_VALUE;
        DebugFun.printBool(Gamma.cumulative(1.0, Inf, Inf, true, false) == 0.0);
        DebugFun.printBool(Double.isNaN(Gamma.cumulative(Inf, 1.0, Inf, true, false)) && Double.isNaN(Gamma.cumulative(Inf, Inf, Inf, true, false)));
        double p = Gamma.cumulative(Inf, 1.0, xMax, true, false);
        if (!DebugFun.isEqual(p, 1.0)) {
            System.err.println(String.format("Error: pgamma(Inf, 1, xMax) = %g", p));
            success = false;
        }
        if (!DebugFun.isEqual(p = Gamma.cumulative(xMax, 1.0, Inf, true, false), 0.0)) {
            System.err.println(String.format("Error: pgamma(xMax, 1, Inf) = %g", p));
            success = false;
        }
        double[] scLrg = new double[]{2.0, 100.0, 1.0E299, 1.0E300, 1.0E301, 1.0E302, 1.0E307, xMax, Inf};
        double[] ans = new double[]{0.0, 0.0, -4.995239687137007E-4, -1.3308932682040548, -5.364705028732112, -9.910151440191221, -32.929338549143246, -38.70751717460899, Double.NEGATIVE_INFINITY};
        int i2 = 0;
        while (i2 < scLrg.length) {
            p = Gamma.cumulative(1.0E300, 2.0, scLrg[i2], true, true);
            if (!VectorMath.isEqual(p, ans[i2], 2.0E-15)) {
                System.err.println(String.format("Error: pgamma(1e300, 2, %g) = %3.18g. Correct answer = %3.18g", scLrg[i2], p, ans[i2]));
                success = false;
            }
            ++i2;
        }
        p = 7.0E-4;
        double df = 0.9;
        double lim = 1.0E-15;
        double[] d = new double[]{Math.abs(1.0 - ChiSquare.cumulative(ChiSquare.quantile(p, df, true, false), df, true, false) / p), Math.abs(1.0 - ChiSquare.cumulative(ChiSquare.quantile(1.0 - p, df, false, false), df, false, false) / (1.0 - p)), Math.abs(1.0 - ChiSquare.cumulative(ChiSquare.quantile(Math.log(p), df, true, true), df, true, true) / Math.log(p)), Math.abs(1.0 - ChiSquare.cumulative(ChiSquare.quantile(Math.log1p(-p), df, false, true), df, false, true) / Math.log1p(-p))};
        DebugFun.printBool(d[0] < lim, d[1] < lim, d[2] < lim, d[3] < lim);
        return success;
    }

    @Test
    public static final boolean test_noncentralchisq() {
        boolean cur_success;
        int n;
        int n2;
        System.out.println("##-- non central Chi^2 :");
        boolean success = true;
        double[] dArray = new double[]{0.1, 1.0, 10.0};
        int n3 = dArray.length;
        int n4 = 0;
        while (n4 < n3) {
            double df = dArray[n4];
            double[] dArray2 = new double[]{0.0, 1.0, 10.0, 100.0};
            int n5 = dArray2.length;
            n2 = 0;
            while (n2 < n5) {
                double ncp = dArray2[n2];
                double[] dArray3 = new double[]{2000.0, 1000000.0, 1.0E50, Double.POSITIVE_INFINITY};
                n = dArray3.length;
                int n6 = 0;
                while (n6 < n) {
                    double xB = dArray3[n6];
                    double val = NonCentralChiSquare.cumulative(xB, df, ncp, true, false);
                    if (!DebugFun.isEqual(val, 1.0)) {
                        System.err.println(String.format("Error: pchisq(x=%g, df=%g, ncp=%g) = %3.18g. Correct answer = 1", xB, df, ncp, val));
                        success = false;
                    }
                    ++n6;
                }
                ++n2;
            }
            ++n4;
        }
        double cor_val = 49.776624656055475;
        double val = NonCentralChiSquare.quantile(0.025, 31.0, 1.0, false, false);
        if (!VectorMath.isEqual(val, cor_val, 1.0E-11)) {
            System.err.println(String.format("Error: qchisq(x=0.025, df=31, ncp=1) = %3.18g. Correct answer = %3.18g", val, cor_val));
            success = false;
        }
        double[] dArray4 = new double[]{0.1, 0.5, 1.5, 4.7, 10.0, 20.0, 50.0, 100.0};
        n2 = dArray4.length;
        int n7 = 0;
        while (n7 < n2) {
            double df = dArray4[n7];
            System.out.print("df =" + df);
            cur_success = true;
            double dtol = 1.0E-12 * (double)(2.0 < df && df <= 50.0 ? 64 : (df > 50.0 ? 20000 : 501));
            double[] dArray5 = new double[]{1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 0.9, 1.2, df + 3.0, df + 7.0, df + 20.0, df + 30.0, df + 35.0, df + 38.0};
            int n8 = dArray5.length;
            n = 0;
            while (n < n8) {
                double xx = dArray5[n];
                double pval = NonCentralChiSquare.cumulative(xx, df, 1.0, true, false);
                double qval = NonCentralChiSquare.quantile(pval, df, 1.0, true, false);
                if (!VectorMath.isEqual(qval, xx, dtol)) {
                    System.err.println(String.format("Error: xx=%g, df=%g, ncp=1, pchisq = %3.18g, qchisq = %3.18g != xx", xx, df, pval, qval));
                    cur_success = false;
                    success = false;
                }
                ++n;
            }
            DebugFun.printBool(cur_success);
            ++n7;
        }
        cur_success = true;
        boolean cur_success2 = true;
        int i = 10;
        while (i <= 54) {
            double psml = Math.pow(2.0, -i);
            double q0 = NonCentralChiSquare.quantile(psml, 1.2, 10.0, false, false);
            double q1 = NonCentralChiSquare.quantile(1.0 - psml, 1.2, 10.0, true, false);
            double p0 = NonCentralChiSquare.cumulative(q0, 1.2, 10.0, false, false);
            double p1 = NonCentralChiSquare.cumulative(q1, 1.2, 10.0, false, false);
            if (i < 29 & !VectorMath.isEqual(q0, q1, 1.0E-5)) {
                System.err.println(String.format("Error: psml=%g, q0=%3.18g, q1 = %3.18g", psml, q0, q1));
                cur_success = false;
                success = false;
            }
            if (i < 29 & !DebugFun.isEqual(p0, psml)) {
                System.err.println(String.format("Error: psml=%g, p0=%3.18g", psml, q0));
                cur_success2 = false;
                success = false;
            }
            ++i;
        }
        DebugFun.printBool(cur_success);
        DebugFun.printBool(cur_success2);
        return success;
    }

    @Test
    public static final boolean test_beta() {
        System.out.println("##--- Beta (need more):");
        boolean success = true;
        int i = 0;
        while (i < 20) {
            double a = LogNormal.random(5.5, 1.0, random);
            int j = 0;
            while (j < 20) {
                double b = LogNormal.random(6.6, 1.0, random);
                int k = 0;
                while (k <= 10) {
                    double v2log;
                    double v2;
                    double p = (double)k / 10.0;
                    double v1 = Beta.density(p, a, b, false);
                    if (!VectorMath.isEqual(v1, v2 = Math.exp(v2log = Beta.density(p, a, b, true)), 1.0E-11)) {
                        System.err.println(String.format("Error: p=%g, a=%3.18g, b=%3.18g, dbeta(p,a,b) = %3.18g, exp(dbeta(p,a,b,TRUE)) = %3.18g", p, a, b, v1, v2));
                        success = false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return success;
    }

    @Test
    public static final boolean test_normal() {
        double val;
        System.out.println("##--- Normal (& Lognormal) :");
        boolean success = Normal.quantile(0.0, 1.0, 0.0, true, false) == Double.NEGATIVE_INFINITY && Normal.quantile(Double.NEGATIVE_INFINITY, 1.0, 0.0, true, true) == Double.NEGATIVE_INFINITY;
        DebugFun.printBool(success);
        DebugFun.printBool(success &= Normal.quantile(1.0, 1.0, 0.0, true, false) == Double.POSITIVE_INFINITY && Normal.quantile(0.0, 1.0, 0.0, true, true) == Double.POSITIVE_INFINITY);
        DebugFun.printBool(success &= Double.isNaN(Normal.quantile(1.1, 1.0, 0.0, true, false)) && Double.isNaN(Normal.quantile(-0.1, 1.0, 0.0, true, false)));
        double[] xx = new double[]{Double.NEGATIVE_INFINITY, -1.0E100, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 1.0E200, Double.POSITIVE_INFINITY};
        System.out.print("d.s0");
        int i = 0;
        while (i < xx.length) {
            val = Normal.density(xx[i], 3.0, 0.0, false);
            System.out.print(" " + val);
            success &= val == (i == 4 ? Double.POSITIVE_INFINITY : 0.0);
            ++i;
        }
        System.out.println();
        System.out.print("p.s0");
        i = 0;
        while (i < xx.length) {
            val = Normal.cumulative(xx[i], 3.0, 0.0, true, false);
            System.out.print(" " + val);
            success &= val == (double)(i >= 4 ? 1 : 0);
            ++i;
        }
        System.out.println();
        System.out.print("d.sI");
        i = 0;
        while (i < xx.length) {
            val = Normal.density(xx[i], 3.0, Double.POSITIVE_INFINITY, false);
            System.out.print(" " + val);
            success &= val == 0.0;
            ++i;
        }
        System.out.println();
        System.out.print("p.sI");
        i = 0;
        while (i < xx.length) {
            val = Normal.cumulative(xx[i], 3.0, Double.POSITIVE_INFINITY, true, false);
            System.out.print(" " + val);
            success &= val == (i == 0 ? 0.0 : (i == 9 ? 1.0 : 0.5));
            ++i;
        }
        System.out.println();
        double q1 = Normal.quantile(0.25, 0.0, 1.0, true, false);
        double q2 = Normal.quantile(0.001, 0.0, 1.0, true, false);
        double q3 = Normal.quantile(1.0E-20, 0.0, 1.0, true, false);
        boolean cur_success = VectorMath.isEqual(q1, -0.6744897501960817, 1.0E-15) && VectorMath.isEqual(q2, -3.090232306167813, 1.0E-15) && VectorMath.isEqual(q3, -9.262340089798405, 1.0E-15);
        success &= cur_success;
        DebugFun.printBool(cur_success);
        q1 = Normal.quantile(-100000.0, 0.0, 1.0, true, true);
        cur_success = DebugFun.isEqual(q1, -447.197494465048);
        success &= cur_success;
        DebugFun.printBool(cur_success);
        cur_success = true;
        int i2 = 0;
        while (i2 < 1000) {
            double pz_comp;
            double z = Normal.random_standard(random);
            double pz = Normal.cumulative(z, 0.0, 1.0, true, false);
            if (!VectorMath.isEqual(pz, pz_comp = 1.0 - Normal.cumulative(-z, 0.0, 1.0, true, false), 1.0E-15)) {
                System.err.println(String.format("Error: z=%3.18g, pnorm(z) = %3.18g, 1-pnorm(-z) = %3.18g", z, pz, pz_comp));
                cur_success = false;
                success = false;
            }
            ++i2;
        }
        DebugFun.printBool(cur_success);
        boolean cur_success2 = true;
        boolean cur_success3 = true;
        boolean cur_success4 = true;
        boolean cur_success5 = true;
        boolean cur_success6 = true;
        StringBuilder buf = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        int i3 = 0;
        while (i3 < 1003) {
            double qnorm_pz;
            double plnorm_exp_z;
            double log_pz;
            double pz_comp2;
            double pz_comp;
            double z = i3 == 0 ? Double.NEGATIVE_INFINITY : (i3 == 1 ? Double.POSITIVE_INFINITY : (i3 == 2 ? Double.NaN : T.random(2.0, random)));
            int df = 1;
            while (df <= 10) {
                double pt_comp;
                double pt = T.cumulative(z, df, true, false);
                if (!VectorMath.isEqual(pt, pt_comp = 1.0 - T.cumulative(-z, df, true, false), 1.0E-15)) {
                    System.err.println(String.format("Error: z=%3.18g, df=%d, pt(z,df) = %3.18g, 1-pt(-z,df) = %3.18g", z, df, pt, pt_comp));
                    cur_success = false;
                    success = false;
                }
                ++df;
            }
            double pz = Normal.cumulative(z, 0.0, 1.0, true, false);
            if (!DebugFun.isEqual(pz, pz_comp = 1.0 - Normal.cumulative(z, 0.0, 1.0, false, false))) {
                System.err.println(String.format("Error: z=%3.18g, pnorm(z) = %3.18g, 1-pnorm(z, lower=FALSE) = %3.18g", z, pz, pz_comp));
                cur_success2 = false;
                success = false;
            }
            if (!DebugFun.isEqual(pz, pz_comp2 = Normal.cumulative(-z, 0.0, 1.0, false, false))) {
                System.err.println(String.format("Error: z=%3.18g, pnorm(z) = %3.18g, pnorm(-z, lower=FALSE) = %3.18g", z, pz, pz_comp2));
                cur_success3 = false;
                success = false;
            }
            if ((MathFunctions.isInfinite(z) || z > -37.5) && !VectorMath.isEqual(log_pz = Math.log(pz), pz_comp = Normal.cumulative(z, 0.0, 1.0, true, true), 2.842170943040401E-14)) {
                System.err.println(String.format("Error: z=%3.18g, log(pnorm(z)) = %3.18g, pnorm(z, log=TRUE) = %3.18g", z, log_pz, pz_comp));
                cur_success4 = false;
                success = false;
            }
            if (!DebugFun.isEqual(pz, plnorm_exp_z = LogNormal.cumulative(Math.exp(z), 0.0, 1.0, true, false))) {
                buf.append(String.valueOf(String.format("Error: z=%3.18g, pnorm(z) = %3.18g, plnorm(exp(z)) = %3.18g", z, pz, plnorm_exp_z)) + "\n");
                cur_success5 = false;
                success = false;
            }
            if (1.0E-5 < pz && pz < 0.99999 && !VectorMath.isEqual(z, qnorm_pz = Normal.quantile(pz, 0.0, 1.0, true, false), 1.0E-12)) {
                buf2.append(String.valueOf(String.format("Error: z=%3.18g, qnorm(pnorm(z)) = %3.18g", z, qnorm_pz)) + "\n");
                cur_success6 = false;
                success = false;
            }
            ++i3;
        }
        DebugFun.printBool(cur_success);
        DebugFun.printBool(cur_success2);
        DebugFun.printBool(cur_success3);
        DebugFun.printBool(cur_success4);
        int y = -70;
        while (y <= 0) {
            double log_pnorm_y = Math.log(Normal.cumulative(y, 0.0, 1.0, true, false));
            double pnorm_y_log = Normal.cumulative(y, 0.0, 1.0, true, true);
            System.out.println(String.format("y=%d, log(pnorm(y)) = %3.18g, pnorm(y, log=TRUE) = %3.18g", y, log_pnorm_y, pnorm_y_log));
            y += 10;
        }
        System.out.println();
        int[] nArray = Utilities.c(new int[][]{Utilities.colon(1, 15), Utilities.seq(20, 40, 5)});
        int n = nArray.length;
        int log_pnorm_y = 0;
        while (log_pnorm_y < n) {
            y = nArray[log_pnorm_y];
            double log_pnorm_y2 = Math.log(Normal.cumulative(y, 0.0, 1.0, true, false));
            double pnorm_y_log = Normal.cumulative(y, 0.0, 1.0, true, true);
            double log_pnorm_min_y = Math.log(Normal.cumulative(-y, 0.0, 1.0, true, false));
            double pnorm_min_y_log = Normal.cumulative(-y, 0.0, 1.0, true, true);
            System.out.println(String.format("y=%d, log(pnorm(y)) = %3.18g, pnorm(y, log=TRUE) = %3.18g, log(pnorm(-y)) = %3.18g, pnorm(-y, log=TRUE) = %3.18g", y, log_pnorm_y2, pnorm_y_log, log_pnorm_min_y, pnorm_min_y_log));
            ++log_pnorm_y;
        }
        double[] yy = Utilities.c(new double[][]{Utilities.colon(1.0, 50.0), VectorMath.vpow(10.0, Utilities.c(new int[][]{Utilities.colon(3, 10), Utilities.c(20, 50, 150, 250)}))});
        double[] dArray = yy = Utilities.c(new double[][]{VectorMath.vmin(yy), {0.0}, yy});
        int n2 = yy.length;
        int n3 = 0;
        while (n3 < n2) {
            double y2 = dArray[n3];
            double py_minus = Normal.cumulative(-y2, 0.0, 1.0, true, false);
            double py_plus = Normal.cumulative(y2, 0.0, 1.0, false, false);
            if (py_plus != py_minus) {
                System.err.println(String.format("y=%d, pnorm(-y) = %3.18g, pnorm(y, lower=FALSE)", y2, py_minus, py_plus));
                success = false;
            }
            py_minus = Normal.cumulative(-y2, 0.0, 1.0, true, true);
            py_plus = Normal.cumulative(y2, 0.0, 1.0, false, true);
            if (py_plus != py_minus) {
                System.err.println(String.format("y=%d, pnorm(-y, log=TRUE) = %3.18g, pnorm(y, lower=FALSE, log=TRUE)", y2, py_minus, py_plus));
                success = false;
            }
            ++n3;
        }
        DebugFun.printBool(cur_success5);
        if (!cur_success5) {
            System.err.println(buf.toString());
        }
        DebugFun.printBool(cur_success6);
        if (!cur_success6) {
            System.err.println(buf2.toString());
        }
        return success;
    }

    @Test
    public static final void test_random() {
        Beta beta = new Beta(0.8, 2.0);
        beta.setRandomEngine(random);
        Binomial binom = new Binomial(25.0, 0.19634954084936207);
        binom.setRandomEngine(random);
        Cauchy cauchy = new Cauchy(12.0, 2.0);
        cauchy.setRandomEngine(random);
        ChiSquare chisq = new ChiSquare(3.0);
        chisq.setRandomEngine(random);
        Exponential exp = new Exponential(0.5);
        exp.setRandomEngine(random);
        F f = new F(12.0, 6.0);
        f.setRandomEngine(random);
        Gamma gamma = new Gamma(2.0, 5.0);
        gamma.setRandomEngine(random);
        Geometric geom = new Geometric(0.19634954084936207);
        geom.setRandomEngine(random);
        HyperGeometric hyper = new HyperGeometric(40.0, 30.0, 20.0);
        hyper.setRandomEngine(random);
        LogNormal lnorm = new LogNormal(-1.0, 3.0);
        lnorm.setRandomEngine(random);
        Logistic logis = new Logistic(12.0, 2.0);
        logis.setRandomEngine(random);
        NegBinomial nbinom = new NegBinomial(7.0, 0.01);
        nbinom.setRandomEngine(random);
        Normal norm = new Normal(-1.0, 3.0);
        norm.setRandomEngine(random);
        Poisson pois = new Poisson(12.0);
        pois.setRandomEngine(random);
        SignRank signrank = new SignRank(47);
        signrank.setRandomEngine(random);
        T t = new T(11.0);
        t.setRandomEngine(random);
        Uniform unif = new Uniform(0.2, 2.0);
        unif.setRandomEngine(random);
        Weibull weibull = new Weibull(3.0, 2.0);
        weibull.setRandomEngine(random);
        Wilcoxon wilcox = new Wilcoxon(13, 17);
        wilcox.setRandomEngine(random);
        T t2 = new T(1.01);
        t2.setRandomEngine(random);
        int n = 20;
        double[] Rbeta = beta.random(n);
        double[] Rbinom = binom.random(n);
        double[] Rcauchy = cauchy.random(n);
        double[] Rchisq = chisq.random(n);
        double[] Rexp = exp.random(n);
        double[] Rf = f.random(n);
        double[] Rgamma = gamma.random(n);
        double[] Rgeom = geom.random(n);
        double[] Rhyper = hyper.random(n);
        double[] Rlnorm = lnorm.random(n);
        double[] Rlogis = logis.random(n);
        double[] Rnbinom = nbinom.random(n);
        double[] Rnorm = norm.random(n);
        double[] Rpois = pois.random(n);
        double[] Rsignrank = signrank.random(n);
        double[] Rt = t.random(n);
        double[] Runif = unif.random(n);
        double[] Rweibull = weibull.random(n);
        double[] Rwilcox = wilcox.random(n);
        double[] Rt2 = t2.random(n);
        System.out.println();
        System.out.println("Random beta(0.8, 2)");
        Utilities.print(Rbeta);
        System.out.println("Random binomial(25, pi/16.0)");
        Utilities.print(Rbinom);
        System.out.println("Random cauchy(12, 2)");
        Utilities.print(Rcauchy);
        System.out.println("Random chisq(3)");
        Utilities.print(Rchisq);
        System.out.println("Random exp(rate = 2.0)");
        Utilities.print(Rexp);
        System.out.println("Random f(12, 6)");
        Utilities.print(Rf);
        System.out.println("Random gamma(2, 5)");
        Utilities.print(Rgamma);
        System.out.println("Random geom(pi/16.0)");
        Utilities.print(Rgeom);
        System.out.println("Random hyper(40, 30, 20)");
        Utilities.print(Rhyper);
        System.out.println("Random lnorm(-1, 3)");
        Utilities.print(Rlnorm);
        System.out.println("Random logis(12, 2)");
        Utilities.print(Rlogis);
        System.out.println("Random nbinom(7, 0.01)");
        Utilities.print(Rnbinom);
        System.out.println("Random norm(-1, 3)");
        Utilities.print(Rnorm);
        System.out.println("Random pois(12)");
        Utilities.print(Rpois);
        System.out.println("Random signrank(47)");
        Utilities.print(Rsignrank);
        System.out.println("Random t(11)");
        Utilities.print(Rt);
        System.out.println("Random t(1.01)");
        Utilities.print(Rt2);
        System.out.println("Random unif(0.2, 2)");
        Utilities.print(Runif);
        System.out.println("Random weibull(3, 2)");
        Utilities.print(Rweibull);
        System.out.println("Random wilcox(13, 17)");
        Utilities.print(Rwilcox);
        boolean lower_tail = true;
        boolean log_p = false;
        double[] Pbeta = beta.cumulative(Rbeta, lower_tail, log_p);
        double[] Pbinom = binom.cumulative(Rbinom, lower_tail, log_p);
        double[] Pcauchy = cauchy.cumulative(Rcauchy, lower_tail, log_p);
        double[] Pchisq = chisq.cumulative(Rchisq, lower_tail, log_p);
        double[] Pexp = exp.cumulative(Rexp, lower_tail, log_p);
        double[] Pf = f.cumulative(Rf, lower_tail, log_p);
        double[] Pgamma = gamma.cumulative(Rgamma, lower_tail, log_p);
        double[] Pgeom = geom.cumulative(Rgeom, lower_tail, log_p);
        double[] Phyper = hyper.cumulative(Rhyper, lower_tail, log_p);
        double[] Plnorm = lnorm.cumulative(Rlnorm, lower_tail, log_p);
        double[] Plogis = logis.cumulative(Rlogis, lower_tail, log_p);
        double[] Pnbinom = nbinom.cumulative(Rnbinom, lower_tail, log_p);
        double[] Pnorm = norm.cumulative(Rnorm, lower_tail, log_p);
        double[] Ppois = pois.cumulative(Rpois, lower_tail, log_p);
        double[] Psignrank = signrank.cumulative(Rsignrank, lower_tail, log_p);
        double[] Pt = t.cumulative(Rt, lower_tail, log_p);
        double[] Pt2 = t2.cumulative(Rt2, lower_tail, log_p);
        double[] Punif = unif.cumulative(Runif, lower_tail, log_p);
        double[] Pweibull = weibull.cumulative(Rweibull, lower_tail, log_p);
        double[] Pwilcox = wilcox.cumulative(Rwilcox, lower_tail, log_p);
        System.out.println();
        System.out.println("Cumulative beta(0.8, 2)");
        Utilities.print(Pbeta);
        System.out.println("Cumulative binomial(25, pi/16.0)");
        Utilities.print(Pbinom);
        System.out.println("Cumulative cauchy(12, 2)");
        Utilities.print(Pcauchy);
        System.out.println("Cumulative chisq(3)");
        Utilities.print(Pchisq);
        System.out.println("Cumulative exp(rate = 2.0)");
        Utilities.print(Pexp);
        System.out.println("Cumulative f(12, 6)");
        Utilities.print(Pf);
        System.out.println("Cumulative gamma(2, 5)");
        Utilities.print(Pgamma);
        System.out.println("Cumulative geom(pi/16.0)");
        Utilities.print(Pgeom);
        System.out.println("Cumulative hyper(40, 30, 20)");
        Utilities.print(Phyper);
        System.out.println("Cumulative lnorm(-1, 3)");
        Utilities.print(Plnorm);
        System.out.println("Cumulative logis(12, 2)");
        Utilities.print(Plogis);
        System.out.println("Cumulative nbinom(7, 0.01)");
        Utilities.print(Pnbinom);
        System.out.println("Cumulative norm(-1, 3)");
        Utilities.print(Pnorm);
        System.out.println("Cumulative pois(12)");
        Utilities.print(Ppois);
        System.out.println("Cumulative signrank(47)");
        Utilities.print(Psignrank);
        System.out.println("Cumulative t(11)");
        Utilities.print(Pt);
        System.out.println("Cumulative t(1.01)");
        Utilities.print(Pt2);
        System.out.println("Cumulative unif(0.2, 2)");
        Utilities.print(Punif);
        System.out.println("Cumulative weibull(3, 2)");
        Utilities.print(Pweibull);
        System.out.println("Cumulative wilcox(13, 17)");
        Utilities.print(Pwilcox);
        double[] Dbeta = beta.density(Rbeta, false);
        double[] Dbinom = binom.density(Rbinom, false);
        double[] Dcauchy = cauchy.density(Rcauchy, false);
        double[] Dchisq = chisq.density(Rchisq, false);
        double[] Dexp = exp.density(Rexp, false);
        double[] Df = f.density(Rf, false);
        double[] Dgamma = gamma.density(Rgamma, false);
        double[] Dgeom = geom.density(Rgeom, false);
        double[] Dhyper = hyper.density(Rhyper, false);
        double[] Dlnorm = lnorm.density(Rlnorm, false);
        double[] Dlogis = logis.density(Rlogis, false);
        double[] Dnbinom = nbinom.density(Rnbinom, false);
        double[] Dnorm = norm.density(Rnorm, false);
        double[] Dpois = pois.density(Rpois, false);
        double[] Dsignrank = signrank.density(Rsignrank, false);
        double[] Dt = t.density(Rt, false);
        double[] Dt2 = t2.density(Rt2, false);
        double[] Dunif = unif.density(Runif, false);
        double[] Dweibull = weibull.density(Rweibull, false);
        double[] Dwilcox = wilcox.density(Rwilcox, false);
        System.out.println();
        System.out.println("Density beta(0.8, 2)");
        Utilities.print(Dbeta);
        System.out.println("Density binomial(25, pi/16.0)");
        Utilities.print(Dbinom);
        System.out.println("Density cauchy(12, 2)");
        Utilities.print(Dcauchy);
        System.out.println("Density chisq(3)");
        Utilities.print(Dchisq);
        System.out.println("Density exp(rate = 2.0)");
        Utilities.print(Dexp);
        System.out.println("Density f(12, 6)");
        Utilities.print(Df);
        System.out.println("Density gamma(2, 5)");
        Utilities.print(Dgamma);
        System.out.println("Density geom(pi/16.0)");
        Utilities.print(Dgeom);
        System.out.println("Density hyper(40, 30, 20)");
        Utilities.print(Dhyper);
        System.out.println("Density lnorm(-1, 3)");
        Utilities.print(Dlnorm);
        System.out.println("Density logis(12, 2)");
        Utilities.print(Dlogis);
        System.out.println("Density nbinom(7, 0.01)");
        Utilities.print(Dnbinom);
        System.out.println("Density norm(-1, 3)");
        Utilities.print(Dnorm);
        System.out.println("Density pois(12)");
        Utilities.print(Dpois);
        System.out.println("Density signrank(47)");
        Utilities.print(Dsignrank);
        System.out.println("Density t(11)");
        Utilities.print(Dt);
        System.out.println("Density t(1.01)");
        Utilities.print(Dt2);
        System.out.println("Density unif(0.2, 2)");
        Utilities.print(Dunif);
        System.out.println("Density weibull(3, 2)");
        Utilities.print(Dweibull);
        System.out.println("Density wilcox(13, 17)");
        Utilities.print(Dwilcox);
        double[] Qbeta = beta.quantile(Pbeta, lower_tail, log_p);
        double[] Qbinom = binom.quantile(Pbinom, lower_tail, log_p);
        double[] Qcauchy = cauchy.quantile(Pcauchy, lower_tail, log_p);
        double[] Qchisq = chisq.quantile(Pchisq, lower_tail, log_p);
        double[] Qexp = exp.quantile(Pexp, lower_tail, log_p);
        double[] Qf = f.quantile(Pf, lower_tail, log_p);
        double[] Qgamma = gamma.quantile(Pgamma, lower_tail, log_p);
        double[] Qgeom = geom.quantile(Pgeom, lower_tail, log_p);
        double[] Qhyper = hyper.quantile(Phyper, lower_tail, log_p);
        double[] Qlnorm = lnorm.quantile(Plnorm, lower_tail, log_p);
        double[] Qlogis = logis.quantile(Plogis, lower_tail, log_p);
        double[] Qnbinom = nbinom.quantile(Pnbinom, lower_tail, log_p);
        double[] Qnorm = norm.quantile(Pnorm, lower_tail, log_p);
        double[] Qpois = pois.quantile(Ppois, lower_tail, log_p);
        double[] Qsignrank = signrank.quantile(Psignrank, lower_tail, log_p);
        double[] Qt = t.quantile(Pt, lower_tail, log_p);
        double[] Qt2 = t2.quantile(Pt2, lower_tail, log_p);
        double[] Qunif = unif.quantile(Punif, lower_tail, log_p);
        double[] Qweibull = weibull.quantile(Pweibull, lower_tail, log_p);
        double[] Qwilcox = wilcox.quantile(Pwilcox, lower_tail, log_p);
        System.out.println();
        System.out.println("Lower tail equality beta(0.8, 2)");
        DebugFun.printAllEqual(Rbeta, Qbeta);
        System.out.println("Lower tail equality binomial(25, pi/16.0)");
        DebugFun.printAllEqual(Rbinom, Qbinom);
        System.out.println("Lower tail equality cauchy(12, 2)");
        DebugFun.printAllEqual(Rcauchy, Qcauchy, 2.842170943040401E-14);
        System.out.println("Lower tail equality chisq(3)");
        DebugFun.printAllEqual(Rchisq, Qchisq, 2.842170943040401E-14);
        System.out.println("Lower tail equality exp(rate = 2.0)");
        DebugFun.printAllEqual(Rexp, Qexp);
        System.out.println("Lower tail equality f(12, 6)");
        DebugFun.printAllEqual(Rf, Qf);
        System.out.println("Lower tail equality gamma(2, 5)");
        DebugFun.printAllEqual(Rgamma, Qgamma, 2.842170943040401E-14);
        System.out.println("Lower tail equality geom(pi/16.0)");
        DebugFun.printAllEqual(Rgeom, Qgeom);
        System.out.println("Lower tail equality hyper(40, 30, 20)");
        DebugFun.printAllEqual(Rhyper, Qhyper);
        System.out.println("Lower tail equality lnorm(-1, 3)");
        DebugFun.printAllEqual(Rlnorm, Qlnorm);
        System.out.println("Lower tail equality logis(12, 2)");
        DebugFun.printAllEqual(Rlogis, Qlogis);
        System.out.println("Lower tail equality nbinom(7, 0.01)");
        DebugFun.printAllEqual(Rnbinom, Qnbinom);
        System.out.println("Lower tail equality norm(-1, 3)");
        DebugFun.printAllEqual(Rnorm, Qnorm);
        System.out.println("Lower tail equality pois(12)");
        DebugFun.printAllEqual(Rpois, Qpois);
        System.out.println("Lower tail equality signrank(47)");
        DebugFun.printAllEqual(Rsignrank, Qsignrank);
        System.out.println("Lower tail equality t(11)");
        DebugFun.printAllEqual(Rt, Qt);
        System.out.println("Lower tail equality t(1.01)");
        DebugFun.printAllEqual(Rt2, Qt2);
        System.out.println("Lower tail equality unif(0.2, 2)");
        DebugFun.printAllEqual(Runif, Qunif);
        System.out.println("Lower tail equality weibull(3, 2)");
        DebugFun.printAllEqual(Rweibull, Qweibull);
        System.out.println("Lower tail equality wilcox(13, 17)");
        DebugFun.printAllEqual(Rwilcox, Qwilcox);
        lower_tail = false;
        log_p = false;
        Qbeta = beta.quantile(VectorMath.vcomp(Pbeta), lower_tail, log_p);
        Qbinom = binom.quantile(VectorMath.vcomp(Pbinom), lower_tail, log_p);
        Qcauchy = cauchy.quantile(VectorMath.vcomp(Pcauchy), lower_tail, log_p);
        Qchisq = chisq.quantile(VectorMath.vcomp(Pchisq), lower_tail, log_p);
        Qexp = exp.quantile(VectorMath.vcomp(Pexp), lower_tail, log_p);
        Qf = f.quantile(VectorMath.vcomp(Pf), lower_tail, log_p);
        Qgamma = gamma.quantile(VectorMath.vcomp(Pgamma), lower_tail, log_p);
        Qgeom = geom.quantile(VectorMath.vcomp(Pgeom), lower_tail, log_p);
        Qhyper = hyper.quantile(VectorMath.vcomp(Phyper), lower_tail, log_p);
        Qlnorm = lnorm.quantile(VectorMath.vcomp(Plnorm), lower_tail, log_p);
        Qlogis = logis.quantile(VectorMath.vcomp(Plogis), lower_tail, log_p);
        Qnbinom = nbinom.quantile(VectorMath.vcomp(Pnbinom), lower_tail, log_p);
        Qnorm = norm.quantile(VectorMath.vcomp(Pnorm), lower_tail, log_p);
        Qpois = pois.quantile(VectorMath.vcomp(Ppois), lower_tail, log_p);
        Qsignrank = signrank.quantile(VectorMath.vcomp(Psignrank), lower_tail, log_p);
        Qt = t.quantile(VectorMath.vcomp(Pt), lower_tail, log_p);
        Qt2 = t2.quantile(VectorMath.vcomp(Pt2), lower_tail, log_p);
        Qunif = unif.quantile(VectorMath.vcomp(Punif), lower_tail, log_p);
        Qweibull = weibull.quantile(VectorMath.vcomp(Pweibull), lower_tail, log_p);
        Qwilcox = wilcox.quantile(VectorMath.vcomp(Pwilcox), lower_tail, log_p);
        System.out.println();
        System.out.println("Upper tail equality beta(0.8, 2)");
        DebugFun.printAllEqual(Rbeta, Qbeta);
        System.out.println("Upper tail equality binomial(25, pi/16.0)");
        DebugFun.printAllEqual(Rbinom, Qbinom);
        System.out.println("Upper tail equality cauchy(12, 2)");
        DebugFun.printAllEqual(Rcauchy, Qcauchy, 1.4210854715202004E-12);
        System.out.println("Upper tail equality chisq(3)");
        DebugFun.printAllEqual(Rchisq, Qchisq, 2.842170943040401E-14);
        System.out.println("Upper tail equality exp(rate = 2.0)");
        DebugFun.printAllEqual(Rexp, Qexp);
        System.out.println("Upper tail equality f(12, 6)");
        DebugFun.printAllEqual(Rf, Qf);
        System.out.println("Upper tail equality gamma(2, 5)");
        DebugFun.printAllEqual(Rgamma, Qgamma, 5.684341886080802E-14);
        System.out.println("Upper tail equality geom(pi/16.0)");
        DebugFun.printAllEqual(Rgeom, Qgeom);
        System.out.println("Upper tail equality hyper(40, 30, 20)");
        DebugFun.printAllEqual(Rhyper, Qhyper);
        System.out.println("Upper tail equality lnorm(-1, 3)");
        DebugFun.printAllEqual(Rlnorm, Qlnorm);
        System.out.println("Upper tail equality logis(12, 2)");
        DebugFun.printAllEqual(Rlogis, Qlogis);
        System.out.println("Upper tail equality nbinom(7, 0.01)");
        DebugFun.printAllEqual(Rnbinom, Qnbinom);
        System.out.println("Upper tail equality norm(-1, 3)");
        DebugFun.printAllEqual(Rnorm, Qnorm);
        System.out.println("Upper tail equality pois(12)");
        DebugFun.printAllEqual(Rpois, Qpois);
        System.out.println("Upper tail equality signrank(47)");
        DebugFun.printAllEqual(Rsignrank, Qsignrank);
        System.out.println("Upper tail equality t(11)");
        DebugFun.printAllEqual(Rt, Qt);
        System.out.println("Upper tail equality t(1.01)");
        DebugFun.printAllEqual(Rt2, Qt2);
        System.out.println("Upper tail equality unif(0.2, 2)");
        DebugFun.printAllEqual(Runif, Qunif);
        System.out.println("Upper tail equality weibull(3, 2)");
        DebugFun.printAllEqual(Rweibull, Qweibull);
        System.out.println("Upper tail equality wilcox(13, 17)");
        DebugFun.printAllEqual(Rwilcox, Qwilcox);
        lower_tail = true;
        log_p = true;
        Qbeta = beta.quantile(VectorMath.vlog(Pbeta), lower_tail, log_p);
        Qbinom = binom.quantile(VectorMath.vlog(Pbinom), lower_tail, log_p);
        Qcauchy = cauchy.quantile(VectorMath.vlog(Pcauchy), lower_tail, log_p);
        Qchisq = chisq.quantile(VectorMath.vlog(Pchisq), lower_tail, log_p);
        Qexp = exp.quantile(VectorMath.vlog(Pexp), lower_tail, log_p);
        Qf = f.quantile(VectorMath.vlog(Pf), lower_tail, log_p);
        Qgamma = gamma.quantile(VectorMath.vlog(Pgamma), lower_tail, log_p);
        Qgeom = geom.quantile(VectorMath.vlog(Pgeom), lower_tail, log_p);
        Qhyper = hyper.quantile(VectorMath.vlog(Phyper), lower_tail, log_p);
        Qlnorm = lnorm.quantile(VectorMath.vlog(Plnorm), lower_tail, log_p);
        Qlogis = logis.quantile(VectorMath.vlog(Plogis), lower_tail, log_p);
        Qnbinom = nbinom.quantile(VectorMath.vlog(Pnbinom), lower_tail, log_p);
        Qnorm = norm.quantile(VectorMath.vlog(Pnorm), lower_tail, log_p);
        Qpois = pois.quantile(VectorMath.vlog(Ppois), lower_tail, log_p);
        Qsignrank = signrank.quantile(VectorMath.vlog(Psignrank), lower_tail, log_p);
        Qt = t.quantile(VectorMath.vlog(Pt), lower_tail, log_p);
        Qt2 = t2.quantile(VectorMath.vlog(Pt2), lower_tail, log_p);
        Qunif = unif.quantile(VectorMath.vlog(Punif), lower_tail, log_p);
        Qweibull = weibull.quantile(VectorMath.vlog(Pweibull), lower_tail, log_p);
        Qwilcox = wilcox.quantile(VectorMath.vlog(Pwilcox), lower_tail, log_p);
        System.out.println();
        System.out.println("Lower tail, log equality beta(0.8, 2)");
        DebugFun.printAllEqual(Rbeta, Qbeta);
        System.out.println("Lower tail, log equality binomial(25, pi/16.0)");
        DebugFun.printAllEqual(Rbinom, Qbinom);
        System.out.println("Lower tail, log equality cauchy(12, 2)");
        DebugFun.printAllEqual(Rcauchy, Qcauchy, 7.105427357601002E-14);
        System.out.println("Lower tail, log equality chisq(3)");
        DebugFun.printAllEqual(Rchisq, Qchisq, 2.842170943040401E-14);
        System.out.println("Lower tail, log equality exp(rate = 2.0)");
        DebugFun.printAllEqual(Rexp, Qexp);
        System.out.println("Lower tail, log equality f(12, 6)");
        DebugFun.printAllEqual(Rf, Qf);
        System.out.println("Lower tail, log equality gamma(2, 5)");
        DebugFun.printAllEqual(Rgamma, Qgamma, 2.842170943040401E-14);
        System.out.println("Lower tail, log equality geom(pi/16.0)");
        DebugFun.printAllEqual(Rgeom, Qgeom);
        System.out.println("Lower tail, log equality hyper(40, 30, 20)");
        DebugFun.printAllEqual(Rhyper, Qhyper);
        System.out.println("Lower tail, log equality lnorm(-1, 3)");
        DebugFun.printAllEqual(Rlnorm, Qlnorm);
        System.out.println("Lower tail, log equality logis(12, 2)");
        DebugFun.printAllEqual(Rlogis, Qlogis);
        System.out.println("Lower tail, log equality nbinom(7, 0.01)");
        DebugFun.printAllEqual(Rnbinom, Qnbinom);
        System.out.println("Lower tail, log equality norm(-1, 3)");
        DebugFun.printAllEqual(Rnorm, Qnorm);
        System.out.println("Lower tail, log equality pois(12)");
        DebugFun.printAllEqual(Rpois, Qpois);
        System.out.println("Lower tail, log equality signrank(47)");
        DebugFun.printAllEqual(Rsignrank, Qsignrank);
        System.out.println("Lower tail, log equality t(11)");
        DebugFun.printAllEqual(Rt, Qt);
        System.out.println("Lower tail, log equality t(1.01)");
        DebugFun.printAllEqual(Rt2, Qt2);
        System.out.println("Lower tail, log equality unif(0.2, 2)");
        DebugFun.printAllEqual(Runif, Qunif);
        System.out.println("Lower tail, log equality weibull(3, 2)");
        DebugFun.printAllEqual(Rweibull, Qweibull);
        System.out.println("Lower tail, log equality wilcox(13, 17)");
        DebugFun.printAllEqual(Rwilcox, Qwilcox);
        lower_tail = false;
        log_p = true;
        Qbeta = beta.quantile(VectorMath.vlog1pComps(Pbeta), lower_tail, log_p);
        Qbinom = binom.quantile(VectorMath.vlog1pComps(Pbinom), lower_tail, log_p);
        Qcauchy = cauchy.quantile(VectorMath.vlog1pComps(Pcauchy), lower_tail, log_p);
        Qchisq = chisq.quantile(VectorMath.vlog1pComps(Pchisq), lower_tail, log_p);
        Qexp = exp.quantile(VectorMath.vlog1pComps(Pexp), lower_tail, log_p);
        Qf = f.quantile(VectorMath.vlog1pComps(Pf), lower_tail, log_p);
        Qgamma = gamma.quantile(VectorMath.vlog1pComps(Pgamma), lower_tail, log_p);
        Qgeom = geom.quantile(VectorMath.vlog1pComps(Pgeom), lower_tail, log_p);
        Qhyper = hyper.quantile(VectorMath.vlog1pComps(Phyper), lower_tail, log_p);
        Qlnorm = lnorm.quantile(VectorMath.vlog1pComps(Plnorm), lower_tail, log_p);
        Qlogis = logis.quantile(VectorMath.vlog1pComps(Plogis), lower_tail, log_p);
        Qnbinom = nbinom.quantile(VectorMath.vlog1pComps(Pnbinom), lower_tail, log_p);
        Qnorm = norm.quantile(VectorMath.vlog1pComps(Pnorm), lower_tail, log_p);
        Qpois = pois.quantile(VectorMath.vlog1pComps(Ppois), lower_tail, log_p);
        Qsignrank = signrank.quantile(VectorMath.vlog1pComps(Psignrank), lower_tail, log_p);
        Qt = t.quantile(VectorMath.vlog1pComps(Pt), lower_tail, log_p);
        Qt2 = t2.quantile(VectorMath.vlog1pComps(Pt2), lower_tail, log_p);
        Qunif = unif.quantile(VectorMath.vlog1pComps(Punif), lower_tail, log_p);
        Qweibull = weibull.quantile(VectorMath.vlog1pComps(Pweibull), lower_tail, log_p);
        Qwilcox = wilcox.quantile(VectorMath.vlog1pComps(Pwilcox), lower_tail, log_p);
        System.out.println();
        System.out.println("Upper tail, log equality beta(0.8, 2)");
        DebugFun.printAllEqual(Rbeta, Qbeta);
        System.out.println("Upper tail, log equality binomial(25, pi/16.0)");
        DebugFun.printAllEqual(Rbinom, Qbinom);
        System.out.println("Upper tail, log equality cauchy(12, 2)");
        DebugFun.printAllEqual(Rcauchy, Qcauchy);
        System.out.println("Upper tail, log equality chisq(3)");
        DebugFun.printAllEqual(Rchisq, Qchisq, 2.842170943040401E-14);
        System.out.println("Upper tail, log equality exp(rate = 2.0)");
        DebugFun.printAllEqual(Rexp, Qexp);
        System.out.println("Upper tail, log equality f(12, 6)");
        DebugFun.printAllEqual(Rf, Qf);
        System.out.println("Upper tail, log equality gamma(2, 5)");
        DebugFun.printAllEqual(Rgamma, Qgamma, 5.684341886080802E-14);
        System.out.println("Upper tail, log equality geom(pi/16.0)");
        DebugFun.printAllEqual(Rgeom, Qgeom);
        System.out.println("Upper tail, log equality hyper(40, 30, 20)");
        DebugFun.printAllEqual(Rhyper, Qhyper);
        System.out.println("Upper tail, log equality lnorm(-1, 3)");
        DebugFun.printAllEqual(Rlnorm, Qlnorm);
        System.out.println("Upper tail, log equality logis(12, 2)");
        DebugFun.printAllEqual(Rlogis, Qlogis);
        System.out.println("Upper tail, log equality nbinom(7, 0.01)");
        DebugFun.printAllEqual(Rnbinom, Qnbinom);
        System.out.println("Upper tail, log equality norm(-1, 3)");
        DebugFun.printAllEqual(Rnorm, Qnorm);
        System.out.println("Upper tail, log equality pois(12)");
        DebugFun.printAllEqual(Rpois, Qpois);
        System.out.println("Upper tail, log equality signrank(47)");
        DebugFun.printAllEqual(Rsignrank, Qsignrank);
        System.out.println("Upper tail, log equality t(11)");
        DebugFun.printAllEqual(Rt, Qt);
        System.out.println("Upper tail, log equality t(1.01)");
        DebugFun.printAllEqual(Rt2, Qt2);
        System.out.println("Upper tail, log equality unif(0.2, 2)");
        DebugFun.printAllEqual(Runif, Qunif);
        System.out.println("Upper tail, log equality weibull(3, 2)");
        DebugFun.printAllEqual(Rweibull, Qweibull);
        System.out.println("Upper tail, log equality wilcox(13, 17)");
        DebugFun.printAllEqual(Rwilcox, Qwilcox);
        lower_tail = false;
        log_p = true;
        double[] _Pbeta = beta.cumulative(Rbeta, lower_tail, log_p);
        double[] _Pbinom = binom.cumulative(Rbinom, lower_tail, log_p);
        double[] _Pcauchy = cauchy.cumulative(Rcauchy, lower_tail, log_p);
        double[] _Pchisq = chisq.cumulative(Rchisq, lower_tail, log_p);
        double[] _Pexp = exp.cumulative(Rexp, lower_tail, log_p);
        double[] _Pf = f.cumulative(Rf, lower_tail, log_p);
        double[] _Pgamma = gamma.cumulative(Rgamma, lower_tail, log_p);
        double[] _Pgeom = geom.cumulative(Rgeom, lower_tail, log_p);
        double[] _Phyper = hyper.cumulative(Rhyper, lower_tail, log_p);
        double[] _Plnorm = lnorm.cumulative(Rlnorm, lower_tail, log_p);
        double[] _Plogis = logis.cumulative(Rlogis, lower_tail, log_p);
        double[] _Pnbinom = nbinom.cumulative(Rnbinom, lower_tail, log_p);
        double[] _Pnorm = norm.cumulative(Rnorm, lower_tail, log_p);
        double[] _Ppois = pois.cumulative(Rpois, lower_tail, log_p);
        double[] _Psignrank = signrank.cumulative(Rsignrank, lower_tail, log_p);
        double[] _Pt = t.cumulative(Rt, lower_tail, log_p);
        double[] _Pt2 = t2.cumulative(Rt2, lower_tail, log_p);
        double[] _Punif = unif.cumulative(Runif, lower_tail, log_p);
        double[] _Pweibull = weibull.cumulative(Rweibull, lower_tail, log_p);
        double[] _Pwilcox = wilcox.cumulative(Rwilcox, lower_tail, log_p);
        System.out.println();
        System.out.println("Upper tail cumulative equality beta(0.8, 2)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pbeta), _Pbeta);
        System.out.println("Upper tail cumulative equality binomial(25, pi/16.0)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pbinom), _Pbinom);
        System.out.println("Upper tail cumulative equality cauchy(12, 2)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pcauchy), _Pcauchy);
        System.out.println("Upper tail cumulative equality chisq(3)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pchisq), _Pchisq);
        System.out.println("Upper tail cumulative equality exp(rate = 2.0)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pexp), _Pexp);
        System.out.println("Upper tail cumulative equality f(12, 6)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pf), _Pf);
        System.out.println("Upper tail cumulative equality gamma(2, 5)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pgamma), _Pgamma);
        System.out.println("Upper tail cumulative equality geom(pi/16.0)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pgeom), _Pgeom);
        System.out.println("Upper tail cumulative equality hyper(40, 30, 20)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Phyper), _Phyper);
        System.out.println("Upper tail cumulative equality lnorm(-1, 3)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Plnorm), _Plnorm);
        System.out.println("Upper tail cumulative equality logis(12, 2)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Plogis), _Plogis);
        System.out.println("Upper tail cumulative equality nbinom(7, 0.01)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pnbinom), _Pnbinom);
        System.out.println("Upper tail cumulative equality norm(-1, 3)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pnorm), _Pnorm);
        System.out.println("Upper tail cumulative equality pois(12)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Ppois), _Ppois);
        System.out.println("Upper tail cumulative equality signrank(47)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Psignrank), _Psignrank);
        System.out.println("Upper tail cumulative equality t(11)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pt), _Pt);
        System.out.println("Upper tail cumulative equality t(1.01)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pt2), _Pt2);
        System.out.println("Upper tail cumulative equality unif(0.2, 2)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Punif), _Punif);
        System.out.println("Upper tail cumulative equality weibull(3, 2)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pweibull), _Pweibull);
        System.out.println("Upper tail cumulative equality wilcox(13, 17)");
        DebugFun.printAllEqual(VectorMath.vlog1pComps(Pwilcox), _Pwilcox);
    }

    @Test
    public static final boolean test_extreme() {
        int n;
        F f;
        double[] a;
        Object t;
        double[] x;
        System.out.println("### (Extreme) tail tests added more recently:");
        boolean success = true;
        double neginf = Double.NEGATIVE_INFINITY;
        double inf = Double.POSITIVE_INFINITY;
        success = DebugFun.printBool(DebugFun.isEqual(1.0, -1.0E-17 / Exponential.cumulative(Exponential.quantile(-1.0E-17, 1.0, true, true), 1.0, true, true)));
        success &= DebugFun.printBool(VectorMath.isEqual(Math.abs(Gamma.cumulative(30.0, 100.0, 1.0, false, true)), 7.3384686328784E-24, 1.0E-36));
        success &= DebugFun.printBool(DebugFun.isEqual(1.0, Cauchy.cumulative(-1.0E20, 0.0, 1.0, true, false) / 3.18309886183791E-21));
        success &= DebugFun.printBool(DebugFun.isEqual(1.0, Cauchy.cumulative(1.0E15, 0.0, 1.0, true, true) / -3.18309886183791E-16));
        Cauchy cauchy = new Cauchy(0.0, 1.0);
        double[] ex = new double[]{1.0, 2.0, 5.0, 10.0, 15.0, 20.0, 25.0, 50.0, 100.0, 200.0, 300.0, Double.POSITIVE_INFINITY};
        double[] dArray = x = VectorMath.vpow(10.0, ex);
        int n2 = x.length;
        int n3 = 0;
        while (n3 < n2) {
            double _x = dArray[n3];
            if (_x > 1.0E10) {
                DebugFun.printBool(VectorMath.isEqual(T.cumulative(-_x, 1.0, true, false), cauchy.cumulative(-_x), 1.0E-15));
            }
            ++n3;
        }
        System.out.println("## for PR#7902:");
        double[] rec_x = Utilities.rec(x);
        double[] mins_x = VectorMath.vmin(x);
        success &= DebugFun.printAllEqualScaled(mins_x, cauchy.quantile(cauchy.cumulative(mins_x)));
        success &= DebugFun.printAllEqualScaled(x, cauchy.quantile(cauchy.cumulative(x, true, true), true, true));
        success &= DebugFun.printAllEqual(rec_x, cauchy.quantile(cauchy.cumulative(rec_x)));
        ex = VectorMath.vmin(Utilities.c(new double[][]{Utilities.rev(rec_x), ex}));
        success &= DebugFun.printAllEqualScaled(ex, cauchy.quantile(cauchy.cumulative(ex, true, true), true, true));
        x = new double[]{0.0, 1.0};
        ex = new double[]{neginf, inf};
        if (!(DebugFun.allEqual(cauchy.cumulative(ex), x) && DebugFun.allEqual(cauchy.quantile(x), ex) && DebugFun.allEqual(cauchy.quantile(new double[]{neginf, 0.0}, true, true), ex))) {
            System.err.println("Boundary exception error in Cauchy distribution");
            success = false;
        }
        success &= VectorMath.isEqualScaled(cauchy.quantile(0.999755859375), 1303.797038145332, 1.0E-14);
        System.out.println("## PR#6757:");
        if (!VectorMath.isEqualScaled(Math.pow(1.0E-23, 12.0), Binomial.cumulative(11.0, 12.0, 1.0E-23, false, false), 1.0E-12)) {
            System.err.println("Extreme tail error in Binomial.cumulative");
            success = false;
        }
        System.out.println("## PR#6792:");
        double val = Geometric.cumulative(1.0, 1.0E-17, true, false);
        if (!DebugFun.isEqualScaled(2.0E-17, val)) {
            System.err.println("Extreme tail error in Geometric.cumulative");
            success = false;
        }
        x = VectorMath.vpow(10.0, Utilities.colon(100, 295));
        double[] dArray2 = new double[]{1.0E-250, 1.0E-25, 0.9, 1.1, 101.0, 1.0E10, 1.0E100};
        int n4 = dArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            double v = dArray2[n5];
            Gamma pgamma = new Gamma(v, 1.0);
            success &= DebugFun.printAllEqualScaled(VectorMath.vmin(x), pgamma.cumulative(x, false, true));
            ++n5;
        }
        x = VectorMath.vpow(2.0, Utilities.colon(-1022, -900));
        Gamma g = new Gamma(10.0, 1.0);
        success &= DebugFun.printAllEqual(VectorMath.vmin(g.cumulative(x, true, true), VectorMath.vtimes(10.0, VectorMath.vlog(x))), Utilities.rep(-15.104412573076, x.length), 1.0E-12);
        g = new Gamma(0.1, 1.0);
        success &= DebugFun.printAllEqual(VectorMath.vmin(g.cumulative(x, true, true), VectorMath.vtimes(0.1, VectorMath.vlog(x))), Utilities.rep(0.0498724412598364, x.length), 1.0E-13);
        Poisson pois = new Poisson(3.0E-308);
        success &= DebugFun.printAllEqualScaled(Utilities.c(-7096.080376108055, -14204.287543530712), pois.density(Utilities.c(10.0, 20.0), true));
        val = Poisson.density(1.0E20, 1.0E-290, true);
        success &= DebugFun.printBool(DebugFun.isEqualScaled(-7.128013788281541E22, val));
        String fmt = " %3.18g";
        x = Utilities.c(0.3183098861837907, 1.0, Math.PI);
        F f1 = new F(3.0, 1000000.0);
        F f2 = new F(3.0, inf);
        System.out.println("## Inf df in pf etc.");
        Utilities.print(fmt, f1.density(x));
        Utilities.print(fmt, f2.density(x));
        Utilities.print(fmt, f1.cumulative(x));
        Utilities.print(fmt, f2.cumulative(x));
        f1 = new F(1000000.0, 5.0);
        f2 = new F(inf, 5.0);
        Utilities.print(fmt, f1.density(x));
        Utilities.print(fmt, f2.density(x));
        Utilities.print(fmt, f1.cumulative(x));
        Utilities.print(fmt, f2.cumulative(x));
        f1 = new F(inf, inf);
        Utilities.print(f1.density(x));
        Utilities.print(f1.cumulative(x));
        f1 = new F(5.0, inf);
        Utilities.print(fmt, f1.cumulative(x));
        NonCentralF ncf22 = new NonCentralF(5.0, 1000000.0, 1.0);
        success &= DebugFun.printAllEqualScaled(Utilities.c(0.06593319432457068, 0.470879986605836, 0.9788758673705319), ncf22.cumulative(x));
        ncf22 = new NonCentralF(5.0, 1.0E7, 1.0);
        success &= DebugFun.printAllEqualScaled(Utilities.c(0.06593308950344137, 0.47088028378103325, 0.9788764068176146), ncf22.cumulative(x));
        ncf22 = new NonCentralF(5.0, 1.0E8, 1.0);
        success &= DebugFun.printAllEqualScaled(Utilities.c(0.06593307522941962, 0.4708802999941468, 0.9788764591647495), ncf22.cumulative(x));
        ncf22 = new NonCentralF(5.0, inf, 1.0);
        Utilities.print(fmt, ncf22.cumulative(x));
        Utilities.print(fmt, T.density(1.0, inf, false));
        Utilities.print(fmt, NonCentralT.density(1.0, inf, 0.0, false));
        Utilities.print(fmt, NonCentralT.density(1.0, inf, 1.0, false));
        Utilities.print(fmt, NonCentralT.density(1.0, 1000000.0, 1.0, false));
        Utilities.print(fmt, NonCentralT.density(1.0, 1.0E7, 1.0, false));
        Utilities.print(fmt, NonCentralT.density(1.0, 1.0E8, 1.0, false));
        Utilities.print(fmt, NonCentralT.density(1.0, 1.0E10, 1.0, false));
        double[] dArray3 = new double[]{0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-100, 0.0};
        int n6 = dArray3.length;
        int ncf22 = 0;
        while (ncf22 < n6) {
            double _x = dArray3[ncf22];
            System.out.println(String.format("%3.18g %3.18g", _x, NonCentralT.density(_x, 2.0, 1.0, false)));
            ++ncf22;
        }
        x = Utilities.rep(VectorMath.vpow(10.0, Utilities.c(new double[][]{Utilities.colon(-3.0, 2.0), Utilities.colon(6.0, 9.0), VectorMath.vtimes(10.0, Utilities.colon(2.0, 30.0))})), 12);
        boolean cur_success = true;
        double[] dArray4 = new double[]{0.75, 1.2, 4.5, 999.0, 1.0E50};
        int n7 = dArray4.length;
        n6 = 0;
        while (n6 < n7) {
            double nu = dArray4[n6];
            t = new T(nu);
            double[] lfx = ((GenericDistribution)t).density(x, true);
            cur_success &= VectorMath.allFinite(lfx);
            cur_success &= DebugFun.allEqual(VectorMath.vexp(lfx), ((GenericDistribution)t).density(x));
            ++n6;
        }
        success &= cur_success;
        if (!cur_success) {
            System.err.println("Error at extreme values of T density");
        }
        val = ChiSquare.cumulative(1.0, 1.0, true, false);
        double[] nus = VectorMath.vpow(2.0, Utilities.seq(25.0, 34.0, 0.5));
        int i = 0;
        while (i < nus.length) {
            double y_next;
            double nu = nus[i];
            double _f = F.cumulative(1.0, 1.0, inf, true, false);
            if (!DebugFun.isEqual(_f, val)) {
                System.err.println(String.format("Error: target=%3.18g, pf(1,1,Inf) = %3.18g", val, _f));
                success = false;
            }
            double y = F.cumulative(1.0, 1.0, nu, true, false);
            double d = y_next = i == nus.length - 1 ? val : F.cumulative(1.0, 1.0, nus[i + 1], true, false);
            if (y_next < y) {
                System.err.println(String.format("Not monotonic increasing: %3.18g %3.18g", y, y_next));
                success = false;
            }
            if (i == 0 && Math.abs(y - (val - 7.21129E-9)) > 1.0E-11) {
                System.err.println(String.format("Precision error: %3.18g", y));
                success = false;
            }
            ++i;
        }
        if (Gamma.cumulative(inf, 1.1, 1.0, true, false) != 1.0) {
            System.err.println("Error at Gamma.cumulative(Inf, 1.1, 1, true, false)!");
            success = false;
        }
        System.out.println("## qgamma(q, *) should give {0,Inf} for q={0,1}");
        double[] dArray5 = new double[]{1.1, 0.5, 0.2, 0.15, 0.01, 1.0E-10};
        t = dArray5;
        int _f = dArray5.length;
        n7 = 0;
        while (n7 < _f) {
            Object sh = t[n7];
            if (Gamma.quantile(1.0, (double)sh, 1.0, true, false) != inf) {
                System.err.println(String.format("Error at Gamma.cumulative(1, %f, 1, true, false)!", (double)sh));
                success = false;
            }
            if (Gamma.quantile(0.0, (double)sh, 1.0, true, false) != 0.0) {
                System.err.println(String.format("Error at Gamma.cumulative(0, %f, 1, true, false)!", (double)sh));
                success = false;
            }
            ++n7;
        }
        System.out.println("## In extreme left tail {PR#11030}");
        x = VectorMath.vtimes(1.0E-12, Utilities.colon(10.0, 123.0));
        double[] qg = new Gamma(19.0, 1.0).quantile(x);
        double[] qg2 = new Gamma(11.0, 1.0).quantile(VectorMath.vtimes(1.0E-9, Utilities.colon(1.0, 100.0)));
        double[] dqg = VectorMath.diff(qg, 1, 2);
        double[] dqg2 = VectorMath.diff(qg2, 1, 2);
        if (!VectorMath.allLt(dqg, -6.0E-6)) {
            System.err.println("Error at Gamma.cumulative(x, 19, 1, true, false)!");
            success = false;
        }
        if (!VectorMath.allLt(dqg2, -6.0E-6)) {
            System.err.println("Error at Gamma.cumulative(x, 11, 1, true, false)!");
            success = false;
        }
        if (!VectorMath.allLt(VectorMath.vabs(VectorMath.vcomp(VectorMath.vdiv(new Gamma(19.0, 1.0).cumulative(qg), x))), 1.0E-13)) {
            System.err.println("Error at 1-Gamma.cumulative(x, 19, 1, true, false)!");
            success = false;
        }
        if (!DebugFun.isEqual(qg[0], 2.35047385139143)) {
            System.err.println("Error at Gamma.cumulative(1e-11, 19, 1, true, false)!=2.35047385139143");
            success = false;
        }
        if (!DebugFun.isEqual(qg2[29], 1.11512318734547)) {
            System.err.println("Error at Gamma.cumulative(3e-8, 11, 1, true, false)!=1.11512318734547");
            success = false;
        }
        double[] dArray6 = new double[]{0.5, 1.0, 2.0, 3.0, 4.0};
        int y_next = dArray6.length;
        int n8 = 0;
        while (n8 < y_next) {
            double f22 = dArray6[n8];
            if (F.density(0.0, 1.0, f22, false) != inf) {
                System.err.println(String.format("Error: F.density(0, 1, %f, false) != Inf", f22));
                success = false;
            }
            if (F.density(0.0, 2.0, f22, false) != 1.0) {
                System.err.println(String.format("Error: F.density(0, 2, %f, false) != 1", f22));
                success = false;
            }
            if (F.density(0.0, 3.0, f22, false) != 0.0) {
                System.err.println(String.format("Error: F.density(0, 3, %f, false) != 0", f22));
                success = false;
            }
            ++n8;
        }
        dArray6 = new double[]{-2.0E-22, -2.0E-10, -2.0E-7, -2.0E-5};
        y_next = dArray6.length;
        n8 = 0;
        while (n8 < y_next) {
            double x0 = dArray6[n8];
            if (Binomial.cumulative(x0, 3.0, 1.0, true, false) != 0.0) {
                System.err.println(String.format("Error: Binomial.cumulative(%f, 3, 0.1, true, false) != 0", x0));
                success = false;
            }
            if (Binomial.density(x0, 3.0, 1.0, false) != 0.0) {
                System.err.println(String.format("Error: Binomial.density(%f, 3, 0.1, false) != 0", x0));
                success = false;
            }
            ++n8;
        }
        System.out.println("## dbeta(*, ncp):");
        Object[] objectArray = a = new LogNormal(0.0, 1.0).random(100);
        int n9 = a.length;
        y_next = 0;
        while (y_next < n9) {
            double a_ = objectArray[y_next];
            val = NonCentralBeta.density(0.0, 1.0, a_, 0.0, false);
            if (val != a_) {
                System.err.println(String.format("Error: Beta.density(0, 1, %3.18g, false) %3.18g != %3.18g", a_, val, a_));
                success = false;
            }
            if (NonCentralBeta.density(0.0, 0.9, 2.2, a_, false) != inf) {
                System.err.println(String.format("Error: NonCentralBeta.density(0, 1, 2.2, %3.18g, false) != Inf", a_));
                success = false;
            }
            ++y_next;
        }
        if (NonCentralBeta.density(0.0, 0.9, 2.2, 0.0, false) != inf) {
            System.err.println("Error: NonCentralBeta.density(0, 1, 2.2, 0, false) != Inf");
            success = false;
        }
        double[] dbx = new double[]{0.0, 5.0, 80.0, 405.0, 1280.0, 3125.0, 6480.0, 12005.0, 20480.0, 32805.0, 50000.0, 73205.0, 103680.0, 142805.0, 192080.0, 253125.0, 327680.0};
        double[] cc = VectorMath.vdiv(Utilities.colon(0.0, 16.0), 16.0);
        success &= DebugFun.allEqual(VectorMath.vtimes(65536.0, new Beta(5.0, 1.0).density(cc)), dbx);
        success &= DebugFun.allEqual(VectorMath.vexp(VectorMath.vplus(16.0 * Math.log(2.0), new Beta(5.0, 1.0).density(cc, true))), dbx);
        System.out.println("## the first gave 0, the 2nd NaN in R <= 2.3.0; others use 'TRUE' values");
        val = NonCentralBeta.density(0.8, 0.5, 5.0, 1000.0, false);
        if (DebugFun.isEqual(val, 3.0018523089086246E-35)) {
            System.err.println(String.format("Precision loss: NonCentralBeta.density(0.8, 0.5, 5, 1000, false) %3.18g != 3.0018523089086246e-35", val));
            success = false;
        }
        System.out.println("## df(*, ncp):");
        x = Utilities.seq(0.0, 10.0, 0.1);
        NonCentralF ncf = new NonCentralF(7.0, 5.0, 2.5);
        success &= DebugFun.printAllEqual(ncf.density(x), VectorMath.vdiv(VectorMath.vmin(ncf.cumulative(VectorMath.vplus(x, 1.0E-7)), ncf.cumulative(VectorMath.vmin(x, 1.0E-7))), 2.0E-7), 1.0E-6);
        objectArray = x;
        n9 = x.length;
        y_next = 0;
        while (y_next < n9) {
            double val2;
            double _x = objectArray[y_next];
            val = NonCentralF.density(0.0, 2.0, 4.0, _x, false);
            if (!DebugFun.isEqual(val, val2 = NonCentralF.density(1.0E-300, 2.0, 4.0, _x, false))) {
                System.err.println(String.format("Error: x = %f, NonCentralF.density(0, 2, 4, x, false) = %3.18g != NonCentralF.density(1e-300, 2, 4, x, false)  = %3.18g", x, val, val2));
                success = false;
            }
            ++y_next;
        }
        System.out.println("## qt(p ~ 0, df=1) - PR#9804");
        T t2 = new T(1.0);
        x = VectorMath.vpow(10.0, Utilities.colon(-10.0, -20.0));
        success &= DebugFun.printAllEqual(x, t2.cumulative(t2.quantile(x)), 1.0E-14);
        System.out.println("## Similarly for df = 2 --- both for p ~ 0  *and*  p ~ 1/2");
        System.out.println("## P ~ 0");
        val = T.quantile(-740.0, 2.0, true, true);
        if (!DebugFun.isEqualScaled(val, -Math.exp(370.0) / Math.sqrt(2.0))) {
            System.err.println(String.format("Precision loss: T.quantile(-740, 2, true, true) %3.18g != %3.18g", val, -Math.exp(370.0) / Math.sqrt(2.0)));
            success = false;
        }
        System.out.println("## P ~ 1 (=> p ~ 0.5):");
        double[] p5 = VectorMath.vplus(0.5, VectorMath.vpow(2.0, Utilities.seq(-25, -40, -5)));
        t2 = new T(2.0);
        success &= DebugFun.printAllEqual(t2.quantile(p5), Utilities.c(8.429369702178821E-8, 2.634178031930877E-9, 8.231806349783991E-11, 2.5724394843074972E-12));
        System.out.println("## qt(<large>, log = TRUE)  is now more finite and monotone (again!):");
        val = T.quantile(-1000.0, 4.0, true, true);
        if (!DebugFun.isEqualScaled(val, -4.930611E108)) {
            System.err.println(String.format("Precision loss: T.quantile(-1000, 4, true, true) %3.18g != -4.930611e108", val));
            success = false;
        }
        System.out.println("##almost: stopifnot(all(abs(5/6 - diff(log(qtp))) < 1e-11)):");
        x = new T(1.2).quantile(Utilities.colon(-20.0, -850.0), false, true);
        p5 = VectorMath.diff(VectorMath.vlog(x));
        Utilities.sort(p5);
        p5 = VectorMath.quantile(p5, Utilities.c(0.0, 0.995));
        success &= DebugFun.printAllEqual(p5, Utilities.c(0.8333333333333334, 0.8333333333333334), 1.0E-11);
        System.out.println("## close to df=1 (where Taylor steps are important!):");
        t2 = new T(1.02);
        val = t2.cumulative(t2.quantile(-20.0, true, true), true, true);
        if (!DebugFun.isEqual(val, -20.0)) {
            System.err.println(String.format("Precision loss: T.cumulative(T.quantile(-20, 1.02, true, true), 1.02, true, true) == %3.18g != -20", val));
            success = false;
        }
        if (!DebugFun.isEqual(val = t2.quantile(t2.cumulative(-20.0, true, true), true, true), -20.0)) {
            System.err.println(String.format("Precision loss: T.quantile(T.cumulative(-20, 1.02, true, true), 1.02, true, true) == %3.18g != -20", val));
            success = false;
        }
        if (!VectorMath.allGt(VectorMath.diff(VectorMath.vlog((t2 = new T(1.1)).quantile(x = VectorMath.vpow(-2.0, Utilities.colon(-10.0, -600.0)), true, true))), 0.6)) {
            System.err.println("Precision loss: diff(T.quantile(x, 1.1, true, true)) <= 0.6");
            success = false;
        }
        if (VectorMath.mean(VectorMath.vabs(VectorMath.vmin(VectorMath.diff((t2 = new T(1.0)).quantile(x = VectorMath.vpow(-2.0, Utilities.colon(-20.0, -600.0)), true, true)), Math.log(2.0)))) >= 1.0E-8) {
            System.err.println("Precision loss: diff(T.quantile(x, 1, true, true)) != log(2)");
            success = false;
        }
        if (VectorMath.mean(VectorMath.vabs(VectorMath.vmin(VectorMath.diff((t2 = new T(2.0)).quantile(x, true, true)), Math.log(Math.sqrt(2.0))))) >= 1.0E-8) {
            System.err.println("Precision loss: diff(T.quantile(x, 2, true, true)) != log(sqrt(2))");
            success = false;
        }
        System.out.println("## Case, where log.p=TRUE was fine, but log.p=FALSE (default) gave NaN:");
        x = Utilities.colon(40.0, 406.0);
        t2 = new T(1.2);
        success &= DebugFun.printAllEqualScaled(x, VectorMath.vmin(t2.cumulative(t2.quantile(VectorMath.vexp(VectorMath.vmin(x))), true, true)));
        System.out.println("## pbeta(*, log=TRUE) {toms708} -- now improved tail behavior:");
        x = Utilities.c(0.01, 0.1, 0.25, 0.4, 0.55, 0.71, 0.98);
        double[] pbval = Utilities.c(-0.04605755624088, -0.3182809860569, -0.7503593555585, -1.241555830932, -1.851527837938, -2.76044482378, -8.149862739881);
        success &= DebugFun.printAllEqualScaled(new Beta(0.8, 2.0).cumulative(x, false, true), pbval);
        success &= DebugFun.printAllEqualScaled(new Beta(2.0, 0.8).cumulative(VectorMath.vcomp(x), true, true), pbval);
        x = VectorMath.vmin(VectorMath.vpow(2.0, Utilities.colon(0, 1022)));
        objectArray = Utilities.c(0.1, 0.2, 0.5, 1.0, 1.2, 2.2, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0);
        n9 = objectArray.length;
        y_next = 0;
        while (y_next < n9) {
            double nu = objectArray[y_next];
            if (!VectorMath.allFinite(new T(nu).cumulative(x, true, true))) {
                System.err.println(String.format("Bad numeric behavior: T.cumulative(x, %f, true, true))", nu));
                success = false;
            }
            ++y_next;
        }
        val = T.cumulative(Math.pow(2.0, -30.0), 10.0, true, false);
        if (!DebugFun.isEqual(val, 0.5000000003623855)) {
            System.err.println(String.format("Precision loss: T.cumulative(2^-30, 10, true, true)) = %3.18g != 0.50000000036238542", val));
            success = false;
        }
        System.out.println("## rbinom(*, size) gave NaN for large size up to R <= 2.6.1");
        x = Binomial.random(100, 2.147483647E9, 1.0E-9, random);
        if (!VectorMath.allFinite(x) || VectorMath.sum(VectorMath.table(x)) != 100.0) {
            System.err.println("Produces NaN: Binomial.random(100, Integer.MAX_VALUE, 1e-9, random)");
            success = false;
        }
        if (!VectorMath.allFinite(x = Binomial.random(100, 2.147483647E10, 1.0E-10, random)) || VectorMath.sum(VectorMath.table(x)) != 100.0) {
            System.err.println("Produces NaN: Binomial.random(100, 10*Integer.MAX_VALUE, 1e-10, random)");
            success = false;
        }
        System.out.println("## qf() with large df1, df2  and/or  small p:");
        val = F.quantile(0.25, inf, inf, true, false);
        if (val != 1.0) {
            System.err.println(String.format("F.quantile(1/4, inf, inf, true, false) != 1, but produces %3.18g", val));
            success = false;
        }
        if (!VectorMath.isEqual(1.0, 1.0E-18 / (val = (f = new F(12.0, 50.0)).cumulative(f.quantile(1.0E-18))), 1.0E-10)) {
            System.err.println(String.format("F.cumulative(F.quantile(1e-18, 12, 50, true, false), true, false) != 1e-18, but produces %3.18g", val));
            success = false;
        }
        if (!VectorMath.isEqual(0.01, val = (f = new F(1.0E60, 1.0E90)).quantile(f.cumulative(0.01, true, true), true, true), 1.0E-4)) {
            System.err.println(String.format("F.quantile(F.cumulative(0.01, 1e60, 1e90, true, true), true, true) != 0.01, but produces %3.18g", val));
            success = false;
        }
        System.out.println("## qbeta(*, log.p) for \"border\" case:");
        val = Beta.quantile(-1.0E10, 50.0, 40.0, true, true);
        if (MathFunctions.isInfinite(val)) {
            System.err.println("Beta.quantile(-1e10, 50, 40, true, true) is infinite");
            success = false;
        }
        if (MathFunctions.isInfinite(val = Beta.quantile(-1.0E10, 2.0, 3.0, false, true))) {
            System.err.println("Beta.quantile(-1e10, 2, 3, false, true) is infinite");
            success = false;
        }
        System.out.println("## phyper(x, 0,0,0), notably for huge x");
        HyperGeometric h = new HyperGeometric(0.0, 0.0, 0.0);
        x = h.cumulative(Utilities.c(0.0, 1.0, 2.0, 3.0, 1.0E67));
        success &= DebugFun.printAllEqual(Utilities.rep(1.0, x.length), x);
        System.out.println("## plnorm(<= 0, . , log.p=TRUE)");
        if (LogNormal.cumulative(-1.0, 0.0, 1.0, false, true) != 0.0) {
            System.err.println("LogNormal.cumulative(-1, 0, 1, false, true) != 0");
            success = false;
        }
        if (LogNormal.cumulative(0.0, 0.0, 1.0, false, true) != 0.0) {
            System.err.println("LogNormal.cumulative(0, 0, 1, false, true) != 0");
            success = false;
        }
        if (LogNormal.cumulative(-1.0, 0.0, 1.0, true, true) != neginf) {
            System.err.println("LogNormal.cumulative(-1, 0, 1, true, true) != -Inf");
            success = false;
        }
        if (LogNormal.cumulative(0.0, 0.0, 1.0, true, true) != neginf) {
            System.err.println("LogNormal.cumulative(0, 0, 1, true, true) != -Inf");
            success = false;
        }
        System.out.println("## pchisq(df=0) was wrong in 2.7.1; then, upto 2.10.1, P*(0,0) gave 1");
        ChiSquare chisq = new ChiSquare(0.0);
        x = Utilities.c(-1.0, 0.0, 1.0);
        if (!VectorMath.allEqual(chisq.cumulative(x), Utilities.c(0.0, 0.0, 1.0))) {
            System.err.println("ChiSquare.cumulative(c(-1,0,1), 0, true, false) != c(0,0,1)");
            success = false;
        }
        if (!VectorMath.allEqual(chisq.cumulative(x, false, false), Utilities.c(1.0, 1.0, 0.0))) {
            System.err.println("ChiSquare.cumulative(c(-1,0,1), 0, false, false) != c(1,1,0)");
            success = false;
        }
        System.out.println("## dnbinom for extreme  size and/or mu :");
        x = VectorMath.vtimes(1.0E11, VectorMath.vpow(2.0, Utilities.colon(1.0, 10.0)));
        double[] d = new double[x.length];
        int i2 = 0;
        while (i2 < x.length) {
            double size = x[i2];
            val = NegBinomial.density_mu(17.0, size, 20.0, false);
            double val422 = Poisson.density(17.0, 20.0, false);
            d[i2] = val - val422;
            if (d[i2] >= 0.0) {
                System.err.println(String.format("NegBinomial.density_mu(17, %3.18g, 20, false) = %3.18g > Poisson.density(17, 20, false) = %3.18g", size, val, val422));
                success = false;
            }
            ++i2;
        }
        if (!VectorMath.allGt(VectorMath.diff(d), 0.0)) {
            System.err.println("diff(NegBinomial.density_mu(17, size, 20, false) - Poisson.density(17, 20, false)) <= 0");
            success = false;
        }
        objectArray = VectorMath.vtimes(1.0E12, VectorMath.vpow(2.0, Utilities.colon(0.0, 20.0)));
        int val422 = objectArray.length;
        y_next = 0;
        while (y_next < val422) {
            double _x = objectArray[y_next];
            val = NegBinomial.density_mu(0.0, 1.0, _x, false);
            if (!VectorMath.isEqual(1.0 / (1.0 + _x), val, 1.0E-13)) {
                System.err.println(String.format("NegBinomial.density_mu(0, 1, %3.18, false) = %3.18g != %3.18", _x, val, 1.0 / (1.0 + _x)));
                success = false;
            }
            ++y_next;
        }
        double maxerr = 1.9984014443252818E-15;
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 50;
        nArray[12] = 100;
        nArray[13] = 150;
        nArray[14] = 200;
        nArray[15] = 250;
        nArray[16] = 300;
        objectArray = nArray;
        val422 = nArray.length;
        y_next = 0;
        while (y_next < val422) {
            double expo = objectArray[y_next];
            int i3 = 1;
            while (i3 <= 7) {
                double P;
                double mu = (double)i3 * Math.pow(10.0, expo);
                double NB = NegBinomial.density_mu(5.0, 1.0E305, mu, true);
                double abserr = Math.abs(DebugFun.rErr(NB, P = Poisson.density(5.0, mu, true)));
                if (abserr >= 1.9984014443252818E-15) {
                    System.err.println(String.format("abs(NegBinomial.density_mu(5, 1e305, mu=%g, log=true) - Poisson.density(5, %g, log=true)) = %3.18g > %3.18g (%3.18g vs. %3.18g)", mu, mu, abserr, 1.9984014443252818E-15, NB, P));
                    success = false;
                }
                ++i3;
            }
            ++y_next;
        }
        System.out.println("## Non-central F for large x");
        x = VectorMath.vtimes(1.0E16, VectorMath.vpow(1.1, Utilities.colon(0.0, 20.0)));
        NonCentralF f3 = new NonCentralF(1.0, 1.0, 20.0);
        x = f3.cumulative(x, false, true);
        if (!VectorMath.allGt(x, -0.047) && !VectorMath.allLt(x, -0.0455)) {
            System.err.println("NonCentralF.cumulative(large X, 1, 1, 20, false, true) jumped prematurely to -Inf");
            success = false;
        }
        System.out.println("## Non-central Chi^2 density for large x");
        NonCentralChiSquare nc = new NonCentralChiSquare(10.0, 1.0);
        x = nc.density(Utilities.c(inf, 1.0E80, 1.0E50, 1.0E40));
        if (!VectorMath.allEqual(Utilities.rep(0.0, x.length), x)) {
            System.err.println("NonCentralChiSquare.density(x, 10, 1, false) != 0 for huge x");
            success = false;
        }
        System.out.println("## qbinom() .. particularly for large sizes, small prob:");
        x = Utilities.c(0.01, 0.001, 0.1, 0.25);
        double[] pr = VectorMath.vtimes(1.0E-7, Utilities.colon(2.0, 20.0));
        objectArray = Utilities.c(5000279.0, 5006279.0, 5016279.0);
        val422 = objectArray.length;
        y_next = 0;
        while (y_next < val422) {
            double sz = objectArray[y_next];
            double[] dArray7 = x;
            int NB = x.length;
            n = 0;
            while (n < NB) {
                double p = dArray7[n];
                double[] dArray8 = pr;
                int n10 = pr.length;
                int abserr = 0;
                while (abserr < n10) {
                    double val2;
                    double _pr = dArray8[abserr];
                    val = Binomial.quantile(p, sz, _pr, true, false);
                    if (val != (val2 = Poisson.quantile(p, sz * _pr, true, false))) {
                        System.err.println(String.format("p=%3.18g, sz=%3.18g, pr=%3.18g, Binomial.quantile(p, sz, pr, true, false) = %3.18g != Poisson.quantile(p, sz*pr, true, false) = %3.18", p, sz, _pr, val, val2));
                        success = false;
                    }
                    ++abserr;
                }
                ++n;
            }
            dArray7 = pr;
            NB = pr.length;
            n = 0;
            while (n < NB) {
                double _pr = dArray7[n];
                int ks = 0;
                while (ks <= 15) {
                    val = Binomial.cumulative(ks, sz, _pr, true, false);
                    double val2 = Binomial.quantile(val, sz, _pr, true, false);
                    if (val2 != (double)ks) {
                        System.err.println(String.format("Binomial.quantile(Binomial.cumulative(%d, %f, %3.18g, true, false) = %3.18g != %f", ks, sz, _pr, val, val2));
                        success = false;
                    }
                    ++ks;
                }
                ++n;
            }
            ++y_next;
        }
        System.out.println("## pbeta(x, a,b, log=TRUE)  for small x and a  is ~ log-linear");
        x = VectorMath.vpow(2.0, Utilities.colon(-200.0, -10.0));
        double[] val422 = Utilities.c(1.0E-8, 1.0E-12, 1.6E-15, 4.0E-16);
        y_next = val422.length;
        int expo = 0;
        while (expo < y_next) {
            double a2 = val422[expo];
            double[] NB = Utilities.c(0.6, 1.0, 2.0, 10.0);
            n = NB.length;
            int mu = 0;
            while (mu < n) {
                double b22 = NB[mu];
                double[] dp = VectorMath.diff(new Beta(a2, b22).cumulative(x, true, true));
                val = VectorMath.sd(dp) / VectorMath.mean(dp);
                if (val >= 7.0E-4) {
                    System.err.println(String.format("a=%f, b=%f, dp=diff(Beta(x, a, b, true, true)), sd(dp)/mean(db) = %3.18> 0.0007", a2, b22, val));
                    success = false;
                }
                ++mu;
            }
            ++expo;
        }
        System.out.println("## qgamma(p, a) for small a and (hence) small p");
        System.out.println("## pgamma(x, a) for very very small a");
        val = Gamma.quantile(0.99, 1.0E-5, 1.0, true, false);
        if (val != 0.0) {
            System.err.println(String.format("Gamma.quantile(0.99,  0.00001, 1, true, false) = %3.18g != 0", val));
            success = false;
        }
        x = VectorMath.vplus(1.0, VectorMath.vtimes(1.0E-7, Utilities.c(-1.0, 1.0)));
        double[] pg = new Gamma(Math.pow(2.0, -64.0), 1.0).cumulative(x, false, false);
        if (Math.abs(pg[1] - 1.1892824919723776E-20) >= 1.0E-33) {
            System.err.println(String.format("Precision loss: Gamma.cumulative(%g, 2^-64, 1, true, false) %3.18g != 1.18928249197237758088243e-20", x[1], pg[1]));
            success = false;
        }
        if ((val = Math.abs(VectorMath.diff(pg)[0] + VectorMath.diff(x)[0] * Gamma.density(1.0, Math.pow(2.0, -64.0), 1.0, false))) >= 1.0E-13 * VectorMath.mean(pg)) {
            System.err.println(String.format("abs(diff(pg)[0] + diff(x)[0]*Gamma.density(1, pow(2,-64), 1, false)) = %3.18g", val));
            success = false;
        }
        double[] b22 = VectorMath.vpow(2.0, VectorMath.vmin(Utilities.seq(10.0, 1000.0, 0.25)));
        int val422 = b22.length;
        y_next = 0;
        while (y_next < val422) {
            double p3c;
            double p1c;
            double a3 = b22[y_next];
            double q1c = Gamma.quantile(1.0E-100, a3, 1.0, false, false);
            double q3c = Gamma.quantile(1.0E-300, a3, 1.0, false, false);
            if (q1c > 0.0 && Math.abs(1.0 - (p1c = Gamma.cumulative(q1c, a3, 1.0, false, false)) / 1.0E-100) >= 1.0E-12) {
                System.err.println(String.format("Precision loss: a=%f. Gamma.cumulative(Gamma.quantile(1e-300, a, 1, false, false)) != 1e-100", a3));
                success = false;
            }
            if (q3c > 0.0 && Math.abs(1.0 - (p3c = Gamma.cumulative(q3c, a3, 1.0, false, false)) / 1.0E-300) >= 2.8E-12) {
                System.err.println(String.format("Precision loss: a=%f. Gamma.cumulative(Gamma.quantile(1e-300, a, 1, false, false)) != 1e-100", a3));
                success = false;
            }
            ++y_next;
        }
        System.out.println("## gave Inf as p==1 was checked *before* lambda==0");
        x = VectorMath.vdiv(Utilities.colon(0.0, 8.0), 8.0);
        if (!VectorMath.allEqual(new Poisson(0.0).quantile(x), Utilities.rep(0.0, x.length))) {
            System.err.println("Poisson.quantile(x, lambda=0, true, false) != 0");
            success = false;
        }
        System.out.println("## extreme tail of non-central chisquare");
        val = NonCentralChiSquare.cumulative(200.0, 4.0, 0.001, true, true);
        if (!DebugFun.isEqualScaled(-3.851E-42, val)) {
            System.err.println(String.format("Precision loss: NonCentralChiSquare.cumulative(200, 4, 0.001, true, true) = %3.18g != -3.851e-42", val));
            success = false;
        }
        System.out.println("## left \"extreme tail\"");
        double[] lp = new double[201];
        i = 0;
        while (i <= 200) {
            val = Math.pow(2.0, -i);
            lp[i] = NonCentralChiSquare.cumulative(val, 100.0, 1.0, true, true);
            if (MathFunctions.isInfinite(lp[i])) {
                System.err.println(String.format("Precision loss: NonCentralChiSquare.cumulative(%3.18g, 100, 1, true, true) is not finite", val));
                success = false;
            }
            if (lp[i] >= -184.0) {
                System.err.println(String.format("Precision loss: NonCentralChiSquare.cumulative(%3.18g, 100, 1, true, true) = %3.18g >= -184", val, lp[i]));
                success = false;
            }
            ++i;
        }
        if (!DebugFun.isEqualScaled(lp[200], -7115.10693158)) {
            System.err.println(String.format("Precision loss: NonCentralChiSquare.cumulative(2^-200, 100, 1, true, true) = %3.18g != -7.115.10693158", lp[201]));
            success = false;
        }
        double[] dlp = VectorMath.diff(lp);
        double[] dd = new double[dlp.length - 30];
        int i4 = 0;
        while (i4 < dd.length) {
            dd[i4] = Math.abs(dlp[i4 + 30] - -34.65735902799);
            ++i4;
        }
        Utilities.print(VectorMath.range(dd));
        i4 = 0;
        while (i4 < dlp.length) {
            if (-34.66 >= dlp[i4] || dlp[i4] >= -34.41) {
                System.err.println(String.format("Precision loss: %3.18g not within -34.41 and -34.66", dlp[i4]));
                success = false;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < dd.length) {
            if (dd[i4] >= 1.0E-8) {
                System.err.println(String.format("Precision loss: Differential error of %3.18g >= 1e-8 detected!", dd[i4]));
                success = false;
            }
            ++i4;
        }
        double[] mu = Utilities.c(0.0, 2.0E-16);
        int q1c = mu.length;
        int b22 = 0;
        while (b22 < q1c) {
            double e = mu[b22];
            val = NonCentralChiSquare.cumulative(1.0, 1.01, 80.0 * (1.0 - e), true, true);
            if (!DebugFun.isEqualScaled(val, -34.57369629)) {
                System.err.println(String.format("Continuity error detected: NonCentralChiSquare.cumulative(1, 1.01, 80*(1-%g), true, true) = %3.18g != -34.57369629", e, val));
                success = false;
            }
            if (!DebugFun.isEqualScaled(val = NonCentralChiSquare.cumulative(2.0, 1.01, 80.0 * (1.0 - e), true, true), -31.31514671)) {
                System.err.println(String.format("Continuity error detected: NonCentralChiSquare.cumulative(2, 1.01, 80*(1-%g), true, true) = %3.18g != -31.31514671", e, val));
                success = false;
            }
            ++b22;
        }
        System.out.println("## logit() == qlogit() on the right extreme:");
        x = Utilities.c(new double[][]{Utilities.colon(10.0, 80.0), VectorMath.vplus(80.0, VectorMath.vtimes(5.0, Utilities.colon(1.0, 24.0))), VectorMath.vplus(200.0, VectorMath.vtimes(20.0, Utilities.colon(1.0, 25.0)))});
        Logistic l = new Logistic(0.0, 1.0);
        success &= DebugFun.printAllEqual(x, l.quantile(l.cumulative(x, true, true), true, true));
        System.out.println("## Part 2:");
        x = Utilities.c(new double[][]{x, Utilities.seq(700.0, 800.0, 10.0)});
        success &= DebugFun.printAllEqual(x, l.quantile(l.cumulative(x, false, true), false, true));
        System.out.println("## log upper tail pbeta():");
        x = VectorMath.vdiv(Utilities.colon(25.0, 50.0), 128.0);
        double[] pbx = new Beta(0.5, 2200.0).cumulative(x, false, true);
        double[] dp = VectorMath.diff(pbx);
        double[] d2p = VectorMath.diff(dp);
        if (!VectorMath.allGt(pbx, -1094.0) || !VectorMath.allLt(pbx, -481.66)) {
            System.err.println("Anomalous Beta.cumulative(x, 0.5, 2200, false, true)");
            success = false;
        }
        if (!VectorMath.allGt(dp, -29.0) || !VectorMath.allLt(dp, -20.0)) {
            System.err.println("Anomalous Beta.cumulative(x, 0.5, 2200, false, true) at the first derivative");
            success = false;
        }
        if (!VectorMath.allGt(d2p, -0.36) || !VectorMath.allLt(d2p, -0.2)) {
            System.err.println("Anomalous Beta.cumulative(x, 0.5, 2200, false, true) at the second derivative");
            success = false;
        }
        double[] b = new double[51];
        double[] y = new double[b.length];
        int i5 = 0;
        while (i5 < b.length) {
            b[i5] = 2200.0 * Math.pow(2.0, i5);
            y[i5] = Math.log(-Beta.cumulative(0.28, 0.5, b[i5], false, true)) + 1.113;
            ++i5;
        }
        val = VectorMath.mean(VectorMath.vabs(VectorMath.vmin(b = VectorMath.vlog(b), y))) / VectorMath.mean(b);
        DebugFun.printBool(Math.abs(val) <= 2.0E-5);
        if (Math.abs(val) > 2.0E-5) {
            System.err.println("Precision loss at log(-Beta.cumulative(x, 0.5, 2200+, false, true))");
            success = false;
        }
        System.out.println("## dnorm(x) for \"large\" |x|");
        val = Normal.density(35.0 + Math.pow(3.0, -9.0), 0.0, 1.0, false);
        if (Math.abs(1.0 - val / 3.933395747534971E-267) >= 1.0E-15) {
            System.err.println(String.format("Precision loss at Normal.density(35+3^-9, 0, 1, false) %3.18g != 3.933395747534971e-267", val));
            success = false;
        }
        System.out.println("## pbeta(x, <small a>,<small b>, .., log):");
        double loghalf = Math.log(0.5);
        double pow2_60 = Math.pow(2.0, -60.0);
        double[] ldp = new double[25];
        i5 = 0;
        while (i5 < ldp.length) {
            ldp[i5] = Beta.cumulative(0.5, Math.pow(2.0, -91 - i5), pow2_60, true, true);
            ++i5;
        }
        ldp = VectorMath.diff(VectorMath.vlog(VectorMath.diff(ldp)));
        i5 = 0;
        while (i5 < ldp.length) {
            if (Math.abs(ldp[i5] - loghalf) >= 1.0E-9) {
                System.err.println(String.format("Precision loss %3.18g vs %3.18g", ldp[i5], loghalf));
                success = false;
            }
            ++i5;
        }
        System.out.println("## \"stair function\" effect (from denormalized numbers)");
        double[] dpx = new double[101];
        i = 0;
        while (i < 101) {
            dpx[i] = Beta.cumulative(0.9833 + (double)i * 1.0E-6, 43779.0, 0.06728, true, true);
            if (i == 0 && !VectorMath.isEqualScaled(dpx[0], -746.0986886924, 1.0E-12)) {
                System.err.println(String.format("Precision loss pbeta(.9833, 43779, 0.06728, true, true) = %3.18g vs -746.0986886924", dpx[0]));
                success = false;
            }
            ++i;
        }
        dpx = VectorMath.diff(dpx);
        i = 0;
        while (i < dpx.length) {
            if (dpx[i] <= 0.0445741 || dpx[i] >= 0.0445783) {
                System.err.println(String.format("Stair case detected %3.18g outside (0.0445741, 0.0445783) range", dpx[i]));
                success = false;
            }
            ++i;
        }
        dpx = VectorMath.diff(dpx);
        i = 0;
        while (i < dpx.length) {
            if (dpx[i] <= -4.2E-8 || dpx[i] >= -4.18E-8) {
                System.err.println(String.format("Stair case detected %3.18g outside (-4.2e-8, -4.18e-8) range", dpx[i]));
                success = false;
            }
            ++i;
        }
        System.out.println("## Infinite loop check");
        long time1 = System.currentTimeMillis();
        double p0 = Beta.cumulative(0.9999, 1.0E30, 1.001, true, true);
        long cB = (long)Math.max(0.001, (double)(System.currentTimeMillis() - time1));
        time1 = System.currentTimeMillis();
        double p1 = Beta.cumulative(0.999999999, 1.0E30, 1.001, true, true);
        long c32 = System.currentTimeMillis() - time1;
        time1 = System.currentTimeMillis();
        double p2 = Beta.cumulative(0.999999999999, 1.0E30, 1.001, true, true);
        long c2 = System.currentTimeMillis() - time1;
        if (!VectorMath.isEqualScaled(p0, -1.000050003333E26, 1.0E-10)) {
            System.err.println(String.format("Beta.cumulative(.9999, 1e30, 1.001, true, true) = %3.18g != -1.000050003333e26", p0));
            success = false;
        }
        if (!VectorMath.isEqualScaled(p1, -1.0E-21, 1.0E-6)) {
            System.err.println(String.format("Beta.cumulative(1 - 1e-9, 1e30, 1.001, true, true) = %3.18g != -1e21", p1));
            success = false;
        }
        if (!VectorMath.isEqualScaled(p2, -9.9997788E17, 1.0E-14)) {
            System.err.println(String.format("Beta.cumulative(1 - 1e-12, 1e30, 1.001, true, true) = %3.18g != -9.9997788e17", p2));
            success = false;
        }
        if (c32 > 1000L * cB || c2 > 1000L * cB) {
            System.err.println("Near infinite loop when computing Beta cumulative with x close to 1, huge alpha, and beta near to 1");
            success = false;
        }
        System.out.println("## pbinom(), dbinom(), dhyper(),.. : R allows \"almost integer\" n");
        double[] arr = Utilities.sample_int(10000, 1000);
        i = 0;
        while (i < arr.length) {
            double[] n11 = VectorMath.vtimes(arr[i] / 100.0, VectorMath.vpow(10.0, Utilities.colon(2, 20)));
            int j = 0;
            while (j < n11.length) {
                val = Binomial.density(1.0, n11[j], 0.5, false);
                if (Double.isNaN(val)) {
                    System.err.println(String.format("NaN detected in Binomial.density(1, %g, 0.5, false)", n11[j]));
                    success = false;
                }
                if (Double.isNaN(val = Binomial.cumulative(1.0, n11[j], 0.5, true, false))) {
                    System.err.println(String.format("NaN detected in Binomial.cumulative(1, %g, 0.5, true, false)", n11[j]));
                    success = false;
                }
                if (Double.isNaN(val = Poisson.density(n11[j], n11[j], false))) {
                    System.err.println(String.format("NaN detected in Poisson.density(%g, %g, false)", n11[j], n11[j]));
                    success = false;
                }
                if (Double.isNaN(val = HyperGeometric.density(n11[j] + 1.0, n11[j] + 5.0, n11[j] + 5.0, n11[j], false))) {
                    System.err.println(String.format("NaN detected in HyperGeometric.density(%g, %g, %g, %g, false)", n11[j] + 1.0, n11[j] + 5.0, n11[j] + 5.0, n11[j]));
                    success = false;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("## check was too tight for large n in R <= 3.1.0 (PR#15734)");
        System.out.println("## [dpqr]beta(*, a,b) where a and/or b are Inf");
        if (Beta.cumulative(0.1, Double.POSITIVE_INFINITY, 40.0, true, false) != 0.0) {
            System.err.println("Beta.cumulative(.1, Inf, 40, true, false) != 0");
            success = false;
        }
        if (Beta.cumulative(0.5, 40.0, Double.POSITIVE_INFINITY, true, false) != 1.0) {
            System.err.println("Beta.cumulative(.5, 40, Inf, true, false) != 1");
            success = false;
        }
        if (Beta.cumulative(0.4, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, true, false) != 0.0) {
            System.err.println("Beta.cumulative(.5, Inf, Inf, true, false) != 0");
            success = false;
        }
        if (Beta.cumulative(0.5, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, true, false) != 1.0) {
            System.err.println("Beta.cumulative(.5, Inf, Inf, true, false) != 1");
            success = false;
        }
        if (Beta.quantile(0.9, Double.POSITIVE_INFINITY, 100.0, true, false) != 1.0) {
            System.err.println("Beta.quantile(.9, Inf, 100, true, false) != 1");
            success = false;
        }
        if (Beta.quantile(0.1, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, true, false) != 0.5) {
            System.err.println("Beta.quantile(.1, Inf, Inf, true, false) != 0.5");
            success = false;
        }
        System.out.println("## range check (in \"close\" cases):");
        double[] c32 = VectorMath.vpow(-2.0, Utilities.c(-10, -100, -1000));
        int j = c32.length;
        int n11 = 0;
        while (n11 < j) {
            double v = c32[n11];
            if (!Double.isNaN(Beta.quantile(v, 2.0, 3.0, true, true))) {
                System.err.println(String.format("Beta.quantile(%3.18g, 2, 3, true, true) != NaN", v));
                success = false;
            }
            ++n11;
        }
        c32 = Utilities.c(-0.1, -1.0E-300, 1.25);
        j = c32.length;
        n11 = 0;
        while (n11 < j) {
            double v = c32[n11];
            if (!Double.isNaN(Beta.quantile(v, 2.0, 3.0, true, false))) {
                System.err.println(String.format("Beta.quantile(%3.18g, 2, 3, true, false) != NaN", v));
                success = false;
            }
            ++n11;
        }
        System.out.println("## lognormal boundary case sdlog = 0:");
        int i6 = 0;
        while (i6 <= 8) {
            double v2;
            double p = (double)i6 / 8.0;
            int mean = i6 % 2 == 0 ? 1 : 2;
            double v1 = LogNormal.quantile(p, mean, 0.0, true, false);
            if (!DebugFun.isEqual(v1, v2 = LogNormal.quantile(p, mean, 1.0E-200, true, false))) {
                System.err.println(String.format("LogNormal.quantile(%3.4g, %d, 0, true, false) %3.18g != %3.18g LogNormal.quantile(%3.4g, %d, 0, true, false)", p, mean, v1, v2, p, mean));
                success = false;
            }
            ++i6;
        }
        i6 = -10;
        while (i6 <= 10) {
            val = LogNormal.density(Math.pow(2.0, i6), 0.0, 0.0, false);
            if (i6 == 0) {
                if (val != Double.POSITIVE_INFINITY) {
                    System.err.println(String.format("LogNormal.density(1, 0, 0, false) %3.18g != Inf", val));
                    success = false;
                }
            } else if (val != 0.0) {
                System.err.println(String.format("LogNormal.density(%3.18g, 0, 0, false) %3.18g != 0", Math.pow(2.0, i6), val));
                success = false;
            }
            ++i6;
        }
        System.out.println("## qbeta(*, a,b) when  a,b << 1 : can easily fail");
        System.out.println(Beta.quantile(Math.pow(2.0, -28.0), 0.125, Math.pow(2.0, -26.0), true, false));
        double a4 = 0.125;
        double oldp = 0.0;
        int i7 = 4;
        while (i7 <= 200) {
            double b3 = Math.pow(2.0, -i7);
            double alpha = b3 / 4.0;
            double qq = Beta.quantile(alpha, a4, b3, true, false);
            double pp = Beta.cumulative(qq, a4, b3, true, false);
            if (pp <= 0.0 || i7 > 4 && pp - oldp >= 0.0 || Math.abs(1.0 - pp / alpha) >= 4.0E-15) {
                System.err.println(String.format("b = %3.18g, alpha = %3.18g, Beta.quantile(alpha, 0.125, b, true, false) %3.18g != Beta.cumulative(%3.18g, 0.125, b, true, false) %3.18g", b3, alpha, qq, qq, pp));
                System.err.println(String.format("diff(pp) = %3.18g", pp - oldp));
                success = false;
            }
            oldp = pp;
            ++i7;
        }
        System.out.println("## orig. qbeta() using *many* Newton steps; case where we \"know the truth\"");
        x = VectorMath.vpow(2.0, Utilities.c(-3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -100, -200, -250, -300, -400, -500, -600, -700, -800, -900, -1000));
        double[] pb = new double[]{-40.758879727176655, -57.757406344118365, -74.92878780181198, -92.18062446368936, -109.47131824852443, -126.78111192394739, -144.10037504281453, -161.4243529615446, -178.75068332490915, -196.07818867489516, -213.40628120965798, -230.73466725972438, -248.06320004817744, -1721.0008120167956, -3453.868763416659, -4320.302739116591, -5186.736714816522, -6919.604666216385, -8652.47261761625, -10385.340569016113, -12118.208520415976, -13851.076471815839, -15583.944423215702, -17316.812374615565};
        i = 0;
        while (i < x.length) {
            double qp = Beta.quantile(pb[i], 25.0, 6.0, true, true);
            if (qp <= 0.0 || !VectorMath.isEqual(qp, x[i], 1.0E-15)) {
                System.err.println(String.format("Beta.quantile(%3.18g, 25, 6, true, true) = %3.18g <= 0 != %3.18g", pb[i], qp, x[i]));
                success = false;
            }
            ++i;
        }
        System.out.println("## qbeta(), PR#15755");
        double qp = Beta.quantile(0.6948886, 0.0672788, 226390.0, true, false);
        if (qp >= 2.0E-8 || !DebugFun.isEqual(0.6948886, val = Beta.cumulative(qp, 0.0672788, 226390.0, true, false))) {
            System.err.println(String.format("Beta.quantile(0.6948886, 0.0672788, 226390, true, false) = %3.18g", qp));
            System.err.println(String.format("Beta.cumulative(%3.18g, 0.0672788, 226390, true, false) = %3.18g != 0.6948886", qp, val));
            success = false;
        }
        System.out.println("## less extreme example, same phenomenon:");
        double a5 = 43779.0;
        double b4 = 0.06728;
        qp = Beta.quantile(0.695, b4, a5, true, false);
        val = Beta.cumulative(qp, b4, a5, true, false);
        if (!DebugFun.isEqual(0.695, val)) {
            System.err.println(String.format("Beta.quantile(0.695, 0.06728, 43779, true, false) = %3.18g", qp));
            System.err.println(String.format("Beta.cumulative(%3.18g, 0.06728, 43779, true, false) = %3.18g != 0.695", qp, val));
            success = false;
        }
        x = VectorMath.vmin(VectorMath.vexp(Utilities.seq(0.0, 14.0, Math.pow(2.0, -9.0))));
        double[] qx = new double[x.length];
        double[] pqx = new double[x.length];
        long time12 = System.currentTimeMillis();
        int i8 = 0;
        while (i8 < x.length) {
            qx[i8] = Beta.quantile(x[i8], a5, b4, true, true);
            ++i8;
        }
        long c1 = System.currentTimeMillis() - time12;
        int i9 = 0;
        while (i9 < x.length) {
            pqx[i9] = Beta.cumulative(qx[i9], a5, b4, true, true);
            ++i9;
        }
        success &= DebugFun.printAllEqualScaled(x, pqx, 2.0E-15);
        System.out.println("## note that qx[x > -exp(2)] is too close to 1 to get full accuracy:");
        System.out.println("## i2 <- x > -exp(2); all.equal(x[i2], pqx[i2], tol= 0)#-> 5.849e-12");
        System.out.println("System time = " + (double)c1 / 1000.0);
        System.out.println("## was Inf, and much slower, for R <= 3.1.0");
        double[] x3 = VectorMath.vdiv(Utilities.colon(-15450.0, -15700.0), Math.pow(2.0, 11.0));
        double[] pq3 = new double[x3.length];
        int i10 = 0;
        while (i10 < x3.length) {
            pq3[i10] = Beta.cumulative(Beta.quantile(x3[i10], a5, b4, true, true), a5, b4, true, true);
            ++i10;
        }
        double[] vv = VectorMath.vabs(VectorMath.vmin(pq3, x3));
        double vmean = VectorMath.mean(vv);
        double vmax = VectorMath.max(vv);
        if (vmean >= 4.0E-12 || vmax >= 8.0E-12) {
            System.err.println(String.format("Mean(pq3 - x3) = %3.18g, Max(pq3 - x3) = %3.18g", vmean, vmax));
            success = false;
        }
        i = 1;
        while (i <= 323) {
            double lp2 = -Math.pow(10.0, -i);
            double qq = Beta.quantile(lp2, 0.2, 0.03, true, true);
            if (1.0 - qq >= 1.0E-15) {
                System.err.println(String.format("1 - Beta.quantile(%3.18g, 0.2, 0.03, true, true) = %3.18g > 1e-15", lp2, 1.0 - qq));
                success = false;
            }
            ++i;
        }
        System.out.println("# warnings in R <= 3.1.0");
        val = Beta.quantile(0.5, 2.0, 3.0, true, true);
        if (!Double.isNaN(val)) {
            System.err.println(String.format("Beta.quantile(0.5, 2, 3, true, true) = %3.18g != NaN", val));
            success = false;
        }
        if (!Double.isNaN(val = Beta.quantile(-0.1, 2.0, 3.0, true, false))) {
            System.err.println(String.format("Beta.quantile(-0.1, 2, 3, true, false) = %3.18g != NaN", val));
            success = false;
        }
        if (!Double.isNaN(val = Beta.quantile(1.25, 2.0, 3.0, true, false))) {
            System.err.println(String.format("Beta.quantile(1.25, 2, 3, true, false) = %3.18g != NaN", val));
            success = false;
        }
        System.out.println("# typically qq == 1  exactly");
        System.out.println("## failed in intermediate versions");
        a = Math.pow(2.0, -8.0);
        int i11 = 200;
        while (i11 <= 500) {
            double d2;
            double b5 = Math.pow(2.0, i11);
            double pq = Beta.cumulative(Beta.quantile(0.125, a, b5, true, false), a, b5, true, false);
            val = Math.abs(pq - 0.125);
            if (d2 > 0.125) {
                System.err.println(String.format("|Beta.cumulative(Beta.quantile(1.0/8, 2^-8, %3.18g, true, false), 2^-8, %3.18g, true, false) -1/8| = %3.18g > 1/8", b5, b5, val));
                success = false;
            }
            ++i11;
        }
        System.out.println("## whereas  qbeta() would underflow to 0 \"too early\", for R <= 3.1.0");
        System.out.println("#");
        System.out.println("## very extreme tails on both sides");
        double[] dArray9 = Utilities.c(1.0E-300, 1.0E-12, 1.0E-5, 0.1, 0.21, 0.3);
        int pq = dArray9.length;
        int n12 = 0;
        while (n12 < pq) {
            double xx = dArray9[n12];
            val = Beta.quantile(xx, Math.pow(2.0, -12.0), Math.pow(2.0, -10.0), true, false);
            if (val != 0.0) {
                System.err.println(String.format("Beta.quantile(%3.18g, 2^-12, 2^-19, true, false) = %3.18g != 0", xx, val));
                success = false;
            }
            ++n12;
        }
        double[] ax = VectorMath.vpow(10.0, Utilities.colon(-8, -323));
        i = 0;
        while (i < ax.length) {
            val = Beta.quantile(0.95, ax[i], 20.0, true, false);
            if (MathFunctions.isInfinite(val) || val >= 1.0E-300) {
                System.err.println(String.format("Beta.quantile(0.95, %3.18g, 20, true, false) = %3.18g >= 1e-300", ax[i], val));
                success = false;
            }
            ++i;
        }
        long time13 = System.currentTimeMillis();
        i = 0;
        while (i < ax.length) {
            val = Beta.quantile(0.95, ax[i], ax[i], true, false);
            if (val != 1.0) {
                System.err.println(String.format("Beta.quantile(0.95, %3.18g, %3.18g, true, false) = %3.18g != 1", ax[i], ax[i], val));
                success = false;
            }
            ++i;
        }
        long ct2 = System.currentTimeMillis() - time13;
        System.out.println("System time = " + (double)ct2 / 1000.0);
        return success;
    }

    @Test
    public static final boolean test_dkwtest() {
        boolean success = true;
        System.out.println("DKW test");
        System.out.println("Binomial");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Binomial(1.0, 0.2)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Binomial(2.0, 0.2)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Binomial(100.0, 0.2)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Binomial(10000.0, 0.2)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Binomial(1.0, 0.8)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Binomial(100.0, 0.8)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Binomial(100.0, 0.999)));
        System.out.println("Poisson");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Poisson(0.095)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Poisson(0.95)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Poisson(9.5)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Poisson(95.0)));
        System.out.println("Negative Binomial");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new NegBinomial(1.0, 0.2)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new NegBinomial(2.0, 0.2)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new NegBinomial(100.0, 0.2)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new NegBinomial(10000.0, 0.2)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new NegBinomial(1.0, 0.8)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new NegBinomial(100.0, 0.8)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new NegBinomial(100.0, 0.999)));
        System.out.println("Normal");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Normal()));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Normal(5.0, 3.0)));
        System.out.println("Gamma");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Gamma(0.1, 1.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Gamma(0.2, 1.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Gamma(10.0, 1.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Gamma(20.0, 1.0)));
        System.out.println("Hypergeometric");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new HyperGeometric(40.0, 30.0, 20.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new HyperGeometric(40.0, 3.0, 20.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new HyperGeometric(6.0, 3.0, 2.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new HyperGeometric(5.0, 3.0, 2.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new HyperGeometric(4.0, 3.0, 2.0)));
        System.out.println("SignRank");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new SignRank(1)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new SignRank(2)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new SignRank(10)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new SignRank(30)));
        System.out.println("Wilcoxon");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Wilcoxon(40, 30)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Wilcoxon(40, 10)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Wilcoxon(6, 3)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Wilcoxon(5, 3)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Wilcoxon(4, 3)));
        System.out.println("ChiSquare");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new ChiSquare(1.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new ChiSquare(10.0)));
        System.out.println("Logistic");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Logistic()));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Logistic(4.0, 2.0)));
        System.out.println("T");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new T(1.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new T(10.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new T(40.0)));
        System.out.println("Beta");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Beta(1.0, 1.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Beta(2.0, 1.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Beta(1.0, 2.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Beta(2.0, 2.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Beta(0.2, 0.2)));
        System.out.println("Cauchy");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Cauchy()));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Cauchy(4.0, 2.0)));
        System.out.println("F");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new F(1.0, 1.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new F(1.0, 10.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new F(10.0, 10.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new F(30.0, 3.0)));
        System.out.println("Weibull");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Weibull(1.0, 1.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new Weibull(4.0, 4.0)));
        System.out.println("## regression test for PR#7314");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new HyperGeometric(60.0, 100.0, 50.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new HyperGeometric(6.0, 10.0, 5.0)));
        success &= DebugFun.printBool(TestDPQR.dkwtest(new HyperGeometric(600.0, 1000.0, 500.0)));
        System.out.println("## regression test for non-central t bug");
        success &= DebugFun.printBool(TestDPQR.dkwtest(new NonCentralT(20.0, 3.0)));
        System.out.println("## regression test for non-central F bug");
        return success &= DebugFun.printBool(TestDPQR.dkwtest(new NonCentralF(10.0, 2.0, 3.0)));
    }

    @Test
    public static final boolean test_disttest() {
        boolean success = true;
        double[] ramsay = new double[]{111.0, 107.0, 100.0, 99.0, 102.0, 106.0, 109.0, 108.0, 104.0, 99.0, 101.0, 96.0, 97.0, 102.0, 107.0, 113.0, 116.0, 113.0, 110.0, 98.0};
        double[] jung_parekh = new double[]{107.0, 108.0, 106.0, 98.0, 105.0, 103.0, 110.0, 105.0, 104.0, 100.0, 96.0, 108.0, 103.0, 104.0, 114.0, 114.0, 113.0, 108.0, 106.0, 99.0};
        System.out.println("Ansari-Bradley Test");
        double[] result = DistributionTest.ansari_bradley_test(ramsay, jung_parekh, true);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(185.5, result[0]) && DebugFun.isEqual(0.18668552840821545, result[1]));
        System.out.println("Mood Test");
        result = DistributionTest.mood_test(ramsay, jung_parekh);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(1.0371275614960966, result[0]) && DebugFun.isEqual(0.2996764118570592, result[1]));
        double[] x = new double[]{1.83, 0.5, 1.62, 2.48, 1.68, 1.88, 1.55, 3.06, 1.3};
        double[] y = new double[]{0.878, 0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29};
        System.out.println("One-sample Wilcoxon Test");
        result = DistributionTest.wilcoxon_test(x, 0.0, true, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(45.0, result[0]) && DebugFun.isEqual(0.00390625, result[1]));
        System.out.println("Paired Mann-Whitney-U Test");
        result = DistributionTest.mann_whitney_u_test(x, y, 0.0, true, true, TestKind.GREATER);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(45.0, result[0]) && DebugFun.isEqual(0.001953125, result[1]));
        System.out.println("Two-sample Mann-Whitney-U Test");
        x = new double[]{0.8, 0.83, 1.89, 1.04, 1.45, 1.38, 1.91, 1.64, 0.73, 1.46};
        y = new double[]{1.15, 0.88, 0.9, 0.74, 1.21};
        result = DistributionTest.mann_whitney_u_test(x, y, 0.0, true, false, TestKind.GREATER);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(35.0, result[0]) && DebugFun.isEqual(0.1272061272061272, result[1]));
        System.out.println("Var Test");
        x = new double[]{-0.0059152854391573036, -1.9950493584157172, -1.7710517694817225, 0.5288625402887255, 2.066390112695047, 0.7320344587152663, 1.8734929767683433, 0.217908094524044, 2.422614245474107, -0.20199683115622274, -0.16679743345128284, 1.3527991017152763, 1.7358295678859121, 4.9763152421276, 0.8179625388060164, -0.28876556355263616, 0.1983413319843172, -0.9592436326403222, 1.8732919575310574, 3.4399055493782478, -1.7548551178871183, 1.648422551214855, 1.705558268988422, 1.8620127419877357, -3.6821232011085967, -3.0237990466348665, -2.1192121020310175, -1.8779454652496803, 0.021422471409252474, 3.121802213185541, -2.644542898146826, 2.673253669524355, 2.4974159287824924, 2.825257305101089, 1.5502907975877238, -1.4210351012132723, 1.1094152610219539, 1.9904237245687821, -2.1443073941976376, 2.5147956761762114, 1.7385122356798244, -0.054011218862757476, 1.1647521711578286, -0.5514982320658219, 1.0044292167384754, -0.49151298333795346, 4.977208786370868, -1.8204483596595527, -1.5567259980886476, 0.8420680350214259};
        y = new double[]{-0.023194140472165614, 1.4281220311699832, 2.7803555866267358, 0.8423873685131945, 0.6153979643142353, 1.7155294101667198, 1.7707214777523763, 0.12624694819671645, -0.27848375048233653, 1.5478312280249797, -0.5680164593480082, 0.5357179604790032, 0.8482273496325224, 2.284973376732967, 0.6152147019912435, 0.030012371726727993, 0.8150918187609034, 2.535170571801845, 2.232098069877867, 0.1569715957206057, 2.5105677876545407, 0.18615657506666772, 0.6123666074302951, 2.251588754996834, 2.4824958905680896, 1.2348559933048555, 1.485982046515017, 2.5926499045098943, 1.1142957295892957, 0.3105760796473992};
        result = DistributionTest.var_test(x, y, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(4.092220946951347, result[0]) && DebugFun.isEqual(1.2389663026679543E-4, result[1]));
        System.out.println("Two-sample T Test");
        x = Utilities.colon(1.0, 10.0);
        y = Utilities.colon(7.0, 20.0);
        result = DistributionTest.t_test(x, y, 0.0, false, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(-5.4349297638940595, result[0]) && DebugFun.isEqual(1.8552818325118112E-5, result[1]));
        result = DistributionTest.t_test(x, Utilities.c(new double[][]{y, {200.0}}), 0.0, false, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(-1.6329026332012053, result[0]) && DebugFun.isEqual(0.12451349808974531, result[1]));
        x = new double[]{0.7, -1.6, -0.2, -1.2, -0.1, 3.4, 3.7, 0.8, 0.0, 2.0};
        y = new double[]{1.9, 0.8, 1.1, 0.1, -0.1, 4.4, 5.5, 1.6, 4.6, 3.4};
        result = DistributionTest.t_test(x, y, 0.0, false, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(-1.860813467486853, result[0]) && DebugFun.isEqual(0.07939414018735817, result[1]));
        System.out.println("Paired T Test");
        result = DistributionTest.t_test_paired(x, y, 0.0, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(-4.062127683382037, result[0]) && DebugFun.isEqual(0.00283289019738427, result[1]));
        System.out.println("Two-sample T Test");
        result = DistributionTest.t_test(x, y, 0.0, true, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(-1.860813467486853, result[0]) && DebugFun.isEqual(0.07918671421593818, result[1]));
        System.out.println("Bartlett Test");
        x = new double[]{10.0, 7.0, 20.0, 14.0, 14.0, 12.0, 10.0, 23.0, 17.0, 20.0, 14.0, 13.0, 11.0, 17.0, 21.0, 11.0, 16.0, 14.0, 17.0, 17.0, 19.0, 21.0, 7.0, 13.0, 0.0, 1.0, 7.0, 2.0, 3.0, 1.0, 2.0, 1.0, 3.0, 0.0, 1.0, 4.0, 3.0, 5.0, 12.0, 6.0, 4.0, 3.0, 5.0, 5.0, 5.0, 5.0, 2.0, 4.0, 3.0, 5.0, 3.0, 5.0, 3.0, 6.0, 1.0, 1.0, 3.0, 2.0, 6.0, 4.0, 11.0, 9.0, 15.0, 22.0, 15.0, 16.0, 13.0, 10.0, 26.0, 26.0, 24.0, 13.0};
        int[] g = Utilities.rep_each(Utilities.colon(1, 6), 12);
        result = DistributionTest.bartlett_test(x, g);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqualScaled(25.959825320368687, result[0]) && DebugFun.isEqualScaled(9.085122332945314E-5, result[1]));
        System.out.println("Fligner Test");
        result = DistributionTest.fligner_test(x, g);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(VectorMath.isEqual(14.482781038458608, result[0], 1.0E-12) && VectorMath.isEqual(0.012816779189709193, result[1], 1.0E-12));
        System.out.println("Kruskal-Wallis Test");
        x = new double[]{2.9, 3.0, 2.5, 2.6, 3.2, 3.8, 2.7, 4.0, 2.4, 2.8, 3.4, 3.7, 2.2, 2.0};
        g = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3};
        result = DistributionTest.kruskal_wallis_test(x, g);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(0.7714285714285722, result[0]) && DebugFun.isEqual(0.6799647735788936, result[1]));
        System.out.println("Poisson Test");
        result = DistributionTest.poisson_test(137, 24.19893, 1.0, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(137.0, result[0]) && DebugFun.isEqual(2.845227264114483E-56, result[1]));
        result = DistributionTest.poisson_test(11, 21, 800.0, 3011.0, 1.0, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        success &= DebugFun.printBool(DebugFun.isEqual(11.0, result[0]) && DebugFun.isEqual(0.07966863303332952, result[1]));
        System.out.println("Binomial Test");
        result = DistributionTest.binomial_test(682, 925, 0.75, TestKind.TWO_SIDED);
        System.out.println(result[0]);
        System.out.println(result[1]);
        return success &= DebugFun.printBool(DebugFun.isEqual(682.0, result[0]) && DebugFun.isEqual(0.3824915595748519, result[1]));
    }

    static final void test_diptest() {
        double[] statfaculty = new double[]{30.0, 33.0, 35.0, 36.0, 37.0, 37.0, 39.0, 39.0, 39.0, 39.0, 39.0, 40.0, 40.0, 40.0, 40.0, 41.0, 42.0, 43.0, 43.0, 43.0, 44.0, 44.0, 45.0, 45.0, 46.0, 46.0, 47.0, 47.0, 48.0, 48.0, 48.0, 49.0, 50.0, 50.0, 51.0, 52.0, 52.0, 53.0, 53.0, 53.0, 53.0, 53.0, 54.0, 54.0, 57.0, 57.0, 59.0, 60.0, 60.0, 60.0, 61.0, 61.0, 61.0, 61.0, 62.0, 62.0, 62.0, 62.0, 63.0, 66.0, 70.0, 72.0, 72.0};
        double[] x = DistributionTest.diptest(statfaculty);
        System.out.println(x[0]);
        System.out.println(x[1]);
        x = DistributionTest.diptest(Utilities.c(1.0, 1.0, 2.0, 2.0));
        System.out.println(x[0]);
        x = DistributionTest.diptest(Utilities.c(0.0, 2.0, 3.0, 5.0, 6.0));
        System.out.println(x[0]);
        x = DistributionTest.diptest(Utilities.c(6.0, 4.0, 3.0, 1.0, 0.0));
        System.out.println(x[0]);
        x = new double[]{3.6, 1.8, 3.333, 2.283, 4.533, 2.883, 4.7, 3.6, 1.95, 4.35, 1.833, 3.917, 4.2, 1.75, 4.7, 2.167, 1.75, 4.8, 1.6, 4.25, 1.8, 1.75, 3.45, 3.067, 4.533, 3.6, 1.967, 4.083, 3.85, 4.433, 4.3, 4.467, 3.367, 4.033, 3.833, 2.017, 1.867, 4.833, 1.833, 4.783, 4.35, 1.883, 4.567, 1.75, 4.533, 3.317, 3.833, 2.1, 4.633, 2.0, 4.8, 4.716, 1.833, 4.833, 1.733, 4.883, 3.717, 1.667, 4.567, 4.317, 2.233, 4.5, 1.75, 4.8, 1.817, 4.4, 4.167, 4.7, 2.067, 4.7, 4.033, 1.967, 4.5, 4.0, 1.983, 5.067, 2.017, 4.567, 3.883, 3.6, 4.133, 4.333, 4.1, 2.633, 4.067, 4.933, 3.95, 4.517, 2.167, 4.0, 2.2, 4.333, 1.867, 4.817, 1.833, 4.3, 4.667, 3.75, 1.867, 4.9, 2.483, 4.367, 2.1, 4.5, 4.05, 1.867, 4.7, 1.783, 4.85, 3.683, 4.733, 2.3, 4.9, 4.417, 1.7, 4.633, 2.317, 4.6, 1.817, 4.417, 2.617, 4.067, 4.25, 1.967, 4.6, 3.767, 1.917, 4.5, 2.267, 4.65, 1.867, 4.167, 2.8, 4.333, 1.833, 4.383, 1.883, 4.933, 2.033, 3.733, 4.233, 2.233, 4.533, 4.817, 4.333, 1.983, 4.633, 2.017, 5.1, 1.8, 5.033, 4.0, 2.4, 4.6, 3.567, 4.0, 4.5, 4.083, 1.8, 3.967, 2.2, 4.15, 2.0, 3.833, 3.5, 4.583, 2.367, 5.0, 1.933, 4.617, 1.917, 2.083, 4.583, 3.333, 4.167, 4.333, 4.5, 2.417, 4.0, 4.167, 1.883, 4.583, 4.25, 3.767, 2.033, 4.433, 4.083, 1.833, 4.417, 2.183, 4.8, 1.833, 4.8, 4.1, 3.966, 4.233, 3.5, 4.366, 2.25, 4.667, 2.1, 4.35, 4.133, 1.867, 4.6, 1.783, 4.367, 3.85, 1.933, 4.5, 2.383, 4.7, 1.867, 3.833, 3.417, 4.233, 2.4, 4.8, 2.0, 4.15, 1.867, 4.267, 1.75, 4.483, 4.0, 4.117, 4.083, 4.267, 3.917, 4.55, 4.083, 2.417, 4.183, 2.217, 4.45, 1.883, 1.85, 4.283, 3.95, 2.333, 4.15, 2.35, 4.933, 2.9, 4.583, 3.833, 2.083, 4.367, 2.133, 4.35, 2.2, 4.45, 3.567, 4.5, 4.15, 3.817, 3.917, 4.45, 2.0, 4.283, 4.767, 4.533, 1.85, 4.25, 1.983, 2.25, 4.75, 4.117, 2.15, 4.417, 1.817, 4.467};
        x = DistributionTest.diptest(x);
        System.out.println(x[0]);
        System.out.println(x[1]);
        x = new double[]{67.0, 54.7, 7.0, 48.5, 14.0, 17.2, 20.7, 13.0, 43.4, 40.2, 38.9, 54.5, 59.8, 48.3, 22.9, 11.5, 34.4, 35.1, 38.7, 30.8, 30.6, 43.1, 56.8, 40.8, 41.8, 42.5, 31.0, 31.7, 30.2, 25.9, 49.2, 37.0, 35.9, 15.0, 30.2, 7.2, 36.2, 45.5, 7.8, 33.4, 36.1, 40.2, 42.7, 42.5, 16.2, 39.0, 35.0, 37.0, 31.4, 37.6, 39.9, 36.2, 42.8, 46.4, 24.7, 49.1, 46.0, 35.9, 7.8, 48.2, 15.2, 32.5, 44.7, 42.6, 38.8, 17.4, 40.8, 29.1, 14.6, 59.2};
        x = DistributionTest.diptest(x);
        System.out.println(x[0]);
        System.out.println(x[1]);
    }

    static final void kstest_example() {
        double[] x = new double[]{1.160041688388212, -1.055476349265595, -1.3207242029566646, 0.23915046399456202, 0.1280372490607462, 0.05569133699728501, -0.8125002687519708, -0.2527056092320565, -0.1806423563283645, -1.688517367112071, 0.4520176594127373, -0.8223951418778523, -1.2843174602054348, -1.11673394115549, 0.3548467430335484, 0.6946971736333469, 0.8081483846581686, -0.2132882145279537, -1.2761468822702142, 0.7070114668756505, 0.507517339877647, 0.03272845258879652, 0.35783108099085625, 0.4420890029750776, -0.5206908244712504, -0.557631587177767, -0.4163315169619347, 0.267696024197844, -0.7498723403587779, -0.41904535934255055, 0.8925790614422582, -0.0719059745357396, 0.7330227975648881, -0.10734082387514077, 0.6940662960503111, -0.15263137425121245, -1.1967489516398724, 0.6675716786037661, -0.814948570182664, 0.8004093100578593, 0.8075496724237657, -1.5691692835222897, -1.3516738613760655, 1.1631878981801262, 0.2893620600005766, 0.5229049108151712, -0.057626055701180276, -0.1417637096612063, -0.37619927990739527, -1.067365580349716};
        double[] y = new double[]{0.40490121906623244, 0.24850796000100672, 0.1022286640945822, 0.6285310559906065, 0.6195512628182769, 0.28701157541945577, 0.9514963554684073, 0.010874098632484674, 0.6370721007697284, 0.6103827697224915, 0.0921065725851804, 0.6475813502911478, 0.4883203764911741, 0.1030736668035388, 0.864651667419821, 0.6877460014075041, 0.7625355611089617, 0.5201810055878013, 0.6166569679044187, 0.7778363111428916, 0.8987720855511725, 0.8358376433607191, 0.9225274042692035, 0.836997929494828, 0.3580999285914004, 0.590041151503101, 0.6085326359607279, 0.1356926434673369, 0.383456161711365, 0.9117110567167401};
        double[] p = DistributionTest.kolmogorov_smirnov_test(x, y);
        System.out.println(p[0]);
        System.out.println(p[1]);
        p = DistributionTest.kolmogorov_smirnov_test(x, new Normal());
        System.out.println(p[0]);
        System.out.println(p[1]);
    }

    static final void kstest_example2() {
        int n = 50000;
        double[] x = new double[n];
        double[] y = new double[n];
        int i = 0;
        while (i < n) {
            x[i] = random.nextDouble();
            y[i] = random.nextDouble();
            ++i;
        }
        long time1 = System.currentTimeMillis();
        System.out.println(DistributionTest.kolmogorov_smirnov_test(x, y)[1]);
        long time2 = System.currentTimeMillis();
        System.out.println("Time (Exact) = " + (time2 - time1));
        time1 = System.currentTimeMillis();
        System.out.println(DistributionTest.kolmogorov_smirnov_test(x, y, false)[1]);
        time2 = System.currentTimeMillis();
        System.out.println("Time (Inexact) = " + (time2 - time1));
    }

    static final void kstest_example3() {
        double[] x = new double[]{-0.4327256096589832, 0.8556666526274761, -0.5546375278179974, 1.866000905204401, -1.033452361074729, -1.5128029893029131, -0.8133759541734086, 0.687640682247052, 1.5419273795363184, -2.2295925458536794, 1.42558868046075, -2.3797684265098655, -0.46027673367988814, 0.4297141073628944, 1.0848742490404304, 1.9887805457720291, 0.5271399436789418, 2.1457932121313377, 0.17732741027681803, 0.5901870929879354, -0.7486019696536792, -1.4427382726841995, 0.9137934132833048, 0.5241007177131126, 0.5613852341528923, -1.3266402599057574, -1.323280288237919, 0.5814876355837048, 0.6308838159891056, 1.3385488233125724, -0.06834424563535381, -1.1671401628369862, 0.09379937639386121, 0.17521277521223777, -1.3168087117893892, -0.5244543795040156, 0.24032301793814181, 0.5426753659697515, 0.22182011780487396, 0.6737536223042431, 1.3402529813509523, -1.6817165954775795, -0.20353732094995078, -0.7690838029162941, 0.7984057628094654, 0.3943074921556351, 0.8177375877054202, -0.9211829231536616, 0.7630904005539952, 0.11572488935311727, 0.39220521737386826, -1.8541504624965093};
        double[] y = new double[]{-1.4429961932875182, -0.7818279436142089, -1.1966511647322804, 10.171962424735371, 11.327019721485414, 11.99503521664728, 10.952447325187496, 8.929430883277462};
        double[] p = DistributionTest.kolmogorov_smirnov_test(x, y);
        System.out.println(p[0]);
        System.out.println(p[1]);
        x = Utilities.c(-1.8008263, -0.3398806, 0.6062646, 1.3411303);
        y = Utilities.c(0.7672873, 2.1937257, 3.1405667, 2.0138648, 0.8946941);
        p = DistributionTest.kolmogorov_smirnov_test(x, y);
        System.out.println(p[0]);
        System.out.println(p[1]);
    }

    public static final void norm_test() {
        double[] x = new double[]{4281.099776, 4376.951826, 4378.025799, 4613.572586, 4666.54245, 4675.439476, 4709.961628, 4709.999973, 4709.999973, 4709.999973, 4743.40979, 4751.232853, 4756.295879, 4756.869617, 4779.386288, 4801.67123, 4802.705246, 4803.434021, 4810.069633, 4821.232853, 4824.875099, 4825.106827, 4825.183517, 4829.172607, 4832.31778, 4834.73423, 4845.282188, 4845.282188, 4845.282188, 4850.573738, 4851.417549, 4856.05867, 4859.320534, 4859.587456, 4859.587456, 4859.742439, 4865.570984, 4867.452042, 4869.830147, 4870.403885, 4870.403885, 4870.403885, 4870.904083, 4871.707947, 4871.939728, 4872.398376, 4873.664146, 4879.227371, 4879.801109, 4884.980827, 4893.839508, 4895.181915, 4897.214859, 4897.29155, 4897.521675, 4897.521675, 4897.521675, 4897.751801, 4897.751801, 4901.625748, 4908.186325, 4908.186325, 4913.671204, 4920.535393, 4929.05201, 4932.54245, 4935.841057, 4937.375298, 4941.401131, 4941.709602, 4942.591759, 4944.086052, 4945.735382, 4949.762764, 4950.261414, 4950.453194, 4950.531487, 4952.142418, 4952.257507, 4953.638313, 4953.86689, 4954.672356, 4954.672356, 4955.439476, 4958.891571, 4959.046555, 4959.545204, 4959.545204, 4961.386314, 4961.386314, 4961.386314, 4962.612083, 4965.105225, 4966.179214, 4966.180817, 4966.21756, 4966.255905, 4966.255905, 4966.831245, 4967.253204, 4967.86689, 4968.136963, 4968.136963, 4972.124451, 4972.124451, 4973.275078, 4973.46846, 4974.349068, 4976.30687, 4978.493141, 4980.02578, 4980.02578, 4980.524429, 4982.136963, 4982.904137, 4984.36158, 4988.619141, 4989.654785, 4991.916199, 4991.994492, 4992.684868, 4994.027382, 4994.257507, 4995.713455, 4996.135361, 4996.749046, 4998.783539, 5000.31778, 5000.623047, 5000.623047, 5000.624649, 5003.769821, 5005.302513, 5005.916199, 5005.916199, 5007.643768, 5007.643768, 5007.643768, 5009.138115, 5010.558868, 5010.558868, 5010.558868, 5010.673958, 5010.940826, 5011.019119, 5011.132607, 5011.477821, 5012.630104, 5012.630104, 5012.860283, 5012.860283, 5012.936974, 5013.088753, 5014.624649, 5015.545151, 5015.545151, 5015.736931, 5015.736931, 5016.310722, 5016.310722, 5016.694229, 5017.461403, 5017.461403, 5017.461403, 5017.461403, 5017.653183, 5017.959999, 5018.036743, 5018.036743, 5018.573738, 5019.340858, 5020.06958, 5020.06958, 5020.838303, 5020.838303, 5021.835602, 5023.483276, 5029.006607, 5029.85202, 5029.85202, 5029.85202, 5029.85202, 5029.888763, 5030.657486, 5031.194534, 5031.614784, 5031.614784, 5033.457497, 5033.457497, 5034.95179, 5034.95179, 5034.95179, 5034.991791, 5035.450439, 5035.450439, 5036.334251, 5038.020271, 5038.712303, 5038.942429, 5041.012062, 5041.473969, 5042.239487, 5042.239487, 5042.239487, 5043.812073, 5043.812073, 5043.812073, 5043.812073, 5044.694283, 5045.0411, 5045.079445, 5045.307968, 5045.307968, 5045.307968, 5045.307968, 5045.614838, 5047.342407, 5049.373695, 5051.253151, 5051.599968, 5052.020325, 5052.020325, 5052.020325, 5052.367088, 5052.82579, 5056.354523, 5061.762817, 5062.261414, 5062.76001, 5062.76001, 5063.527184, 5063.643822, 5063.643822, 5064.179214, 5064.946281, 5065.86689, 5066.175362, 5066.175362, 5066.442177, 5066.557266, 5066.750648, 5067.01757, 5067.554565, 5068.244942, 5068.398376, 5068.475121, 5069.587402, 5069.587402, 5070.239487, 5071.006607, 5071.008156, 5072.23558, 5072.23558, 5073.691528, 5073.691528, 5074.228523, 5075.879402, 5076.069633, 5076.069633, 5076.146324, 5076.146324, 5076.569832, 5077.030083, 5077.068481, 5077.068481, 5078.98468, 5079.866837, 5080.635559, 5080.827339, 5081.401131, 5081.784637, 5082.054764, 5082.858627, 5084.317833, 5084.317833, 5084.546303, 5084.89312, 5085.198387, 5085.85202, 5088.688828, 5089.647675, 5090.146271, 5092.257507, 5093.444931, 5093.636765, 5095.631256, 5095.823036, 5095.976471, 5095.976471, 5098.241089, 5099.044952, 5099.735329, 5100.387413, 5100.887611, 5103.647728, 5104.223015, 5104.76001, 5105.797203, 5105.797203, 5106.29425, 5106.29425, 5106.90799, 5107.138115, 5107.523224, 5107.599968, 5108.788994, 5108.827339, 5109.249245, 5109.287643, 5109.326042, 5109.823036, 5110.244995, 5111.050407, 5112.009361, 5112.009361, 5114.655884, 5116.305214, 5116.460251, 5116.460251, 5119.490387, 5119.834, 5121.675056, 5122.403885, 5123.824638, 5123.824638, 5124.129906, 5126.661392, 5126.853172, 5128.157288, 5129.499748, 5129.769875, 5130.997192, 5131.26577, 5132.991791, 5133.066879, 5134.104073, 5135.099716, 5137.784691, 5137.938072, 5137.938072, 5137.938072, 5137.938072, 5137.938072, 5137.938072, 5138.515068, 5139.242188, 5139.855873, 5140.124451, 5142.15889, 5143.0411, 5145.687622, 5145.687622, 5145.687622, 5146.683266, 5146.798409, 5146.915047, 5147.834, 5147.949036, 5147.949036, 5147.949036, 5149.216408, 5149.216408, 5150.328743, 5150.749046, 5150.749046, 5152.591705, 5152.668503, 5154.086052, 5156.120544, 5157.001152, 5157.998344, 5158.573738, 5158.688828, 5159.879456, 5159.879456, 5160.262962, 5160.991791, 5160.991791, 5160.991791, 5161.565475, 5161.603821, 5161.603821, 5162.716156, 5162.716156, 5162.946335, 5162.946335, 5162.946335, 5165.247696, 5165.247696, 5167.932617, 5168.201088, 5168.201088, 5169.046555, 5169.696983, 5170.003853, 5170.003853, 5170.003853, 5170.003853, 5170.003853, 5170.003853, 5170.005455, 5170.504051, 5170.694283, 5171.192879, 5171.192879, 5171.923256, 5172.191727, 5172.191727, 5173.419151, 5173.419151, 5173.419151, 5173.419151, 5174.032837, 5174.186272, 5174.186272, 5174.378105, 5174.531487, 5175.297005, 5175.490387, 5175.490387, 5178.213707, 5178.213707, 5178.865738, 5181.779236, 5181.779236, 5182.853172, 5184.389015, 5185.269623, 5185.423058, 5186.228523, 5187.570984, 5187.801109, 5189.297005, 5191.101372, 5191.521622, 5192.940826, 5193.938126, 5193.938126, 5194.13311, 5194.591759, 5194.591759, 5194.591759, 5196.277832, 5196.891571, 5199.65313, 5199.69313, 5199.69313, 5200.230125, 5200.230125, 5200.688774, 5202.798355, 5205.906784, 5206.212051, 5207.711151, 5207.711151, 5207.711151, 5208.206596, 5208.206596, 5208.246544, 5209.398827, 5209.437172, 5211.66024, 5212.772575, 5218.565979, 5218.677864, 5219.09977, 5220.827339, 5221.442627, 5221.442627, 5221.631203, 5223.130302, 5226.505653, 5230.109581, 5231.450386, 5232.717812, 5235.516167, 5236.706848, 5236.706848, 5236.706848, 5237.127151, 5238.124397, 5242.997246, 5242.997246, 5244.301361, 5244.45314, 5244.45314, 5244.953392, 5247.40979, 5247.830147, 5248.020271, 5250.209801, 5250.401581, 5251.207047, 5251.817581, 5252.434471, 5253.736931, 5255.961655, 5256.0, 5256.039948, 5256.039948, 5257.379204, 5261.02623, 5262.097015, 5262.44223, 5265.322136, 5265.437225, 5266.086052, 5266.394524, 5267.505203, 5267.505203, 5267.505203, 5268.772575, 5269.041046, 5269.194481, 5270.421906, 5270.421906, 5270.421906, 5271.149078, 5274.986282, 5274.986282, 5274.986282, 5274.986282, 5280.354523, 5281.736877, 5283.349518, 5285.495895, 5285.495895, 5287.453644, 5287.798859, 5288.911194, 5290.138565, 5290.982376, 5291.059174, 5292.706848, 5293.857529, 5294.31778, 5295.506805, 5295.506805, 5296.005402, 5296.504105, 5297.61644, 5297.961548, 5299.535843, 5302.142471, 5302.485977, 5302.485977, 5302.792953, 5306.094711, 5306.668396, 5307.242188, 5308.125946, 5308.70134, 5308.893173, 5308.971466, 5308.971466, 5311.501297, 5311.808167, 5312.345215, 5313.073883, 5313.380859, 5313.380859, 5315.490387, 5316.410889, 5316.449234, 5316.679413, 5318.597214, 5320.975266, 5320.975266, 5321.35733, 5322.816376, 5323.391769, 5325.462952, 5325.462952, 5326.690323, 5327.919403, 5328.301361, 5329.490387, 5329.605423, 5330.027435, 5330.027435, 5331.214859, 5332.979172, 5333.861328, 5334.286545, 5335.360428, 5335.704041, 5338.007111, 5338.007111, 5338.695831, 5339.347916, 5339.883255, 5341.187424, 5341.417603, 5341.417603, 5341.417603, 5344.564377, 5345.064575, 5347.286041, 5348.476669, 5350.546356, 5351.314972, 5351.928818, 5352.007111, 5353.769821, 5353.769821, 5354.345215, 5356.071182, 5359.908386, 5362.821884, 5363.35733, 5366.080597, 5366.809372, 5370.339706, 5373.444931, 5373.444931, 5373.444931, 5374.828995, 5375.17421, 5375.554459, 5379.008209, 5379.0849, 5384.913391, 5384.913391, 5384.953445, 5385.14357, 5385.22197, 5385.29866, 5385.491989, 5385.79715, 5391.012115, 5391.013718, 5393.813675, 5393.813675, 5394.427307, 5395.311172, 5397.495789, 5398.683319, 5398.723267, 5400.219162, 5400.219162, 5400.3358, 5402.290344, 5402.290344, 5403.822983, 5406.584595, 5409.731476, 5410.345215, 5412.14798, 5415.406586, 5416.098511, 5427.450333, 5428.18071, 5436.464157, 5436.810974, 5436.964355, 5439.687622, 5439.687622, 5439.687622, 5439.687622, 5439.687622, 5439.687622, 5443.636658, 5450.425812, 5450.425812, 5454.109528, 5454.146378, 5454.14798, 5454.14798, 5455.52713, 5455.835602, 5459.401184, 5464.887665, 5464.887665, 5464.887665, 5468.606522, 5468.913391, 5469.145172, 5470.794556, 5471.369736, 5483.528732, 5486.060165, 5499.139664, 5500.597214, 5502.361633, 5503.318878, 5518.469559, 5526.142471, 5526.142471, 5528.212051, 5528.212051, 5528.250397, 5536.038345, 5536.038345, 5536.038345, 5541.024628, 5541.713348, 5579.724365};
        double w = NormalityTest.shapiro_wilk_statistic(x);
        double p = NormalityTest.shapiro_wilk_pvalue(w, x.length);
        System.out.println(String.valueOf(w) + " -- " + p);
        double[] pp = NormalityTest.kolmogorov_smirnov_test(x);
        System.out.println(String.valueOf(pp[0]) + " -- " + pp[1]);
        w = NormalityTest.cramer_vonmises_statistic(x);
        p = NormalityTest.cramer_vonmises_pvalue(w, x.length);
        System.out.println(String.valueOf(w) + " -- " + p);
    }

    public static final void main(String[] args) {
        TestDPQR.test_binom();
        TestDPQR.test_geom();
        TestDPQR.test_hyper();
        TestDPQR.test_negbin();
        TestDPQR.test_poisson();
        TestDPQR.test_signrank();
        TestDPQR.test_wilcox();
        TestDPQR.test_gamma();
        TestDPQR.test_noncentralchisq();
        TestDPQR.test_beta();
        TestDPQR.test_normal();
        TestDPQR.test_random();
        TestDPQR.test_extreme();
        System.exit(0);
    }
}

