/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class NNge
extends Classifier
implements UpdateableClassifier,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 4084742275553788972L;
    private Instances m_Train;
    private Exemplar m_Exemplars;
    private Exemplar[] m_ExemplarsByClass;
    double[] m_MinArray;
    double[] m_MaxArray;
    private int m_NumAttemptsOfGene = 5;
    private int m_NumFoldersMI = 5;
    private double[] m_MissingVector;
    private int[][][] m_MI_NumAttrClassInter;
    private int[][] m_MI_NumAttrInter;
    private double[] m_MI_MaxArray;
    private double[] m_MI_MinArray;
    private int[][][] m_MI_NumAttrClassValue;
    private int[][] m_MI_NumAttrValue;
    private int[] m_MI_NumClass;
    private int m_MI_NumInst;
    private double[] m_MI;

    public String globalInfo() {
        return "Nearest-neighbor-like algorithm using non-nested generalized exemplars (which are hyperrectangles that can be viewed as if-then rules). For more information, see \n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Brent Martin");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        result.setValue(TechnicalInformation.Field.TITLE, "Instance-Based learning: Nearest Neighbor With Generalization");
        result.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.UNPUBLISHED);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Sylvain Roy");
        additional.setValue(TechnicalInformation.Field.YEAR, "2002");
        additional.setValue(TechnicalInformation.Field.TITLE, "Nearest Neighbor With Generalization");
        additional.setValue(TechnicalInformation.Field.SCHOOL, "University of Canterbury");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "Christchurch, New Zealand");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_Train = new Instances(data, 0);
        this.m_Exemplars = null;
        this.m_ExemplarsByClass = new Exemplar[this.m_Train.numClasses()];
        int i = 0;
        while (i < this.m_Train.numClasses()) {
            this.m_ExemplarsByClass[i] = null;
            ++i;
        }
        this.m_MaxArray = new double[this.m_Train.numAttributes()];
        this.m_MinArray = new double[this.m_Train.numAttributes()];
        i = 0;
        while (i < this.m_Train.numAttributes()) {
            this.m_MinArray[i] = Double.POSITIVE_INFINITY;
            this.m_MaxArray[i] = Double.NEGATIVE_INFINITY;
            ++i;
        }
        this.m_MI_MinArray = new double[data.numAttributes()];
        this.m_MI_MaxArray = new double[data.numAttributes()];
        this.m_MI_NumAttrClassInter = new int[data.numAttributes()][][];
        this.m_MI_NumAttrInter = new int[data.numAttributes()][];
        this.m_MI_NumAttrClassValue = new int[data.numAttributes()][][];
        this.m_MI_NumAttrValue = new int[data.numAttributes()][];
        this.m_MI_NumClass = new int[data.numClasses()];
        this.m_MI = new double[data.numAttributes()];
        this.m_MI_NumInst = 0;
        int cclass = 0;
        while (cclass < data.numClasses()) {
            this.m_MI_NumClass[cclass] = 0;
            ++cclass;
        }
        int attrIndex = 0;
        while (attrIndex < data.numAttributes()) {
            if (attrIndex != data.classIndex()) {
                this.m_MI_MinArray[attrIndex] = Double.NaN;
                this.m_MI_MaxArray[attrIndex] = Double.NaN;
                this.m_MI[attrIndex] = Double.NaN;
                if (data.attribute(attrIndex).isNumeric()) {
                    this.m_MI_NumAttrInter[attrIndex] = new int[this.m_NumFoldersMI];
                    int inter = 0;
                    while (inter < this.m_NumFoldersMI) {
                        this.m_MI_NumAttrInter[attrIndex][inter] = 0;
                        ++inter;
                    }
                } else {
                    this.m_MI_NumAttrValue[attrIndex] = new int[data.attribute(attrIndex).numValues() + 1];
                    int attrValue = 0;
                    while (attrValue < data.attribute(attrIndex).numValues() + 1) {
                        this.m_MI_NumAttrValue[attrIndex][attrValue] = 0;
                        ++attrValue;
                    }
                }
                this.m_MI_NumAttrClassInter[attrIndex] = new int[data.numClasses()][];
                this.m_MI_NumAttrClassValue[attrIndex] = new int[data.numClasses()][];
                int cclass2 = 0;
                while (cclass2 < data.numClasses()) {
                    if (data.attribute(attrIndex).isNumeric()) {
                        this.m_MI_NumAttrClassInter[attrIndex][cclass2] = new int[this.m_NumFoldersMI];
                        int inter = 0;
                        while (inter < this.m_NumFoldersMI) {
                            this.m_MI_NumAttrClassInter[attrIndex][cclass2][inter] = 0;
                            ++inter;
                        }
                    } else if (data.attribute(attrIndex).isNominal()) {
                        this.m_MI_NumAttrClassValue[attrIndex][cclass2] = new int[data.attribute(attrIndex).numValues() + 1];
                        int attrValue = 0;
                        while (attrValue < data.attribute(attrIndex).numValues() + 1) {
                            this.m_MI_NumAttrClassValue[attrIndex][cclass2][attrValue] = 0;
                            ++attrValue;
                        }
                    }
                    ++cclass2;
                }
            }
            ++attrIndex;
        }
        this.m_MissingVector = new double[data.numAttributes()];
        i = 0;
        while (i < data.numAttributes()) {
            this.m_MissingVector[i] = i == data.classIndex() ? Double.NaN : (double)data.attribute(i).numValues();
            ++i;
        }
        Enumeration enu = data.enumerateInstances();
        while (enu.hasMoreElements()) {
            this.update((Instance)enu.nextElement());
        }
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        if (!this.m_Train.equalHeaders(instance.dataset())) {
            throw new Exception("NNge.classifyInstance : Incompatible instance types !");
        }
        Exemplar matched = this.nearestExemplar(instance);
        if (matched == null) {
            throw new Exception("NNge.classifyInstance : NNge hasn't been trained !");
        }
        return matched.classValue();
    }

    @Override
    public void updateClassifier(Instance instance) throws Exception {
        if (!this.m_Train.equalHeaders(instance.dataset())) {
            throw new Exception("Incompatible instance types");
        }
        this.update(instance);
    }

    private void update(Instance instance) throws Exception {
        if (instance.classIsMissing()) {
            return;
        }
        instance.replaceMissingValues(this.m_MissingVector);
        this.m_Train.add(instance);
        this.updateMinMax(instance);
        this.updateMI(instance);
        Exemplar nearest = this.nearestExemplar(instance);
        if (nearest == null) {
            Exemplar newEx = new Exemplar(this, this.m_Train, 10, instance.classValue());
            newEx.generalise(instance);
            this.initWeight(newEx);
            this.addExemplar(newEx);
            return;
        }
        this.adjust(instance, nearest);
        this.generalise(instance);
    }

    private Exemplar nearestExemplar(Instance inst) {
        if (this.m_Exemplars == null) {
            return null;
        }
        Exemplar cur = this.m_Exemplars;
        Exemplar nearest = this.m_Exemplars;
        double smallestDist = cur.squaredDistance(inst);
        while (cur.next != null) {
            double dist = (cur = cur.next).squaredDistance(inst);
            if (!(dist < smallestDist)) continue;
            smallestDist = dist;
            nearest = cur;
        }
        return nearest;
    }

    private Exemplar nearestExemplar(Instance inst, double c) {
        if (this.m_ExemplarsByClass[(int)c] == null) {
            return null;
        }
        Exemplar cur = this.m_ExemplarsByClass[(int)c];
        Exemplar nearest = this.m_ExemplarsByClass[(int)c];
        double smallestDist = cur.squaredDistance(inst);
        while (cur.nextWithClass != null) {
            double dist = (cur = cur.nextWithClass).squaredDistance(inst);
            if (!(dist < smallestDist)) continue;
            smallestDist = dist;
            nearest = cur;
        }
        return nearest;
    }

    private void generalise(Instance newInst) throws Exception {
        Exemplar first = this.m_ExemplarsByClass[(int)newInst.classValue()];
        int n = 0;
        while (n < this.m_NumAttemptsOfGene && first != null) {
            Exemplar closest = first;
            Exemplar cur = first;
            double smallestDist = first.squaredDistance(newInst);
            while (cur.nextWithClass != null) {
                double dist = (cur = cur.nextWithClass).squaredDistance(newInst);
                if (!(dist < smallestDist)) continue;
                smallestDist = dist;
                closest = cur;
            }
            if (closest == first) {
                first = first.nextWithClass;
            }
            this.removeExemplar(closest);
            closest.preGeneralise(newInst);
            if (!this.detectOverlapping(closest)) {
                closest.validateGeneralisation();
                this.addExemplar(closest);
                return;
            }
            closest.cancelGeneralisation();
            this.addExemplar(closest);
            ++n;
        }
        Exemplar newEx = new Exemplar(this, this.m_Train, 5, newInst.classValue());
        newEx.generalise(newInst);
        this.initWeight(newEx);
        this.addExemplar(newEx);
    }

    private void adjust(Instance newInst, Exemplar predictedExemplar) throws Exception {
        if (newInst.classValue() == predictedExemplar.classValue()) {
            predictedExemplar.incrPositiveCount();
        } else {
            predictedExemplar.incrNegativeCount();
            if (predictedExemplar.holds(newInst)) {
                this.prune(predictedExemplar, newInst);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void prune(Exemplar predictedExemplar, Instance newInst) throws Exception {
        block21: {
            this.removeExemplar(predictedExemplar);
            numAttr = -1;
            nomAttr = -1;
            smallestDelta = Infinity;
            biggest_N_Nom = -1;
            biggest_N_Num = -1;
            i = 0;
            while (i < this.m_Train.numAttributes()) {
                if (i != this.m_Train.classIndex()) {
                    if (this.m_Train.attribute(i).isNumeric()) {
                        norm = this.m_MaxArray[i] - this.m_MinArray[i];
                        delta = norm != 0.0 ? Math.min(Exemplar.access$12(predictedExemplar, i) - newInst.value(i), newInst.value(i) - Exemplar.access$13(predictedExemplar, i)) / norm : Infinity;
                        m = 0;
                        n = 0;
                        enu = predictedExemplar.enumerateInstances();
                        while (enu.hasMoreElements()) {
                            ins = (Instance)enu.nextElement();
                            if (ins.value(i) < newInst.value(i)) {
                                ++n;
                                continue;
                            }
                            if (!(ins.value(i) > newInst.value(i))) continue;
                            ++m;
                        }
                        n = Math.max(n, m);
                        if (delta < smallestDelta) {
                            smallestDelta = delta;
                            biggest_N_Num = n;
                            numAttr = i;
                        } else if (delta == smallestDelta && n > biggest_N_Num) {
                            biggest_N_Num = n;
                            numAttr = i;
                        }
                    } else {
                        enu = predictedExemplar.enumerateInstances();
                        n = 0;
                        while (enu.hasMoreElements()) {
                            if (((Instance)enu.nextElement()).value(i) == newInst.value(i)) continue;
                            ++n;
                        }
                        if (n > biggest_N_Nom) {
                            biggest_N_Nom = n;
                            nomAttr = i;
                        }
                    }
                }
                ++i;
            }
            attrToCut = numAttr == -1 && nomAttr == -1 ? 0 : (numAttr == -1 ? nomAttr : (nomAttr == -1 ? numAttr : (biggest_N_Nom > biggest_N_Num ? nomAttr : numAttr)));
            a = new Exemplar(this, this.m_Train, 10, Exemplar.access$0(predictedExemplar));
            b = new Exemplar(this, this.m_Train, 10, Exemplar.access$0(predictedExemplar));
            leftAlone = new LinkedList<Instance>();
            enu = predictedExemplar.enumerateInstances();
            if (!this.m_Train.attribute(attrToCut).isNumeric()) ** GOTO lbl71
            while (enu.hasMoreElements()) {
                curInst = (Instance)enu.nextElement();
                if (curInst.value(attrToCut) > newInst.value(attrToCut)) {
                    Exemplar.access$2(a, curInst);
                    continue;
                }
                if (curInst.value(attrToCut) < newInst.value(attrToCut)) {
                    Exemplar.access$2(b, curInst);
                    continue;
                }
                if (!this.notEqualFeatures(curInst, newInst)) continue;
                leftAlone.add(curInst);
            }
            break block21;
lbl-1000:
            // 1 sources

            {
                curInst = (Instance)enu.nextElement();
                if (curInst.value(attrToCut) != newInst.value(attrToCut)) {
                    Exemplar.access$2(a, curInst);
                    continue;
                }
                if (!this.notEqualFeatures(curInst, newInst)) continue;
                leftAlone.add(curInst);
lbl71:
                // 4 sources

                ** while (enu.hasMoreElements())
            }
        }
        while (leftAlone.size() != 0) {
            alone = (Instance)leftAlone.removeFirst();
            Exemplar.access$6(a, alone);
            if (!Exemplar.access$11(a, newInst)) {
                Exemplar.access$7(a);
                continue;
            }
            Exemplar.access$8(a);
            Exemplar.access$6(b, alone);
            if (!Exemplar.access$11(b, newInst)) {
                Exemplar.access$7(b);
                continue;
            }
            Exemplar.access$8(b);
            exem = new Exemplar(this, this.m_Train, 3, alone.classValue());
            Exemplar.access$2(exem, alone);
            this.initWeight(exem);
            this.addExemplar(exem);
        }
        if (a.numInstances() != 0) {
            this.initWeight(a);
            this.addExemplar(a);
        }
        if (b.numInstances() != 0) {
            this.initWeight(b);
            this.addExemplar(b);
        }
    }

    private boolean notEqualFeatures(Instance inst1, Instance inst2) {
        int i = 0;
        while (i < this.m_Train.numAttributes()) {
            if (i != this.m_Train.classIndex() && inst1.value(i) != inst2.value(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean detectOverlapping(Exemplar ex) {
        Exemplar cur = this.m_Exemplars;
        while (cur != null) {
            if (ex.overlaps(cur)) {
                return true;
            }
            cur = cur.next;
        }
        return false;
    }

    private void updateMinMax(Instance instance) {
        int j = 0;
        while (j < this.m_Train.numAttributes()) {
            if (this.m_Train.classIndex() != j && !this.m_Train.attribute(j).isNominal()) {
                if (instance.value(j) < this.m_MinArray[j]) {
                    this.m_MinArray[j] = instance.value(j);
                }
                if (instance.value(j) > this.m_MaxArray[j]) {
                    this.m_MaxArray[j] = instance.value(j);
                }
            }
            ++j;
        }
    }

    private void updateMI(Instance inst) throws Exception {
        if (this.m_NumFoldersMI < 1) {
            throw new Exception("NNge.updateMI : incorrect number of folders ! Option I must be greater than 1.");
        }
        int n = (int)inst.classValue();
        this.m_MI_NumClass[n] = this.m_MI_NumClass[n] + 1;
        ++this.m_MI_NumInst;
        int attrIndex = 0;
        while (attrIndex < this.m_Train.numAttributes()) {
            if (this.m_Train.classIndex() != attrIndex) {
                double pY;
                int cclass;
                if (this.m_Train.attribute(attrIndex).isNumeric()) {
                    int inter;
                    double delta;
                    if (Double.isNaN(this.m_MI_MaxArray[attrIndex]) || Double.isNaN(this.m_MI_MinArray[attrIndex]) || this.m_MI_MaxArray[attrIndex] < inst.value(attrIndex) || inst.value(attrIndex) < this.m_MI_MinArray[attrIndex]) {
                        if (Double.isNaN(this.m_MI_MaxArray[attrIndex])) {
                            this.m_MI_MaxArray[attrIndex] = inst.value(attrIndex);
                        }
                        if (Double.isNaN(this.m_MI_MinArray[attrIndex])) {
                            this.m_MI_MinArray[attrIndex] = inst.value(attrIndex);
                        }
                        if (this.m_MI_MaxArray[attrIndex] < inst.value(attrIndex)) {
                            this.m_MI_MaxArray[attrIndex] = inst.value(attrIndex);
                        }
                        if (this.m_MI_MinArray[attrIndex] > inst.value(attrIndex)) {
                            this.m_MI_MinArray[attrIndex] = inst.value(attrIndex);
                        }
                        delta = (this.m_MI_MaxArray[attrIndex] - this.m_MI_MinArray[attrIndex]) / (double)this.m_NumFoldersMI;
                        inter = 0;
                        while (inter < this.m_NumFoldersMI) {
                            this.m_MI_NumAttrInter[attrIndex][inter] = 0;
                            int cclass2 = 0;
                            while (cclass2 < this.m_Train.numClasses()) {
                                this.m_MI_NumAttrClassInter[attrIndex][cclass2][inter] = 0;
                                Enumeration enu = this.m_Train.enumerateInstances();
                                while (enu.hasMoreElements()) {
                                    Instance cur = (Instance)enu.nextElement();
                                    if (!(this.m_MI_MinArray[attrIndex] + (double)inter * delta <= cur.value(attrIndex)) || !(cur.value(attrIndex) <= this.m_MI_MinArray[attrIndex] + (double)(inter + 1) * delta) || cur.classValue() != (double)cclass2) continue;
                                    int[] nArray = this.m_MI_NumAttrInter[attrIndex];
                                    int n2 = inter;
                                    nArray[n2] = nArray[n2] + 1;
                                    int[] nArray2 = this.m_MI_NumAttrClassInter[attrIndex][cclass2];
                                    int n3 = inter;
                                    nArray2[n3] = nArray2[n3] + 1;
                                }
                                ++cclass2;
                            }
                            ++inter;
                        }
                    } else {
                        delta = (this.m_MI_MaxArray[attrIndex] - this.m_MI_MinArray[attrIndex]) / (double)this.m_NumFoldersMI;
                        inter = 0;
                        while (inter < this.m_NumFoldersMI) {
                            if (this.m_MI_MinArray[attrIndex] + (double)inter * delta <= inst.value(attrIndex) && inst.value(attrIndex) <= this.m_MI_MinArray[attrIndex] + (double)(inter + 1) * delta) {
                                int[] nArray = this.m_MI_NumAttrInter[attrIndex];
                                int n4 = inter;
                                nArray[n4] = nArray[n4] + 1;
                                int[] nArray3 = this.m_MI_NumAttrClassInter[attrIndex][(int)inst.classValue()];
                                int n5 = inter;
                                nArray3[n5] = nArray3[n5] + 1;
                            }
                            ++inter;
                        }
                    }
                    this.m_MI[attrIndex] = 0.0;
                    int inter2 = 0;
                    while (inter2 < this.m_NumFoldersMI) {
                        cclass = 0;
                        while (cclass < this.m_Train.numClasses()) {
                            double pXY = (double)this.m_MI_NumAttrClassInter[attrIndex][cclass][inter2] / (double)this.m_MI_NumInst;
                            double pX = (double)this.m_MI_NumClass[cclass] / (double)this.m_MI_NumInst;
                            pY = (double)this.m_MI_NumAttrInter[attrIndex][inter2] / (double)this.m_MI_NumInst;
                            if (pXY != 0.0) {
                                int n6 = attrIndex;
                                this.m_MI[n6] = this.m_MI[n6] + pXY * Utils.log2(pXY / (pX * pY));
                            }
                            ++cclass;
                        }
                        ++inter2;
                    }
                } else if (this.m_Train.attribute(attrIndex).isNominal()) {
                    int[] nArray = this.m_MI_NumAttrValue[attrIndex];
                    int n7 = (int)inst.value(attrIndex);
                    nArray[n7] = nArray[n7] + 1;
                    int[] nArray4 = this.m_MI_NumAttrClassValue[attrIndex][(int)inst.classValue()];
                    int n8 = (int)inst.value(attrIndex);
                    nArray4[n8] = nArray4[n8] + 1;
                    this.m_MI[attrIndex] = 0.0;
                    int attrValue = 0;
                    while (attrValue < this.m_Train.attribute(attrIndex).numValues() + 1) {
                        cclass = 0;
                        while (cclass < this.m_Train.numClasses()) {
                            double pXY = (double)this.m_MI_NumAttrClassValue[attrIndex][cclass][attrValue] / (double)this.m_MI_NumInst;
                            double pX = (double)this.m_MI_NumClass[cclass] / (double)this.m_MI_NumInst;
                            pY = (double)this.m_MI_NumAttrValue[attrIndex][attrValue] / (double)this.m_MI_NumInst;
                            if (pXY != 0.0) {
                                int n9 = attrIndex;
                                this.m_MI[n9] = this.m_MI[n9] + pXY * Utils.log2(pXY / (pX * pY));
                            }
                            ++cclass;
                        }
                        ++attrValue;
                    }
                } else {
                    throw new Exception("NNge.updateMI : Cannot deal with 'string attribute'.");
                }
            }
            ++attrIndex;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initWeight(Exemplar ex) {
        pos = 0;
        neg = 0;
        n = 0;
        cur = this.m_Exemplars;
        if (cur != null) ** GOTO lbl13
        Exemplar.access$15(ex, 1);
        Exemplar.access$16(ex, 0);
        return;
lbl-1000:
        // 1 sources

        {
            pos += Exemplar.access$17(cur);
            neg += Exemplar.access$18(cur);
            ++n;
            cur = Exemplar.access$4(cur);
lbl13:
            // 2 sources

            ** while (cur != null)
        }
lbl14:
        // 1 sources

        Exemplar.access$15(ex, pos / n);
        Exemplar.access$16(ex, neg / n);
    }

    private void addExemplar(Exemplar ex) {
        ex.next = this.m_Exemplars;
        if (this.m_Exemplars != null) {
            this.m_Exemplars.previous = ex;
        }
        ex.previous = null;
        this.m_Exemplars = ex;
        ex.nextWithClass = this.m_ExemplarsByClass[(int)ex.classValue()];
        if (this.m_ExemplarsByClass[(int)ex.classValue()] != null) {
            this.m_ExemplarsByClass[(int)ex.classValue()].previousWithClass = ex;
        }
        ex.previousWithClass = null;
        this.m_ExemplarsByClass[(int)((Exemplar)ex).classValue()] = ex;
    }

    private void removeExemplar(Exemplar ex) {
        if (this.m_Exemplars == ex) {
            this.m_Exemplars = ex.next;
            if (this.m_Exemplars != null) {
                this.m_Exemplars.previous = null;
            }
        } else {
            ex.previous.next = ex.next;
            if (ex.next != null) {
                ex.next.previous = ex.previous;
            }
        }
        ex.previous = null;
        ex.next = null;
        if (this.m_ExemplarsByClass[(int)ex.classValue()] == ex) {
            this.m_ExemplarsByClass[(int)((Exemplar)ex).classValue()] = ex.nextWithClass;
            if (this.m_ExemplarsByClass[(int)ex.classValue()] != null) {
                this.m_ExemplarsByClass[(int)ex.classValue()].previousWithClass = null;
            }
        } else {
            ex.previousWithClass.nextWithClass = ex.nextWithClass;
            if (ex.nextWithClass != null) {
                ex.nextWithClass.previousWithClass = ex.previousWithClass;
            }
        }
        ex.previousWithClass = null;
        ex.nextWithClass = null;
    }

    private double attrWeight(int index) {
        return this.m_MI[index];
    }

    public String toString() {
        Exemplar cur = this.m_Exemplars;
        if (this.m_MinArray == null) {
            return "No classifier built";
        }
        int[] nbHypClass = new int[this.m_Train.numClasses()];
        int[] nbSingleClass = new int[this.m_Train.numClasses()];
        int i = 0;
        while (i < nbHypClass.length) {
            nbHypClass[i] = 0;
            nbSingleClass[i] = 0;
            ++i;
        }
        int nbHyp = 0;
        int nbSingle = 0;
        String s = "\nNNGE classifier\n\nRules generated :\n";
        while (cur != null) {
            s = String.valueOf(s) + "\tclass " + this.m_Train.attribute(this.m_Train.classIndex()).value((int)cur.classValue()) + " IF : ";
            s = String.valueOf(s) + cur.toRules() + "\n";
            ++nbHyp;
            int n = (int)cur.classValue();
            nbHypClass[n] = nbHypClass[n] + 1;
            if (cur.numInstances() == 1) {
                ++nbSingle;
                int n2 = (int)cur.classValue();
                nbSingleClass[n2] = nbSingleClass[n2] + 1;
            }
            cur = cur.next;
        }
        s = String.valueOf(s) + "\nStat :\n";
        i = 0;
        while (i < nbHypClass.length) {
            s = String.valueOf(s) + "\tclass " + this.m_Train.attribute(this.m_Train.classIndex()).value(i) + " : " + Integer.toString(nbHypClass[i]) + " exemplar(s) including " + Integer.toString(nbHypClass[i] - nbSingleClass[i]) + " Hyperrectangle(s) and " + Integer.toString(nbSingleClass[i]) + " Single(s).\n";
            ++i;
        }
        s = String.valueOf(s) + "\n\tTotal : " + Integer.toString(nbHyp) + " exemplars(s) including " + Integer.toString(nbHyp - nbSingle) + " Hyperrectangle(s) and " + Integer.toString(nbSingle) + " Single(s).\n";
        s = String.valueOf(s) + "\n";
        s = String.valueOf(s) + "\tFeature weights : ";
        String space = "[";
        int ii = 0;
        while (ii < this.m_Train.numAttributes()) {
            if (ii != this.m_Train.classIndex()) {
                s = String.valueOf(s) + space + Double.toString(this.attrWeight(ii));
                space = " ";
            }
            ++ii;
        }
        s = String.valueOf(s) + "]";
        s = String.valueOf(s) + "\n\n";
        return s;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tNumber of attempts of generalisation.\n", "G", 1, "-G <value>"));
        newVector.addElement(new Option("\tNumber of folder for computing the mutual information.\n", "I", 1, "-I <value>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String str = Utils.getOption('G', options);
        if (str.length() != 0) {
            this.m_NumAttemptsOfGene = Integer.parseInt(str);
            if (this.m_NumAttemptsOfGene < 1) {
                throw new Exception("NNge.setOptions : G option's value must be greater than 1.");
            }
        } else {
            this.m_NumAttemptsOfGene = 5;
        }
        if ((str = Utils.getOption('I', options)).length() != 0) {
            this.m_NumFoldersMI = Integer.parseInt(str);
            if (this.m_NumFoldersMI < 1) {
                throw new Exception("NNge.setOptions : I option's value must be greater than 1.");
            }
        } else {
            this.m_NumFoldersMI = 5;
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[5];
        int current = 0;
        options[current++] = "-G";
        options[current++] = "" + this.m_NumAttemptsOfGene;
        options[current++] = "-I";
        options[current++] = "" + this.m_NumFoldersMI;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String numAttemptsOfGeneOptionTipText() {
        return "Sets the number of attempts for generalization.";
    }

    public int getNumAttemptsOfGeneOption() {
        return this.m_NumAttemptsOfGene;
    }

    public void setNumAttemptsOfGeneOption(int newIntParameter) {
        this.m_NumAttemptsOfGene = newIntParameter;
    }

    public String numFoldersMIOptionTipText() {
        return "Sets the number of folder for mutual information.";
    }

    public int getNumFoldersMIOption() {
        return this.m_NumFoldersMI;
    }

    public void setNumFoldersMIOption(int newIntParameter) {
        this.m_NumFoldersMI = newIntParameter;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5529 $");
    }

    public static void main(String[] argv) {
        NNge.runClassifier(new NNge(), argv);
    }

    private class Exemplar
    extends Instances {
        static final long serialVersionUID = 3960180128928697216L;
        private Exemplar previous;
        private Exemplar next;
        private Exemplar previousWithClass;
        private Exemplar nextWithClass;
        private NNge m_NNge;
        private double m_ClassValue;
        private int m_PositiveCount;
        private int m_NegativeCount;
        private double[] m_MaxBorder;
        private double[] m_MinBorder;
        private boolean[][] m_Range;
        private double[] m_PreMaxBorder;
        private double[] m_PreMinBorder;
        private boolean[][] m_PreRange;
        private Instance m_PreInst;

        private Exemplar(NNge nnge, Instances inst, int size, double classV) {
            super(inst, size);
            this.previous = null;
            this.next = null;
            this.previousWithClass = null;
            this.nextWithClass = null;
            this.m_PositiveCount = 1;
            this.m_NegativeCount = 0;
            this.m_PreMaxBorder = null;
            this.m_PreMinBorder = null;
            this.m_PreRange = null;
            this.m_PreInst = null;
            this.m_NNge = nnge;
            this.m_ClassValue = classV;
            this.m_MinBorder = new double[this.numAttributes()];
            this.m_MaxBorder = new double[this.numAttributes()];
            this.m_Range = new boolean[this.numAttributes()][];
            int i = 0;
            while (i < this.numAttributes()) {
                if (this.attribute(i).isNumeric()) {
                    this.m_MinBorder[i] = Double.POSITIVE_INFINITY;
                    this.m_MaxBorder[i] = Double.NEGATIVE_INFINITY;
                    this.m_Range[i] = null;
                } else {
                    this.m_MinBorder[i] = Double.NaN;
                    this.m_MaxBorder[i] = Double.NaN;
                    this.m_Range[i] = new boolean[this.attribute(i).numValues() + 1];
                    int j = 0;
                    while (j < this.attribute(i).numValues() + 1) {
                        this.m_Range[i][j] = false;
                        ++j;
                    }
                }
                ++i;
            }
        }

        private void generalise(Instance inst) throws Exception {
            if (this.m_ClassValue != inst.classValue()) {
                throw new Exception("Exemplar.generalise : Incompatible instance's class.");
            }
            this.add(inst);
            int i = 0;
            while (i < this.numAttributes()) {
                if (inst.isMissing(i)) {
                    throw new Exception("Exemplar.generalise : Generalisation with missing feature impossible.");
                }
                if (i != this.classIndex()) {
                    if (this.attribute(i).isNumeric()) {
                        if (this.m_MaxBorder[i] < inst.value(i)) {
                            this.m_MaxBorder[i] = inst.value(i);
                        }
                        if (inst.value(i) < this.m_MinBorder[i]) {
                            this.m_MinBorder[i] = inst.value(i);
                        }
                    } else {
                        this.m_Range[i][(int)inst.value((int)i)] = true;
                    }
                }
                ++i;
            }
        }

        private void preGeneralise(Instance inst) throws Exception {
            if (this.m_ClassValue != inst.classValue()) {
                throw new Exception("Exemplar.preGeneralise : Incompatible instance's class.");
            }
            this.m_PreInst = inst;
            this.m_PreRange = new boolean[this.numAttributes()][];
            this.m_PreMinBorder = new double[this.numAttributes()];
            this.m_PreMaxBorder = new double[this.numAttributes()];
            int i = 0;
            while (i < this.numAttributes()) {
                if (this.attribute(i).isNumeric()) {
                    this.m_PreMinBorder[i] = this.m_MinBorder[i];
                    this.m_PreMaxBorder[i] = this.m_MaxBorder[i];
                } else {
                    this.m_PreRange[i] = new boolean[this.attribute(i).numValues() + 1];
                    int j = 0;
                    while (j < this.attribute(i).numValues() + 1) {
                        this.m_PreRange[i][j] = this.m_Range[i][j];
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.numAttributes()) {
                if (inst.isMissing(i)) {
                    throw new Exception("Exemplar.preGeneralise : Generalisation with missing feature impossible.");
                }
                if (i != this.classIndex()) {
                    if (this.attribute(i).isNumeric()) {
                        if (this.m_MaxBorder[i] < inst.value(i)) {
                            this.m_MaxBorder[i] = inst.value(i);
                        }
                        if (inst.value(i) < this.m_MinBorder[i]) {
                            this.m_MinBorder[i] = inst.value(i);
                        }
                    } else {
                        this.m_Range[i][(int)inst.value((int)i)] = true;
                    }
                }
                ++i;
            }
        }

        private void validateGeneralisation() throws Exception {
            if (this.m_PreInst == null) {
                throw new Exception("Exemplar.validateGeneralisation : validateGeneralisation called without previous call to preGeneralise!");
            }
            this.add(this.m_PreInst);
            this.m_PreRange = null;
            this.m_PreMinBorder = null;
            this.m_PreMaxBorder = null;
        }

        private void cancelGeneralisation() throws Exception {
            if (this.m_PreInst == null) {
                throw new Exception("Exemplar.cancelGeneralisation : cancelGeneralisation called without previous call to preGeneralise!");
            }
            this.m_PreInst = null;
            this.m_Range = this.m_PreRange;
            this.m_MinBorder = this.m_PreMinBorder;
            this.m_MaxBorder = this.m_PreMaxBorder;
            this.m_PreRange = null;
            this.m_PreMinBorder = null;
            this.m_PreMaxBorder = null;
        }

        private boolean holds(Instance inst) {
            if (this.numInstances() == 0) {
                return false;
            }
            int i = 0;
            while (i < this.numAttributes()) {
                if (i != this.classIndex() && !this.holds(i, inst.value(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean holds(int attrIndex, double value) {
            if (this.numAttributes() == 0) {
                return false;
            }
            if (this.attribute(attrIndex).isNumeric()) {
                return this.m_MinBorder[attrIndex] <= value && value <= this.m_MaxBorder[attrIndex];
            }
            return this.m_Range[attrIndex][(int)value];
        }

        private boolean overlaps(Exemplar ex) {
            if (ex.isEmpty() || this.isEmpty()) {
                return false;
            }
            int i = 0;
            while (i < this.numAttributes()) {
                if (i != this.classIndex()) {
                    if (this.attribute(i).isNumeric() && (ex.m_MaxBorder[i] < this.m_MinBorder[i] || ex.m_MinBorder[i] > this.m_MaxBorder[i])) {
                        return false;
                    }
                    if (this.attribute(i).isNominal()) {
                        boolean in = false;
                        int j = 0;
                        while (j < this.attribute(i).numValues() + 1) {
                            if (this.m_Range[i][j] && ex.m_Range[i][j]) {
                                in = true;
                                break;
                            }
                            ++j;
                        }
                        if (!in) {
                            return false;
                        }
                    }
                }
                ++i;
            }
            return true;
        }

        private double attrDistance(Instance inst, int attrIndex) {
            if (inst.isMissing(attrIndex)) {
                return 0.0;
            }
            if (this.attribute(attrIndex).isNumeric()) {
                double norm = this.m_NNge.m_MaxArray[attrIndex] - this.m_NNge.m_MinArray[attrIndex];
                if (norm <= 0.0) {
                    norm = 1.0;
                }
                if (this.m_MaxBorder[attrIndex] < inst.value(attrIndex)) {
                    return (inst.value(attrIndex) - this.m_MaxBorder[attrIndex]) / norm;
                }
                if (inst.value(attrIndex) < this.m_MinBorder[attrIndex]) {
                    return (this.m_MinBorder[attrIndex] - inst.value(attrIndex)) / norm;
                }
                return 0.0;
            }
            if (this.holds(attrIndex, inst.value(attrIndex))) {
                return 0.0;
            }
            return 1.0;
        }

        private double squaredDistance(Instance inst) {
            double sum = 0.0;
            int numNotMissingAttr = 0;
            int i = 0;
            while (i < inst.numAttributes()) {
                if (i != this.classIndex()) {
                    double term = this.m_NNge.attrWeight(i) * this.attrDistance(inst, i);
                    term *= term;
                    sum += term;
                    if (!inst.isMissing(i)) {
                        ++numNotMissingAttr;
                    }
                }
                ++i;
            }
            if (numNotMissingAttr == 0) {
                return 0.0;
            }
            return sum / (double)(numNotMissingAttr * numNotMissingAttr);
        }

        private double weight() {
            return (double)(this.m_PositiveCount + this.m_NegativeCount) / (double)this.m_PositiveCount;
        }

        private double classValue() {
            return this.m_ClassValue;
        }

        private double getMinBorder(int attrIndex) throws Exception {
            if (!this.attribute(attrIndex).isNumeric()) {
                throw new Exception("Exception.getMinBorder : not numeric attribute !");
            }
            if (this.numInstances() == 0) {
                throw new Exception("Exception.getMinBorder : empty Exemplar !");
            }
            return this.m_MinBorder[attrIndex];
        }

        private double getMaxBorder(int attrIndex) throws Exception {
            if (!this.attribute(attrIndex).isNumeric()) {
                throw new Exception("Exception.getMaxBorder : not numeric attribute !");
            }
            if (this.numInstances() == 0) {
                throw new Exception("Exception.getMaxBorder : empty Exemplar !");
            }
            return this.m_MaxBorder[attrIndex];
        }

        private int getPositiveCount() {
            return this.m_PositiveCount;
        }

        private int getNegativeCount() {
            return this.m_NegativeCount;
        }

        private void setPositiveCount(int value) {
            this.m_PositiveCount = value;
        }

        private void setNegativeCount(int value) {
            this.m_NegativeCount = value;
        }

        private void incrPositiveCount() {
            ++this.m_PositiveCount;
        }

        private void incrNegativeCount() {
            ++this.m_NegativeCount;
        }

        private boolean isEmpty() {
            return this.numInstances() == 0;
        }

        private String toString2() {
            Enumeration enu = null;
            String s = "Exemplar[";
            if (this.numInstances() == 0) {
                return String.valueOf(s) + "Empty]";
            }
            s = String.valueOf(s) + "{";
            enu = this.enumerateInstances();
            while (enu.hasMoreElements()) {
                s = String.valueOf(s) + "<" + enu.nextElement().toString() + "> ";
            }
            s = s.substring(0, s.length() - 1);
            s = String.valueOf(s) + "} {" + this.toRules() + "} p=" + this.m_PositiveCount + " n=" + this.m_NegativeCount + "]";
            return s;
        }

        private String toRules() {
            if (this.numInstances() == 0) {
                return "No Rules (Empty Exemplar)";
            }
            String s = "";
            String sep = "";
            int i = 0;
            while (i < this.numAttributes()) {
                if (i != this.classIndex()) {
                    if (this.attribute(i).isNumeric()) {
                        s = this.m_MaxBorder[i] != this.m_MinBorder[i] ? String.valueOf(s) + sep + this.m_MinBorder[i] + "<=" + this.attribute(i).name() + "<=" + this.m_MaxBorder[i] : String.valueOf(s) + sep + this.attribute(i).name() + "=" + this.m_MaxBorder[i];
                        sep = " ^ ";
                    } else {
                        s = String.valueOf(s) + sep + this.attribute(i).name() + " in {";
                        String virg = "";
                        int j = 0;
                        while (j < this.attribute(i).numValues() + 1) {
                            if (this.m_Range[i][j]) {
                                s = String.valueOf(s) + virg;
                                s = j == this.attribute(i).numValues() ? String.valueOf(s) + "?" : String.valueOf(s) + this.attribute(i).value(j);
                                virg = ",";
                            }
                            ++j;
                        }
                        s = String.valueOf(s) + "}";
                        sep = " ^ ";
                    }
                }
                ++i;
            }
            s = String.valueOf(s) + "  (" + this.numInstances() + ")";
            return s;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }

        static /* synthetic */ double access$12(Exemplar exemplar, int n) throws Exception {
            return exemplar.getMaxBorder(n);
        }

        static /* synthetic */ double access$13(Exemplar exemplar, int n) throws Exception {
            return exemplar.getMinBorder(n);
        }

        static /* synthetic */ void access$15(Exemplar exemplar, int n) {
            exemplar.setPositiveCount(n);
        }

        static /* synthetic */ void access$16(Exemplar exemplar, int n) {
            exemplar.setNegativeCount(n);
        }

        static /* synthetic */ int access$17(Exemplar exemplar) {
            return exemplar.getPositiveCount();
        }

        static /* synthetic */ int access$18(Exemplar exemplar) {
            return exemplar.getNegativeCount();
        }
    }
}

