/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier;

import dmLab.array.FArray;
import dmLab.classifier.Params;
import dmLab.classifier.PredictionResult;
import dmLab.classifier.adx.ADXClassifier;
import dmLab.classifier.bayesNet.BayesNetClassifier;
import dmLab.classifier.ensemble.EnsembleClassifier;
import dmLab.classifier.hyperPipes.HyperPipesClassifier;
import dmLab.classifier.j48.J48Classifier;
import dmLab.classifier.knn.KNNClassifier;
import dmLab.classifier.logistic.LogisticClassifier;
import dmLab.classifier.m5.M5Classifier;
import dmLab.classifier.nb.NBClassifier;
import dmLab.classifier.randomForest.RandomForestClassifier;
import dmLab.classifier.ripper.RipperClassifier;
import dmLab.classifier.rnd.RNDClassifier;
import dmLab.classifier.sliq.SliqClassifier;
import dmLab.classifier.svm.SVMClassifier;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import java.io.IOException;
import java.util.HashSet;

public abstract class Classifier {
    public Params params;
    public String label = "classifier";
    protected int id = 0;
    public static int MODEL_CLASSIFIER = 0;
    public static int MODEL_PREDICTOR = 1;
    public int modelType = 0;
    protected PredictionResult predResult = new PredictionResult(this.modelType);
    protected String tmpPath = "";
    protected float learningTime = 0.0f;
    protected float testingTime = 0.0f;
    protected int trainSetSize;
    protected HashSet<String> attrSet;
    public static int AUTO = 0;
    public static int ENSEMBLE = 1;
    public static int RND = 2;
    public static int J48 = 3;
    public static int ADX = 4;
    public static int SLIQ = 5;
    public static int RF = 6;
    public static int NB = 7;
    public static int SVM = 8;
    public static int KNN = 9;
    public static int RIPPER = 10;
    public static int BNET = 11;
    public static int HP = 12;
    public static int LOGISTIC = 13;
    public static int M5 = 14;
    public static String[] labels = new String[]{"auto", "ensemble", "rnd", "j48", "adx", "sliq", "rf", "nb", "svm", "knn", "ripper", "bayesNet", "hyperPipes", "logistic", "m5"};

    /*
     * WARNING - void declaration
     */
    public static Classifier getClassifier(int model) {
        void var0_1;
        int classifier2;
        Classifier classifier2;
        if (model == ENSEMBLE) {
            classifier2 = new EnsembleClassifier();
        } else if (classifier2 == RND) {
            classifier2 = new RNDClassifier();
        } else if (classifier2 == J48) {
            classifier2 = new J48Classifier();
        } else if (classifier2 == ADX) {
            classifier2 = new ADXClassifier();
        } else if (classifier2 == SLIQ) {
            classifier2 = new SliqClassifier();
        } else if (classifier2 == RF) {
            classifier2 = new RandomForestClassifier();
        } else if (classifier2 == NB) {
            classifier2 = new NBClassifier();
        } else if (classifier2 == KNN) {
            classifier2 = new KNNClassifier();
        } else if (classifier2 == RIPPER) {
            classifier2 = new RipperClassifier();
        } else if (classifier2 == SVM) {
            classifier2 = new SVMClassifier();
        } else if (classifier2 == BNET) {
            classifier2 = new BayesNetClassifier();
        } else if (classifier2 == HP) {
            classifier2 = new HyperPipesClassifier();
        } else if (classifier2 == LOGISTIC) {
            classifier2 = new LogisticClassifier();
        } else if (classifier2 == M5) {
            classifier2 = new M5Classifier();
        } else {
            System.err.println("Error creating the classifier. Incorrect model value.");
            return null;
        }
        return var0_1;
    }

    public final boolean isClassifier() {
        return this.modelType == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void setId(int id) {
        void var1_1;
        this.id = var1_1;
    }

    public final String getMyName() {
        return String.valueOf(this.label) + "_C" + this.id;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTempPath(String tempPath) {
        void var1_1;
        this.tmpPath = var1_1;
    }

    public final double getLearningTime() {
        return this.learningTime;
    }

    public final double getTestingTime() {
        return this.testingTime;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkTargetAttr(FArray array) {
        void var1_2;
        short DecAttrType = array.attributes[array.getDecAttrIdx()].type;
        if (DecAttrType == 1 && this.modelType == MODEL_PREDICTOR) {
            System.err.println("Model" + this.getMyName() + " cannot handle nominal target attribute!");
            return false;
        }
        if (var1_2 == 2 && this.modelType == 0) {
            System.err.println("Model" + this.getMyName() + " cannot handle numeric target attribute!");
            return false;
        }
        return true;
    }

    public abstract boolean train(FArray var1);

    public abstract boolean test(FArray var1);

    public abstract boolean init();

    public abstract boolean finish();

    public abstract String toString();

    public String toString(boolean header) {
        return this.toString();
    }

    public abstract boolean saveDefinition(String var1, String var2) throws IOException;

    public abstract boolean add_RI(AttributesRI[] var1);

    public boolean add_ID(AttributesID attrIDependencies, MCFSParams params) {
        if (this.attrSet == null || this.attrSet.size() == 0) {
            return false;
        }
        Object[] attr = this.attrSet.toArray();
        int i = 0;
        while (i < attr.length) {
            int j = 0;
            while (j < attr.length) {
                if (i != j) {
                    attrIDependencies.addDependency((String)attr[i], (String)attr[j], 1.0f);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static String int2label(int id) {
        int n;
        if (id < 0 || id >= labels.length) {
            return "";
        }
        return labels[n];
    }

    public static int label2int(String label) {
        int i = 0;
        while (i < labels.length) {
            if (label.equalsIgnoreCase(labels[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final PredictionResult getPredResult() {
        return this.predResult;
    }
}

