/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.functions;

import cern.jet.stat.Probability;
import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.array.SArray;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.condition.Condition;
import dmLab.utils.condition.Operator;
import dmLab.utils.list.IntegerList;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jdistlib.disttest.NormalityTest;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class DiscFunctions {
    public ArrayUtils arrayUtils;

    public static boolean applyRanges(FArray array) {
        block2: {
            if (!array.isDiscretized()) break block2;
            int i = 0;
            while (i < array.attributes.length) {
                block6: {
                    boolean bl;
                    block5: {
                        block3: {
                            block4: {
                                int n = i;
                                FArray fArray = array;
                                if (!fArray.isDiscretized()) break block3;
                                if (!fArray.isDiscretized(n)) break block4;
                                int n2 = fArray.rowsNumber();
                                int n3 = 0;
                                while (n3 < n2) {
                                    float f = fArray.discRanges[n].getDiscreteValue(fArray.readValue(n, n3));
                                    fArray.writeValue(n, n3, f);
                                    ++n3;
                                }
                                break block5;
                            }
                            bl = false;
                            break block6;
                        }
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String toStringRanges(FArray array) {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        FArray fArray = array;
        int cols = fArray.attributes.length;
        int i = 0;
        while (i < cols) {
            tmp.append("Attribute: " + i).append(" # ").append(array.attributes[i].name).append('\n');
            boolean discretized = false;
            if (array.isDiscretized(i)) {
                discretized = true;
            }
            tmp.append("Discretized: " + discretized).append('\n');
            if (discretized) {
                tmp.append("Ranges: " + array.discRanges[i].getSize()).append('\n');
                tmp.append(array.discRanges[i].toString());
                tmp.append('\n');
            }
            ++i;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void addColumnsUniform(FArray array, String colNamePrefix, int columns) {
        void var2_4;
        boolean bl = false;
        FArray fArray = array;
        int n = fArray.rowsNumber();
        FArray fArray2 = new FArray((int)var2_4, n);
        Random random = new Random();
        int n2 = 0;
        while (n2 < var2_4) {
            void var1_3;
            fArray2.attributes[n2].type = (short)2;
            fArray2.attributes[n2].name = String.valueOf(var1_3) + n2;
            int n3 = 0;
            while (n3 < n) {
                fArray2.writeValue(n2, n3, random.nextFloat());
                ++n3;
            }
            ++n2;
        }
        fArray.cbind(fArray2);
    }

    public static boolean isContrastAttribute(String colName) {
        return colName.startsWith(MCFSParams.CONTRAST_ATTR_NAME);
    }

    public static void addAttribute(Array array) {
        String string;
        block3: {
            Array array2;
            if (array2 != null) {
                int n = 1;
                while (true) {
                    String string2;
                    if (array2.getColIndex(string2 = "attr_" + Integer.toString(n)) == -1) {
                        string = string2;
                        break block3;
                    }
                    ++n;
                }
            }
            string = null;
        }
        DiscFunctions.addAttribute(array, string);
    }

    /*
     * WARNING - void declaration
     */
    public static void addAttribute(Array array, String name) {
        void var2_3;
        Array array2;
        void var1_1;
        void srcArray22;
        int rows = array.rowsNumber();
        Array srcArray22 = array instanceof FArray ? new FArray(1, rows) : new SArray(1, (int)srcArray22);
        srcArray22.attributes[0].name = var1_1;
        srcArray22.attributes[0].type = (short)2;
        array2.cbind((Array)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public DiscFunctions(Random random) {
        void var1_1;
        this.arrayUtils = new ArrayUtils((Random)var1_1);
    }

    public FArray balanceClasses(FArray srcArray, int[] balancedSizes) {
        FArray fArray;
        int decIndex = srcArray.getDecAttrIdx();
        float[] decColumn = srcArray.getColumn(decIndex);
        float[] decValues = srcArray.getDecValues();
        if (srcArray.getDecValues().length != balancedSizes.length) {
            System.err.println("Error. balancedSizes.lenght does not equal to srcArray.getDecValues().length.");
        }
        Object splitMask2 = new int[srcArray.rowsNumber()];
        int i = 0;
        while (i < decValues.length) {
            int[] nArray;
            int[] nArray2 = splitMask2;
            int n = balancedSizes[i];
            float f = decValues[i];
            float[] fArray2 = decColumn;
            splitMask2 = this;
            int n2 = fArray2.length;
            if (fArray2.length != nArray2.length) {
                nArray = null;
            } else {
                IntegerList integerList = new IntegerList(n2);
                int n3 = 0;
                while (n3 < n2) {
                    if (fArray2[n3] == f) {
                        integerList.add(n3);
                    }
                    ++n3;
                }
                if (integerList.size() != 0) {
                    if (n >= integerList.size()) {
                        n3 = 0;
                        while (n3 < n2) {
                            if (fArray2[n3] == f) {
                                nArray2[n3] = 1;
                            }
                            ++n3;
                        }
                    } else {
                        int[] nArray3 = new int[integerList.size()];
                        splitMask2.arrayUtils.randomFill(nArray3, n, 1, 0);
                        int splitMask2 = 0;
                        while (splitMask2 < nArray3.length) {
                            if (nArray3[splitMask2] == 1) {
                                nArray2[integerList.get((int)splitMask2)] = 1;
                            }
                            ++splitMask2;
                        }
                    }
                }
                nArray = nArray2;
            }
            splitMask2 = nArray;
            ++i;
        }
        FArray fArray3 = srcArray;
        boolean[] colMask = new boolean[fArray3.attributes.length];
        Arrays.fill(colMask, true);
        fArray = fArray.clone(colMask, ArrayUtils.int2boolean(splitMask2, 1));
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public FArray shuffleColumns(FArray srcArray) {
        void var2_2;
        FArray dstArray = srcArray.clone();
        FArray fArray = srcArray;
        float[] colMask = new float[fArray.attributes.length];
        int i = 0;
        while (i < colMask.length) {
            colMask[i] = i;
            ++i;
        }
        colMask = this.arrayUtils.shuffle(colMask, 3);
        i = 0;
        while (i < colMask.length) {
            int srcIndex = (int)colMask[i];
            dstArray.attributes[i] = srcArray.attributes[srcIndex];
            dstArray.setDomain(i, srcArray.getFDomain(srcIndex));
            dstArray.setColumn(i, srcArray.getColumn(srcIndex));
            if (srcIndex == srcArray.getDecAttrIdx()) {
                dstArray.setDecAttrIdx(i);
                dstArray.setDecValues(srcArray.getDecValues());
            }
            ++i;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Array selectRows(Array srcArray, String rowCondition) {
        void var2_5;
        void var1_4;
        Array array;
        Condition condition = new Condition();
        if (!condition.parse(rowCondition)) {
            System.err.println("Error Parsing Condition: " + rowCondition);
            return null;
        }
        int conditionAttrIndex2 = srcArray.getColIndex(condition.attributeName);
        if (conditionAttrIndex2 == -1) {
            System.err.println("Incorrect Attribute. Attribute: " + condition.attributeName + " is not present.");
            return null;
        }
        if (srcArray.attributes[conditionAttrIndex2].type == 1) {
            Operator conditionAttrIndex2 = condition.operator;
            if (conditionAttrIndex2.op == Operator.GREATER || conditionAttrIndex2.op == Operator.LESS || conditionAttrIndex2.op == Operator.GEQ || conditionAttrIndex2.op == Operator.LEQ) {
                System.err.println("Incorrect Operator. Attribute is NOMINAL ( use '=' or '!=' ).");
                return null;
            }
        }
        boolean[] colMask = new boolean[srcArray.colsNumber()];
        Arrays.fill(colMask, true);
        boolean[] rowMask = DiscFunctions.getRowMask(srcArray, condition);
        if (rowMask == null) {
            return null;
        }
        return array.clone((boolean[])var1_4, (boolean[])var2_5);
    }

    private static boolean[] getRowMask(Array array, Condition condition) {
        int conditionAttrIndex = array.getColIndex(condition.attributeName);
        if (conditionAttrIndex == -1) {
            System.err.println("Incorrect Attribute. Attribute: " + condition.attributeName + " does not exist in the array.");
            return null;
        }
        float conditionValue = Float.NaN;
        if (array.attributes[conditionAttrIndex].type == 2) {
            try {
                conditionValue = Float.parseFloat(condition.value);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Incorrect Condition Value. Value: " + condition.value + " is not numeric.");
                return null;
            }
        }
        boolean[] rowMask = new boolean[array.rowsNumber()];
        Arrays.fill(rowMask, false);
        int i = 0;
        while (i < rowMask.length) {
            Object value = array.readValueStr(conditionAttrIndex, i);
            if (array.attributes[conditionAttrIndex].type == 1) {
                String string = condition.value;
                String string2 = value;
                value = condition.operator;
                if (((Operator)value).op == 0 && string2.equalsIgnoreCase(string) ? true : ((Operator)value).op == Operator.NOTEQUAL && !string2.equalsIgnoreCase(string)) {
                    rowMask[i] = true;
                }
            } else if (array.attributes[conditionAttrIndex].type == 2) {
                float f = conditionValue;
                float f2 = Float.parseFloat((String)value);
                Operator operator = condition.operator;
                if (operator.op == 0 && f2 == f ? true : (operator.op == Operator.GREATER && f2 > f ? true : (operator.op == Operator.LESS && f2 < f ? true : (operator.op == Operator.GEQ && f2 >= f ? true : (operator.op == Operator.LEQ && f2 <= f ? true : operator.op == Operator.NOTEQUAL && f2 != f))))) {
                    rowMask[i] = true;
                }
            }
            ++i;
        }
        return rowMask;
    }

    /*
     * WARNING - void declaration
     */
    public Array selectRowsRandom(Array srcArray, float dstRows) {
        void var3_4;
        void var2_3;
        Array array;
        if (dstRows <= 0.0f || (float)srcArray.rowsNumber() <= dstRows) {
            return srcArray;
        }
        if (dstRows < 1.0f) {
            dstRows = Math.round(dstRows * (float)srcArray.rowsNumber());
        }
        int[] splitMask = new int[srcArray.rowsNumber()];
        this.arrayUtils.randomFill(splitMask, (int)dstRows, 1);
        boolean[] colMask = new boolean[srcArray.colsNumber()];
        Arrays.fill(colMask, true);
        array = array.clone((boolean[])var2_3, ArrayUtils.int2boolean((int[])var3_4, 1));
        return array;
    }

    /*
     * WARNING - void declaration
     */
    public int[] getSplitMaskRandom(Array srcArray, double splitRatio) {
        void var1_2;
        void var2_3;
        int[] splitMask = new int[srcArray.rowsNumber()];
        int dstRows = (int)((double)srcArray.rowsNumber() * var2_3);
        this.arrayUtils.randomFill(splitMask, (int)var1_2, 1, 0);
        return splitMask;
    }

    /*
     * WARNING - void declaration
     */
    public int[] getSplitMaskUniform(FArray srcArray, double splitRatio2) {
        if (srcArray.attributes[srcArray.getDecAttrIdx()].type != 1) {
            return this.getSplitMaskRandom(srcArray, splitRatio2);
        }
        float[] decColumn = srcArray.getColumn(srcArray.getDecAttrIdx());
        int srcRows = srcArray.rowsNumber();
        float[] decValues = srcArray.getDecValues();
        double d = splitRatio2;
        float[] fArray = decValues;
        Object[] splitRatio2 = decColumn;
        splitRatio2 = ArrayUtils.distribution(decColumn, fArray);
        int n = 0;
        while (n < fArray.length) {
            splitRatio2[n] = (int)Math.floor((double)splitRatio2[n] * d);
            ++n;
        }
        int[] splitMask = new int[srcRows];
        IntegerList[] intList = new IntegerList[decValues.length];
        int i = 0;
        while (i < intList.length) {
            intList[i] = new IntegerList();
            ++i;
        }
        i = 0;
        while (i < decColumn.length) {
            int j = 0;
            while (j < decValues.length) {
                if (decColumn[i] == decValues[j]) {
                    intList[j].add(i);
                }
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < decValues.length) {
            void distribution;
            int size = intList[j].size();
            int[] random = new int[size];
            this.arrayUtils.randomFill(random, (int)distribution[j], 1);
            int i2 = 0;
            while (i2 < size) {
                if (random[i2] == 1) {
                    splitMask[intList[j].get((int)i2)] = 1;
                }
                ++i2;
            }
            ++j;
        }
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public static Array[] split(Array srcArray, int[] splitMask) {
        void var3_3;
        void var1_1;
        void var2_2;
        Array array;
        if (!srcArray.domainsCreated()) {
            srcArray.findDomains();
        }
        boolean[] colMask = new boolean[srcArray.colsNumber()];
        Arrays.fill(colMask, true);
        Array[] arrayArray = new Array[2];
        Array[] trainTestArrays = arrayArray;
        arrayArray[0] = srcArray.clone(colMask, ArrayUtils.int2boolean(splitMask, 1));
        trainTestArrays[1] = array.clone((boolean[])var2_2, ArrayUtils.int2boolean((int[])var1_1, 0));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int[] getColumnsMask(Array srcArray, int dstColumns) {
        int decisionIndex = srcArray.getDecAttrIdx();
        int srcColumns = srcArray.colsNumber();
        int[] colMask = new int[srcColumns];
        if ((double)dstColumns > (double)srcColumns / 2.0) {
            void var1_2;
            Arrays.fill(colMask, 1);
            colMask[decisionIndex] = 0;
            this.arrayUtils.randomFill(colMask, (int)(var1_2 - dstColumns - true), 0);
            colMask[decisionIndex] = 1;
        } else {
            void var2_3;
            Arrays.fill(colMask, 0);
            colMask[var3_4] = 1;
            this.arrayUtils.randomFill(colMask, (int)var2_3, 1);
        }
        return colMask;
    }

    /*
     * WARNING - void declaration
     */
    public static Array selectColumns(Array array, String[] colNames) {
        void var3_3;
        void var1_1;
        Array array2;
        HashSet colNamesSet = new HashSet();
        Collections.addAll(colNamesSet, colNames);
        boolean[] colMask = new boolean[array.colsNumber()];
        boolean[] rowMask = new boolean[array.rowsNumber()];
        Arrays.fill(colMask, false);
        Arrays.fill(rowMask, true);
        int i = 0;
        while (i < array.attributes.length) {
            if (colNamesSet.contains(array.attributes[i].name)) {
                colMask[i] = true;
            }
            ++i;
        }
        array2 = array2.clone((boolean[])var1_1, (boolean[])var3_3);
        return array2;
    }

    /*
     * WARNING - void declaration
     */
    public static Array selectColumns(Array srcArray, AttributesRI importances, int dstColumns) {
        void var1_1;
        Array array;
        void var2_2;
        if (dstColumns >= srcArray.colsNumber()) {
            return srcArray;
        }
        Cloneable cloneable = null;
        ArrayList<String> finalAttributes = new ArrayList<String>();
        Ranking topRanking = importances.getTopRankingSize(importances.mainMeasureIdx, (int)var2_2);
        finalAttributes.addAll(Arrays.asList(topRanking.getAttributesNames()));
        finalAttributes.add(srcArray.attributes[srcArray.getDecAttrIdx()].name);
        String[] attributes = new String[1];
        attributes = cloneable.toArray(attributes);
        cloneable = DiscFunctions.selectColumns(array, (String[])var1_1);
        return cloneable;
    }

    /*
     * WARNING - void declaration
     */
    public static Instances convert(FArray array) {
        void var3_4;
        FArray fArray;
        void var1_1;
        if (!array.domainsCreated()) {
            System.err.println("Cannot convert to Instances. Domains of input FArray are not determined!");
            return null;
        }
        FastVector attInfo = new FastVector();
        int rows = array.rowsNumber();
        int i = 0;
        while (i < array.attributes.length) {
            if (array.attributes[i].type == 2) {
                attInfo.addElement((Object)new Attribute(array.attributes[i].name));
            } else if (array.attributes[i].type == 1) {
                String[] domainValues = array.getDomainStr(i);
                FastVector vect = new FastVector(domainValues.length);
                int v = 0;
                while (v < domainValues.length) {
                    vect.addElement((Object)domainValues[v]);
                    ++v;
                }
                attInfo.addElement((Object)new Attribute(array.attributes[i].name, vect));
            }
            ++i;
        }
        Instances instances = new Instances("converted", (FastVector)var1_1, rows);
        int j = 0;
        while (j < rows) {
            Instance instance = new Instance(array.attributes.length);
            instance.setDataset(instances);
            int i2 = 0;
            while (i2 < array.attributes.length) {
                if (array.attributes[i2].type == 2) {
                    instance.setValue(i2, (double)array.readValue(i2, j));
                } else if (array.attributes[i2].type == 1) {
                    instance.setValue(i2, array.readValueStr(i2, j));
                }
                ++i2;
            }
            instances.add(instance);
            ++j;
        }
        instances.setClassIndex(fArray.getDecAttrIdx());
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static double calc(float posCoverage, float negCoverage, int qMethod) {
        void var2_2;
        if (qMethod == 0) {
            return posCoverage - negCoverage;
        }
        if (qMethod == 1) {
            return (posCoverage - negCoverage) * (1.0f - negCoverage);
        }
        if (qMethod == 2) {
            return (double)(posCoverage - negCoverage) * Math.pow(1.0f - negCoverage, 2.0);
        }
        if (qMethod == 3) {
            return posCoverage;
        }
        if (qMethod == 4) {
            return 1.0 / (double)negCoverage;
        }
        if (var2_2 == 5) {
            void var1_1;
            float f;
            return f * (1.0f - var1_1);
        }
        return -1.0;
    }

    /*
     * WARNING - void declaration
     */
    public static String getFileExtension(String fileName) {
        void var1_1;
        String extension = "";
        int index = fileName.lastIndexOf(46);
        if (index > 0 && index < fileName.length() - 1) {
            void var2_2;
            String string;
            extension = string.substring((int)(var2_2 + true)).toLowerCase();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String dropFileExtension(File label) {
        void var1_2;
        String string;
        String name = label.getName();
        String ext = DiscFunctions.getFileExtension(name);
        int index = name.lastIndexOf(ext);
        string = string.substring(0, (int)(var1_2 - true));
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean saveString(String fileName, String data) {
        FileWriter file;
        try {
            file = new FileWriter(fileName, false);
        }
        catch (IOException iOException) {
            System.err.println("Error opening file: " + fileName);
            return false;
        }
        try {
            void var2_2;
            void var1_1;
            file.write((String)var1_1);
            var2_2.close();
        }
        catch (IOException iOException) {
            String string;
            System.err.println("Error writing or closing file: " + string);
            return false;
        }
        return true;
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            File file2;
            file2.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileToZip(String fileName, ZipOutputStream zos) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            void var2_2;
            void var1_1;
            int length;
            FileInputStream fis = new FileInputStream(file);
            File zipEntry = new ZipEntry(file.getName());
            zos.putNextEntry((ZipEntry)((Object)zipEntry));
            File bytes = (File)new byte[4096];
            while ((length = fis.read((byte[])bytes)) >= 0) {
                zos.write((byte[])bytes, 0, length);
            }
            var1_1.closeEntry();
            var2_2.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void extractFile(ZipInputStream in, File outdir, String name) throws IOException {
        void var1_1;
        int count;
        byte[] buffer = new byte[4096];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outdir, name)));
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    private static void mkdirs(File outdir, String path) {
        void var1_1;
        File d = new File(outdir, (String)var1_1);
        if (!d.exists()) {
            File file;
            file.mkdirs();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static File[] extract(File zipfile, File outdir, String fileNamePrefix) {
        File[] fileArray;
        void var3_3;
        File[] zin;
        ArrayList<File> extracted = new ArrayList<File>();
        try {
            Object entry;
            zin = new ZipInputStream(new FileInputStream(zipfile));
            while ((entry = zin.getNextEntry()) != null) {
                String name = ((ZipEntry)entry).getName();
                if (((ZipEntry)entry).isDirectory()) {
                    DiscFunctions.mkdirs(outdir, name);
                    continue;
                }
                entry = name;
                int n = ((String)entry).lastIndexOf(File.separatorChar);
                String dir = n == -1 ? null : ((String)entry).substring(0, n);
                if (dir != null) {
                    DiscFunctions.mkdirs(outdir, dir);
                }
                if (fileNamePrefix.length() <= 0 || !name.toLowerCase().startsWith(fileNamePrefix.toLowerCase())) continue;
                DiscFunctions.extractFile((ZipInputStream)zin, outdir, name);
                extracted.add(new File(name));
            }
            zin.close();
        }
        catch (IOException iOException) {
            zin = iOException;
            iOException.printStackTrace();
        }
        if (extracted.size() == 0) {
            return null;
        }
        File[] f = new File[1];
        return var3_3.toArray(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader openFile(File file) {
        void var1_1;
        if (!file.exists()) {
            System.err.println("File does not exist. File: " + file.toString());
            return null;
        }
        try {
            BufferedReader fileReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            File file2;
            System.err.println("Error opening file. File: " + file2.toString());
            return null;
        }
        return var1_1;
    }

    public static boolean closeFile(BufferedReader fileReader) {
        try {
            if (fileReader != null) {
                BufferedReader bufferedReader;
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Error closing file.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatFloat(double number, int precision) {
        void var3_3;
        void var0_1;
        void var2_2;
        String power = "";
        String tempString = Double.toString(number);
        int ePosition = tempString.indexOf("E");
        int dotPosition = tempString.lastIndexOf(46);
        if (ePosition != -1) {
            void var1_4;
            power = tempString.substring((int)var1_4, tempString.length());
        }
        dotPosition = dotPosition == -1 || dotPosition + precision + 1 > tempString.length() ? tempString.length() : (dotPosition += var2_2 + true);
        return String.valueOf(var0_1.substring(0, dotPosition)) + (String)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String timeIntervalFormat(float seconds) {
        void var0_1;
        void var1_2;
        float retString22;
        float f;
        float s = seconds;
        String retString22 = f < 1.0f ? String.valueOf(MathUtils.truncate(seconds, 3)) + " s." : (s < 60.0f ? String.valueOf(MathUtils.truncate(retString22, 1)) + " s." : (var1_2 < 3600.0f ? String.valueOf(MathUtils.truncate(retString22 / 60.0f, 1)) + " min." : String.valueOf(MathUtils.truncate(retString22 / 3600.0f, 1)) + " hours"));
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] tokenizeString(String s, char[] separators, boolean mergeSeparators) {
        String[] stringArray;
        void var3_3;
        int n;
        if (s == null || s.length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int lineSize = s.length();
        while (n < lineSize) {
            String value;
            int stop = DiscFunctions.minIndexOf(s, start, separators);
            if (stop == -1) {
                stop = s.length();
            }
            if ((value = s.substring(start, stop).trim()).length() != 0) {
                list.add(value);
            } else if (!mergeSeparators) {
                list.add("");
            }
            n = stop + 1;
        }
        String[] array = new String[1];
        stringArray = var3_3.toArray(stringArray);
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private static int minIndexOf(String s, int start, char[] chars) {
        void var3_3;
        String string;
        int minIndex = s.length() + 1;
        int i = 0;
        while (i < chars.length) {
            int currIndex = s.indexOf(chars[i], start);
            if (currIndex < minIndex && currIndex != -1) {
                minIndex = currIndex;
            }
            ++i;
        }
        if (minIndex == string.length() + 1) {
            return -1;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] tokenize(String s, char[] separators, char[] quoteChar) {
        void var1_3;
        void var3_5;
        ArrayList<String> tokens = new ArrayList<String>();
        StringReader reader = new StringReader(s);
        StringReader st = new StreamTokenizer(reader);
        ((StreamTokenizer)((Object)st)).resetSyntax();
        ((StreamTokenizer)((Object)st)).wordChars(32, 254);
        int i = 0;
        while (i < 2) {
            ((StreamTokenizer)((Object)st)).whitespaceChars(separators[i], separators[i]);
            ++i;
        }
        i = 0;
        while (i < 2) {
            ((StreamTokenizer)((Object)st)).quoteChar(quoteChar[i]);
            ++i;
        }
        boolean eof = false;
        block10: do {
            int token = -1;
            try {
                token = ((StreamTokenizer)((Object)st)).nextToken();
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
            switch (token) {
                case -1: {
                    eof = true;
                    break;
                }
                case 10: {
                    break;
                }
                case -3: {
                    tokens.add(((StreamTokenizer)((Object)st)).sval.trim());
                    break;
                }
                case -2: {
                    tokens.add(Double.toString(((StreamTokenizer)((Object)st)).nval).trim());
                    break;
                }
                default: {
                    tokens.add(((StreamTokenizer)((Object)st)).sval);
                    if (token != 33) continue block10;
                    eof = true;
                }
            }
        } while (!eof);
        String[] tokensArray = new String[1];
        return (String[])var3_5.toArray((T[])var1_3);
    }

    public static String replaceAll(String s, String source, String destination) {
        CharSequence charSequence;
        CharSequence tmp = new StringBuffer(s);
        int start = ((StringBuffer)tmp).indexOf(source);
        while (start != -1) {
            ((StringBuffer)tmp).replace(start, start + source.length(), destination);
            start = ((StringBuffer)tmp).indexOf(source, start + destination.length());
        }
        return ((StringBuffer)charSequence).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static char[] toCharArray(String s, int size) {
        void var2_2;
        void var3_3;
        String string;
        char[] charArray = new char[size];
        Arrays.fill(charArray, ' ');
        int stop = s.length();
        if (stop > size) {
            void var1_1;
            stop = var1_1;
        }
        string.getChars(0, (int)var3_3, charArray, 0);
        return var2_2;
    }

    public static boolean equalsToAny(String inputString, String[] items) {
        int i = 0;
        while (i < items.length) {
            if (inputString.equalsIgnoreCase(items[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] getConfidenceInterval(double alpha, double[] x) {
        void var3_3;
        double t;
        void var2_2;
        int size = x.length;
        double stdev = MathUtils.stdev(x);
        double avg = MathUtils.mean((double[])var2_2);
        try {
            t = Probability.studentTInverse((double)alpha, (int)(size - 1));
        }
        catch (Exception exception) {
            double d;
            System.out.println("T-Student Inverse Error:");
            System.out.println("alpha: " + d + " size: " + (size - 1));
            return null;
        }
        double conf1 = avg - t * stdev / Math.sqrt(size);
        double conf2 = avg + t * stdev / Math.sqrt((double)var3_3);
        double[] dArray = new double[]{conf1, conf2};
        return dArray;
    }

    public static double andersonDarlingNormTest(double[] x) {
        double[] dArray;
        double d = NormalityTest.anderson_darling_statistic((double[])x);
        double d2 = NormalityTest.anderson_darling_pvalue((double)d, (int)dArray.length);
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    public static float pearson(double[] x, double[] y) {
        void var2_8;
        if (x.length != y.length) {
            return Float.NaN;
        }
        double avg_x = MathUtils.mean(x);
        double avg_y = MathUtils.mean(y);
        double numerator = 0.0;
        double denominator_x = 0.0;
        double denominator_y = 0.0;
        int i = 0;
        while (i < x.length) {
            numerator += (x[i] - avg_x) * (y[i] - avg_y);
            denominator_x += Math.pow(x[i] - avg_x, 2.0);
            denominator_y += Math.pow(y[i] - avg_y, 2.0);
            ++i;
        }
        double pearson = numerator / (Math.sqrt(denominator_x) * Math.sqrt(denominator_y));
        if (Double.isNaN(pearson)) {
            pearson = 0.0;
        }
        return (float)var2_8;
    }
}

