/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;

public class Discretize
extends Expression {
    protected String m_fieldName;
    protected int m_fieldIndex;
    protected boolean m_mapMissingDefined = false;
    protected String m_mapMissingTo;
    protected boolean m_defaultValueDefined = false;
    protected String m_defaultValue;
    protected ArrayList<DiscretizeBin> m_bins = new ArrayList();
    protected Attribute m_outputDef;

    public Discretize(Element discretize, FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs) throws Exception {
        super(opType, fieldDefs);
        if (opType == FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[Discretize] must have a categorical or ordinal optype");
        }
        this.m_fieldName = discretize.getAttribute("field");
        this.m_mapMissingTo = discretize.getAttribute("mapMissingTo");
        if (this.m_mapMissingTo != null && this.m_mapMissingTo.length() > 0) {
            this.m_mapMissingDefined = true;
        }
        this.m_defaultValue = discretize.getAttribute("defaultValue");
        if (this.m_defaultValue != null && this.m_defaultValue.length() > 0) {
            this.m_defaultValueDefined = true;
        }
        NodeList dbL = discretize.getElementsByTagName("DiscretizeBin");
        int i = 0;
        while (i < dbL.getLength()) {
            Node dbN = dbL.item(i);
            if (dbN.getNodeType() == 1) {
                Element dbE = (Element)dbN;
                DiscretizeBin db = new DiscretizeBin(dbE);
                this.m_bins.add(db);
            }
            ++i;
        }
        this.setUpField();
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> fieldDefs) throws Exception {
        super.setFieldDefs(fieldDefs);
        this.setUpField();
    }

    private void setUpField() throws Exception {
        this.m_fieldIndex = -1;
        if (this.m_fieldDefs != null) {
            this.m_fieldIndex = this.getFieldDefIndex(this.m_fieldName);
            if (this.m_fieldIndex < 0) {
                throw new Exception("[Discretize] Can't find field " + this.m_fieldName + " in the supplied field definitions.");
            }
            Attribute field = (Attribute)this.m_fieldDefs.get(this.m_fieldIndex);
            if (!field.isNumeric()) {
                throw new Exception("[Discretize] reference field " + this.m_fieldName + " must be continuous.");
            }
        }
        Attribute tempAtt = new Attribute("temp", null);
        for (DiscretizeBin d : this.m_bins) {
            tempAtt.addStringValue(d.getBinValue());
        }
        if (this.m_defaultValueDefined) {
            tempAtt.addStringValue(this.m_defaultValue);
        }
        if (this.m_mapMissingDefined) {
            tempAtt.addStringValue(this.m_mapMissingTo);
        }
        FastVector values = new FastVector();
        int i = 0;
        while (i < tempAtt.numValues()) {
            values.addElement(tempAtt.value(i));
            ++i;
        }
        this.m_outputDef = new Attribute(String.valueOf(this.m_fieldName) + "_discretized", values);
    }

    @Override
    protected Attribute getOutputDef() {
        return this.m_outputDef;
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        double result = Instance.missingValue();
        double value = incoming[this.m_fieldIndex];
        if (Instance.isMissingValue(value)) {
            if (this.m_mapMissingDefined) {
                result = this.m_outputDef.indexOfValue(this.m_mapMissingTo);
            }
        } else {
            boolean found = false;
            for (DiscretizeBin b : this.m_bins) {
                if (!b.containsValue(value)) continue;
                found = true;
                result = this.m_outputDef.indexOfValue(b.getBinValue());
                break;
            }
            if (!found && this.m_defaultValueDefined) {
                result = this.m_outputDef.indexOfValue(this.m_defaultValue);
            }
        }
        return result;
    }

    @Override
    public String getResultCategorical(double[] incoming) throws Exception {
        double index = this.getResult(incoming);
        if (Instance.isMissingValue(index)) {
            return "**Missing Value**";
        }
        return this.m_outputDef.value((int)index);
    }

    @Override
    public String toString(String pad) {
        StringBuffer buff = new StringBuffer();
        buff.append(String.valueOf(pad) + "Discretize (" + this.m_fieldName + "):");
        for (DiscretizeBin d : this.m_bins) {
            buff.append("\n" + pad + d.toString());
        }
        if (this.m_mapMissingDefined) {
            buff.append("\n" + pad + "map missing values to: " + this.m_mapMissingTo);
        }
        if (this.m_defaultValueDefined) {
            buff.append("\n" + pad + "defautl value: " + this.m_defaultValue);
        }
        return buff.toString();
    }

    protected class DiscretizeBin
    implements Serializable {
        private static final long serialVersionUID = 5810063243316808400L;
        private ArrayList<FieldMetaInfo.Interval> m_intervals = new ArrayList();
        private String m_binValue;

        protected DiscretizeBin(Element bin) throws Exception {
            NodeList iL = bin.getElementsByTagName("Interval");
            int i = 0;
            while (i < iL.getLength()) {
                Node iN = iL.item(i);
                if (iN.getNodeType() == 1) {
                    FieldMetaInfo.Interval tempInterval = new FieldMetaInfo.Interval((Element)iN);
                    this.m_intervals.add(tempInterval);
                }
                ++i;
            }
            this.m_binValue = bin.getAttribute("binValue");
        }

        protected String getBinValue() {
            return this.m_binValue;
        }

        protected boolean containsValue(double value) {
            boolean result = false;
            for (FieldMetaInfo.Interval i : this.m_intervals) {
                if (!i.containsValue(value)) continue;
                result = true;
                break;
            }
            return result;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("\"" + this.m_binValue + "\" if value in: ");
            boolean first = true;
            for (FieldMetaInfo.Interval i : this.m_intervals) {
                if (!first) {
                    buff.append(", ");
                } else {
                    first = false;
                }
                buff.append(i.toString());
            }
            return buff.toString();
        }
    }
}

