/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.loader;

import dmLab.array.Array;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.Data2Array;
import dmLab.array.loader.fileLoader.FileLoader;
import dmLab.array.loader.fileLoader.FileLoaderADH;
import dmLab.array.loader.fileLoader.FileLoaderADX;
import dmLab.array.loader.fileLoader.FileLoaderArff;
import dmLab.array.loader.fileLoader.FileLoaderCSV;
import dmLab.array.loader.fileLoader.FileType;
import dmLab.mcfs.MCFSParams;
import java.io.File;
import java.util.Arrays;

public final class File2Array
extends Data2Array {
    private FileLoader fileLoader = null;
    public char separatorCSV = (char)44;
    public boolean firstLineContainsAttributesCSV = true;
    public String defaultAttributeNameCSV = "attr";
    public boolean trimCommentsCSV = false;
    public boolean consequentSeparatorsTreatAsOneCSV = false;

    /*
     * WARNING - void declaration
     */
    public final boolean load(Array array, String inputFileName) {
        void var1_2;
        void var2_3;
        Object object;
        Object tmpFile;
        Object fileNamePrefix;
        Object[] extracted = null;
        File file = new File(inputFileName);
        if (DiscFunctions.getFileExtension(file.getName()).equalsIgnoreCase("zip")) {
            fileNamePrefix = DiscFunctions.dropFileExtension(file);
            extracted = DiscFunctions.extract(file, new File(MCFSParams.TMP_PATH), (String)fileNamePrefix);
            Arrays.sort(extracted);
            if (extracted == null || extracted.length == 0) {
                System.err.println("Input Zip file: '" + file.toString() + "' does not contain any '" + (String)fileNamePrefix + ".*' file. '");
                return false;
            }
            tmpFile = null;
            int i = 0;
            while (i < extracted.length) {
                if (DiscFunctions.equalsToAny(DiscFunctions.getFileExtension(((File)extracted[i]).getName()), new String[]{"adx", "adh", "arff", "csv"})) {
                    tmpFile = extracted[i];
                    break;
                }
                ++i;
            }
            if (tmpFile == null) {
                System.err.println("Input Zip file: '" + file.toString() + "' does not contain any data file: '" + (String)fileNamePrefix + "[.adx, .adh, .arff, .csv]'.");
                return false;
            }
            file = new File(String.valueOf(MCFSParams.TMP_PATH) + ((File)tmpFile).toString());
        }
        tmpFile = file;
        fileNamePrefix = this;
        String string = DiscFunctions.getFileExtension(((File)tmpFile).getName());
        int n = FileType.toType(string);
        if (n == 0) {
            object = new FileLoaderADX();
        } else if (n == 1) {
            object = new FileLoaderADH();
        } else if (n == 2) {
            object = new FileLoaderArff();
        } else if (n == 3) {
            tmpFile = new FileLoaderCSV();
            new FileLoaderCSV().firstLineContainsAttributes = ((File2Array)fileNamePrefix).firstLineContainsAttributesCSV;
            ((FileLoaderCSV)tmpFile).separator = ((File2Array)fileNamePrefix).separatorCSV;
            ((FileLoaderCSV)tmpFile).defaultAttributeName = ((File2Array)fileNamePrefix).defaultAttributeNameCSV;
            ((FileLoaderCSV)tmpFile).trimComments = ((File2Array)fileNamePrefix).trimCommentsCSV;
            ((FileLoaderCSV)tmpFile).consequentSeparatorsTreatAsOne = ((File2Array)fileNamePrefix).consequentSeparatorsTreatAsOneCSV;
            object = tmpFile;
        } else {
            System.err.println("Format of input file: " + ((File)tmpFile).getName() + " is not recognized.");
            object = this.fileLoader = null;
        }
        if (this.fileLoader == null) {
            return false;
        }
        this.fileLoader.init();
        boolean retVal = this.fileLoader.loadFile(array, (File)var2_3);
        if (extracted != null) {
            int i = 0;
            while (i < extracted.length) {
                tmpFile = new File(String.valueOf(MCFSParams.TMP_PATH) + ((File)extracted[i]).toString());
                if (((File)tmpFile).exists()) {
                    ((File)tmpFile).delete();
                }
                ++i;
            }
        }
        return (boolean)var1_2;
    }
}

