/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.attributesID;

import dmLab.array.functions.DiscFunctions;
import dmLab.mcfs.attributesID.Dependency;
import dmLab.mcfs.attributesID.DependencyFactors;
import dmLab.mcfs.attributesID.DependencyIdx;
import dmLab.mcfs.attributesID.DependencyList;
import dmLab.mcfs.attributesID.graph.IDGraph;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.utils.MyDict;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public final class AttributesID {
    private HashMap<DependencyIdx, DependencyFactors> connections;
    private MyDict myDict;
    private float maxID;
    private float minID;
    private boolean directedGraph;
    private boolean selfID;
    public static String CONN_FILE_HEADER = "parent,child,weight";

    /*
     * WARNING - void declaration
     */
    private AttributesID(MyDict myDict, boolean directed, boolean selfID) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.myDict = var1_1;
        this.directedGraph = var2_2;
        this.selfID = var3_3;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public AttributesID(String[] attributes, boolean directed, boolean selfID) {
        void var1_1;
        this.myDict = new MyDict((String[])var1_1);
        this.directedGraph = true;
        this.selfID = false;
        this.init();
    }

    public AttributesID(boolean directed, boolean selfID) {
        this.myDict = new MyDict();
        this.directedGraph = true;
        this.selfID = false;
        this.init();
    }

    public final void init() {
        this.connections = new HashMap();
        this.maxID = Float.NaN;
        this.minID = Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public final int addDependency(String parent, String child, float weight) {
        if (!this.selfID && parent.equalsIgnoreCase(child)) {
            return this.connections.size();
        }
        this.put(parent, child, weight);
        if (!this.directedGraph) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.put((String)var2_2, (String)var1_1, (float)var3_3);
        }
        return this.connections.size();
    }

    /*
     * WARNING - void declaration
     */
    private int put(String parent, String child, float weight) {
        int childId;
        int parentId = this.myDict.put(parent);
        DependencyIdx connID = new DependencyIdx(parentId, childId = this.myDict.put(child));
        DependencyFactors connFactors = this.connections.get(connID);
        if (connFactors == null) {
            void var1_3;
            connFactors = new DependencyFactors(weight);
            this.connections.put((DependencyIdx)var1_3, connFactors);
        } else {
            void var3_7;
            void var2_6;
            var2_6.addWeight((float)var3_7);
        }
        return this.connections.size();
    }

    /*
     * WARNING - void declaration
     */
    private int put(DependencyIdx dependencyIdx, DependencyFactors dependencyFactors) {
        void var1_1;
        DependencyFactors myConnFactors = this.connections.get(dependencyIdx);
        if (myConnFactors == null) {
            this.connections.put((DependencyIdx)var1_1, dependencyFactors);
        } else {
            void var2_2;
            void var3_3;
            var1_1 = var3_3;
            var1_1.addWeight(var2_2.weight);
        }
        return this.connections.size();
    }

    public final int addDependencies(AttributesID attrID) {
        DependencyIdx[] connectionIds = new DependencyIdx[1];
        connectionIds = attrID.connections.keySet().toArray(connectionIds);
        int i = 0;
        while (i < connectionIds.length) {
            DependencyIdx connId = connectionIds[i];
            if (connId != null) {
                DependencyFactors connFactors = attrID.connections.get(connId);
                this.put(connId, connFactors);
            }
            ++i;
        }
        return this.connections.size();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(CONN_FILE_HEADER).append('\n');
        DependencyIdx[] connectionIds = new DependencyIdx[1];
        connectionIds = this.connections.keySet().toArray(connectionIds);
        int i = 0;
        while (i < connectionIds.length) {
            DependencyIdx connId = connectionIds[i];
            if (connId != null) {
                DependencyFactors connFactors = this.connections.get(connId);
                tmp.append(connId.toString(this.myDict)).append(",").append(connFactors.toString()).append("\n");
            }
            ++i;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private DependencyList getDependencyLists() {
        String[] attributes = this.myDict.getKeys();
        DependencyIdx[] dependencyIndex = new DependencyIdx[1];
        dependencyIndex = this.connections.keySet().toArray(dependencyIndex);
        int[] attrIds = new int[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            attrIds[i] = this.myDict.get(attributes[i]);
            ++i;
        }
        DependencyList cll = new DependencyList(attrIds);
        int i2 = 0;
        while (i2 < dependencyIndex.length) {
            DependencyIdx connId = dependencyIndex[i2];
            if (connId != null) {
                void var3_4;
                cll.put(connId.parentId, var3_4.childId);
            }
            ++i2;
        }
        return cll;
    }

    public final boolean save(String fileName) {
        AttributesID attributesID = this;
        String[] stringArray = attributesID.myDict.getKeys();
        StringBuffer stringBuffer = new StringBuffer();
        DependencyList dependencyList = attributesID.getDependencyLists();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = attributesID.myDict.get(stringArray[n]);
            Integer[] integerArray = dependencyList.getValues(n2);
            if (integerArray != null) {
                stringBuffer.append(stringArray[n]);
                Object[] objectArray = new Dependency[integerArray.length];
                int n3 = 0;
                while (n3 < integerArray.length) {
                    DependencyIdx dependencyIdx = new DependencyIdx(n2, integerArray[n3]);
                    DependencyFactors dependencyFactors = attributesID.connections.get(dependencyIdx);
                    objectArray[n3] = new Dependency(dependencyIdx, dependencyFactors);
                    ++n3;
                }
                Arrays.sort(objectArray);
                n3 = 0;
                while (n3 < objectArray.length) {
                    stringBuffer.append(',').append(attributesID.myDict.get(((Dependency)objectArray[n3]).connId.childId)).append("(" + ((Dependency)objectArray[n3]).connFactors.toString() + ")");
                    ++n3;
                }
                stringBuffer.append('\n');
            }
            ++n;
        }
        return DiscFunctions.saveString(fileName, stringBuffer.toString());
    }

    /*
     * WARNING - void declaration
     */
    public final AttributesID cut(float minWeight, AttributesRI importance, int attrNumber) {
        void var1_1;
        Object object;
        Ranking ranking = null;
        String[] selectedAttr = null;
        if (importance != null) {
            void var3_4;
            ranking = importance.getTopRankingSize(object.mainMeasureIdx, (int)var3_4);
        }
        if (ranking != null) {
            selectedAttr = ranking.getAttributesNames();
        }
        void var3_5 = var1_1;
        object = selectedAttr;
        AttributesID attributesID = this;
        AttributesID attributesID2 = new AttributesID(attributesID.myDict.clone(), attributesID.directedGraph, attributesID.selfID);
        HashSet<Integer> hashSet = null;
        if (object != null) {
            hashSet = new HashSet<Integer>();
            int n = 0;
            while (n < ((String[])object).length) {
                Integer n2 = attributesID.myDict.get(object[n]);
                if (n2 != null) {
                    hashSet.add(n2);
                }
                ++n;
            }
        }
        DependencyIdx[] dependencyIdxArray = new DependencyIdx[1];
        dependencyIdxArray = attributesID.connections.keySet().toArray(dependencyIdxArray);
        int n = 0;
        while (n < dependencyIdxArray.length) {
            object = dependencyIdxArray[n];
            if (object != null) {
                DependencyFactors dependencyFactors;
                DependencyFactors dependencyFactors2 = attributesID.connections.get(object);
                boolean bl = dependencyFactors.weight >= var3_5;
                bl = hashSet == null ? (bl &= true) : (hashSet.contains(object.parentId) && hashSet.contains(object.childId) ? (bl &= true) : false);
                if (bl) {
                    attributesID2.put((DependencyIdx)object, dependencyFactors2);
                }
            }
            ++n;
        }
        attributesID2.findMinMaxID();
        attributesID = attributesID2;
        return attributesID;
    }

    /*
     * WARNING - void declaration
     */
    public final IDGraph toGraph() {
        void var1_1;
        IDGraph graph = new IDGraph();
        DependencyIdx[] connectionIds = new DependencyIdx[1];
        connectionIds = this.connections.keySet().toArray(connectionIds);
        int i = 0;
        while (i < connectionIds.length) {
            DependencyIdx connId = connectionIds[i];
            if (connId != null) {
                DependencyFactors connFactors = this.connections.get(connId);
                graph.addEdge(this.myDict.get(connId.parentId), this.myDict.get(connId.childId), connFactors.weight);
            }
            ++i;
        }
        graph.setMinEdgeWeight(this.minID);
        graph.setMaxEdgeWeight(this.maxID);
        return var1_1;
    }

    public final float getMaxID() {
        return this.maxID;
    }

    /*
     * WARNING - void declaration
     */
    public final void findMinMaxID() {
        this.minID = Float.MAX_VALUE;
        this.maxID = Float.MIN_VALUE;
        DependencyIdx[] connectionIds = new DependencyIdx[1];
        connectionIds = this.connections.keySet().toArray(connectionIds);
        int i = 0;
        while (i < connectionIds.length) {
            Object connId = connectionIds[i];
            if (connId != null) {
                float f;
                connId = this.connections.get(connId);
                float weight = ((DependencyFactors)connId).weight;
                if (f > this.maxID) {
                    this.maxID = weight;
                }
                if (weight < this.minID) {
                    void var3_4;
                    this.minID = var3_4;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float getIDValue(int topSize) {
        void var3_5;
        void var1_2;
        ArrayList<Float> w = new ArrayList<Float>();
        DependencyIdx[] connectionIds = new DependencyIdx[1];
        connectionIds = this.connections.keySet().toArray(connectionIds);
        int i = 0;
        while (i < connectionIds.length) {
            DependencyIdx connId = connectionIds[i];
            if (connId != null) {
                DependencyFactors connFactors = this.connections.get(connId);
                w.add(Float.valueOf(connFactors.weight));
            }
            ++i;
        }
        Float[] f = new Float[1];
        f = var1_2.toArray(f);
        Arrays.sort((Object[])f);
        if (f.length - 20 < 0) {
            return f[0].floatValue();
        }
        return f[((void)var3_5).length - 20].floatValue();
    }

    public final int getNodesNumber() {
        return this.myDict.size();
    }
}

