/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.j48;

import dmLab.array.functions.DiscFunctions;
import dmLab.array.saver.Array2File;
import dmLab.classifier.WekaClassifier;
import dmLab.classifier.attributeIndicators.AttributeIndicators;
import dmLab.classifier.j48.J48Params;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.mcfs.tree.Tree;
import dmLab.mcfs.tree.TreeNode;
import dmLab.mcfs.tree.parser.J48Parser;
import dmLab.utils.cmatrix.AccuracyMeasure;
import dmLab.utils.list.IntegerList;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import weka.classifiers.trees.J48;
import weka.core.converters.ArffLoader;

public final class J48Classifier
extends WekaClassifier {
    private J48Params cfg;

    public J48Classifier() {
        this.wekaClassifier = new J48();
        this.arffLoader = new ArffLoader();
        this.array2File = new Array2File();
        this.array2File.setFormat(1);
        this.label = labels[J48];
        this.params = new J48Params();
        this.cfg = (J48Params)this.params;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean saveDefinition(String path, String name) throws IOException {
        void var1_1;
        void var2_2;
        if (this.params.verbose) {
            System.out.print("Saving classifier definition...");
        }
        this.params.save(path, name);
        FileWriter writer = new FileWriter(String.valueOf(path) + "//" + (String)var2_2 + ".tree");
        writer.write(this.toString());
        var1_1.close();
        if (this.params.verbose) {
            System.out.println(" Done!");
        }
        return true;
    }

    @Override
    public final boolean init() {
        this.wekaClassifier = new J48();
        this.setParams();
        return true;
    }

    @Override
    public final boolean addImportances(AttributesRI[] importances) {
        TreeNode node;
        this.attrSet = new HashSet();
        ((J48)this.wekaClassifier).setPrintNodeIndicators(true);
        IntegerList nodesId = new IntegerList();
        String j48String = this.wekaClassifier.toString();
        J48Parser j48Parser = new J48Parser(j48String);
        ExperimentIndicators experimentIndicators = new ExperimentIndicators();
        new ExperimentIndicators().eventsNumber = this.trainSetSize;
        experimentIndicators.predictionQuality = AccuracyMeasure.calcWAcc(this.confusionMatrix.getMatrix());
        while ((node = j48Parser.getNextNode()) != null) {
            if (!nodesId.contains(node.nodeIndicators.nodeIndex)) {
                importances[0].addImportances(node.condition.attributeName, experimentIndicators, (AttributeIndicators)node.nodeIndicators);
                nodesId.add(node.nodeIndicators.nodeIndex);
                this.attrSet.add(node.condition.attributeName);
            }
            j48Parser.flush();
        }
        int i = 0;
        while (i < importances.length) {
            importances[i].flushMeasures();
            ++i;
        }
        return true;
    }

    @Override
    public final boolean addIDependencies(AttributesID connectionsLight, MCFSParams params) {
        int maxConnectionDepth = params.maxConnectionDepth;
        String j48String = this.wekaClassifier.toString();
        J48Parser j48Parser = new J48Parser(j48String);
        Tree tree = new Tree();
        tree.init();
        tree.getRootNode().parseTree(j48Parser);
        tree.finalize();
        tree.initNodesIterating();
        HashSet<String> existingConnection = new HashSet<String>();
        block0: while (tree.hasNextNode()) {
            TreeNode node = tree.getNextNode();
            if (node.isRoot()) continue;
            TreeNode parentTmp = node.getParent();
            int i = 0;
            while (i < maxConnectionDepth) {
                if (parentTmp.isRoot()) continue block0;
                float f = node.nodeIndicators.attrEventsNumber / parentTmp.nodeIndicators.attrEventsNumber;
                float connValue = f * node.nodeIndicators.attrGainRatio;
                String connStr = parentTmp.nodeIndicators.nodeIndex + "-" + node.nodeIndicators.nodeIndex;
                boolean bl = !existingConnection.contains(connStr) && !DiscFunctions.isContrastAttribute(parentTmp.condition.attributeName) && !DiscFunctions.isContrastAttribute(node.condition.attributeName);
                if (bl) {
                    existingConnection.add(connStr);
                    connectionsLight.addDependency(parentTmp.condition.attributeName, node.condition.attributeName, connValue);
                }
                parentTmp = parentTmp.getParent();
                ++i;
            }
        }
        return true;
    }

    @Override
    protected final void setParams() {
        if (this.wekaClassifier != null) {
            ((J48)this.wekaClassifier).setBinarySplits(this.cfg.binarySplits);
            ((J48)this.wekaClassifier).setMinNumObj(this.cfg.minNumObj);
            ((J48)this.wekaClassifier).setSaveInstanceData(this.cfg.saveInstanceData);
            ((J48)this.wekaClassifier).setConfidenceFactor(this.cfg.confidenceFactor);
            ((J48)this.wekaClassifier).setReducedErrorPruning(this.cfg.reducedErrorPruning);
            ((J48)this.wekaClassifier).setSubtreeRaising(this.cfg.subtreeRaising);
            ((J48)this.wekaClassifier).setNumFolds(this.cfg.numFolds);
            ((J48)this.wekaClassifier).setUnpruned(this.cfg.unpruned);
            ((J48)this.wekaClassifier).setUseLaplace(this.cfg.useLaplace);
        }
    }
}

