% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_format.R
\name{resolve_output_format}
\alias{resolve_output_format}
\title{Resolve the output format for an R Markdown document}
\usage{
resolve_output_format(
  input,
  output_format = NULL,
  output_options = NULL,
  output_yaml = NULL,
  encoding = "UTF-8"
)
}
\arguments{
\item{input}{Input file (Rmd or plain markdown)}

\item{output_format}{Name of output format (or \code{NULL} to use
the default format for the input file).}

\item{output_options}{List of output options that should override the
options specified in metadata.}

\item{output_yaml}{Paths to YAML files specifying output formats and their
configurations. The first existing one is used. If none are found, then
the function searches YAML files specified to the \code{output_yaml} top-level
parameter in the YAML front matter, _output.yml or _output.yaml, and then uses
the first existing one.}

\item{encoding}{The encoding of the input file; see \code{\link{file}}.}
}
\value{
An R Markdown output format definition that can be passed to
  \code{\link{render}}.
}
\description{
Read the YAML metadata (and any common output YAML file) for the
document and return an output format object that can be
passed to the \code{\link{render}} function.
}
\details{
This function is useful for front-end tools that need to modify
the default behavior of an output format.
}
