% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shiny.R
\name{run}
\alias{run}
\title{Run a Shiny document}
\usage{
run(file = "index.Rmd", dir = dirname(file), default_file = NULL,
  auto_reload = TRUE, shiny_args = NULL, render_args = NULL)
}
\arguments{
\item{file}{Path to the R Markdown document to launch in a web browser.
Defaults to \code{index.Rmd} in the current working directory, but may be
\code{NULL} to skip launching a browser.}

\item{dir}{The directory from which to to read input documents. Defaults to
the parent directory of \code{file}.}

\item{default_file}{The file to serve at the Shiny server's root URL. If
\code{NULL} (the default), a sensible default is chosen (see Details)}

\item{auto_reload}{If \code{TRUE} (the default), automatically reload the
Shiny application when the file currently being viewed is changed on disk.}

\item{shiny_args}{Additional arguments to \code{\link[shiny:runApp]{runApp}}.}

\item{render_args}{Additional arguments to \code{\link{render}}.}
}
\value{
Invisible NULL.
}
\description{
Start a Shiny server for the given document, and render it for display.
}
\details{
The \code{run} function runs a Shiny document by starting a Shiny
  server associated with the document. The \code{shiny_args} parameter can be
  used to configure the server; see the \code{\link[shiny:runApp]{runApp}}
  documentation for details.

  Once the server is started, the document will be rendered using
  \code{\link{render}}. The server will initiate a render of the document
  whenever necessary, so it is not necessary to call \code{run} every time
  the document changes: if \code{auto_reload} is \code{TRUE}, saving the
  document will trigger a render. You can also manually trigger a render by
  reloading the document in a Web browser.

  The server will render any R Markdown (\code{.Rmd}) document in \code{dir};
  the \code{file} argument specifies only the initial document to be
  rendered and viewed. You can therefore link to other documents in the
  directory using standard Markdown syntax, e.g.
  \code{[Analysis Page 2](page2.Rmd)}.

  If \code{default_file} is not specified, nor is a file specified on the
  URL, then the default document to serve at \code{/} is chosen from (in
  order of preference):
  \itemize{
    \item{If \code{dir} contains only one \code{Rmd}, that \code{Rmd}.}
    \item{The file \code{index.Rmd}, if it exists in \code{dir}}
    \item{The file \code{index.html}, if it exists in \code{dir}}
  }

  If you wish to share R code between your documents, place it in a file
  named \code{global.R} in \code{dir}; it will be sourced into the global
  environment.
}
\note{
Unlike \code{\link{render}}, \code{run} does not render the document to
  a file on disk. In most cases a Web browser will be started automatically
  to view the document; see \code{launch.browser} in the
  \code{\link[shiny:runApp]{runApp}} documentation for details.

  When using an external web browser with the server, specify the name of the
  R Markdown file to view in the URL (e.g.
  \code{http://127.0.0.1:1234/foo.Rmd}). A URL without a filename will show
  the \code{default_file} as described above.
}
\examples{
\dontrun{

# Run the Shiny document "index.Rmd" in the current directory
rmarkdown::run()

# Run the Shiny document "shiny_doc.Rmd" on port 8241
rmarkdown::run("shiny_doc.Rmd", shiny_args = list(port = 8241))

}
}

