% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mz-bbox.R
\name{mz_bbox}
\alias{mz_bbox}
\alias{mz_bbox.mapzen_geo_list}
\alias{mz_bbox.mapzen_isochrone_list}
\alias{mz_rect}
\title{Get the bounding box}
\usage{
mz_bbox(geo)

\method{mz_bbox}{mapzen_geo_list}(geo)

\method{mz_bbox}{mapzen_isochrone_list}(geo)

mz_rect(min_lon, min_lat, max_lon, max_lat)
}
\arguments{
\item{geo}{A mapzen geo list or isochrone list}

\item{min_lon, min_lat, max_lon, max_lat}{The bottom left and top right corners,
expressed as latitude and longitude, of a rectangle.}
}
\value{
A single-row tibble with columns \code{min_lon}, \code{min_lat},
\code{max_lon}, \code{max_lat}.
}
\description{
Returns the bottom left and top right corners of the box that contains a
mapzen object (\code{mz_geo_list}, \code{mz_isochrone_list},
or \code{mapzen_vector_tiles}).
In the case of \code{mz_rect}, creates such a box from the specified
coordinates. The returned value can be used directly as the
\code{boundary.rect} parameter for \code{\link{search}} functions, as well as
converted to x, y, zoom coordinates to use with \code{\link{mz_vector_tiles}}.
}
\examples{
mz_rect(min_lon = -122.2856, min_lat = 37.73742, max_lon = -122.1749, max_lat = 37.84632)
mz_bbox(oakland_public)

}
