% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgeRFit.R
\name{edgeRFit}
\alias{edgeRFit}
\title{Analysis of the RFI RNA-seq data Using edgeR}
\usage{
edgeRFit(counts, design, Effect)
}
\arguments{
\item{counts}{a  matrix of count data.}

\item{design}{a design matrix.}

\item{Effect}{the effect used to simulate data, either line2, or
time. This  effect is considered as the main factor of interest where the
status of DE and EE genes was specified.}
}
\value{
a list of 4 components
\item{fit}{output of \code{\link[edgeR]{glmQLFit}} function.}
\item{pv}{a vector of p-values of the test for significant of \code{Effect}.}
\item{qv}{a vector of q-values corresponding to the \code{pv} above.}
}
\description{
This function analyzes the RFI RNA-seq data and simulated datasets using
\code{\link[edgeR]{glmQLFTest}}, the Quasi-likelihood F-test in \code{edgeR}
package.
}
\examples{
\donttest{
data(dat)
data(design)
counts <- dat[1:100,]
design <- design
Effect <- "line2"
edgeRout <- rmRNAseq:::edgeRFit(counts, design, Effect)
names(edgeRout)
}
}
