% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limit_theorems.R
\name{GenLowEstim}
\alias{GenLowEstim}
\title{Low frequency estimation procedure for lfsm.}
\usage{
GenLowEstim(t1, t2, p, path, freq)
}
\arguments{
\item{t1}{real number such that  t2 > t1 > 0}

\item{t2}{real number such that  t2 > t1 > 0}

\item{p}{power}

\item{path}{sample path of lfsm on which the inference is to be performed}

\item{freq}{Frequency of the motion. It can take two values: "H" for high frequency and "L" for the low frequency setting.}
}
\description{
General estimation procedure for low frequency case when 1/alpha is not a natural number
}
\examples{
m<-45; M<-60; N<-2^10-M
sigma<-0.3
p<-0.3; k=3; t1=1; t2=2

#### Continuous case
lfsm<-path(N=N,m=m,M=M,alpha=1.8,H=0.8,
           sigma=sigma,freq='L',disable_X=FALSE,seed=3)$lfsm

GenLowEstim(t1=t1,t2=t2,p=p,path=lfsm,freq="L")

#### H-1/alpha<0 case
lfsm<-path(N=N,m=m,M=M,alpha=0.8,H=0.8,
           sigma=sigma,freq='L',disable_X=FALSE,seed=3)$lfsm

GenLowEstim(t1=t1,t2=t2,p=p,path=lfsm,freq="L")

#### The procedure works also for high frequency case
lfsm<-path(N=N,m=m,M=M,alpha=1.8,H=0.8,
           sigma=sigma,freq='H',disable_X=FALSE,seed=3)$lfsm

GenLowEstim(t1=t1,t2=t2,p=p,path=lfsm,freq="H")
}
\references{
\insertRef{MOP18}{rlfsm}
}
