% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mincut.R
\name{MinCut}
\alias{MinCut}
\title{MinCut}
\usage{
MinCut(arcSources, arcTargets, arcWeights, numNodes, algorithm)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcWeights}{Vector corresponding to the weights of a graph's arcs}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Which algorithm to run. Choices include "NagamochiIbaraki",
"HaoOrlin" where NagamochiIbaraki is the default; see
<https://lemon.cs.elte.hu/pub/doc/1.3.1/a00613.html> for details on the
differences.}
}
\value{
A list containing three entries: 1) The value of the minimum cut in
  the graph, and 2) A list of nodes in the first partition, and 3) A list of
  nodes in the second partition. GomoryHu calculates a Gomory-Hu Tree and
  returns a list containing three entries: 1) A list of predecessor nodes of
  each node in the graph, and 2) A list of weights of the predecessor edge
  of each node, and 3) A list of distances from the root node to each node.
}
\description{
Finds the minimum cut on graphs. NagamochiIbaraki calculates the min cut
value and edges in undirected graphs,while HaoOrlin calculates the min cut value
and edges in directed graphs.
}
