% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimumspanningtree.R
\name{MinCostArborescence}
\alias{MinCostArborescence}
\title{MinCostArborescence}
\usage{
MinCostArborescence(
  arcSources,
  arcTargets,
  arcDistances,
  sourceNode,
  numNodes,
  algorithm = "MinCostArborescence"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcDistances}{Vector corresponding to the distances of nodes of a
graph's edges}

\item{sourceNode}{The source node}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Which algorithm to run. Choices include
"MinCostArborescence" where "MinCostArborescence" is the default. See
<https://lemon.cs.elte.hu/pub/doc/1.3.1/a00264.html> for more information.}
}
\value{
A list containing three entries: 1) Two vectors corresponding the
  source and target nodes of the edges in the tree, and 2) the total cost of
  the arborescence.
}
\description{
Finds the minimum cost arborescence of a graph, returning both the cost and
the pairs of nodes for the edges in the arborescence.
}
