% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Connectivity-Algorithms-3}
\alias{Connectivity-Algorithms-3}
\alias{getBipartitePartitionsRunner}
\alias{getAndCheckTopologicalSortRunner}
\alias{getTopologicalSortRunner}
\alias{FindStronglyConnectedComponentsRunner}
\alias{FindStronglyConnectedCutArcsRunner}
\alias{FindBiEdgeConnectedCutEdgesRunner}
\alias{FindBiNodeConnectedComponentsRunner}
\alias{FindBiNodeConnectedCutNodesRunner}
\alias{FindConnectedComponentsRunner}
\alias{FindBiEdgeConnectedComponentsRunner}
\title{Connectivity Algorithms - List Return}
\usage{
getBipartitePartitionsRunner(arcSources, arcTargets, numNodes)

getAndCheckTopologicalSortRunner(arcSources, arcTargets, numNodes)

getTopologicalSortRunner(arcSources, arcTargets, numNodes)

FindStronglyConnectedComponentsRunner(arcSources, arcTargets, numNodes)

FindStronglyConnectedCutArcsRunner(arcSources, arcTargets, numNodes)

FindBiEdgeConnectedCutEdgesRunner(arcSources, arcTargets, numNodes)

FindBiNodeConnectedComponentsRunner(arcSources, arcTargets, numNodes)

FindBiNodeConnectedCutNodesRunner(arcSources, arcTargets, numNodes)

FindConnectedComponentsRunner(arcSources, arcTargets, numNodes)

FindBiEdgeConnectedComponentsRunner(arcSources, arcTargets, numNodes)
}
\arguments{
\item{arcSources, }{a vector corresponding to the source nodes of a graph's edges}

\item{arcTargets, }{a vector corresponding to the destination nodes of a graph's edges}

\item{numNodes, }{the number of nodes in the graph}
}
\value{
a List, returning some set of nodes or edges in a graph

`getBipartitePartitionsRunner` returns an R List containing (1) A boolean stating if the graph is bipartite, and (2) an std::vector of length numNodes, containing the partition for each node

`getAndCheckTopologicalSortRunner` returns an R List containing (1) A boolean stating if the graph is a dag, and (2) a vector of length numNodes, containing the index of vertex i in the ordering at location i

`getTopologicalSortRunner` returns a vector of length numNodes, containing the index of vertex i in the ordering at location i.
}
\description{
`FindStronglyConnectedComponents` returns a vector containing the component number of each node

`FindStronglyConnectedCutArcs` returns an R List containing 1) A list of cut arc sources, and 2) A list of cut arc destinations

`FindBiEdgeConnectedCutEdges` returns an R List containing 1) A list of cut edge sources, and 2) A list of cut edge destinations

`FindBiNodeConnectedCutComponents` returns a vector containing the component number of each cut arc.

`FindBiNodeConnectedCutNodes` returns a vector containing the cut nodes

`FindConnectedComponents` returns a vector containing the component number of each node

`FindBiEdgeConnectedComponents` returns a vector containing the component number of each node
}
